/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.util.Arrays;
import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.RowAVL;
import org.hsqldb.RowAVLDisk;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.TableBase;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.index.IndexAVL;
import org.hsqldb.index.NodeAVL;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.RowStoreAVL;
import org.hsqldb.rowio.RowInputInterface;

public class RowStoreAVLHybrid
extends RowStoreAVL {
    DataFileCache cache;
    private final int maxMemoryRowCount;
    private boolean useDisk;
    boolean isCached;
    long rowIdSequence = 0L;

    public RowStoreAVLHybrid(Session session, TableBase tableBase, boolean bl) {
        this.table = tableBase;
        this.maxMemoryRowCount = session.getResultMemoryRowCount();
        this.useDisk = bl;
        if (this.maxMemoryRowCount == 0) {
            this.useDisk = false;
        }
        if (tableBase.getTableType() == 9) {
            this.setTimestamp(session.getActionSCN());
        }
        this.resetAccessorKeys(session, tableBase.getIndexList());
        this.nullsList = new boolean[tableBase.getColumnCount()];
    }

    @Override
    public boolean isMemory() {
        return !this.isCached;
    }

    @Override
    public void setMemory(boolean bl) {
        this.useDisk = !bl;
    }

    @Override
    public CachedObject get(long l2, boolean bl) {
        try {
            if (this.isCached) {
                return this.cache.get(l2, (PersistentStore)this, bl);
            }
            throw Error.runtimeError(201, "RowStoreAVLHybrid");
        }
        catch (HsqlException hsqlException) {
            return null;
        }
    }

    @Override
    public CachedObject get(CachedObject cachedObject, boolean bl) {
        try {
            if (cachedObject.isMemory()) {
                return cachedObject;
            }
            if (this.isCached) {
                return this.cache.get(cachedObject, (PersistentStore)this, bl);
            }
            return cachedObject;
        }
        catch (HsqlException hsqlException) {
            return null;
        }
    }

    @Override
    public void add(Session session, CachedObject cachedObject, boolean bl) {
        if (this.isCached) {
            int n2 = cachedObject.getRealSize(this.cache.rowOut);
            n2 += this.indexList.length * 16;
            n2 = this.cache.rowOut.getStorageSize(n2);
            cachedObject.setStorageSize(n2);
            long l2 = this.tableSpace.getFilePosition(n2);
            cachedObject.setPos(l2);
            this.cache.add(cachedObject, false);
        }
        Object[] objectArray = ((Row)cachedObject).getData();
        for (int i2 = 0; i2 < this.nullsList.length; ++i2) {
            if (objectArray[i2] != null) continue;
            this.nullsList[i2] = true;
        }
    }

    @Override
    public CachedObject get(RowInputInterface rowInputInterface) {
        try {
            if (this.isCached) {
                return new RowAVLDisk(this, rowInputInterface);
            }
        }
        catch (HsqlException hsqlException) {
            return null;
        }
        return null;
    }

    @Override
    public CachedObject getNewCachedObject(Session session, Object object, boolean bl) {
        RowAVL rowAVL;
        if (!this.isCached && this.useDisk && this.elementCount.get() >= (long)this.maxMemoryRowCount) {
            this.changeToDiskTable(session);
        }
        if (this.isCached) {
            rowAVL = new RowAVLDisk(this.table, (Object[])object, this);
        } else {
            long l2 = this.rowIdSequence++;
            rowAVL = new RowAVL(this.table, (Object[])object, l2, this);
        }
        this.add(session, rowAVL, bl);
        return rowAVL;
    }

    @Override
    public void indexRow(Session session, Row row) {
        try {
            row = (Row)this.get((CachedObject)row, true);
            super.indexRow(session, row);
        }
        finally {
            row.keepInMemory(false);
        }
    }

    @Override
    public void removeAll() {
        if (!this.isCached) {
            this.destroyIndexes();
        }
        this.elementCount.set(0L);
        ArrayUtil.fillArray(this.accessorList, null);
        Arrays.fill(this.nullsList, false);
    }

    @Override
    public void remove(CachedObject cachedObject) {
        if (cachedObject.isMemory()) {
            return;
        }
        if (this.isCached) {
            this.cache.remove(cachedObject);
        }
    }

    @Override
    public void commitPersistence(CachedObject cachedObject) {
    }

    @Override
    public void postCommitAction(Session session, RowAction rowAction) {
    }

    @Override
    public void commitRow(Session session, Row row, int n2, int n3) {
        switch (n2) {
            case 2: {
                this.remove(row);
                break;
            }
            case 1: {
                break;
            }
            case 4: {
                this.remove(row);
                break;
            }
            case 3: {
                throw Error.runtimeError(201, "RowStore");
            }
        }
    }

    @Override
    public void rollbackRow(Session session, Row row, int n2, int n3) {
        switch (n2) {
            case 2: {
                row = (Row)this.get((CachedObject)row, true);
                ((RowAVL)row).setNewNodes(this);
                row.keepInMemory(false);
                this.indexRow(session, row);
                break;
            }
            case 1: {
                this.delete(session, row);
                this.remove(row);
                break;
            }
            case 4: {
                this.remove(row);
            }
        }
    }

    @Override
    public DataFileCache getCache() {
        return this.cache;
    }

    @Override
    public void setCache(DataFileCache dataFileCache) {
        throw Error.runtimeError(201, "RowStoreAVLHybrid");
    }

    @Override
    public void release() {
        if (this.isCached) {
            this.cache.adjustStoreCount(-1);
            this.cache = null;
            this.isCached = false;
        } else {
            this.destroyIndexes();
        }
        this.elementCount.set(0L);
        ArrayUtil.fillArray(this.accessorList, null);
    }

    @Override
    public CachedObject getAccessor(Index index) {
        int n2 = index.getPosition();
        NodeAVL nodeAVL = (NodeAVL)this.accessorList[n2];
        if (nodeAVL == null) {
            return null;
        }
        RowAVL rowAVL = nodeAVL.getRow(this);
        RowAVL rowAVL2 = (RowAVL)this.get((CachedObject)rowAVL, false);
        nodeAVL = rowAVL2.getNode(index.getPosition());
        this.accessorList[index.getPosition()] = nodeAVL;
        return nodeAVL;
    }

    @Override
    public synchronized void resetAccessorKeys(Session session, Index[] indexArray) {
        if (this.indexList.length == 0 || this.accessorList[0] == null) {
            this.indexList = indexArray;
            this.accessorList = new CachedObject[this.indexList.length];
            return;
        }
        if (this.isCached) {
            throw Error.runtimeError(201, "RowStoreAVLHybrid");
        }
        super.resetAccessorKeys(session, indexArray);
    }

    @Override
    public boolean hasNull(int n2) {
        return this.nullsList[n2];
    }

    public final void changeToDiskTable(Session session) {
        this.cache = session.sessionData.persistentStoreCollection.getSessionDataCache();
        if (this.cache == null) {
            this.useDisk = false;
            return;
        }
        this.tableSpace = this.cache.spaceManager.getTableSpace(7);
        this.isCached = true;
        this.cache.adjustStoreCount(1);
        if (this.elementCount.get() == 0L) {
            return;
        }
        IndexAVL indexAVL = (IndexAVL)this.indexList[0];
        NodeAVL nodeAVL = (NodeAVL)this.accessorList[0];
        RowIterator rowIterator = this.table.rowIterator(this);
        ArrayUtil.fillArray(this.accessorList, null);
        ArrayUtil.fillArray(this.nullsList, false);
        this.elementCount.set(0L);
        while (rowIterator.next()) {
            Row row = rowIterator.getCurrentRow();
            Row row2 = (Row)this.getNewCachedObject(session, row.getData(), false);
            this.indexRow(session, row2);
        }
        indexAVL.unlinkNodes(this, nodeAVL);
    }
}

