/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.index.Index;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.navigator.RowSetNavigatorClient;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.persist.RowInsertInterface;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class RowInsertVersioning
implements RowInsertInterface {
    final Session session;
    final RowInsertInterface.ErrorLogger callback;
    final int mode;
    RowSetNavigatorClient rowSet = new RowSetNavigatorClient(64);
    Table table = null;
    PersistentStore store;
    Index index = null;

    public RowInsertVersioning(Session session, RowInsertInterface.ErrorLogger errorLogger, int n2) {
        this.session = session;
        this.callback = errorLogger;
        this.mode = n2;
    }

    @Override
    public void finishTable() {
        this.applyChangeSet();
    }

    @Override
    public void close() {
        this.callback.close();
    }

    @Override
    public long getErrorLineNumber() {
        return 0L;
    }

    @Override
    public void insert(Table table, PersistentStore persistentStore, Object[] objectArray) {
        if (this.table != table) {
            this.resetTable(table, persistentStore);
        }
        if (this.isSameRowSet(objectArray)) {
            this.rowSet.add(objectArray);
        } else {
            this.applyChangeSet();
            this.rowSet.add(objectArray);
        }
    }

    @Override
    public void setStartLineNumber(long l2) {
    }

    boolean isSameRowSet(Object[] objectArray) {
        if (this.rowSet.isEmpty()) {
            return true;
        }
        return this.index.compareRow(this.session, objectArray, this.rowSet.getData(0)) == 0;
    }

    void applyChangeSet() {
        Object[] objectArray;
        if (this.rowSet.getSize() == 0) {
            return;
        }
        int n2 = 0;
        RowIterator rowIterator = this.index.findFirstRow(this.session, this.store, this.rowSet.getData(0));
        boolean bl = false;
        Row row = null;
        while (rowIterator.next() && this.isSameRowSet(rowIterator.getCurrent())) {
            row = rowIterator.getCurrentRow();
            TimestampData timestampData = row.getSystemStartVersion();
            int n3 = this.compareColumn(timestampData, objectArray = this.rowSet.getData(n2), this.table.getSystemPeriodStartIndex());
            if (n3 < 0) {
                timestampData = row.getSystemEndVersion();
                n3 = this.compareColumn(timestampData, objectArray, this.table.getSystemPeriodStartIndex());
                if (n3 <= 0) continue;
                bl = true;
                break;
            }
            if (n3 > 0) {
                bl = true;
                break;
            }
            timestampData = row.getSystemEndVersion();
            n3 = this.compareColumn(timestampData, objectArray, this.table.getSystemPeriodEndIndex());
            if (n3 == 0) {
                ++n2;
                continue;
            }
            if (timestampData.getSeconds() != DateTimeType.epochLimitSeconds) continue;
            rowIterator.removeCurrent();
            break;
        }
        if (bl) {
            for (int i2 = n2; i2 < this.rowSet.getSize(); ++i2) {
                objectArray = this.rowSet.getData(i2);
                Row row2 = new Row(this.table, objectArray);
                this.callback.writeRow(0L, row2);
            }
        } else {
            for (int i3 = n2; i3 < this.rowSet.getSize(); ++i3) {
                objectArray = this.rowSet.getData(i3);
                this.table.insertFromScript(this.session, this.store, objectArray);
            }
        }
        this.rowSet.clear();
    }

    void resetTable(Table table, PersistentStore persistentStore) {
        this.table = table;
        this.store = persistentStore;
        this.index = table.getPrimaryIndex();
    }

    int compareColumn(TimestampData timestampData, Object[] objectArray, int n2) {
        return Type.SQL_TIMESTAMP_WITH_TIME_ZONE.compare(this.session, timestampData, objectArray[n2]);
    }
}

