/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.hsqldb.Database;
import org.hsqldb.error.Error;
import org.hsqldb.lib.EventLogInterface;
import org.hsqldb.persist.RandomAccessInterface;

final class RAFileSimple
implements RandomAccessInterface {
    final RandomAccessFile file;
    final boolean readOnly;
    final EventLogInterface logger;

    RAFileSimple(EventLogInterface eventLogInterface, String string, String string2) throws FileNotFoundException, IOException {
        this.file = new RandomAccessFile(string, string2);
        this.logger = eventLogInterface;
        this.readOnly = string2.equals("r");
    }

    @Override
    public long length() throws IOException {
        return this.file.length();
    }

    @Override
    public void seek(long l2) throws IOException {
        this.file.seek(l2);
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.file.getFilePointer();
    }

    @Override
    public int read() throws IOException {
        return this.file.read();
    }

    @Override
    public long readLong() throws IOException {
        return this.file.readLong();
    }

    @Override
    public int readInt() throws IOException {
        return this.file.readInt();
    }

    @Override
    public void read(byte[] byArray, int n2, int n3) throws IOException {
        this.file.readFully(byArray, n2, n3);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        this.file.write(byArray, n2, n3);
    }

    @Override
    public void writeInt(int n2) throws IOException {
        this.file.writeInt(n2);
    }

    @Override
    public void writeLong(long l2) throws IOException {
        this.file.writeLong(l2);
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean ensureLength(long l2) {
        try {
            if (!this.readOnly && this.file.length() < l2) {
                this.file.seek(l2 - 1L);
                this.file.writeByte(0);
            }
        }
        catch (IOException iOException) {
            this.logger.logWarningEvent("data file enlarge failed ", iOException);
            return false;
        }
        return true;
    }

    @Override
    public boolean setLength(long l2) {
        try {
            this.file.setLength(l2);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public Database getDatabase() {
        return null;
    }

    @Override
    public void synch() {
        try {
            this.file.getFD().sync();
        }
        catch (Throwable throwable) {
            try {
                this.file.getFD().sync();
            }
            catch (Throwable throwable2) {
                this.logger.logSevereEvent("RA file sync error ", throwable);
                throw Error.error(throwable, 452, null);
            }
        }
    }
}

