/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.hsqldb.Database;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.EventLogInterface;
import org.hsqldb.lib.HsqlByteArrayInputStream;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.persist.RAFileHybrid;
import org.hsqldb.persist.RAFileInJar;
import org.hsqldb.persist.RandomAccessInterface;

final class RAFile
implements RandomAccessInterface {
    static final int DATA_FILE_RAF = 0;
    static final int DATA_FILE_NIO = 1;
    static final int DATA_FILE_JAR = 2;
    static final int DATA_FILE_STORED = 3;
    static final int DATA_FILE_SINGLE = 4;
    static final int DATA_FILE_TEXT = 5;
    static final int bufferScale = 13;
    static final int bufferSize = 8192;
    static final long bufferMask = -8192L;
    final EventLogInterface logger;
    final RandomAccessFile file;
    final FileDescriptor fileDescriptor;
    private final boolean readOnly;
    final String fileName;
    final byte[] buffer;
    final HsqlByteArrayInputStream ba;
    final byte[] valueBuffer;
    final HsqlByteArrayOutputStream vbao;
    final HsqlByteArrayInputStream vbai;
    long bufferOffset;
    long fileLength;
    final boolean extendLength;
    long seekPosition;
    int cacheHit;

    static RandomAccessInterface newScaledRAFile(Database database, String string, boolean bl, int n2) throws FileNotFoundException, IOException {
        if (n2 == 2) {
            return new RAFileInJar(string);
        }
        if (n2 == 5) {
            return new RAFile(database.logger, string, bl, false, true);
        }
        if (n2 == 0) {
            return new RAFile(database.logger, string, bl, true, false);
        }
        File file = new File(string);
        long l2 = file.length();
        if (l2 > database.logger.propNioMaxSize) {
            return new RAFile(database.logger, string, bl, true, false);
        }
        return new RAFileHybrid(database, string, bl);
    }

    RAFile(EventLogInterface eventLogInterface, String string, boolean bl, boolean bl2, boolean bl3) throws FileNotFoundException, IOException {
        this.logger = eventLogInterface;
        this.fileName = string;
        this.readOnly = bl;
        this.extendLength = bl2;
        String string2 = bl ? "r" : (bl3 ? "rws" : "rw");
        this.file = new RandomAccessFile(string, string2);
        this.buffer = new byte[8192];
        this.ba = new HsqlByteArrayInputStream(this.buffer);
        this.valueBuffer = new byte[8];
        this.vbao = new HsqlByteArrayOutputStream(this.valueBuffer);
        this.vbai = new HsqlByteArrayInputStream(this.valueBuffer);
        this.fileDescriptor = this.file.getFD();
        this.fileLength = this.length();
        this.readIntoBuffer();
    }

    @Override
    public long length() throws IOException {
        return this.file.length();
    }

    @Override
    public void seek(long l2) throws IOException {
        if (this.readOnly && this.fileLength < l2) {
            throw new IOException("read beyond end of file");
        }
        this.seekPosition = l2;
    }

    @Override
    public long getFilePointer() {
        return this.seekPosition;
    }

    private void readIntoBuffer() throws IOException {
        long l2 = this.seekPosition & 0xFFFFFFFFFFFFE000L;
        long l3 = this.fileLength - l2;
        if (l3 > (long)this.buffer.length) {
            l3 = this.buffer.length;
        }
        if (l3 < 0L) {
            throw new IOException("read beyond end of file");
        }
        try {
            this.file.seek(l2);
            this.file.readFully(this.buffer, 0, (int)l3);
            this.bufferOffset = l2;
        }
        catch (IOException iOException) {
            this.resetPointer();
            this.logger.logWarningEvent("Read Error " + l2 + " " + l3, iOException);
            throw iOException;
        }
    }

    @Override
    public int read() throws IOException {
        if (this.seekPosition >= this.fileLength) {
            return -1;
        }
        if (this.seekPosition < this.bufferOffset || this.seekPosition >= this.bufferOffset + (long)this.buffer.length) {
            this.readIntoBuffer();
        } else {
            ++this.cacheHit;
        }
        int n2 = this.buffer[(int)(this.seekPosition - this.bufferOffset)] & 0xFF;
        ++this.seekPosition;
        return n2;
    }

    @Override
    public long readLong() throws IOException {
        this.vbai.reset();
        this.read(this.valueBuffer, 0, 8);
        return this.vbai.readLong();
    }

    @Override
    public int readInt() throws IOException {
        this.vbai.reset();
        this.read(this.valueBuffer, 0, 4);
        return this.vbai.readInt();
    }

    @Override
    public void read(byte[] byArray, int n2, int n3) throws IOException {
        try {
            if (this.seekPosition + (long)n3 > this.fileLength) {
                throw new EOFException();
            }
            if (n3 > this.buffer.length && (this.seekPosition < this.bufferOffset || this.seekPosition >= this.bufferOffset + (long)this.buffer.length)) {
                this.file.seek(this.seekPosition);
                this.file.readFully(byArray, n2, n3);
                this.seekPosition += (long)n3;
                return;
            }
            if (this.seekPosition < this.bufferOffset || this.seekPosition >= this.bufferOffset + (long)this.buffer.length) {
                this.readIntoBuffer();
            } else {
                ++this.cacheHit;
            }
            this.ba.reset();
            if (this.seekPosition - this.bufferOffset != this.ba.skip(this.seekPosition - this.bufferOffset)) {
                throw new EOFException();
            }
            int n4 = this.ba.read(byArray, n2, n3);
            this.seekPosition += (long)n4;
            if (n4 < n3) {
                this.file.seek(this.seekPosition);
                this.file.readFully(byArray, n2 + n4, n3 - n4);
                this.seekPosition += (long)(n3 - n4);
            }
        }
        catch (IOException iOException) {
            this.resetPointer();
            this.logger.logWarningEvent("failed to read a byte array", iOException);
            throw iOException;
        }
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        try {
            this.file.seek(this.seekPosition);
            if (this.seekPosition < this.bufferOffset + (long)this.buffer.length && this.seekPosition + (long)n3 > this.bufferOffset) {
                this.writeToBuffer(byArray, n2, n3);
            }
            this.file.write(byArray, n2, n3);
            this.seekPosition += (long)n3;
            if (!this.extendLength && this.fileLength < this.seekPosition) {
                this.fileLength = this.seekPosition;
            }
        }
        catch (IOException iOException) {
            this.resetPointer();
            this.logger.logWarningEvent("failed to write a byte array", iOException);
            throw iOException;
        }
    }

    @Override
    public void writeInt(int n2) throws IOException {
        this.vbao.reset();
        this.vbao.writeInt(n2);
        this.write(this.valueBuffer, 0, 4);
    }

    @Override
    public void writeLong(long l2) throws IOException {
        this.vbao.reset();
        this.vbao.writeLong(l2);
        this.write(this.valueBuffer, 0, 8);
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean ensureLength(long l2) {
        if (l2 <= this.fileLength) {
            return true;
        }
        try {
            this.extendLength(l2);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    @Override
    public boolean setLength(long l2) {
        try {
            this.file.setLength(l2);
            this.file.seek(0L);
            this.fileLength = this.file.length();
            this.seekPosition = 0L;
            this.readIntoBuffer();
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    @Override
    public void synch() {
        try {
            this.fileDescriptor.sync();
        }
        catch (Throwable throwable) {
            try {
                this.fileDescriptor.sync();
            }
            catch (Throwable throwable2) {
                this.logger.logSevereEvent("RA file sync error ", throwable2);
                throw Error.error(throwable, 452, null);
            }
        }
    }

    private int writeToBuffer(byte[] byArray, int n2, int n3) {
        int n4 = ArrayUtil.copyBytes(this.seekPosition - (long)n2, byArray, n2, n3, this.bufferOffset, this.buffer, this.buffer.length);
        return n4;
    }

    private long getExtendLength(long l2) {
        if (!this.extendLength) {
            return l2;
        }
        int n2 = l2 < 262144L ? 2 : (l2 < 0x100000L ? 6 : (l2 < 0x2000000L ? 8 : 12));
        l2 = ArrayUtil.getBinaryNormalisedCeiling(l2, 13 + n2);
        return l2;
    }

    private void extendLength(long l2) throws IOException {
        long l3 = this.getExtendLength(l2);
        if (l3 > this.fileLength) {
            try {
                this.file.seek(l3 - 1L);
                this.file.write(0);
                this.fileLength = l3;
            }
            catch (IOException iOException) {
                this.logger.logWarningEvent("data file enlarge failed ", iOException);
                throw iOException;
            }
        }
    }

    private void resetPointer() {
        try {
            this.seekPosition = 0L;
            this.fileLength = this.length();
            this.bufferOffset = -this.buffer.length;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

