/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.hsqldb.Database;
import org.hsqldb.error.Error;
import org.hsqldb.persist.LobStore;

public class LobStoreInJar
implements LobStore {
    final int lobBlockSize;
    Database database;
    DataInputStream dataInput;
    final String fileName;
    long realPosition;

    public LobStoreInJar(Database database, int n2) {
        this.lobBlockSize = n2;
        this.database = database;
        try {
            this.fileName = database.getPath() + ".lobs";
        }
        catch (Throwable throwable) {
            throw Error.error(466, throwable);
        }
    }

    @Override
    public byte[] getBlockBytes(int n2, int n3) {
        try {
            long l2 = (long)n2 * (long)this.lobBlockSize;
            int n4 = n3 * this.lobBlockSize;
            byte[] byArray = new byte[n4];
            this.fileSeek(l2);
            this.dataInput.readFully(byArray, 0, n4);
            this.realPosition = l2 + (long)n4;
            return byArray;
        }
        catch (Throwable throwable) {
            throw Error.error(466, throwable);
        }
    }

    @Override
    public void setBlockBytes(byte[] byArray, int n2, int n3) {
    }

    @Override
    public void setBlockBytes(byte[] byArray, long l2, int n2, int n3) {
    }

    @Override
    public int getBlockSize() {
        return this.lobBlockSize;
    }

    @Override
    public long getLength() {
        return 0L;
    }

    @Override
    public void setLength(long l2) {
    }

    @Override
    public void close() {
        try {
            if (this.dataInput != null) {
                this.dataInput.close();
            }
        }
        catch (Throwable throwable) {
            throw Error.error(466, throwable);
        }
    }

    @Override
    public void synch() {
    }

    private void resetStream() throws IOException {
        if (this.dataInput != null) {
            this.dataInput.close();
        }
        InputStream inputStream = null;
        try {
            ClassLoader classLoader;
            inputStream = this.getClass().getResourceAsStream(this.fileName);
            if (inputStream == null && (classLoader = Thread.currentThread().getContextClassLoader()) != null) {
                inputStream = classLoader.getResourceAsStream(this.fileName);
            }
        }
        catch (Throwable throwable) {
            if (inputStream == null) {
                throw new FileNotFoundException(this.fileName);
            }
        }
        finally {
            if (inputStream == null) {
                throw new FileNotFoundException(this.fileName);
            }
        }
        this.dataInput = new DataInputStream(inputStream);
        this.realPosition = 0L;
    }

    private void fileSeek(long l2) throws IOException {
        long l3;
        if (this.dataInput == null) {
            this.resetStream();
        }
        if (l2 < (l3 = this.realPosition)) {
            this.resetStream();
            l3 = 0L;
        }
        while (l2 > l3) {
            l3 += this.dataInput.skip(l2 - l3);
        }
        this.realPosition = l2;
    }
}

