/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.lib.LongLookup;
import org.hsqldb.persist.CachedObjectBase;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class DoubleIntArrayCachedObject
extends CachedObjectBase {
    public static final int fileSizeFactor = 8;
    DoubleIntIndex table;

    public DoubleIntArrayCachedObject(int n2) {
        this.table = new DoubleIntIndex(n2, true);
        this.hasChanged = true;
    }

    @Override
    public void read(RowInputInterface rowInputInterface) {
        int n2;
        this.position = rowInputInterface.getFilePosition();
        int n3 = this.table.capacity();
        int[] nArray = this.table.getKeys();
        int n4 = -1;
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[n2] = rowInputInterface.readInt();
            if (nArray[n2] == 0) continue;
            n4 = n2;
        }
        nArray = this.table.getValues();
        for (n2 = 0; n2 < n3; ++n2) {
            nArray[n2] = rowInputInterface.readInt();
        }
        this.table.setSize(n4 + 1);
        this.hasChanged = false;
    }

    @Override
    public int getDefaultCapacity() {
        return this.table.capacity();
    }

    @Override
    public int getRealSize(RowOutputInterface rowOutputInterface) {
        return this.table.capacity() * 8;
    }

    @Override
    public void write(RowOutputInterface rowOutputInterface) {
        this.write(rowOutputInterface, null);
    }

    @Override
    public void write(RowOutputInterface rowOutputInterface, LongLookup longLookup) {
        int n2;
        int n3 = this.table.capacity();
        rowOutputInterface.setStorageSize(this.storageSize);
        int[] nArray = this.table.getKeys();
        for (n2 = 0; n2 < n3; ++n2) {
            rowOutputInterface.writeInt(nArray[n2]);
        }
        nArray = this.table.getValues();
        for (n2 = 0; n2 < n3; ++n2) {
            rowOutputInterface.writeInt(nArray[n2]);
        }
        rowOutputInterface.writeEnd();
    }

    public void clear() {
        this.hasChanged |= this.table.size() > 0;
        this.table.clear();
    }

    public boolean removeKey(int n2) {
        boolean bl = this.table.removeKey(n2);
        this.hasChanged |= bl;
        return bl;
    }

    public boolean addKey(int n2, int n3) {
        boolean bl = this.table.addOrReplaceUnique(n2, n3);
        this.hasChanged |= bl;
        return bl;
    }

    public int getValue(int n2) {
        return this.table.lookup(n2, -1);
    }

    public int getValue(int n2, int n3) {
        return this.table.lookup(n2, n3);
    }
}

