/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.lib.LongLookup;
import org.hsqldb.persist.CachedObjectBase;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class DirectoryBlockCachedObject
extends CachedObjectBase {
    static final int fileSizeFactor = 12;
    int[] tableId;
    int[] bitmapAddress;
    char[] freeSpace;
    char[] freeSpaceBlock;

    public DirectoryBlockCachedObject(int n2) {
        this.tableId = new int[n2];
        this.bitmapAddress = new int[n2];
        this.freeSpace = new char[n2];
        this.freeSpaceBlock = new char[n2];
        this.hasChanged = true;
    }

    @Override
    public void read(RowInputInterface rowInputInterface) {
        int n2;
        this.position = rowInputInterface.getFilePosition();
        int n3 = this.tableId.length;
        for (n2 = 0; n2 < n3; ++n2) {
            this.tableId[n2] = rowInputInterface.readInt();
        }
        for (n2 = 0; n2 < n3; ++n2) {
            this.bitmapAddress[n2] = rowInputInterface.readInt();
        }
        for (n2 = 0; n2 < n3; ++n2) {
            this.freeSpace[n2] = rowInputInterface.readChar();
        }
        for (n2 = 0; n2 < n3; ++n2) {
            this.freeSpaceBlock[n2] = rowInputInterface.readChar();
        }
        this.hasChanged = false;
    }

    @Override
    public int getDefaultCapacity() {
        return this.tableId.length;
    }

    @Override
    public int getRealSize(RowOutputInterface rowOutputInterface) {
        return this.tableId.length * 12;
    }

    @Override
    public void write(RowOutputInterface rowOutputInterface) {
        this.write(rowOutputInterface, null);
    }

    @Override
    public void write(RowOutputInterface rowOutputInterface, LongLookup longLookup) {
        int n2;
        int n3 = this.tableId.length;
        rowOutputInterface.setStorageSize(this.storageSize);
        for (n2 = 0; n2 < n3; ++n2) {
            rowOutputInterface.writeInt(this.tableId[n2]);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            rowOutputInterface.writeInt(this.bitmapAddress[n2]);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            rowOutputInterface.writeChar(this.freeSpace[n2]);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            rowOutputInterface.writeChar(this.freeSpaceBlock[n2]);
        }
        rowOutputInterface.writeEnd();
    }

    public void setTableId(int n2, int n3) {
        this.tableId[n2] = n3;
        this.hasChanged = true;
    }

    public void setBitmapAddress(int n2, int n3) {
        this.bitmapAddress[n2] = n3;
        this.hasChanged = true;
    }

    public void setFreeSpace(int n2, char c2) {
        this.freeSpace[n2] = c2;
        this.hasChanged = true;
    }

    public void setFreeBlock(int n2, char c2) {
        this.freeSpaceBlock[n2] = c2;
        this.hasChanged = true;
    }

    public void setLastUsed(int n2, byte by) {
    }

    public int getTableId(int n2) {
        return this.tableId[n2];
    }

    public int getBitmapAddress(int n2) {
        return this.bitmapAddress[n2];
    }

    public char getFreeSpace(int n2) {
        return this.freeSpace[n2];
    }

    public char getFreeBlock(int n2) {
        return this.freeSpaceBlock[n2];
    }

    public int[] getTableIdArray() {
        return this.tableId;
    }

    public int[] getBitmapAddressArray() {
        return this.bitmapAddress;
    }

    public char[] getFreeSpaceArray() {
        return this.freeSpace;
    }

    public char[] getFreeBlockArray() {
        return this.freeSpaceBlock;
    }
}

