/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.navigator;

import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.error.Error;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public class RowSetNavigatorClient
extends RowSetNavigator {
    public static final Object[][] emptyTable = new Object[0][];
    int currentOffset;
    int baseBlockSize;
    Object[][] table;

    public RowSetNavigatorClient() {
        this.table = emptyTable;
    }

    public RowSetNavigatorClient(int n2) {
        this.table = new Object[n2][];
    }

    public RowSetNavigatorClient(RowSetNavigator rowSetNavigator, int n2, int n3) {
        this.size = rowSetNavigator.size;
        this.baseBlockSize = n3;
        this.currentOffset = n2;
        this.table = new Object[n3][];
        rowSetNavigator.absolute(n2);
        for (int i2 = 0; i2 < n3; ++i2) {
            this.table[i2] = rowSetNavigator.getCurrent();
            rowSetNavigator.next();
        }
        rowSetNavigator.beforeFirst();
    }

    public void setData(Object[][] objectArray) {
        this.table = objectArray;
        this.size = objectArray.length;
    }

    public void setData(int n2, Object[] objectArray) {
        this.table[n2] = objectArray;
    }

    public Object[] getData(int n2) {
        return this.table[n2];
    }

    @Override
    public Object[] getCurrent() {
        if (this.currentPos < 0 || this.currentPos >= this.size) {
            return null;
        }
        if (this.currentPos >= this.currentOffset + this.table.length) {
            this.getBlock(this.currentOffset + this.table.length);
        }
        return this.table[this.currentPos - this.currentOffset];
    }

    @Override
    public Row getCurrentRow() {
        throw Error.runtimeError(201, "RowSetNavigatorClient");
    }

    @Override
    public void removeCurrent() {
        System.arraycopy(this.table, this.currentPos + 1, this.table, this.currentPos, this.size - this.currentPos - 1);
        this.table[this.size - 1] = null;
        --this.currentPos;
        --this.size;
    }

    @Override
    public void add(Object[] objectArray) {
        this.ensureCapacity();
        this.table[this.size] = objectArray;
        ++this.size;
    }

    @Override
    public boolean addRow(Row row) {
        throw Error.runtimeError(201, "RowSetNavigatorClient");
    }

    @Override
    public void clear() {
        this.setData(emptyTable);
        this.size = 0;
        this.reset();
    }

    @Override
    public void release() {
        this.setData(emptyTable);
        this.reset();
        this.isClosed = true;
    }

    @Override
    public boolean absolute(int n2) {
        if (n2 < 0) {
            n2 += this.size;
        }
        if (n2 < 0) {
            this.beforeFirst();
            return false;
        }
        if (n2 >= this.size) {
            this.afterLast();
            return false;
        }
        if (this.size == 0) {
            return false;
        }
        this.currentPos = n2;
        return true;
    }

    @Override
    public void readSimple(RowInputInterface rowInputInterface, ResultMetaData resultMetaData) {
        this.size = rowInputInterface.readInt();
        if (this.table.length < this.size) {
            this.table = new Object[this.size][];
        }
        for (int i2 = 0; i2 < this.size; ++i2) {
            this.table[i2] = rowInputInterface.readData(resultMetaData.columnTypes);
        }
    }

    @Override
    public void writeSimple(RowOutputInterface rowOutputInterface, ResultMetaData resultMetaData) {
        rowOutputInterface.writeInt(this.size);
        for (int i2 = 0; i2 < this.size; ++i2) {
            Object[] objectArray = this.table[i2];
            rowOutputInterface.writeData(resultMetaData.getColumnCount(), resultMetaData.columnTypes, objectArray, null, null);
        }
    }

    @Override
    public void read(RowInputInterface rowInputInterface, ResultMetaData resultMetaData) {
        this.id = rowInputInterface.readLong();
        this.size = rowInputInterface.readInt();
        this.currentOffset = rowInputInterface.readInt();
        this.baseBlockSize = rowInputInterface.readInt();
        if (this.table.length < this.baseBlockSize) {
            this.table = new Object[this.baseBlockSize][];
        }
        for (int i2 = 0; i2 < this.baseBlockSize; ++i2) {
            this.table[i2] = rowInputInterface.readData(resultMetaData.columnTypes);
        }
    }

    @Override
    public void write(RowOutputInterface rowOutputInterface, ResultMetaData resultMetaData) {
        int n2 = this.size - this.currentOffset;
        if (n2 > this.table.length) {
            n2 = this.table.length;
        }
        rowOutputInterface.writeLong(this.id);
        rowOutputInterface.writeInt(this.size);
        rowOutputInterface.writeInt(this.currentOffset);
        rowOutputInterface.writeInt(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Object[] objectArray = this.table[i2];
            rowOutputInterface.writeData(resultMetaData.getColumnCount(), resultMetaData.columnTypes, objectArray, null, null);
        }
    }

    void getBlock(int n2) {
        try {
            RowSetNavigatorClient rowSetNavigatorClient = this.session.getRows(this.id, n2, this.baseBlockSize);
            this.table = rowSetNavigatorClient.table;
            this.currentOffset = rowSetNavigatorClient.currentOffset;
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    private void ensureCapacity() {
        if (this.size == this.table.length) {
            int n2 = this.size == 0 ? 4 : this.size * 2;
            Object[][] objectArrayArray = new Object[n2][];
            System.arraycopy(this.table, 0, objectArrayArray, 0, this.size);
            this.table = objectArrayArray;
        }
    }
}

