/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.navigator;

import org.hsqldb.Row;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.navigator.RangeIterator;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

public abstract class RowSetNavigator
implements RangeIterator {
    SessionInterface session;
    long id;
    int size;
    int mode;
    int currentPos = -1;
    int rangePosition;
    boolean hadNext;
    boolean isClosed;

    public void setId(long l2) {
        this.id = l2;
    }

    public long getId() {
        return this.id;
    }

    @Override
    public abstract Object[] getCurrent();

    @Override
    public Object getField(int n2) {
        Object[] objectArray = this.getCurrent();
        if (objectArray == null) {
            return null;
        }
        return objectArray[n2];
    }

    @Override
    public void setCurrent(Object[] objectArray) {
    }

    @Override
    public abstract Row getCurrentRow();

    public abstract void add(Object[] var1);

    public abstract boolean addRow(Row var1);

    @Override
    public abstract void removeCurrent();

    @Override
    public void reset() {
        this.currentPos = -1;
    }

    public abstract void clear();

    @Override
    public abstract void release();

    public boolean isClosed() {
        return this.isClosed;
    }

    public void setSession(SessionInterface sessionInterface) {
        this.session = sessionInterface;
    }

    public SessionInterface getSession() {
        return this.session;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean next() {
        if (this.hasNext()) {
            ++this.currentPos;
            this.hadNext = true;
            return true;
        }
        if (this.size != 0) {
            this.currentPos = this.size;
        }
        this.hadNext = false;
        return false;
    }

    final boolean hasNext() {
        return this.currentPos < this.size - 1;
    }

    @Override
    public long getRowId() {
        throw Error.runtimeError(201, "RowSetNavigator");
    }

    public boolean hadNext() {
        return this.hadNext;
    }

    public boolean beforeFirst() {
        this.reset();
        this.currentPos = -1;
        return true;
    }

    public boolean afterLast() {
        if (this.size == 0) {
            return false;
        }
        this.reset();
        this.currentPos = this.size;
        return true;
    }

    public boolean first() {
        this.beforeFirst();
        return this.next();
    }

    public boolean last() {
        if (this.size == 0) {
            return false;
        }
        if (this.isAfterLast()) {
            this.beforeFirst();
        }
        while (this.hasNext()) {
            this.next();
        }
        return true;
    }

    public int getRowNumber() {
        return this.currentPos;
    }

    public boolean absolute(int n2) {
        if (n2 < 0) {
            n2 += this.size;
        }
        if (n2 < 0) {
            this.beforeFirst();
            return false;
        }
        if (n2 >= this.size) {
            this.afterLast();
            return false;
        }
        if (this.size == 0) {
            return false;
        }
        if (n2 < this.currentPos) {
            this.beforeFirst();
        }
        while (n2 > this.currentPos) {
            this.next();
        }
        return true;
    }

    public boolean relative(int n2) {
        int n3 = this.currentPos + n2;
        if (n3 < 0) {
            this.beforeFirst();
            return false;
        }
        return this.absolute(n3);
    }

    public boolean previous() {
        return this.relative(-1);
    }

    public boolean isFirst() {
        return this.size > 0 && this.currentPos == 0;
    }

    public boolean isLast() {
        return this.size > 0 && this.currentPos == this.size - 1;
    }

    @Override
    public boolean isBeforeFirst() {
        return this.size > 0 && this.currentPos == -1;
    }

    public boolean isAfterLast() {
        return this.size > 0 && this.currentPos == this.size;
    }

    public void writeSimple(RowOutputInterface rowOutputInterface, ResultMetaData resultMetaData) {
        throw Error.runtimeError(201, "RowSetNavigator");
    }

    public void readSimple(RowInputInterface rowInputInterface, ResultMetaData resultMetaData) {
        throw Error.runtimeError(201, "RowSetNavigator");
    }

    public abstract void write(RowOutputInterface var1, ResultMetaData var2);

    public abstract void read(RowInputInterface var1, ResultMetaData var2);

    public boolean isMemory() {
        return true;
    }

    @Override
    public int getRangePosition() {
        return this.rangePosition;
    }
}

