/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.map;

import org.hsqldb.map.BaseHashMap;
import org.hsqldb.types.TimestampData;

public class ValuePoolHashMap
extends BaseHashMap {
    long hits;

    public ValuePoolHashMap(int n2, int n3, int n4) throws IllegalArgumentException {
        super(n2, 3, 0, true);
        this.maxCapacity = n3;
        this.purgePolicy = n4;
    }

    protected Integer getOrAddInteger(int n2) {
        int n3;
        Integer n4;
        int n5 = this.hashIndex.getHashIndex(n2);
        int n6 = this.hashIndex.hashTable[n5];
        int n7 = -1;
        while (n6 >= 0) {
            n4 = (Integer)this.objectKeyTable[n6];
            n3 = n4;
            if (n3 == n2) {
                int n8 = this.accessCount.incrementAndGet();
                if (n8 < 0) {
                    this.resetAccessCount();
                    n8 = this.accessCount.incrementAndGet();
                }
                this.accessTable[n6] = n8;
                ++this.hits;
                return n4;
            }
            if (n3 > n2) break;
            n7 = n6;
            n6 = this.hashIndex.getNextLookup(n6);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
            return this.getOrAddInteger(n2);
        }
        n6 = this.hashIndex.linkNode(n5, n7);
        n4 = n2;
        this.objectKeyTable[n6] = n4;
        n3 = this.accessCount.incrementAndGet();
        if (n3 < 0) {
            this.resetAccessCount();
            n3 = this.accessCount.incrementAndGet();
        }
        this.accessTable[n6] = n3;
        return n4;
    }

    protected Long getOrAddLong(long l2) {
        Long l3;
        int n2 = this.hashIndex.getHashIndex((int)(l2 ^ l2 >>> 32));
        int n3 = this.hashIndex.hashTable[n2];
        int n4 = -1;
        while (n3 >= 0) {
            l3 = (Long)this.objectKeyTable[n3];
            long l4 = l3;
            if (l4 == l2) {
                int n5 = this.accessCount.incrementAndGet();
                if (n5 < 0) {
                    this.resetAccessCount();
                    n5 = this.accessCount.incrementAndGet();
                }
                this.accessTable[n3] = n5;
                ++this.hits;
                return l3;
            }
            if (l4 > l2) break;
            n4 = n3;
            n3 = this.hashIndex.getNextLookup(n3);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
            return this.getOrAddLong(l2);
        }
        n3 = this.hashIndex.linkNode(n2, n4);
        l3 = l2;
        this.objectKeyTable[n3] = l3;
        int n6 = this.accessCount.incrementAndGet();
        if (n6 < 0) {
            this.resetAccessCount();
            n6 = this.accessCount.incrementAndGet();
        }
        this.accessTable[n3] = n6;
        return l3;
    }

    protected String getOrAddString(Object object) {
        String string;
        int n2 = this.hashIndex.getHashIndex(object.hashCode());
        int n3 = this.hashIndex.hashTable[n2];
        int n4 = -1;
        while (n3 >= 0) {
            string = (String)this.objectKeyTable[n3];
            if (object.equals(string)) {
                int n5 = this.accessCount.incrementAndGet();
                if (n5 < 0) {
                    this.resetAccessCount();
                    n5 = this.accessCount.incrementAndGet();
                }
                this.accessTable[n3] = n5;
                ++this.hits;
                return string;
            }
            n4 = n3;
            n3 = this.hashIndex.getNextLookup(n3);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
            return this.getOrAddString(object);
        }
        string = object.toString();
        n3 = this.hashIndex.linkNode(n2, n4);
        this.objectKeyTable[n3] = string;
        int n6 = this.accessCount.incrementAndGet();
        if (n6 < 0) {
            this.resetAccessCount();
            n6 = this.accessCount.incrementAndGet();
        }
        this.accessTable[n3] = n6;
        return string;
    }

    protected String getOrAddSubString(String string, int n2, int n3) {
        String string2;
        string = string.substring(n2, n3);
        int n4 = this.hashIndex.getHashIndex(string.hashCode());
        int n5 = this.hashIndex.hashTable[n4];
        int n6 = -1;
        while (n5 >= 0) {
            string2 = (String)this.objectKeyTable[n5];
            if (string.equals(string2)) {
                int n7 = this.accessCount.incrementAndGet();
                if (n7 < 0) {
                    this.resetAccessCount();
                    n7 = this.accessCount.incrementAndGet();
                }
                this.accessTable[n5] = n7;
                ++this.hits;
                return string2;
            }
            n6 = n5;
            n5 = this.hashIndex.getNextLookup(n5);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
            return this.getOrAddString(string);
        }
        string2 = new String(string.toCharArray());
        n5 = this.hashIndex.linkNode(n4, n6);
        this.objectKeyTable[n5] = string2;
        int n8 = this.accessCount.incrementAndGet();
        if (n8 < 0) {
            this.resetAccessCount();
            n8 = this.accessCount.incrementAndGet();
        }
        this.accessTable[n5] = n8;
        return string2;
    }

    protected TimestampData getOrAddDate(long l2) {
        TimestampData timestampData;
        int n2 = (int)l2 ^ (int)(l2 >>> 32);
        int n3 = this.hashIndex.getHashIndex(n2);
        int n4 = this.hashIndex.hashTable[n3];
        int n5 = -1;
        while (n4 >= 0) {
            timestampData = (TimestampData)this.objectKeyTable[n4];
            if (timestampData.getSeconds() == l2) {
                int n6 = this.accessCount.incrementAndGet();
                if (n6 < 0) {
                    this.resetAccessCount();
                    n6 = this.accessCount.incrementAndGet();
                }
                this.accessTable[n4] = n6;
                ++this.hits;
                return timestampData;
            }
            n5 = n4;
            n4 = this.hashIndex.getNextLookup(n4);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
            return this.getOrAddDate(l2);
        }
        n4 = this.hashIndex.linkNode(n3, n5);
        timestampData = new TimestampData(l2);
        this.objectKeyTable[n4] = timestampData;
        int n7 = this.accessCount.incrementAndGet();
        if (n7 < 0) {
            this.resetAccessCount();
            n7 = this.accessCount.incrementAndGet();
        }
        this.accessTable[n4] = n7;
        return timestampData;
    }

    protected Double getOrAddDouble(long l2) {
        Double d2;
        int n2 = this.hashIndex.getHashIndex((int)(l2 ^ l2 >>> 32));
        int n3 = this.hashIndex.hashTable[n2];
        int n4 = -1;
        while (n3 >= 0) {
            d2 = (Double)this.objectKeyTable[n3];
            if (Double.doubleToLongBits(d2) == l2) {
                int n5 = this.accessCount.incrementAndGet();
                if (n5 < 0) {
                    this.resetAccessCount();
                    n5 = this.accessCount.incrementAndGet();
                }
                this.accessTable[n3] = n5;
                ++this.hits;
                return d2;
            }
            n4 = n3;
            n3 = this.hashIndex.getNextLookup(n3);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
            return this.getOrAddDouble(l2);
        }
        n3 = this.hashIndex.linkNode(n2, n4);
        d2 = Double.longBitsToDouble(l2);
        this.objectKeyTable[n3] = d2;
        int n6 = this.accessCount.incrementAndGet();
        if (n6 < 0) {
            this.resetAccessCount();
            n6 = this.accessCount.incrementAndGet();
        }
        this.accessTable[n3] = n6;
        return d2;
    }

    protected Object getOrAddObject(Object object) {
        int n2 = this.hashIndex.getHashIndex(object.hashCode());
        int n3 = this.hashIndex.hashTable[n2];
        int n4 = -1;
        while (n3 >= 0) {
            Object object2 = this.objectKeyTable[n3];
            if (object2.equals(object)) {
                int n5 = this.accessCount.incrementAndGet();
                if (n5 < 0) {
                    this.resetAccessCount();
                    n5 = this.accessCount.incrementAndGet();
                }
                this.accessTable[n3] = n5;
                ++this.hits;
                return object2;
            }
            n4 = n3;
            n3 = this.hashIndex.getNextLookup(n3);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
            return this.getOrAddObject(object);
        }
        n3 = this.hashIndex.linkNode(n2, n4);
        this.objectKeyTable[n3] = object;
        int n6 = this.accessCount.incrementAndGet();
        if (n6 < 0) {
            this.resetAccessCount();
            n6 = this.accessCount.incrementAndGet();
        }
        this.accessTable[n3] = n6;
        return object;
    }
}

