/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.map;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import org.hsqldb.lib.ArrayCounter;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.ObjectComparator;
import org.hsqldb.lib.PrimitiveIterator;
import org.hsqldb.map.HashIndex;

public class BaseHashMap {
    protected boolean isIntKey;
    protected boolean isLongKey;
    protected boolean isObjectKey;
    protected boolean isNoValue;
    protected boolean isIntValue;
    protected boolean isLongValue;
    protected boolean isObjectValue;
    protected boolean isMultiValue;
    protected boolean isTwoObjectValue;
    protected boolean isList;
    protected boolean isAccessCount;
    protected boolean isLastAccessCount;
    protected HashIndex hashIndex;
    protected int[] intKeyTable;
    protected Object[] objectKeyTable;
    protected long[] longKeyTable;
    protected int[] intValueTable;
    protected Object[] objectValueTable;
    protected long[] longValueTable;
    protected int accessMin;
    protected AtomicInteger accessCount;
    protected int[] accessTable;
    protected Object[] objectValueTable2;
    protected final float loadFactor;
    protected final int initialCapacity;
    protected int threshold;
    protected int maxCapacity;
    protected int purgePolicy = 0;
    protected boolean minimizeOnEmpty;
    protected ObjectComparator comparator = ObjectComparator.defaultComparator;
    protected boolean hasZeroKey;
    protected int zeroKeyIndex = -1;
    protected int zeroOrNullValueCount;
    protected static final int noKeyOrValue = 0;
    protected static final int intKeyOrValue = 1;
    protected static final int longKeyOrValue = 2;
    protected static final int objectKeyOrValue = 3;
    protected static final int NO_PURGE = 0;
    protected static final int PURGE_ALL = 1;
    protected static final int PURGE_HALF = 2;
    public static final int ACCESS_MAX = 0x7FEFFFFF;
    public static final Object[] emptyObjectArray = new Object[0];

    protected BaseHashMap(int n2, int n3, int n4, boolean bl) throws IllegalArgumentException {
        if (n2 <= 0) {
            throw new IllegalArgumentException();
        }
        n2 = n2 < 4 ? 4 : (int)ArrayUtil.getBinaryNormalisedCeiling(n2);
        this.loadFactor = 1.0f;
        this.initialCapacity = n2;
        this.threshold = n2;
        int n5 = (int)((float)n2 * this.loadFactor);
        if (n5 < 4) {
            n5 = 4;
        }
        this.hashIndex = new HashIndex(n5, n2, true);
        int n6 = this.threshold;
        if (n3 == 1) {
            this.isIntKey = true;
            this.intKeyTable = new int[n6];
        } else if (n3 == 3) {
            this.isObjectKey = true;
            this.objectKeyTable = new Object[n6];
        } else {
            this.isLongKey = true;
            this.longKeyTable = new long[n6];
        }
        if (n4 == 1) {
            this.isIntValue = true;
            this.intValueTable = new int[n6];
        } else if (n4 == 3) {
            this.isObjectValue = true;
            this.objectValueTable = new Object[n6];
        } else if (n4 == 2) {
            this.isLongValue = true;
            this.longValueTable = new long[n6];
        } else {
            this.isNoValue = true;
        }
        this.isLastAccessCount = bl;
        if (bl) {
            this.accessTable = new int[n6];
            this.accessCount = new AtomicInteger();
        }
    }

    protected int getLookup(Object object) {
        Object object2;
        int n2 = this.comparator.hashCode(object);
        int n3 = this.hashIndex.getLookup(n2);
        while (n3 >= 0 && !this.comparator.equals(object, object2 = this.objectKeyTable[n3])) {
            n3 = this.hashIndex.getNextLookup(n3);
        }
        return n3;
    }

    protected int getLookup(Object object, int n2) {
        Object object2;
        int n3 = this.hashIndex.getLookup(n2);
        while (n3 >= 0 && !this.comparator.equals(object, object2 = this.objectKeyTable[n3])) {
            n3 = this.hashIndex.getNextLookup(n3);
        }
        return n3;
    }

    protected int getLookup(int n2) {
        int n3;
        int n4 = (int)((long)n2 >>> 32 ^ (long)n2);
        int n5 = this.hashIndex.getLookup(n4);
        while (n5 >= 0 && n2 != (n3 = this.intKeyTable[n5])) {
            n5 = this.hashIndex.getNextLookup(n5);
        }
        return n5;
    }

    protected int getLookup(long l2) {
        long l3;
        int n2 = (int)(l2 >>> 32 ^ l2);
        int n3 = this.hashIndex.getLookup(n2);
        while (n3 >= 0 && l2 != (l3 = this.longKeyTable[n3])) {
            n3 = this.hashIndex.getNextLookup(n3);
        }
        return n3;
    }

    protected int getObjectLookup(long l2) {
        long l3;
        int n2 = (int)(l2 >>> 32 ^ l2);
        int n3 = this.hashIndex.getLookup(n2);
        while (n3 >= 0 && (l3 = this.comparator.longKey(this.objectKeyTable[n3])) != l2) {
            n3 = this.hashIndex.getNextLookup(n3);
        }
        return n3;
    }

    protected PrimitiveIterator getMultiValuesIterator(Object object) {
        int n2 = this.getLookup(object);
        ValueCollectionIterator valueCollectionIterator = new ValueCollectionIterator(object, n2);
        return valueCollectionIterator;
    }

    protected int multiValueElementCount(Object object) {
        int n2 = this.getLookup(object);
        if (n2 == -1) {
            return 0;
        }
        int n3 = 1;
        while ((n2 = this.hashIndex.getNextLookup(n2)) != -1 && this.objectKeyTable[n2].equals(object)) {
            ++n3;
        }
        return n3;
    }

    protected int multiValueKeyCount() {
        int n2 = 0;
        int n3 = -1;
        Object object = null;
        int n4 = 0;
        while (n4 < this.hashIndex.hashTable.length) {
            if (this.hashIndex.hashTable[n4] < 0) {
                ++n4;
                continue;
            }
            if ((n3 = n3 < 0 ? this.hashIndex.hashTable[n4] : this.hashIndex.getNextLookup(n3)) < 0) {
                ++n4;
                continue;
            }
            if (this.comparator.equals(object, this.objectKeyTable[n3])) continue;
            object = this.objectKeyTable[n3];
            ++n2;
        }
        return n2;
    }

    protected Object addOrUpdate(long l2, long l3, Object object, Object object2) {
        int n2;
        if (this.isObjectKey) {
            if (object == null) {
                return null;
            }
            n2 = this.comparator.hashCode(object);
        } else {
            n2 = (int)(l2 >>> 32 ^ l2);
        }
        int n3 = this.hashIndex.getHashIndex(n2);
        int n4 = this.hashIndex.hashTable[n3];
        int n5 = -1;
        Object object3 = null;
        boolean bl = false;
        while (n4 >= 0) {
            if (this.isObjectKey) {
                bl = this.comparator.equals(this.objectKeyTable[n4], object);
            } else if (this.isIntKey) {
                bl = l2 == (long)this.intKeyTable[n4];
            } else if (this.isLongKey) {
                boolean bl2 = bl = l2 == this.longKeyTable[n4];
            }
            if (bl) break;
            n5 = n4;
            n4 = this.hashIndex.getNextLookup(n4);
        }
        if (bl) {
            if (this.isNoValue) {
                return Boolean.FALSE;
            }
            if (this.isObjectValue) {
                object3 = this.objectValueTable[n4];
                this.objectValueTable[n4] = object2;
                if (object2 == null) {
                    if (object3 != null) {
                        ++this.zeroOrNullValueCount;
                    }
                } else if (object3 == null) {
                    --this.zeroOrNullValueCount;
                }
            } else if (this.isIntValue) {
                int n6 = this.intValueTable[n4];
                object3 = n6;
                this.intValueTable[n4] = (int)l3;
                if (l3 == 0L) {
                    if (n6 != 0) {
                        ++this.zeroOrNullValueCount;
                    }
                } else if (n6 == 0) {
                    --this.zeroOrNullValueCount;
                }
            } else if (this.isLongValue) {
                long l4 = this.longValueTable[n4];
                object3 = l4;
                this.longValueTable[n4] = l3;
                if (l3 == 0L) {
                    if (l4 != 0L) {
                        ++this.zeroOrNullValueCount;
                    }
                } else if (l4 == 0L) {
                    --this.zeroOrNullValueCount;
                }
            }
            if (this.isLastAccessCount) {
                this.accessTable[n4] = this.accessCount.incrementAndGet();
            } else if (this.isAccessCount) {
                int n7 = n4;
                this.accessTable[n7] = this.accessTable[n7] + 1;
            }
            return object3;
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            if (this.reset()) {
                return this.addOrUpdate(l2, l3, object, object2);
            }
            throw new NoSuchElementException("BaseHashMap");
        }
        n4 = this.hashIndex.linkNode(n3, n5);
        if (this.isObjectKey) {
            this.objectKeyTable[n4] = object;
        } else if (this.isIntKey) {
            this.intKeyTable[n4] = (int)l2;
            if (l2 == 0L) {
                this.hasZeroKey = true;
                this.zeroKeyIndex = n4;
            }
        } else if (this.isLongKey) {
            this.longKeyTable[n4] = l2;
            if (l2 == 0L) {
                this.hasZeroKey = true;
                this.zeroKeyIndex = n4;
            }
        }
        if (this.isNoValue) {
            return Boolean.TRUE;
        }
        if (this.isObjectValue) {
            this.objectValueTable[n4] = object2;
            if (object2 == null) {
                ++this.zeroOrNullValueCount;
            }
        } else if (this.isIntValue) {
            this.intValueTable[n4] = (int)l3;
            if (l3 == 0L) {
                ++this.zeroOrNullValueCount;
            }
        } else if (this.isLongValue) {
            this.longValueTable[n4] = l3;
            if (l3 == 0L) {
                ++this.zeroOrNullValueCount;
            }
        }
        if (this.isLastAccessCount) {
            this.accessTable[n4] = this.accessCount.incrementAndGet();
        } else if (this.isAccessCount) {
            this.accessTable[n4] = 1;
        }
        return object3;
    }

    protected Object remove(long l2, long l3, Object object, Object object2, boolean bl, boolean bl2) {
        int n2;
        int n3;
        if (this.isObjectKey) {
            if (object == null) {
                return null;
            }
            n3 = this.comparator.hashCode(object);
        } else {
            n3 = (int)(l2 >>> 32 ^ l2);
        }
        int n4 = this.hashIndex.getHashIndex(n3);
        int n5 = this.hashIndex.hashTable[n4];
        int n6 = -1;
        Object object3 = null;
        while (n5 >= 0) {
            n2 = 0;
            if (this.isObjectKey) {
                n2 = this.comparator.equals(this.objectKeyTable[n5], object);
            } else if (this.isIntKey) {
                n2 = l2 == (long)this.intKeyTable[n5] ? 1 : 0;
            } else if (this.isLongKey) {
                int n7 = n2 = l2 == this.longKeyTable[n5] ? 1 : 0;
            }
            if (n2 != 0) {
                if (!bl) break;
                if (this.isObjectValue) {
                    n2 = ObjectComparator.defaultComparator.equals(this.objectValueTable[n5], object2) ? 1 : 0;
                } else if (this.isIntValue) {
                    n2 = (long)this.intValueTable[n5] == l3 ? 1 : 0;
                } else if (this.isLongKey) {
                    int n8 = n2 = this.longValueTable[n5] == l3 ? 1 : 0;
                }
                if (n2 != 0) break;
                return null;
            }
            n6 = n5;
            n5 = this.hashIndex.getNextLookup(n5);
        }
        if (n5 < 0) {
            if (this.isNoValue) {
                return Boolean.FALSE;
            }
            return null;
        }
        if (this.isObjectKey) {
            this.objectKeyTable[n5] = null;
        } else {
            if (l2 == 0L) {
                this.hasZeroKey = false;
                this.zeroKeyIndex = -1;
            }
            if (this.isIntKey) {
                this.intKeyTable[n5] = 0;
            } else {
                this.longKeyTable[n5] = 0L;
            }
        }
        if (this.isNoValue) {
            object3 = Boolean.TRUE;
        } else if (this.isObjectValue) {
            object3 = this.objectValueTable[n5];
            this.objectValueTable[n5] = null;
            if (object3 == null) {
                --this.zeroOrNullValueCount;
            }
        } else if (this.isIntValue) {
            n2 = this.intValueTable[n5];
            object3 = n2;
            this.intValueTable[n5] = 0;
            if (n2 == 0) {
                --this.zeroOrNullValueCount;
            }
        } else if (this.isLongValue) {
            long l4 = this.longValueTable[n5];
            object3 = l4;
            this.longValueTable[n5] = 0L;
            if (l4 == 0L) {
                --this.zeroOrNullValueCount;
            }
        }
        this.hashIndex.unlinkNode(n4, n6, n5);
        if (this.accessTable != null) {
            this.accessTable[n5] = 0;
        }
        if (this.isList && bl2) {
            this.removeRow(n5);
        }
        if (this.minimizeOnEmpty && this.hashIndex.elementCount == 0) {
            this.rehash(this.initialCapacity);
        }
        return object3;
    }

    protected boolean addMultiVal(long l2, long l3, Object object, Object object2) {
        int n2;
        if (this.isObjectKey) {
            if (object == null) {
                return false;
            }
            n2 = this.comparator.hashCode(object);
        } else {
            n2 = (int)(l2 >>> 32 ^ l2);
        }
        int n3 = this.hashIndex.getHashIndex(n2);
        int n4 = this.hashIndex.hashTable[n3];
        int n5 = -1;
        int n6 = -1;
        boolean bl = false;
        while (n4 >= 0) {
            if (this.isObjectKey) {
                bl = this.comparator.equals(this.objectKeyTable[n4], object);
            } else if (this.isIntKey) {
                bl = l2 == (long)this.intKeyTable[n4];
            } else if (this.isLongKey) {
                boolean bl2 = bl = l2 == this.longKeyTable[n4];
            }
            if (!bl) {
                if (n6 >= 0) break;
            } else {
                n6 = n4;
                if (this.isObjectValue) {
                    bl = ObjectComparator.defaultComparator.equals(this.objectValueTable[n4], object2);
                } else if (this.isIntValue) {
                    bl = l3 == (long)this.intValueTable[n4];
                } else if (this.isLongValue) {
                    boolean bl3 = bl = l3 == this.longValueTable[n4];
                }
                if (bl) {
                    return false;
                }
            }
            n5 = n4;
            n4 = this.hashIndex.getNextLookup(n4);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            if (this.reset()) {
                return this.addMultiVal(l2, l3, object, object2);
            }
            throw new NoSuchElementException("BaseHashMap");
        }
        n4 = this.hashIndex.linkNode(n3, n5);
        if (this.isObjectKey) {
            this.objectKeyTable[n4] = object;
        } else if (this.isIntKey) {
            this.intKeyTable[n4] = (int)l2;
            if (l2 == 0L) {
                this.hasZeroKey = true;
                this.zeroKeyIndex = n4;
            }
        } else if (this.isLongKey) {
            this.longKeyTable[n4] = l2;
            if (l2 == 0L) {
                this.hasZeroKey = true;
                this.zeroKeyIndex = n4;
            }
        }
        if (this.isObjectValue) {
            this.objectValueTable[n4] = object2;
            if (object2 == null) {
                ++this.zeroOrNullValueCount;
            }
        } else if (this.isIntValue) {
            this.intValueTable[n4] = (int)l3;
            if (l3 == 0L) {
                ++this.zeroOrNullValueCount;
            }
        } else if (this.isLongValue) {
            this.longValueTable[n4] = l3;
            if (l3 == 0L) {
                ++this.zeroOrNullValueCount;
            }
        }
        if (this.isLastAccessCount) {
            this.accessTable[n4] = this.accessCount.incrementAndGet();
        } else if (this.isAccessCount) {
            this.accessTable[n4] = 1;
        }
        return true;
    }

    protected Object removeMultiVal(long l2, long l3, Object object, Object object2, boolean bl) {
        if (object == null) {
            return null;
        }
        int n2 = this.comparator.hashCode(object);
        int n3 = this.hashIndex.getHashIndex(n2);
        int n4 = this.hashIndex.hashTable[n3];
        int n5 = -1;
        int n6 = -1;
        Object object3 = null;
        while (n4 >= 0) {
            boolean bl2 = false;
            if (this.isObjectKey) {
                bl2 = this.comparator.equals(this.objectKeyTable[n4], object);
                if (!bl2) {
                    if (n6 >= 0) break;
                } else {
                    n6 = n4;
                    if (bl) {
                        bl2 = ObjectComparator.defaultComparator.equals(this.objectValueTable[n4], object2);
                        if (bl2) {
                            this.objectKeyTable[n4] = null;
                            object3 = this.objectValueTable[n4];
                            this.objectValueTable[n4] = null;
                            if (object3 == null) {
                                --this.zeroOrNullValueCount;
                            }
                            this.hashIndex.unlinkNode(n3, n5, n4);
                            return object3;
                        }
                    } else {
                        this.objectKeyTable[n4] = null;
                        object3 = this.objectValueTable[n4];
                        this.objectValueTable[n4] = null;
                        if (object3 == null) {
                            --this.zeroOrNullValueCount;
                        }
                        if (n5 > n4) {
                            // empty if block
                        }
                        this.hashIndex.unlinkNode(n3, n5, n4);
                        if (n5 < 0) {
                            n4 = this.hashIndex.hashTable[n3];
                            if (n4 < 0) {
                                break;
                            }
                        } else {
                            n4 = n5;
                        }
                    }
                }
            }
            n5 = n4;
            n4 = this.hashIndex.getNextLookup(n4);
        }
        return object3;
    }

    protected Object removeObject(Object object, boolean bl) {
        if (object == null) {
            return null;
        }
        int n2 = this.comparator.hashCode(object);
        int n3 = this.hashIndex.getHashIndex(n2);
        int n4 = this.hashIndex.hashTable[n3];
        int n5 = -1;
        Object object2 = null;
        while (n4 >= 0) {
            if (this.comparator.equals(this.objectKeyTable[n4], object)) {
                object2 = this.objectKeyTable[n4];
                this.objectKeyTable[n4] = null;
                if (this.accessTable != null) {
                    this.accessTable[n4] = 0;
                }
                this.hashIndex.unlinkNode(n3, n5, n4);
                if (this.isObjectValue) {
                    object2 = this.objectValueTable[n4];
                    this.objectValueTable[n4] = null;
                }
                if (bl) {
                    this.removeRow(n4);
                }
                return object2;
            }
            n5 = n4;
            n4 = this.hashIndex.getNextLookup(n4);
        }
        return object2;
    }

    protected Object addOrRemoveObject(long l2, Object object, boolean bl) {
        int n2 = (int)(l2 >>> 32 ^ l2);
        int n3 = this.hashIndex.getHashIndex(n2);
        int n4 = this.hashIndex.getLookup(n2);
        int n5 = -1;
        Object object2 = null;
        while (n4 >= 0) {
            if (this.comparator.longKey(this.objectKeyTable[n4]) == l2) {
                object2 = this.objectKeyTable[n4];
                break;
            }
            n5 = n4;
            n4 = this.hashIndex.getNextLookup(n4);
        }
        if (n4 >= 0) {
            if (bl) {
                this.objectKeyTable[n4] = null;
                this.hashIndex.unlinkNode(n3, n5, n4);
                if (this.accessTable != null) {
                    this.accessTable[n4] = 0;
                }
                if (this.minimizeOnEmpty && this.hashIndex.elementCount == 0) {
                    this.rehash(this.initialCapacity);
                }
            } else {
                this.objectKeyTable[n4] = object;
                if (this.isLastAccessCount) {
                    this.accessTable[n4] = this.accessCount.incrementAndGet();
                } else if (this.isAccessCount) {
                    int n6 = n4;
                    this.accessTable[n6] = this.accessTable[n6] + 1;
                }
            }
            return object2;
        }
        if (bl) {
            return null;
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            if (this.reset()) {
                return this.addOrRemoveObject(l2, object, bl);
            }
            throw new NoSuchElementException("BaseHashMap");
        }
        n4 = this.hashIndex.linkNode(n3, n5);
        this.objectKeyTable[n4] = object;
        if (this.isLastAccessCount) {
            this.accessTable[n4] = this.accessCount.incrementAndGet();
        } else if (this.isAccessCount) {
            this.accessTable[n4] = 1;
        }
        return object2;
    }

    protected boolean reset() {
        if (this.maxCapacity == 0 || this.maxCapacity > this.threshold) {
            this.rehash(this.hashIndex.linkTable.length * 2);
            return true;
        }
        switch (this.purgePolicy) {
            case 1: {
                this.clear();
                return true;
            }
            case 2: {
                this.clearToHalf();
                return true;
            }
        }
        return false;
    }

    protected void rehash(int n2) {
        int n3 = this.hashIndex.newNodePointer;
        boolean bl = this.hasZeroKey;
        int n4 = this.zeroKeyIndex;
        if (n2 < this.hashIndex.elementCount) {
            return;
        }
        this.hashIndex.reset((int)((float)n2 * this.loadFactor), n2);
        this.hasZeroKey = false;
        this.zeroKeyIndex = -1;
        this.zeroOrNullValueCount = 0;
        this.threshold = n2;
        int n5 = -1;
        while ((n5 = this.nextLookup(n5, n3, bl, n4)) < n3) {
            long l2 = 0L;
            long l3 = 0L;
            Object object = null;
            Object object2 = null;
            if (this.isObjectKey) {
                object = this.objectKeyTable[n5];
            } else {
                l2 = this.isIntKey ? (long)this.intKeyTable[n5] : this.longKeyTable[n5];
            }
            if (this.isObjectValue) {
                object2 = this.objectValueTable[n5];
            } else if (this.isIntValue) {
                l3 = this.intValueTable[n5];
            } else if (this.isLongValue) {
                l3 = this.longValueTable[n5];
            }
            if (this.isMultiValue) {
                this.addMultiVal(l2, l3, object, object2);
            } else {
                this.addOrUpdate(l2, l3, object, object2);
            }
            if (this.accessTable == null) continue;
            this.accessTable[this.hashIndex.elementCount - 1] = this.accessTable[n5];
        }
        this.resizeElementArrays(this.hashIndex.newNodePointer, n2);
    }

    private void resizeElementArrays(int n2, int n3) {
        Object[] objectArray;
        int n4;
        int n5 = n4 = n3 > n2 ? n2 : n3;
        if (this.isIntKey) {
            objectArray = this.intKeyTable;
            this.intKeyTable = new int[n3];
            System.arraycopy(objectArray, 0, this.intKeyTable, 0, n4);
        }
        if (this.isIntValue) {
            objectArray = this.intValueTable;
            this.intValueTable = new int[n3];
            System.arraycopy(objectArray, 0, this.intValueTable, 0, n4);
        }
        if (this.isLongKey) {
            objectArray = this.longKeyTable;
            this.longKeyTable = new long[n3];
            System.arraycopy(objectArray, 0, this.longKeyTable, 0, n4);
        }
        if (this.isLongValue) {
            objectArray = this.longValueTable;
            this.longValueTable = new long[n3];
            System.arraycopy(objectArray, 0, this.longValueTable, 0, n4);
        }
        if (this.objectKeyTable != null) {
            objectArray = this.objectKeyTable;
            this.objectKeyTable = new Object[n3];
            System.arraycopy(objectArray, 0, this.objectKeyTable, 0, n4);
        }
        if (this.isObjectValue) {
            objectArray = this.objectValueTable;
            this.objectValueTable = new Object[n3];
            System.arraycopy(objectArray, 0, this.objectValueTable, 0, n4);
        }
        if (this.objectValueTable2 != null) {
            objectArray = this.objectValueTable2;
            this.objectValueTable2 = new Object[n3];
            System.arraycopy(objectArray, 0, this.objectValueTable2, 0, n4);
        }
        if (this.accessTable != null) {
            objectArray = this.accessTable;
            this.accessTable = new int[n3];
            System.arraycopy(objectArray, 0, this.accessTable, 0, n4);
        }
    }

    private void clearElementArrays(int n2, int n3) {
        if (this.intKeyTable != null) {
            Arrays.fill(this.intKeyTable, n2, n3, 0);
        } else if (this.longKeyTable != null) {
            Arrays.fill(this.longKeyTable, n2, n3, 0L);
        }
        if (this.objectKeyTable != null) {
            Arrays.fill(this.objectKeyTable, n2, n3, null);
        }
        if (this.intValueTable != null) {
            Arrays.fill(this.intValueTable, n2, n3, 0);
        } else if (this.longValueTable != null) {
            Arrays.fill(this.longValueTable, n2, n3, 0L);
        } else if (this.objectValueTable != null) {
            Arrays.fill(this.objectValueTable, n2, n3, null);
        }
        if (this.objectValueTable2 != null) {
            Arrays.fill(this.objectValueTable2, n2, n3, null);
        }
        if (this.accessTable != null) {
            Arrays.fill(this.accessTable, n2, n3, 0);
        }
    }

    void removeFromElementArrays(int n2, int n3) {
        Object[] objectArray;
        if (this.isIntKey) {
            objectArray = this.intKeyTable;
            System.arraycopy(objectArray, n3 + 1, objectArray, n3, n2 - n3 - 1);
            this.intKeyTable[n2 - 1] = 0;
        } else if (this.isLongKey) {
            objectArray = this.longKeyTable;
            System.arraycopy(objectArray, n3 + 1, objectArray, n3, n2 - n3 - 1);
            this.longKeyTable[n2 - 1] = 0L;
        }
        if (this.objectKeyTable != null) {
            objectArray = this.objectKeyTable;
            System.arraycopy(objectArray, n3 + 1, objectArray, n3, n2 - n3 - 1);
            this.objectKeyTable[n2 - 1] = null;
        }
        if (this.isIntValue) {
            objectArray = this.intValueTable;
            System.arraycopy(objectArray, n3 + 1, objectArray, n3, n2 - n3 - 1);
            this.intValueTable[n2 - 1] = 0;
        } else if (this.isLongValue) {
            objectArray = this.longValueTable;
            System.arraycopy(objectArray, n3 + 1, objectArray, n3, n2 - n3 - 1);
            this.longValueTable[n2 - 1] = 0L;
        }
        if (this.isObjectValue) {
            objectArray = this.objectValueTable;
            System.arraycopy(objectArray, n3 + 1, objectArray, n3, n2 - n3 - 1);
            this.objectValueTable[n2 - 1] = null;
        }
        if (this.objectValueTable2 != null) {
            objectArray = this.objectValueTable2;
            System.arraycopy(objectArray, n3 + 1, objectArray, n3, n2 - n3 - 1);
            this.objectValueTable2[n2 - 1] = null;
        }
        if (this.accessTable != null) {
            objectArray = this.accessTable;
            System.arraycopy(objectArray, n3 + 1, objectArray, n3, n2 - n3 - 1);
            this.accessTable[n2 - 1] = 0;
        }
    }

    void insertIntoElementArrays(int n2, int n3) {
        Object[] objectArray;
        if (this.isIntKey) {
            objectArray = this.intKeyTable;
            System.arraycopy(objectArray, n3, objectArray, n3 + 1, n2 - n3);
            this.intKeyTable[n3] = 0;
        } else if (this.isLongKey) {
            objectArray = this.longKeyTable;
            System.arraycopy(objectArray, n3, objectArray, n3 + 1, n2 - n3);
            this.longKeyTable[n3] = 0L;
        }
        if (this.objectKeyTable != null) {
            objectArray = this.objectKeyTable;
            System.arraycopy(objectArray, n3, objectArray, n3 + 1, n2 - n3);
            this.objectKeyTable[n3] = null;
        }
        if (this.isIntValue) {
            objectArray = this.intValueTable;
            System.arraycopy(objectArray, n3, objectArray, n3 + 1, n2 - n3);
            this.intValueTable[n3] = 0;
        } else if (this.isLongValue) {
            objectArray = this.longValueTable;
            System.arraycopy(objectArray, n3, objectArray, n3 + 1, n2 - n3);
            this.longValueTable[n3] = 0L;
        }
        if (this.isObjectValue) {
            objectArray = this.objectValueTable;
            System.arraycopy(objectArray, n3, objectArray, n3 + 1, n2 - n3);
            this.objectValueTable[n3] = null;
        }
        if (this.objectValueTable2 != null) {
            objectArray = this.objectValueTable2;
            System.arraycopy(objectArray, n3, objectArray, n3 + 1, n2 - n3);
            this.objectValueTable2[n3] = null;
        }
        if (this.accessTable != null) {
            objectArray = this.accessTable;
            System.arraycopy(objectArray, n3, objectArray, n3 + 1, n2 - n3);
            this.accessTable[n3] = 0;
        }
    }

    int nextLookup(int n2, int n3, boolean bl, int n4) {
        ++n2;
        while (n2 < n3) {
            if (this.isObjectKey) {
                if (this.objectKeyTable[n2] != null) {
                    return n2;
                }
            } else if (this.isIntKey) {
                if (this.intKeyTable[n2] != 0) {
                    return n2;
                }
                if (bl && n2 == n4) {
                    return n2;
                }
            } else {
                if (this.longKeyTable[n2] != 0L) {
                    return n2;
                }
                if (bl && n2 == n4) {
                    return n2;
                }
            }
            ++n2;
        }
        return n2;
    }

    protected int nextLookup(int n2) {
        ++n2;
        while (n2 < this.hashIndex.newNodePointer) {
            if (this.isObjectKey) {
                if (this.objectKeyTable[n2] != null) {
                    return n2;
                }
            } else if (this.isIntKey) {
                if (this.intKeyTable[n2] != 0) {
                    return n2;
                }
                if (this.hasZeroKey && n2 == this.zeroKeyIndex) {
                    return n2;
                }
            } else {
                if (this.longKeyTable[n2] != 0L) {
                    return n2;
                }
                if (this.hasZeroKey && n2 == this.zeroKeyIndex) {
                    return n2;
                }
            }
            ++n2;
        }
        return -1;
    }

    protected void removeRow(int n2) {
        int n3 = this.hashIndex.newNodePointer;
        if (n3 == 0) {
            return;
        }
        this.hashIndex.removeEmptyNode(n2);
        this.removeFromElementArrays(n3, n2);
    }

    protected void insertRow(int n2) {
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
        }
        if (n2 == this.hashIndex.elementCount) {
            return;
        }
        int n3 = this.hashIndex.newNodePointer;
        if (n3 == 0) {
            return;
        }
        this.insertIntoElementArrays(n3, n2);
        this.hashIndex.insertEmptyNode(n2);
    }

    public void clear() {
        if (this.hashIndex.modified) {
            if (this.accessCount != null) {
                this.accessCount.set(0);
            }
            this.accessMin = 0;
            this.hasZeroKey = false;
            this.zeroKeyIndex = -1;
            this.zeroOrNullValueCount = 0;
            this.clearElementArrays(0, this.hashIndex.newNodePointer);
            this.hashIndex.clear();
            if (this.minimizeOnEmpty) {
                this.rehash(this.initialCapacity);
            }
        }
    }

    protected int getAccessCountCeiling(int n2, int n3) {
        return ArrayCounter.rank(this.accessTable, this.hashIndex.newNodePointer, n2, this.accessMin, this.accessCount.get(), n3);
    }

    protected void setAccessCountFloor(int n2) {
        this.accessMin = n2;
    }

    private void clearToHalf() {
        int n2 = this.threshold >> 1;
        int n3 = this.threshold >> 8;
        if (n3 < 64) {
            n3 = 64;
        }
        int n4 = this.hashIndex.newNodePointer;
        int n5 = this.getAccessCountCeiling(n2, n3);
        for (int i2 = 0; i2 < n4; ++i2) {
            Object object = this.objectKeyTable[i2];
            if (object == null || this.accessTable[i2] >= n5) continue;
            this.removeObject(object, false);
        }
        this.accessMin = n5;
        if (this.hashIndex.elementCount > this.threshold - n3) {
            this.clear();
        }
    }

    protected void resetAccessCount() {
        int n2 = this.accessCount.get();
        if (n2 > 0 && n2 < 0x7FEFFFFF) {
            return;
        }
        int n3 = this.hashIndex.getNewNodePointer();
        n2 = 0;
        this.accessMin = Integer.MAX_VALUE;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = this.accessTable[i2];
            if (n4 == 0) continue;
            this.accessTable[i2] = n4 = (n4 >>> 2) + 1;
            if (n4 > n2) {
                n2 = n4;
                continue;
            }
            if (n4 >= this.accessMin) continue;
            this.accessMin = n4;
        }
        if (this.accessMin > n2) {
            this.accessMin = n2;
        }
        this.accessCount.set(n2);
    }

    protected int capacity() {
        return this.hashIndex.linkTable.length;
    }

    public int size() {
        return this.hashIndex.elementCount;
    }

    public boolean isEmpty() {
        return this.hashIndex.elementCount == 0;
    }

    protected boolean containsKey(Object object) {
        if (object == null) {
            return false;
        }
        if (this.hashIndex.elementCount == 0) {
            return false;
        }
        int n2 = this.getLookup(object, this.comparator.hashCode(object));
        return n2 != -1;
    }

    protected boolean containsKey(int n2) {
        if (this.hashIndex.elementCount == 0) {
            return false;
        }
        int n3 = this.getLookup(n2);
        return n3 != -1;
    }

    protected boolean containsKey(long l2) {
        if (this.hashIndex.elementCount == 0) {
            return false;
        }
        int n2 = this.getLookup(l2);
        return n2 != -1;
    }

    protected boolean containsValue(Object object) {
        int n2;
        if (this.hashIndex.elementCount == 0) {
            return false;
        }
        if (object == null) {
            for (n2 = 0; n2 < this.hashIndex.newNodePointer; ++n2) {
                if (this.objectValueTable[n2] != null) continue;
                if (this.isObjectKey) {
                    if (this.objectKeyTable[n2] == null) continue;
                    return true;
                }
                if (this.isIntKey) {
                    if (this.intKeyTable[n2] != 0) {
                        return true;
                    }
                    if (!this.hasZeroKey || n2 != this.zeroKeyIndex) continue;
                    return true;
                }
                if (this.longKeyTable[n2] != 0L) {
                    return true;
                }
                if (!this.hasZeroKey || n2 != this.zeroKeyIndex) continue;
                return true;
            }
        } else {
            while (n2 < this.hashIndex.newNodePointer) {
                if (object.equals(this.objectValueTable[n2])) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected boolean containsValue(int n2) {
        if (n2 == 0) {
            return this.zeroOrNullValueCount > 0;
        }
        for (int i2 = 0; i2 < this.hashIndex.newNodePointer; ++i2) {
            if (this.intValueTable[i2] != n2) continue;
            return true;
        }
        return false;
    }

    protected boolean containsValue(long l2) {
        if (l2 == 0L) {
            return this.zeroOrNullValueCount > 0;
        }
        for (int i2 = 0; i2 < this.hashIndex.newNodePointer; ++i2) {
            if (this.longValueTable[i2] != l2) continue;
            return true;
        }
        return false;
    }

    protected Object[] toArray(boolean bl) {
        Object[] objectArray = new Object[this.size()];
        return this.toArray(objectArray, bl);
    }

    protected <T> T[] multiValueKeysToArray(T[] objectArray) {
        int n2 = this.multiValueKeyCount();
        if (objectArray.length < n2) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n2);
        }
        MultiValueKeyIterator multiValueKeyIterator = new MultiValueKeyIterator();
        int n3 = 0;
        while (multiValueKeyIterator.hasNext()) {
            objectArray[n3] = multiValueKeyIterator.next();
            ++n3;
        }
        return objectArray;
    }

    protected <T> T[] toArray(T[] objectArray, boolean bl) {
        if (objectArray.length < this.size()) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.size());
        }
        int n2 = this.hashIndex.getNewNodePointer();
        int n3 = 0;
        Object[] objectArray2 = bl ? this.objectKeyTable : this.objectValueTable;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = objectArray2[i2];
            if (object == null) continue;
            objectArray[n3++] = object;
        }
        return objectArray;
    }

    protected int[] toIntArray(int[] nArray, boolean bl) {
        if (nArray.length < this.size()) {
            nArray = new int[this.size()];
        }
        BaseHashIterator baseHashIterator = new BaseHashIterator(bl);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2;
            nArray[i2] = n2 = baseHashIterator.nextInt();
        }
        return nArray;
    }

    protected long[] toLongArray(long[] lArray, boolean bl) {
        if (lArray.length < this.size()) {
            lArray = new long[this.size()];
        }
        BaseHashIterator baseHashIterator = new BaseHashIterator(bl);
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            long l2;
            lArray[i2] = l2 = (long)baseHashIterator.nextInt();
        }
        return lArray;
    }

    public BaseHashMap clone() {
        BaseHashMap baseHashMap = null;
        try {
            baseHashMap = (BaseHashMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        baseHashMap.hashIndex = this.hashIndex.clone();
        if (this.intKeyTable != null) {
            baseHashMap.intKeyTable = (int[])this.intKeyTable.clone();
        }
        if (this.objectKeyTable != null) {
            baseHashMap.objectKeyTable = (Object[])this.objectKeyTable.clone();
        }
        if (this.longKeyTable != null) {
            baseHashMap.longKeyTable = (long[])this.longKeyTable.clone();
        }
        if (this.intValueTable != null) {
            baseHashMap.intValueTable = (int[])this.intValueTable.clone();
        }
        if (this.objectValueTable != null) {
            baseHashMap.objectValueTable = (Object[])this.objectValueTable.clone();
        }
        if (this.longValueTable != null) {
            baseHashMap.longValueTable = (long[])this.longValueTable.clone();
        }
        if (this.accessTable != null) {
            baseHashMap.accessTable = (int[])this.accessTable.clone();
        }
        if (this.objectValueTable2 != null) {
            baseHashMap.objectValueTable2 = (Object[])this.objectValueTable2.clone();
        }
        return baseHashMap;
    }

    BaseHashMap duplicate() {
        return null;
    }

    protected class BaseHashIterator
    implements PrimitiveIterator {
        protected boolean keys;
        protected int lookup = -1;
        protected int counter;
        protected boolean removed;

        public BaseHashIterator() {
        }

        public BaseHashIterator(boolean bl) {
            this.keys = bl;
            if (!bl && BaseHashMap.this.isNoValue) {
                throw new RuntimeException("Hash Iterator");
            }
        }

        public void reset() {
            this.lookup = -1;
            this.counter = 0;
            this.removed = false;
        }

        @Override
        public boolean hasNext() {
            return this.counter < BaseHashMap.this.hashIndex.elementCount;
        }

        @Override
        public Object next() throws NoSuchElementException {
            if (this.keys) {
                if (BaseHashMap.this.isIntKey) {
                    return this.nextInt();
                }
                if (BaseHashMap.this.isLongKey) {
                    return this.nextLong();
                }
            } else {
                if (BaseHashMap.this.isIntValue) {
                    return this.nextInt();
                }
                if (BaseHashMap.this.isLongValue) {
                    return this.nextLong();
                }
            }
            this.removed = false;
            if (this.hasNext()) {
                ++this.counter;
                this.lookup = BaseHashMap.this.nextLookup(this.lookup);
                if (this.keys) {
                    return BaseHashMap.this.objectKeyTable[this.lookup];
                }
                return BaseHashMap.this.objectValueTable[this.lookup];
            }
            throw new NoSuchElementException("Hash Iterator");
        }

        @Override
        public int nextInt() throws NoSuchElementException {
            if (this.keys && !BaseHashMap.this.isIntKey || !this.keys && !BaseHashMap.this.isIntValue) {
                throw new NoSuchElementException("Hash Iterator");
            }
            this.removed = false;
            if (this.hasNext()) {
                ++this.counter;
                this.lookup = BaseHashMap.this.nextLookup(this.lookup);
                if (this.keys) {
                    return BaseHashMap.this.intKeyTable[this.lookup];
                }
                return BaseHashMap.this.intValueTable[this.lookup];
            }
            throw new NoSuchElementException("Hash Iterator");
        }

        @Override
        public long nextLong() throws NoSuchElementException {
            if (this.keys && !BaseHashMap.this.isLongKey || !this.keys && !BaseHashMap.this.isLongValue) {
                throw new NoSuchElementException("Hash Iterator");
            }
            this.removed = false;
            if (this.hasNext()) {
                ++this.counter;
                this.lookup = BaseHashMap.this.nextLookup(this.lookup);
                return this.keys ? BaseHashMap.this.longKeyTable[this.lookup] : BaseHashMap.this.longValueTable[this.lookup];
            }
            throw new NoSuchElementException("Hash Iterator");
        }

        @Override
        public void remove() throws NoSuchElementException {
            if (this.removed) {
                throw new NoSuchElementException("Hash Iterator");
            }
            --this.counter;
            this.removed = true;
            if (BaseHashMap.this.isObjectKey) {
                if (BaseHashMap.this.isMultiValue) {
                    BaseHashMap.this.removeMultiVal(0L, 0L, BaseHashMap.this.objectKeyTable[this.lookup], BaseHashMap.this.objectValueTable[this.lookup], true);
                } else {
                    BaseHashMap.this.remove(0L, 0L, BaseHashMap.this.objectKeyTable[this.lookup], null, false, true);
                }
            } else if (BaseHashMap.this.isIntKey) {
                BaseHashMap.this.remove(BaseHashMap.this.intKeyTable[this.lookup], 0L, null, null, false, true);
            } else {
                BaseHashMap.this.remove(BaseHashMap.this.longKeyTable[this.lookup], 0L, null, null, false, true);
            }
            if (BaseHashMap.this.isList) {
                --this.lookup;
            }
        }

        public int getAccessCount() {
            if (this.removed || BaseHashMap.this.accessTable == null) {
                throw new NoSuchElementException();
            }
            return BaseHashMap.this.accessTable[this.lookup];
        }

        public void setAccessCount(int n2) {
            if (this.removed || BaseHashMap.this.accessTable == null) {
                throw new NoSuchElementException();
            }
            BaseHashMap.this.accessTable[this.lookup] = n2;
        }

        public int getLookup() {
            return this.lookup;
        }
    }

    protected class MultiValueKeyIterator
    implements PrimitiveIterator {
        int index = 0;
        int lookup = -1;
        boolean removed;
        Object oldKey;

        public MultiValueKeyIterator() {
            if (BaseHashMap.this.hashIndex.elementCount > 0) {
                this.toNextLookup();
            }
        }

        private void toNextLookup() {
            while (this.index < BaseHashMap.this.hashIndex.hashTable.length) {
                if (BaseHashMap.this.hashIndex.hashTable[this.index] < 0) {
                    ++this.index;
                    continue;
                }
                this.lookup = this.lookup < 0 ? BaseHashMap.this.hashIndex.hashTable[this.index] : BaseHashMap.this.hashIndex.getNextLookup(this.lookup);
                if (this.lookup < 0) {
                    ++this.index;
                    continue;
                }
                if (BaseHashMap.this.comparator.equals(this.oldKey, BaseHashMap.this.objectKeyTable[this.lookup])) continue;
            }
        }

        @Override
        public boolean hasNext() {
            return this.lookup != -1;
        }

        @Override
        public Object next() throws NoSuchElementException {
            if (this.lookup < 0) {
                throw new NoSuchElementException("Hash Iterator");
            }
            Object object = BaseHashMap.this.objectKeyTable[this.lookup];
            this.toNextLookup();
            this.oldKey = object;
            return object;
        }

        @Override
        public int nextInt() throws NoSuchElementException {
            throw new NoSuchElementException("Hash Iterator");
        }

        @Override
        public long nextLong() throws NoSuchElementException {
            throw new NoSuchElementException("Hash Iterator");
        }

        @Override
        public void remove() throws NoSuchElementException {
            BaseHashMap.this.removeMultiVal(0L, 0L, this.oldKey, null, false);
            this.oldKey = null;
        }
    }

    protected class ValueCollectionIterator
    implements PrimitiveIterator {
        int lookup = -1;
        Object key;

        ValueCollectionIterator(Object object, int n2) {
            this.key = object;
            this.lookup = n2;
        }

        @Override
        public boolean hasNext() {
            return this.lookup != -1;
        }

        @Override
        public Object next() throws NoSuchElementException {
            Object object;
            if (this.lookup == -1) {
                throw new NoSuchElementException();
            }
            Object object2 = BaseHashMap.this.objectValueTable[this.lookup];
            this.lookup = BaseHashMap.this.hashIndex.getNextLookup(this.lookup);
            if (this.lookup != -1 && !BaseHashMap.this.comparator.equals(object = BaseHashMap.this.objectKeyTable[this.lookup], this.key)) {
                this.lookup = -1;
            }
            return object2;
        }

        @Override
        public int nextInt() throws NoSuchElementException {
            throw new NoSuchElementException("Hash Iterator");
        }

        @Override
        public long nextLong() throws NoSuchElementException {
            throw new NoSuchElementException("Hash Iterator");
        }

        @Override
        public void remove() throws NoSuchElementException {
            throw new NoSuchElementException("Hash Iterator");
        }
    }
}

