/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib.tar;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hsqldb.lib.InputStreamInterface;
import org.hsqldb.lib.InputStreamWrapper;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.lib.tar.PIFGenerator;
import org.hsqldb.lib.tar.RB;
import org.hsqldb.lib.tar.TarFileOutputStream;
import org.hsqldb.lib.tar.TarHeaderField;
import org.hsqldb.lib.tar.TarMalformatException;

public class TarGenerator {
    protected TarFileOutputStream archive;
    protected List<TarEntrySupplicant> entryQueue = new ArrayList<TarEntrySupplicant>();
    protected long paxThreshold = 0x200000000L;

    public void setPaxThreshold(long l2) {
        this.paxThreshold = l2;
    }

    public long getPaxThreshold() {
        return this.paxThreshold;
    }

    public TarGenerator(File file, boolean bl, Integer n2) throws IOException {
        File file2 = file.getAbsoluteFile();
        int n3 = 0;
        if (file2.getName().endsWith(".tgz") || file2.getName().endsWith(".tar.gz")) {
            n3 = 1;
        } else if (!file2.getName().endsWith(".tar")) {
            throw new IllegalArgumentException(RB.unsupported_ext.getString(this.getClass().getName(), file2.getPath()));
        }
        if (file2.exists()) {
            if (!bl) {
                throw new IOException(RB.dest_exists.getString(file2.getPath()));
            }
        } else {
            File file3 = file2.getParentFile();
            if (file3.exists()) {
                if (!file3.isDirectory()) {
                    throw new IOException(RB.parent_not_dir.getString(file3.getPath()));
                }
                if (!file3.canWrite()) {
                    throw new IOException(RB.cant_write_parent.getString(file3.getPath()));
                }
            } else if (!file3.mkdirs()) {
                throw new IOException(RB.parent_create_fail.getString(file3.getPath()));
            }
        }
        TarFileOutputStream tarFileOutputStream = this.archive = n2 == null ? new TarFileOutputStream(file2, n3) : new TarFileOutputStream(file2, n3, n2);
        if (n2 != null && TarFileOutputStream.debug) {
            System.out.println(RB.bpr_write.getString(n2));
        }
    }

    public void queueEntry(File file) throws FileNotFoundException, TarMalformatException {
        this.queueEntry(null, file);
    }

    public void queueEntry(String string, File file) throws FileNotFoundException, TarMalformatException {
        this.entryQueue.add(new TarEntrySupplicant(string, file, this.archive, this.paxThreshold));
    }

    public void queueEntry(String string, InputStreamInterface inputStreamInterface) throws FileNotFoundException, TarMalformatException {
        this.entryQueue.add(new TarEntrySupplicant(string, inputStreamInterface, this.archive, this.paxThreshold));
    }

    public void queueEntry(String string, InputStream inputStream, int n2) throws IOException, TarMalformatException {
        this.entryQueue.add(new TarEntrySupplicant(string, inputStream, n2, '0', this.archive));
    }

    public void write() throws IOException, TarMalformatException {
        if (TarFileOutputStream.debug) {
            System.out.println(RB.write_queue_report.getString(this.entryQueue.size()));
        }
        try {
            for (int i2 = 0; i2 < this.entryQueue.size(); ++i2) {
                System.out.print(Integer.toString(i2 + 1) + " / " + this.entryQueue.size() + " ");
                TarEntrySupplicant tarEntrySupplicant = this.entryQueue.get(i2);
                System.out.print(tarEntrySupplicant.getPath() + "... ");
                tarEntrySupplicant.write();
                this.archive.assertAtBlockBoundary();
                System.out.println();
            }
            this.archive.finish();
        }
        catch (IOException iOException) {
            System.out.println();
            try {
                for (TarEntrySupplicant tarEntrySupplicant : this.entryQueue) {
                    tarEntrySupplicant.close();
                }
                this.archive.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            throw iOException;
        }
    }

    protected static class TarEntrySupplicant {
        static final byte[] HEADER_TEMPLATE = (byte[])TarFileOutputStream.ZERO_BLOCK.clone();
        static Character swapOutDelim = null;
        static final byte[] ustarBytes = new byte[]{117, 115, 116, 97, 114};
        protected byte[] rawHeader = (byte[])HEADER_TEMPLATE.clone();
        protected String fileMode = "600";
        protected InputStreamInterface inputStream;
        protected String path;
        protected long modTime;
        protected TarFileOutputStream tarStream;
        protected long dataSize;
        protected boolean paxSized = false;
        protected final long paxThreshold;
        public static final String DEFAULT_FILE_MODES = "600";

        protected static void writeField(TarHeaderField tarHeaderField, String string, byte[] byArray) throws TarMalformatException {
            int n2 = tarHeaderField.getStart();
            int n3 = tarHeaderField.getStop();
            byte[] byArray2 = string.getBytes(Charset.forName("ISO-8859-1"));
            if (byArray2.length > n3 - n2) {
                throw new TarMalformatException(RB.tar_field_toobig.getString(tarHeaderField.toString(), string));
            }
            for (int i2 = 0; i2 < byArray2.length; ++i2) {
                byArray[n2 + i2] = byArray2[i2];
            }
        }

        protected static void clearField(TarHeaderField tarHeaderField, byte[] byArray) {
            int n2 = tarHeaderField.getStart();
            int n3 = tarHeaderField.getStop();
            for (int i2 = n2; i2 < n3; ++i2) {
                byArray[i2] = 0;
            }
        }

        protected static void writeField(TarHeaderField tarHeaderField, long l2, byte[] byArray) throws TarMalformatException {
            TarEntrySupplicant.writeField(tarHeaderField, TarEntrySupplicant.prePaddedOctalString(l2, tarHeaderField.getStop() - tarHeaderField.getStart()), byArray);
        }

        public static String prePaddedOctalString(long l2, int n2) {
            return StringUtil.toPaddedString(Long.toOctalString(l2), n2, '0', false);
        }

        public String getPath() {
            return this.path;
        }

        public long getDataSize() {
            return this.dataSize;
        }

        protected TarEntrySupplicant(String string, char c2, TarFileOutputStream tarFileOutputStream, long l2) throws TarMalformatException {
            this.paxThreshold = l2;
            if (string == null) {
                throw new IllegalArgumentException(RB.missing_supp_path.getString());
            }
            this.path = swapOutDelim == null ? string : string.replace(swapOutDelim.charValue(), '/');
            this.tarStream = tarFileOutputStream;
            this.writeField(TarHeaderField.typeflag, c2);
            if (c2 == '\u0000' || c2 == ' ') {
                TarEntrySupplicant.writeField(TarHeaderField.uname, System.getProperty("user.name"), HEADER_TEMPLATE);
                TarEntrySupplicant.writeField(TarHeaderField.gname, "root", HEADER_TEMPLATE);
            }
        }

        public TarEntrySupplicant makeXentry() throws IOException, TarMalformatException {
            PIFGenerator pIFGenerator = new PIFGenerator(new File(this.path));
            pIFGenerator.addRecord("size", this.dataSize);
            return new TarEntrySupplicant(pIFGenerator.getName(), new ByteArrayInputStream(pIFGenerator.toByteArray()), pIFGenerator.size(), 'x', this.tarStream);
        }

        public TarEntrySupplicant(String string, File file, TarFileOutputStream tarFileOutputStream, long l2) throws FileNotFoundException, TarMalformatException {
            this(string == null ? file.getPath() : string, '0', tarFileOutputStream, l2);
            if (!file.isFile()) {
                throw new IllegalArgumentException(RB.nonfile_entry.getString());
            }
            if (!file.canRead()) {
                throw new IllegalArgumentException(RB.read_denied.getString(file.getAbsolutePath()));
            }
            this.modTime = file.lastModified() / 1000L;
            this.fileMode = TarEntrySupplicant.getLameMode(file);
            this.dataSize = file.length();
            this.inputStream = new InputStreamWrapper(new FileInputStream(file));
        }

        public TarEntrySupplicant(String string, InputStreamInterface inputStreamInterface, TarFileOutputStream tarFileOutputStream, long l2) throws TarMalformatException {
            this(string, '0', tarFileOutputStream, l2);
            this.modTime = System.currentTimeMillis() / 1000L;
            this.fileMode = DEFAULT_FILE_MODES;
            this.inputStream = inputStreamInterface;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TarEntrySupplicant(String string, InputStream inputStream, int n2, char c2, TarFileOutputStream tarFileOutputStream) throws IOException, TarMalformatException {
            this(string, c2, tarFileOutputStream, 0x200000000L);
            if (n2 < 1) {
                throw new IllegalArgumentException(RB.read_lt_1.getString());
            }
            PipedOutputStream pipedOutputStream = new PipedOutputStream();
            try {
                int n3;
                this.inputStream = new InputStreamWrapper(new PipedInputStream(pipedOutputStream));
                while ((n3 = inputStream.read(tarFileOutputStream.writeBuffer, 0, tarFileOutputStream.writeBuffer.length)) > 0) {
                    pipedOutputStream.write(tarFileOutputStream.writeBuffer, 0, n3);
                }
                pipedOutputStream.flush();
                this.dataSize = this.inputStream.available();
                if (TarFileOutputStream.debug) {
                    System.out.println(RB.stream_buffer_report.getString(Long.toString(this.dataSize)));
                }
            }
            catch (IOException iOException) {
                this.close();
                throw iOException;
            }
            finally {
                try {
                    pipedOutputStream.close();
                }
                finally {
                    pipedOutputStream = null;
                }
            }
            this.modTime = new Date().getTime() / 1000L;
        }

        public void close() throws IOException {
            if (this.inputStream == null) {
                return;
            }
            try {
                this.inputStream.close();
            }
            finally {
                this.inputStream = null;
            }
        }

        protected long headerChecksum() {
            long l2 = 0L;
            for (int i2 = 0; i2 < this.rawHeader.length; ++i2) {
                boolean bl = i2 >= TarHeaderField.checksum.getStart() && i2 < TarHeaderField.checksum.getStop();
                l2 += bl ? 32L : (long)(0xFF & this.rawHeader[i2]);
            }
            return l2;
        }

        protected void clearField(TarHeaderField tarHeaderField) {
            TarEntrySupplicant.clearField(tarHeaderField, this.rawHeader);
        }

        protected void writeField(TarHeaderField tarHeaderField, String string) throws TarMalformatException {
            TarEntrySupplicant.writeField(tarHeaderField, string, this.rawHeader);
        }

        protected void writeField(TarHeaderField tarHeaderField, long l2) throws TarMalformatException {
            TarEntrySupplicant.writeField(tarHeaderField, l2, this.rawHeader);
        }

        protected void writeField(TarHeaderField tarHeaderField, char c2) throws TarMalformatException {
            TarEntrySupplicant.writeField(tarHeaderField, Character.toString(c2), this.rawHeader);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write() throws IOException, TarMalformatException {
            try {
                int n2;
                long l2 = this.inputStream.getSizeLimit();
                if (l2 == 0L) {
                    return;
                }
                if (l2 > 0L) {
                    this.dataSize = l2;
                }
                if (this.dataSize >= this.paxThreshold) {
                    this.paxSized = true;
                    this.makeXentry().write();
                    System.out.print("x... ");
                }
                this.writeField(TarHeaderField.name, this.path);
                this.writeField(TarHeaderField.mode, this.fileMode);
                if (!this.paxSized) {
                    this.writeField(TarHeaderField.size, this.dataSize);
                }
                this.writeField(TarHeaderField.mtime, this.modTime);
                this.writeField(TarHeaderField.checksum, TarEntrySupplicant.prePaddedOctalString(this.headerChecksum(), 6) + "\u0000 ");
                this.tarStream.writeBlock(this.rawHeader);
                long l3 = this.tarStream.getBytesWritten();
                while ((n2 = this.inputStream.read(this.tarStream.writeBuffer)) > 0) {
                    this.tarStream.write(n2);
                }
                if (l3 + this.dataSize != this.tarStream.getBytesWritten()) {
                    throw new IOException(RB.data_changed.getString(Long.toString(this.dataSize), Long.toString(this.tarStream.getBytesWritten() - l3)));
                }
                this.tarStream.padCurrentBlock();
            }
            finally {
                this.close();
            }
        }

        protected static String getLameMode(File file) {
            int n2 = 0;
            if (file.canExecute()) {
                n2 = 1;
            }
            if (file.canWrite()) {
                n2 += 2;
            }
            if (file.canRead()) {
                n2 += 4;
            }
            return "0" + n2 + "00";
        }

        static {
            char c2 = System.getProperty("file.separator").charAt(0);
            if (c2 != '/') {
                swapOutDelim = Character.valueOf(c2);
            }
            try {
                TarEntrySupplicant.writeField(TarHeaderField.uid, 0L, HEADER_TEMPLATE);
                TarEntrySupplicant.writeField(TarHeaderField.gid, 0L, HEADER_TEMPLATE);
            }
            catch (TarMalformatException tarMalformatException) {
                throw new RuntimeException(tarMalformatException);
            }
            int n2 = TarHeaderField.magic.getStart();
            for (int i2 = 0; i2 < ustarBytes.length; ++i2) {
                TarEntrySupplicant.HEADER_TEMPLATE[n2 + i2] = ustarBytes[i2];
            }
            TarEntrySupplicant.HEADER_TEMPLATE[263] = 48;
            TarEntrySupplicant.HEADER_TEMPLATE[264] = 48;
        }
    }
}

