/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib.tar;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.hsqldb.lib.tar.RB;

public class TarFileOutputStream {
    public static final boolean debug = Boolean.getBoolean("DEBUG");
    protected int blocksPerRecord;
    protected long bytesWritten = 0L;
    private OutputStream writeStream;
    private File targetFile;
    private File writeFile;
    public byte[] writeBuffer;
    static final byte[] ZERO_BLOCK = new byte[512];

    public TarFileOutputStream(File file) throws IOException {
        this(file, 0);
    }

    public TarFileOutputStream(File file, int n2) throws IOException {
        this(file, n2, 20);
    }

    public TarFileOutputStream(File file, int n2, int n3) throws IOException {
        this.blocksPerRecord = n3;
        this.targetFile = file;
        this.writeFile = new File(file.getParentFile(), file.getName() + "-partial");
        if (this.writeFile.exists()) {
            throw new IOException(RB.move_work_file.getString(this.writeFile.getAbsolutePath()));
        }
        if (file.exists() && !file.canWrite()) {
            throw new IOException(RB.cant_overwrite.getString(file.getAbsolutePath()));
        }
        File file2 = file.getAbsoluteFile().getParentFile();
        if (file2.exists() && file2.isDirectory()) {
            if (!file2.canWrite()) {
                throw new IOException(RB.cant_write_dir.getString(file2.getAbsolutePath()));
            }
        } else {
            throw new IOException(RB.no_parent_dir.getString(file2.getAbsolutePath()));
        }
        this.writeBuffer = new byte[n3 * 512];
        switch (n2) {
            case 0: {
                this.writeStream = new FileOutputStream(this.writeFile);
                break;
            }
            case 1: {
                this.writeStream = new GZIPOutputStream((OutputStream)new FileOutputStream(this.writeFile), this.writeBuffer.length);
                break;
            }
            default: {
                throw new IllegalArgumentException(RB.compression_unknown.getString(n2));
            }
        }
        this.writeFile.setExecutable(false, true);
        this.writeFile.setExecutable(false, false);
        this.writeFile.setReadable(false, false);
        this.writeFile.setReadable(true, true);
        this.writeFile.setWritable(false, false);
        this.writeFile.setWritable(true, true);
    }

    public void write(byte[] byArray, int n2) throws IOException {
        this.writeStream.write(byArray, 0, n2);
        this.bytesWritten += (long)n2;
    }

    public void write(int n2) throws IOException {
        this.write(this.writeBuffer, n2);
    }

    public void writeBlock(byte[] byArray) throws IOException {
        if (byArray.length != 512) {
            throw new IllegalArgumentException(RB.bad_block_write_len.getString(byArray.length));
        }
        this.write(byArray, byArray.length);
    }

    public void writePadBlocks(int n2) throws IOException {
        for (int i2 = 0; i2 < n2; ++i2) {
            this.write(ZERO_BLOCK, ZERO_BLOCK.length);
        }
    }

    public void writePadBlock() throws IOException {
        this.writePadBlocks(1);
    }

    public int bytesLeftInBlock() {
        int n2 = (int)(this.bytesWritten % 512L);
        if (n2 == 0) {
            return 0;
        }
        return 512 - n2;
    }

    public void assertAtBlockBoundary() {
        if (this.bytesLeftInBlock() != 0) {
            throw new IllegalArgumentException(RB.illegal_block_boundary.getString(Long.toString(this.bytesWritten)));
        }
    }

    public void padCurrentBlock() throws IOException {
        int n2 = this.bytesLeftInBlock();
        if (n2 == 0) {
            return;
        }
        this.write(ZERO_BLOCK, n2);
        this.assertAtBlockBoundary();
    }

    public void flush() throws IOException {
        this.writeStream.flush();
    }

    public void close() throws IOException {
        if (this.writeStream == null) {
            return;
        }
        try {
            this.writeStream.close();
            if (!this.writeFile.delete()) {
                throw new IOException(RB.workfile_delete_fail.getString(this.writeFile.getAbsolutePath()));
            }
        }
        finally {
            this.writeStream = null;
        }
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }

    public void finish() throws IOException {
        try {
            long l2 = this.bytesWritten / 512L + 2L;
            if (l2 % (long)this.blocksPerRecord != 0L) {
                l2 = (l2 / (long)this.blocksPerRecord + 1L) * (long)this.blocksPerRecord;
            }
            int n2 = (int)(l2 - this.bytesWritten / 512L);
            if (debug) {
                System.out.println(RB.pad_block_write.getString(n2));
            }
            this.writePadBlocks(n2);
        }
        catch (IOException iOException) {
            try {
                this.close();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            throw iOException;
        }
        this.writeStream.close();
        this.writeFile.renameTo(this.targetFile);
    }

    public static interface Compression {
        public static final int NO_COMPRESSION = 0;
        public static final int GZIP_COMPRESSION = 1;
        public static final int DEFAULT_COMPRESSION = 0;
        public static final int DEFAULT_BLOCKS_PER_RECORD = 20;
    }
}

