/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib.tar;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.hsqldb.lib.tar.RB;
import org.hsqldb.lib.tar.TarMalformatException;

public class TarFileInputStream {
    protected long bytesRead = 0L;
    private InputStream readStream;
    protected byte[] readBuffer;
    protected int readBufferBlocks;
    protected int compressionType;

    public TarFileInputStream(File file) throws IOException {
        this(file, 0);
    }

    public TarFileInputStream(File file, int n2) throws IOException {
        this(file, n2, 20);
    }

    public int getReadBufferBlocks() {
        return this.readBufferBlocks;
    }

    public TarFileInputStream(File file, int n2, int n3) throws IOException {
        if (!file.isFile()) {
            throw new FileNotFoundException(file.getAbsolutePath());
        }
        if (!file.canRead()) {
            throw new IOException(RB.read_denied.getString(file.getAbsolutePath()));
        }
        this.readBufferBlocks = n3;
        this.compressionType = n2;
        this.readBuffer = new byte[n3 * 512];
        switch (n2) {
            case 0: {
                this.readStream = new FileInputStream(file);
                break;
            }
            case 1: {
                this.readStream = new GZIPInputStream((InputStream)new FileInputStream(file), this.readBuffer.length);
                break;
            }
            default: {
                throw new IllegalArgumentException(RB.compression_unknown.getString(n2));
            }
        }
    }

    public void readBlocks(int n2) throws IOException, TarMalformatException {
        if (this.compressionType != 0) {
            this.readCompressedBlocks(n2);
            return;
        }
        int n3 = this.readStream.read(this.readBuffer, 0, n2 * 512);
        this.bytesRead += (long)n3;
        if (n3 != n2 * 512) {
            throw new TarMalformatException(RB.insufficient_read.getString(n2 * 512, n3));
        }
    }

    protected void readCompressedBlocks(int n2) throws IOException {
        int n3;
        int n4 = 512 * n2;
        for (int i2 = 0; i2 < n4; i2 += n3) {
            n3 = this.readStream.read(this.readBuffer, i2, n4 - i2);
            if (n3 < 0) {
                throw new EOFException(RB.decompression_ranout.getString(i2, n4));
            }
            this.bytesRead += (long)n3;
        }
    }

    public void readBlock() throws IOException, TarMalformatException {
        this.readBlocks(1);
    }

    public boolean readNextHeaderBlock() throws IOException, TarMalformatException {
        try {
            while (this.readStream.available() > 0) {
                this.readBlock();
                if (this.readBuffer[0] == 0) continue;
                return true;
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        this.close();
        return false;
    }

    public void close() throws IOException {
        if (this.readStream == null) {
            return;
        }
        try {
            this.readStream.close();
        }
        finally {
            this.readStream = null;
        }
    }
}

