/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.map.BitMap;

public class StringConverter {
    private static final byte[] HEXBYTES = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    private static int getNibble(int n2) {
        if (n2 >= 48 && n2 <= 57) {
            return n2 - 48;
        }
        if (n2 >= 97 && n2 <= 102) {
            return 10 + n2 - 97;
        }
        if (n2 >= 65 && n2 <= 70) {
            return 10 + n2 - 65;
        }
        return -1;
    }

    public static byte[] hexStringToByteArray(String string) throws IOException {
        int n2 = string.length();
        byte[] byArray = new byte[n2 / 2 + n2 % 2];
        int n3 = 0;
        boolean bl = true;
        int n4 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == ' ') continue;
            int n5 = StringConverter.getNibble(c2);
            if (n5 == -1) {
                throw new IOException("hexadecimal string contains non hex character");
            }
            if (bl) {
                n3 = (n5 & 0xF) << 4;
                bl = false;
                continue;
            }
            bl = true;
            byArray[n4++] = (byte)(n3 += n5 & 0xF);
        }
        if (!bl) {
            throw new IOException("hexadecimal string with odd number of characters");
        }
        if (n4 < byArray.length) {
            byArray = (byte[])ArrayUtil.resizeArray(byArray, n4);
        }
        return byArray;
    }

    public static BitMap sqlBitStringToBitMap(String string) throws IOException {
        int n2 = string.length();
        int n3 = 0;
        BitMap bitMap = new BitMap(0, true);
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == ' ') continue;
            int n4 = StringConverter.getNibble(c2);
            if (n4 != 0 && n4 != 1) {
                throw new IOException("hexadecimal string contains non hex character");
            }
            if (n4 == 1) {
                bitMap.set(n3);
            }
            ++n3;
        }
        bitMap.setSize(n3);
        return bitMap;
    }

    public static String byteArrayToHexString(byte[] byArray) {
        int n2 = byArray.length;
        char[] cArray = new char[n2 * 2];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = byArray[i2] & 0xFF;
            cArray[n3++] = (char)HEXBYTES[n4 >> 4 & 0xF];
            cArray[n3++] = (char)HEXBYTES[n4 & 0xF];
        }
        return new String(cArray);
    }

    public static String byteArrayToSQLHexString(byte[] byArray) {
        int n2 = byArray.length;
        char[] cArray = new char[n2 * 2 + 3];
        cArray[0] = 88;
        cArray[1] = 39;
        int n3 = 2;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = byArray[i2] & 0xFF;
            cArray[n3++] = (char)HEXBYTES[n4 >> 4 & 0xF];
            cArray[n3++] = (char)HEXBYTES[n4 & 0xF];
        }
        cArray[n3] = 39;
        return new String(cArray);
    }

    public static String byteArrayToBitString(byte[] byArray, int n2) {
        char[] cArray = new char[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            byte by = byArray[i2 / 8];
            cArray[i2] = BitMap.isSet(by, i2 % 8) ? 49 : 48;
        }
        return new String(cArray);
    }

    public static String byteArrayToSQLBitString(byte[] byArray, int n2) {
        char[] cArray = new char[n2 + 3];
        cArray[0] = 66;
        cArray[1] = 39;
        int n3 = 2;
        for (int i2 = 0; i2 < n2; ++i2) {
            byte by = byArray[i2 / 8];
            cArray[n3++] = BitMap.isSet(by, i2 % 8) ? 49 : 48;
        }
        cArray[n3] = 39;
        return new String(cArray);
    }

    public static int writeHexBytes(byte[] byArray, int n2, byte[] byArray2) {
        int n3 = byArray2.length;
        int n4 = n2;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n5 = byArray2[i2] & 0xFF;
            byArray[n4++] = HEXBYTES[n5 >> 4 & 0xF];
            byArray[n4++] = HEXBYTES[n5 & 0xF];
        }
        return n4 - n2;
    }

    public static String byteArrayToString(byte[] byArray, String string) {
        try {
            return string == null ? new String(byArray) : new String(byArray, string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void stringToUnicodeBytes(HsqlByteArrayOutputStream hsqlByteArrayOutputStream, String string, boolean bl) {
        if (string == null) {
            return;
        }
        int n2 = string.length();
        int n3 = 0;
        if (n2 == 0) {
            return;
        }
        hsqlByteArrayOutputStream.ensureRoom(n2 * 2 + 5);
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\\') {
                if (i2 < n2 - 1 && string.charAt(i2 + 1) == 'u') {
                    hsqlByteArrayOutputStream.writeNoCheck(c2);
                    hsqlByteArrayOutputStream.writeNoCheck(117);
                    hsqlByteArrayOutputStream.writeNoCheck(48);
                    hsqlByteArrayOutputStream.writeNoCheck(48);
                    hsqlByteArrayOutputStream.writeNoCheck(53);
                    hsqlByteArrayOutputStream.writeNoCheck(99);
                    n3 += 5;
                } else {
                    hsqlByteArrayOutputStream.write(c2);
                }
            } else if (c2 >= ' ' && c2 <= '\u007f') {
                hsqlByteArrayOutputStream.writeNoCheck(c2);
                if (c2 == '\'' && bl) {
                    hsqlByteArrayOutputStream.writeNoCheck(c2);
                    ++n3;
                }
            } else {
                hsqlByteArrayOutputStream.writeNoCheck(92);
                hsqlByteArrayOutputStream.writeNoCheck(117);
                hsqlByteArrayOutputStream.writeNoCheck(HEXBYTES[c2 >> 12 & 0xF]);
                hsqlByteArrayOutputStream.writeNoCheck(HEXBYTES[c2 >> 8 & 0xF]);
                hsqlByteArrayOutputStream.writeNoCheck(HEXBYTES[c2 >> 4 & 0xF]);
                hsqlByteArrayOutputStream.writeNoCheck(HEXBYTES[c2 & 0xF]);
                n3 += 5;
            }
            if (n3 <= n2) continue;
            hsqlByteArrayOutputStream.ensureRoom(n2 + n3 + 5);
            n3 = 0;
        }
    }

    public static String unicodeStringToString(String string) {
        if (string == null || !string.contains("\\u")) {
            return string;
        }
        int n2 = string.length();
        char[] cArray = new char[n2];
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\\' && i2 < n2 - 5) {
                char c3 = string.charAt(i2 + 1);
                if (c3 == 'u') {
                    ++i2;
                    int n4 = StringConverter.getNibble(string.charAt(++i2)) << 12;
                    n4 += StringConverter.getNibble(string.charAt(++i2)) << 8;
                    n4 += StringConverter.getNibble(string.charAt(++i2)) << 4;
                    cArray[n3++] = (char)(n4 += StringConverter.getNibble(string.charAt(++i2)));
                    continue;
                }
                cArray[n3++] = c2;
                continue;
            }
            cArray[n3++] = c2;
        }
        return new String(cArray, 0, n3);
    }

    public static String readUTF(byte[] byArray, int n2, int n3) throws IOException {
        char[] cArray = new char[n3];
        return StringConverter.readUTF(byArray, n2, n3, cArray);
    }

    public static String readUTF(byte[] byArray, int n2, int n3, char[] cArray) throws IOException {
        int n4 = 0;
        int n5 = 0;
        block4: while (n5 < n3) {
            int n6 = byArray[n2 + n5];
            if (n4 == cArray.length) {
                cArray = (char[])ArrayUtil.resizeArray(cArray, n3);
            }
            if (n6 > 0) {
                ++n5;
                cArray[n4++] = (char)n6;
                continue;
            }
            switch ((n6 &= 0xFF) >> 4) {
                case 12: 
                case 13: {
                    if ((n5 += 2) > n3) {
                        throw new UTFDataFormatException();
                    }
                    byte by = byArray[n2 + n5 - 1];
                    if ((by & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    cArray[n4++] = (char)((n6 & 0x1F) << 6 | by & 0x3F);
                    continue block4;
                }
                case 14: {
                    if ((n5 += 3) > n3) {
                        throw new UTFDataFormatException();
                    }
                    byte by = byArray[n2 + n5 - 2];
                    byte by2 = byArray[n2 + n5 - 1];
                    if ((by & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    cArray[n4++] = (char)((n6 & 0xF) << 12 | (by & 0x3F) << 6 | by2 & 0x3F);
                    continue block4;
                }
            }
            throw new UTFDataFormatException();
        }
        return new String(cArray, 0, n4);
    }

    public static int stringToUTFBytes(String string, HsqlByteArrayOutputStream hsqlByteArrayOutputStream) {
        int n2 = string.length();
        int n3 = 0;
        if (hsqlByteArrayOutputStream.count + n2 + 8 > hsqlByteArrayOutputStream.buffer.length) {
            hsqlByteArrayOutputStream.ensureRoom(n2 + 8);
        }
        char[] cArray = string.toCharArray();
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = cArray[i2];
            if (c2 >= '\u0001' && c2 <= '\u007f') {
                hsqlByteArrayOutputStream.buffer[hsqlByteArrayOutputStream.count++] = (byte)c2;
                ++n3;
            } else if (c2 > '\u07ff') {
                hsqlByteArrayOutputStream.buffer[hsqlByteArrayOutputStream.count++] = (byte)(0xE0 | c2 >> 12 & 0xF);
                hsqlByteArrayOutputStream.buffer[hsqlByteArrayOutputStream.count++] = (byte)(0x80 | c2 >> 6 & 0x3F);
                hsqlByteArrayOutputStream.buffer[hsqlByteArrayOutputStream.count++] = (byte)(0x80 | c2 & 0x3F);
                n3 += 3;
            } else {
                hsqlByteArrayOutputStream.buffer[hsqlByteArrayOutputStream.count++] = (byte)(0xC0 | c2 >> 6 & 0x1F);
                hsqlByteArrayOutputStream.buffer[hsqlByteArrayOutputStream.count++] = (byte)(0x80 | c2 & 0x3F);
                n3 += 2;
            }
            if (hsqlByteArrayOutputStream.count + 8 <= hsqlByteArrayOutputStream.buffer.length) continue;
            hsqlByteArrayOutputStream.ensureRoom(n2 - i2 + 8);
        }
        return n3;
    }

    public static int getUTFSize(String string) {
        int n2 = string == null ? 0 : string.length();
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= '\u0001' && c2 <= '\u007f') {
                ++n3;
                continue;
            }
            if (c2 > '\u07ff') {
                n3 += 3;
                continue;
            }
            n3 += 2;
        }
        return n3;
    }

    public static String inputStreamToString(InputStream inputStream, String string) throws IOException {
        int n2;
        HsqlByteArrayOutputStream hsqlByteArrayOutputStream = new HsqlByteArrayOutputStream(1024);
        while ((n2 = inputStream.read()) != -1) {
            hsqlByteArrayOutputStream.write(n2);
        }
        return new String(hsqlByteArrayOutputStream.getBuffer(), 0, hsqlByteArrayOutputStream.size(), string);
    }

    public static String toQuotedString(String string, char c2, boolean bl) {
        if (string == null) {
            return null;
        }
        int n2 = bl ? StringConverter.count(string, c2) : 0;
        int n3 = string.length();
        char[] cArray = new char[2 + n2 + n3];
        int n4 = 0;
        cArray[n4++] = c2;
        for (int i2 = 0; i2 < n3; ++i2) {
            char c3 = string.charAt(i2);
            cArray[n4++] = c3;
            if (!bl || c3 != c2) continue;
            cArray[n4++] = c3;
        }
        cArray[n4] = c2;
        return new String(cArray);
    }

    static int count(String string, char c2) {
        int n2 = 0;
        int n3 = 0;
        if (string != null) {
            while ((n2 = string.indexOf(c2, n2)) > -1) {
                ++n3;
                ++n2;
            }
        }
        return n3;
    }

    public static void stringToHtmlBytes(HsqlByteArrayOutputStream hsqlByteArrayOutputStream, String string) {
        if (string == null) {
            return;
        }
        int n2 = string.length();
        if (n2 == 0) {
            return;
        }
        char[] cArray = string.toCharArray();
        hsqlByteArrayOutputStream.ensureRoom(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = cArray[i2];
            if (c2 > '\u007f' || c2 == '\"' || c2 == '&' || c2 == '<' || c2 == '>') {
                int n3 = Character.codePointAt(cArray, i2);
                if (Character.charCount(n3) == 2) {
                    ++i2;
                }
                hsqlByteArrayOutputStream.ensureRoom(16);
                hsqlByteArrayOutputStream.writeNoCheck(38);
                hsqlByteArrayOutputStream.writeNoCheck(35);
                hsqlByteArrayOutputStream.writeBytes(String.valueOf(n3));
                hsqlByteArrayOutputStream.writeNoCheck(59);
                continue;
            }
            if (c2 < ' ') {
                hsqlByteArrayOutputStream.writeNoCheck(32);
                continue;
            }
            hsqlByteArrayOutputStream.writeNoCheck(c2);
        }
    }

    public static String toStringUUID(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        if (byArray.length != 16) {
            throw new NumberFormatException();
        }
        char[] cArray = new char[36];
        int n2 = 0;
        int n3 = 0;
        while (n2 < byArray.length) {
            int n4 = (byArray[n2] & 0xF0) >> 4;
            cArray[n3++] = (char)HEXBYTES[n4];
            n4 = byArray[n2] & 0xF;
            cArray[n3++] = (char)HEXBYTES[n4];
            if (++n2 < 4 || n2 > 10 || n2 % 2 != 0) continue;
            cArray[n3++] = 45;
        }
        return new String(cArray);
    }

    public static int writeUUIDHexBytes(byte[] byArray, int n2, byte[] byArray2) {
        if (byArray2.length != 16) {
            throw new NumberFormatException();
        }
        int n3 = n2;
        int n4 = 0;
        while (n4 < byArray2.length) {
            int n5 = (byArray2[n4] & 0xF0) >> 4;
            byArray[n3++] = HEXBYTES[n5];
            n5 = byArray2[n4] & 0xF;
            byArray[n3++] = HEXBYTES[n5];
            if (++n4 < 4 || n4 > 10 || n4 % 2 != 0) continue;
            byArray[n3++] = 45;
        }
        return n3 - n2;
    }

    public static byte[] toBinaryUUID(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() != 36) {
            throw new NumberFormatException();
        }
        byte[] byArray = new byte[16];
        int n2 = 0;
        int n3 = 0;
        while (n2 < byArray.length) {
            char c2 = string.charAt(n3++);
            int n4 = StringConverter.getNibble(c2);
            c2 = string.charAt(n3++);
            byArray[n2] = (byte)((n4 << 4) + StringConverter.getNibble(c2));
            if (++n2 < 4 || n2 > 10 || n2 % 2 != 0 || (c2 = string.charAt(n3++)) == '-') continue;
            throw new NumberFormatException();
        }
        return byArray;
    }

    static void appendHex(StringBuilder stringBuilder, char c2) {
        for (int i2 = 12; i2 >= 0; i2 -= 4) {
            int n2 = c2 >>> i2 & 0xF;
            if (n2 < 10) {
                stringBuilder.append((char)(48 + n2));
                continue;
            }
            stringBuilder.append((char)(65 + (n2 - 10)));
        }
    }

    public static String stringToUnicodeEscaped(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length() * 2);
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= ' ' && c2 < '\u007f' && c2 != '\\') {
                stringBuilder.append(c2);
                continue;
            }
            stringBuilder.append('\\');
            StringConverter.appendHex(stringBuilder, c2);
        }
        return stringBuilder.toString();
    }

    public static String unicodeEscapedToString(String string) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(string.length() * 2);
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 != '\\') {
                stringBuilder.append(c2);
                continue;
            }
            if (++i2 >= string.length()) {
                throw new UTFDataFormatException();
            }
            c2 = string.charAt(i2);
            if (c2 == '\\') {
                stringBuilder.append(c2);
                continue;
            }
            if (i2 > string.length() - 4) {
                throw new UTFDataFormatException();
            }
            c2 = '\u0000';
            int n2 = 12;
            while (n2 >= 0) {
                int n3 = string.charAt(i2);
                if ((n3 = StringConverter.getNibble(n3)) < 0) {
                    throw new UTFDataFormatException();
                }
                c2 = (char)(c2 | n3 << n2);
                n2 -= 4;
                ++i2;
            }
            stringBuilder.append(c2);
            --i2;
        }
        return stringBuilder.toString();
    }

    public static void toJSONString(String string, StringBuilder stringBuilder) {
        int n2 = string.length();
        stringBuilder.append('\"');
        int n3 = string.indexOf(34);
        if (n3 == -1 && string.indexOf(92) == -1) {
            stringBuilder.append(string);
            stringBuilder.append('\"');
            return;
        }
        stringBuilder.append(string.substring(0, n3));
        for (int i2 = n3; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 < ' ') {
                stringBuilder.append('\\');
                StringConverter.appendHex(stringBuilder, c2);
                continue;
            }
            if (c2 == '\"' || c2 == '\\') {
                stringBuilder.append('\\');
            }
            stringBuilder.append(c2);
        }
        stringBuilder.append('\"');
    }
}

