/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.Objects;
import org.hsqldb.lib.AbstractReadOnlyCollection;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.LongKeyHashMap;
import org.hsqldb.lib.Map;
import org.hsqldb.lib.MapEntry;
import org.hsqldb.lib.PrimitiveIterator;
import org.hsqldb.lib.Set;
import org.hsqldb.map.BaseHashMap;

public class OrderedLongKeyHashMap<V>
extends BaseHashMap
implements Map<Long, V> {
    private Set<Long> keySet;
    private Collection<V> values;
    private Set<Map.Entry<Long, V>> entries;

    public OrderedLongKeyHashMap() {
        this(8);
    }

    public OrderedLongKeyHashMap(int n2) throws IllegalArgumentException {
        super(n2, 2, 3, false);
        this.isList = true;
    }

    public OrderedLongKeyHashMap(int n2, boolean bl) throws IllegalArgumentException {
        super(n2, 2, 3, false);
        this.objectKeyTable = new Object[this.objectValueTable.length];
        this.isTwoObjectValue = true;
        this.isList = true;
        if (bl) {
            this.objectValueTable2 = new Object[this.objectValueTable.length];
        }
        this.minimizeOnEmpty = true;
    }

    @Override
    public boolean containsKey(Object object) {
        if (object instanceof Long) {
            long l2 = (Long)object;
            return this.containsKey(l2);
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return false;
    }

    @Override
    public boolean containsKey(long l2) {
        return super.containsKey(l2);
    }

    @Override
    public boolean containsValue(Object object) {
        return super.containsValue(object);
    }

    @Override
    public V get(Object object) {
        if (object instanceof Long) {
            long l2 = (Long)object;
            return this.get(l2);
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return null;
    }

    public V get(long l2) {
        int n2 = this.getLookup(l2);
        if (n2 != -1) {
            return (V)this.objectValueTable[n2];
        }
        return null;
    }

    public long getKeyAt(int n2) {
        this.checkRange(n2);
        return this.longKeyTable[n2];
    }

    public V getValueAt(int n2) {
        this.checkRange(n2);
        return (V)this.objectValueTable[n2];
    }

    public Object getSecondValueAt(int n2) {
        this.checkRange(n2);
        return this.objectKeyTable[n2];
    }

    public Object getThirdValueAt(int n2) {
        this.checkRange(n2);
        return this.objectValueTable2[n2];
    }

    public Object setValueAt(int n2, Object object) {
        this.checkRange(n2);
        Object object2 = this.objectValueTable[n2];
        this.objectValueTable[n2] = object;
        return object2;
    }

    public Object setSecondValueAt(int n2, Object object) {
        this.checkRange(n2);
        Object object2 = this.objectKeyTable[n2];
        this.objectKeyTable[n2] = object;
        return object2;
    }

    public Object setThirdValueAt(int n2, Object object) {
        this.checkRange(n2);
        Object object2 = this.objectValueTable2[n2];
        this.objectValueTable2[n2] = object;
        return object2;
    }

    public boolean insert(int n2, long l2, V v2) throws IndexOutOfBoundsException {
        if (n2 < 0 || n2 > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = this.getLookup(l2);
        if (n3 >= 0) {
            return false;
        }
        if (n2 < this.size()) {
            super.insertRow(n2);
        }
        this.put(l2, v2);
        return true;
    }

    public boolean set(int n2, long l2, V v2) throws IndexOutOfBoundsException {
        this.checkRange(n2);
        if (this.keySet().contains(l2) && this.getIndex(l2) != n2) {
            return false;
        }
        super.remove(this.longKeyTable[n2], 0L, null, null, false, false);
        this.put(l2, v2);
        return true;
    }

    public boolean setKeyAt(int n2, long l2) throws IndexOutOfBoundsException {
        this.checkRange(n2);
        Object object = this.objectValueTable[n2];
        return this.set(n2, l2, object);
    }

    public int getIndex(long l2) {
        return this.getLookup(l2);
    }

    @Override
    public V put(Long l2, V v2) {
        if (l2 == null) {
            throw new NullPointerException();
        }
        long l3 = l2;
        return this.put(l3, v2);
    }

    @Override
    public V put(long l2, V v2) {
        return (V)super.addOrUpdate(l2, 0L, null, v2);
    }

    @Override
    public V remove(Object object) {
        if (object instanceof Long) {
            long l2 = (Long)object;
            return this.remove(l2);
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return null;
    }

    public V remove(long l2) {
        Object object = super.remove(l2, 0L, null, null, false, true);
        return (V)object;
    }

    public void removeEntry(int n2) throws IndexOutOfBoundsException {
        this.checkRange(n2);
        long l2 = this.longKeyTable[n2];
        super.remove(l2, 0L, null, null, false, true);
    }

    @Override
    public int getLookup(long l2) {
        return super.getLookup(l2);
    }

    @Override
    public void putAll(Map<? extends Long, ? extends V> map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Long l2 = (Long)iterator.next();
            long l3 = l2;
            this.put(l3, map.get(l2));
        }
    }

    public void putAll(LongKeyHashMap longKeyHashMap) {
        PrimitiveIterator primitiveIterator = (PrimitiveIterator)longKeyHashMap.keySet().iterator();
        while (primitiveIterator.hasNext()) {
            long l2 = primitiveIterator.nextLong();
            this.put(l2, (V)longKeyHashMap.get(l2));
        }
    }

    public long[] keysToArray(long[] lArray) {
        return this.toLongArray(lArray, true);
    }

    public Object[] valuesToArray() {
        return this.toArray(false);
    }

    public <T> T[] valuesToArray(T[] TArray) {
        return this.toArray(TArray, false);
    }

    @Override
    public Set<Long> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet<Long>();
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<Long, V>> entrySet() {
        if (this.entries == null) {
            this.entries = new EntrySet();
        }
        return this.entries;
    }

    private void checkRange(int n2) {
        if (n2 < 0 || n2 >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
    }

    private class Values<V>
    extends AbstractReadOnlyCollection<V> {
        private Values() {
        }

        @Override
        public PrimitiveIterator<V> iterator() {
            OrderedLongKeyHashMap orderedLongKeyHashMap = OrderedLongKeyHashMap.this;
            Objects.requireNonNull(orderedLongKeyHashMap);
            return new BaseHashMap.BaseHashIterator(orderedLongKeyHashMap, false);
        }

        @Override
        public int size() {
            return OrderedLongKeyHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public Object[] toArray() {
            return OrderedLongKeyHashMap.this.toArray(false);
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return OrderedLongKeyHashMap.this.toArray(TArray, false);
        }
    }

    private class KeySet<Long>
    extends AbstractReadOnlyCollection<Long>
    implements Set<Long> {
        private KeySet() {
        }

        @Override
        public PrimitiveIterator<Long> iterator() {
            OrderedLongKeyHashMap orderedLongKeyHashMap = OrderedLongKeyHashMap.this;
            Objects.requireNonNull(orderedLongKeyHashMap);
            return new BaseHashMap.BaseHashIterator(orderedLongKeyHashMap, true);
        }

        @Override
        public int size() {
            return OrderedLongKeyHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }

    private class EntrySetIterator
    extends BaseHashMap.BaseHashIterator {
        EntrySetIterator() {
            super(OrderedLongKeyHashMap.this, true);
        }

        @Override
        public Map.Entry<Long, V> next() {
            Long l2 = super.nextLong();
            Object object = OrderedLongKeyHashMap.this.objectValueTable[this.lookup];
            return new MapEntry<Long, Object>(l2, object);
        }
    }

    private class EntrySet
    extends AbstractReadOnlyCollection<Map.Entry<Long, V>>
    implements Set<Map.Entry<Long, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<Long, V>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return OrderedLongKeyHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }
}

