/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.List;
import org.hsqldb.lib.ObjectComparator;
import org.hsqldb.lib.Set;

public class OrderedHashSet<E>
extends HashSet<E>
implements List<E>,
Set<E> {
    public OrderedHashSet() {
        super(8);
        this.isList = true;
    }

    public OrderedHashSet(int n2) {
        super(n2);
        this.isList = true;
    }

    public OrderedHashSet(int n2, ObjectComparator<E> objectComparator) {
        super(n2, objectComparator);
        this.isList = true;
    }

    public OrderedHashSet(Object[] objectArray) {
        this(objectArray.length);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            this.add(objectArray[i2]);
        }
    }

    @Override
    public boolean remove(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return (Boolean)super.remove(0L, 0L, object, null, false, true);
    }

    @Override
    public E remove(int n2) {
        this.checkRange(n2);
        Object object = this.objectKeyTable[n2];
        super.remove(0L, 0L, object, null, false, true);
        return (E)object;
    }

    public void removeEntry(int n2) throws IndexOutOfBoundsException {
        this.remove(n2);
    }

    public boolean insert(int n2, E e2) throws IndexOutOfBoundsException {
        if (n2 < 0 || n2 > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.contains(e2)) {
            return false;
        }
        if (n2 < this.size()) {
            super.insertRow(n2);
        }
        return this.add(e2);
    }

    @Override
    public E set(int n2, E e2) {
        if (e2 == null) {
            throw new NullPointerException();
        }
        this.checkRange(n2);
        if (this.contains(e2) && this.getIndex(e2) != n2) {
            throw new IllegalArgumentException();
        }
        Object object = this.objectKeyTable[n2];
        super.remove(0L, 0L, object, null, false, false);
        this.add(e2);
        return (E)object;
    }

    @Override
    public void add(int n2, E e2) {
        boolean bl = this.insert(n2, e2);
        if (!bl) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public E get(int n2) {
        this.checkRange(n2);
        return (E)this.objectKeyTable[n2];
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.size()];
        return this.toArray(objectArray);
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        System.arraycopy(this.objectKeyTable, 0, TArray, 0, TArray.length);
        return TArray;
    }

    public int indexOf(Object object) {
        return this.getLookup(object);
    }

    public int getIndex(Object object) {
        return this.getLookup(object);
    }

    public int lastIndexOf(Object object) {
        return this.indexOf(object);
    }

    public int getLargestIndex(OrderedHashSet<E> orderedHashSet) {
        int n2 = -1;
        int n3 = orderedHashSet.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = this.indexOf(orderedHashSet.get(i2));
            if (n4 <= n2) continue;
            n2 = n4;
        }
        return n2;
    }

    public int getSmallestIndex(OrderedHashSet<E> orderedHashSet) {
        int n2 = -1;
        int n3 = orderedHashSet.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = this.indexOf(orderedHashSet.get(i2));
            if (n4 == -1 || n2 != -1 && n4 >= n2) continue;
            n2 = n4;
        }
        return n2;
    }

    @Override
    public int getCommonElementCount(Set<E> set) {
        int n2 = 0;
        int n3 = this.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (!set.contains(this.objectKeyTable[i2])) continue;
            ++n2;
        }
        return n2;
    }

    public static <E> OrderedHashSet<E> addAll(OrderedHashSet<E> orderedHashSet, OrderedHashSet<E> orderedHashSet2) {
        if (orderedHashSet2 == null) {
            return orderedHashSet;
        }
        if (orderedHashSet == null) {
            orderedHashSet = new OrderedHashSet<E>();
        }
        orderedHashSet.addAll(orderedHashSet2);
        return orderedHashSet;
    }

    public static <E> OrderedHashSet<E> add(OrderedHashSet<E> orderedHashSet, E e2) {
        if (e2 == null) {
            return orderedHashSet;
        }
        if (orderedHashSet == null) {
            orderedHashSet = new OrderedHashSet<E>();
        }
        orderedHashSet.add(e2);
        return orderedHashSet;
    }

    private void checkRange(int n2) {
        if (n2 < 0 || n2 >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
    }
}

