/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.NoSuchElementException;
import java.util.Objects;
import org.hsqldb.lib.AbstractReadOnlyCollection;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Map;
import org.hsqldb.lib.MapEntry;
import org.hsqldb.lib.PrimitiveIterator;
import org.hsqldb.lib.Set;
import org.hsqldb.map.BaseHashMap;

public class LongKeyIntValueHashMap
extends BaseHashMap
implements Map<Long, Integer> {
    private Set<Long> keySet;
    private Collection<Integer> values;
    private Set<Map.Entry<Long, Integer>> entries;

    public LongKeyIntValueHashMap() {
        this(8);
    }

    public LongKeyIntValueHashMap(boolean bl) {
        this(8);
        this.minimizeOnEmpty = bl;
    }

    public LongKeyIntValueHashMap(int n2) throws IllegalArgumentException {
        super(n2, 2, 1, false);
    }

    @Override
    public boolean containsKey(Object object) {
        if (object instanceof Long) {
            long l2 = (Long)object;
            return super.containsKey(l2);
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return false;
    }

    @Override
    public boolean containsKey(long l2) {
        return super.containsKey(l2);
    }

    @Override
    public boolean containsValue(Object object) {
        if (object instanceof Integer) {
            int n2 = (Integer)object;
            return super.containsValue(n2);
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return false;
    }

    @Override
    public boolean containsValue(int n2) {
        return super.containsValue(n2);
    }

    @Override
    public Integer get(Object object) {
        if (object instanceof Long) {
            long l2 = (Long)object;
            try {
                int n2 = this.get(l2);
                return n2;
            }
            catch (NoSuchElementException noSuchElementException) {
                return null;
            }
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return null;
    }

    public int get(long l2) throws NoSuchElementException {
        int n2 = this.getLookup(l2);
        if (n2 != -1) {
            return this.intValueTable[n2];
        }
        throw new NoSuchElementException();
    }

    public int get(long l2, int n2) {
        int n3 = this.getLookup(l2);
        if (n3 != -1) {
            return this.intValueTable[n3];
        }
        return n2;
    }

    public boolean get(long l2, int[] nArray) {
        int n2 = this.getLookup(l2);
        if (n2 != -1) {
            nArray[0] = this.intValueTable[n2];
            return true;
        }
        return false;
    }

    @Override
    public int getLookup(long l2) {
        return super.getLookup(l2);
    }

    @Override
    public Integer put(Long l2, Integer n2) {
        if (l2 == null || n2 == null) {
            throw new NullPointerException();
        }
        int n3 = this.size();
        super.addOrUpdate(l2, n2.intValue(), null, null);
        if (n3 == this.size()) {
            return null;
        }
        return n2;
    }

    @Override
    public boolean put(long l2, int n2) {
        int n3 = this.size();
        super.addOrUpdate(l2, n2, null, null);
        return n3 != this.size();
    }

    @Override
    public Integer remove(Object object) {
        if (object instanceof Long) {
            long l2 = (Long)object;
            return (Integer)super.remove(l2, 0L, null, null, false, false);
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return null;
    }

    public boolean remove(long l2) {
        Integer n2 = (Integer)super.remove(l2, 0L, null, null, false, false);
        return n2 != null;
    }

    @Override
    public void putAll(Map<? extends Long, ? extends Integer> map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Long l2 = (Long)iterator.next();
            long l3 = l2;
            Integer n2 = map.get(l2);
            int n3 = n2;
            this.put(l3, n3);
        }
    }

    public void putAll(LongKeyIntValueHashMap longKeyIntValueHashMap) {
        PrimitiveIterator primitiveIterator = (PrimitiveIterator)longKeyIntValueHashMap.keySet().iterator();
        while (primitiveIterator.hasNext()) {
            long l2 = primitiveIterator.nextLong();
            int n2 = longKeyIntValueHashMap.get(l2);
            this.put(l2, n2);
        }
    }

    public long[] keysToArray(long[] lArray) {
        return this.toLongArray(lArray, true);
    }

    public int[] valuesToArray(int[] nArray) {
        return this.toIntArray(nArray, false);
    }

    @Override
    public Set<Long> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet<Long>();
        }
        return this.keySet;
    }

    @Override
    public Collection<Integer> values() {
        if (this.values == null) {
            this.values = new Values<Integer>();
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<Long, Integer>> entrySet() {
        if (this.entries == null) {
            this.entries = new EntrySet();
        }
        return this.entries;
    }

    private class Values<Integer>
    extends AbstractReadOnlyCollection<Integer> {
        private Values() {
        }

        @Override
        public PrimitiveIterator<Integer> iterator() {
            LongKeyIntValueHashMap longKeyIntValueHashMap = LongKeyIntValueHashMap.this;
            Objects.requireNonNull(longKeyIntValueHashMap);
            return new BaseHashMap.BaseHashIterator(longKeyIntValueHashMap, false);
        }

        @Override
        public int size() {
            return LongKeyIntValueHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }

    private class KeySet<Long>
    extends AbstractReadOnlyCollection<Long>
    implements Set<Long> {
        private KeySet() {
        }

        @Override
        public PrimitiveIterator<Long> iterator() {
            LongKeyIntValueHashMap longKeyIntValueHashMap = LongKeyIntValueHashMap.this;
            Objects.requireNonNull(longKeyIntValueHashMap);
            return new BaseHashMap.BaseHashIterator(longKeyIntValueHashMap, true);
        }

        @Override
        public int size() {
            return LongKeyIntValueHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }

    private class EntrySetIterator
    extends BaseHashMap.BaseHashIterator {
        EntrySetIterator() {
            super(LongKeyIntValueHashMap.this, true);
        }

        @Override
        public Map.Entry<Long, Integer> next() {
            Long l2 = super.nextLong();
            Integer n2 = LongKeyIntValueHashMap.this.intValueTable[this.lookup];
            return new MapEntry<Long, Integer>(l2, n2);
        }
    }

    private class EntrySet
    extends AbstractReadOnlyCollection<Map.Entry<Long, Integer>>
    implements Set<Map.Entry<Long, Integer>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<Long, Integer>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return LongKeyIntValueHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }
}

