/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hsqldb.lib.AbstractReadOnlyCollection;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Map;
import org.hsqldb.lib.MapEntry;
import org.hsqldb.lib.PrimitiveIterator;
import org.hsqldb.lib.Set;
import org.hsqldb.map.BaseHashMap;

public class LongKeyHashMap<V>
extends BaseHashMap
implements Map<Long, V> {
    ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
    ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
    ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
    private Set<Long> keySet;
    private Collection<V> values;
    private Set<Map.Entry<Long, V>> entries;

    public LongKeyHashMap() {
        this(16);
    }

    public LongKeyHashMap(int n2) throws IllegalArgumentException {
        super(n2, 2, 3, false);
    }

    public Lock getReadLock() {
        return this.readLock;
    }

    public Lock getWriteLock() {
        return this.writeLock;
    }

    @Override
    public boolean containsKey(Object object) {
        if (object instanceof Long) {
            long l2 = (Long)object;
            return this.containsKey(l2);
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(long l2) {
        this.readLock.lock();
        try {
            boolean bl = super.containsKey(l2);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean containsValue(Object object) {
        this.readLock.lock();
        try {
            boolean bl = super.containsValue(object);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public V get(Object object) {
        if (object instanceof Long) {
            long l2 = (Long)object;
            return this.get(l2);
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(long l2) {
        this.readLock.lock();
        try {
            int n2 = this.getLookup(l2);
            if (n2 == -1) {
                V v2 = null;
                return v2;
            }
            Object object = this.objectValueTable[n2];
            return (V)object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public V put(Long l2, V v2) {
        if (l2 == null) {
            throw new NullPointerException();
        }
        long l3 = l2;
        return this.put(l3, v2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(long l2, V v2) {
        this.writeLock.lock();
        try {
            Object object = super.addOrUpdate(l2, 0L, null, v2);
            return (V)object;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public V remove(Object object) {
        if (object instanceof Long) {
            long l2 = (Long)object;
            return this.remove(l2);
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(long l2) {
        this.writeLock.lock();
        try {
            Object object = super.remove(l2, 0L, null, null, false, false);
            return (V)object;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void clear() {
        this.writeLock.lock();
        try {
            super.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        this.readLock.lock();
        try {
            boolean bl = super.isEmpty();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public int size() {
        this.readLock.lock();
        try {
            int n2 = super.size();
            return n2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends Long, ? extends V> map) {
        Iterator iterator = map.keySet().iterator();
        this.writeLock.lock();
        try {
            while (iterator.hasNext()) {
                Long l2 = (Long)iterator.next();
                long l3 = l2;
                this.put(l3, map.get(l2));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(LongKeyHashMap longKeyHashMap) {
        this.writeLock.lock();
        try {
            PrimitiveIterator primitiveIterator = (PrimitiveIterator)longKeyHashMap.keySet().iterator();
            while (primitiveIterator.hasNext()) {
                long l2 = primitiveIterator.nextLong();
                this.put(l2, longKeyHashMap.get(l2));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public long[] keysToArray(long[] lArray) {
        this.readLock.lock();
        try {
            long[] lArray2 = this.toLongArray(lArray, true);
            return lArray2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Object[] valuesToArray() {
        this.readLock.lock();
        try {
            Object[] objectArray = this.toArray(false);
            return objectArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public <T> T[] valuesToArray(T[] TArray) {
        this.readLock.lock();
        try {
            T[] TArray2 = this.toArray(TArray, false);
            return TArray2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Set<Long> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet<Long>();
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<Long, V>> entrySet() {
        if (this.entries == null) {
            this.entries = new EntrySet();
        }
        return this.entries;
    }

    private class Values<V>
    extends AbstractReadOnlyCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            LongKeyHashMap longKeyHashMap = LongKeyHashMap.this;
            Objects.requireNonNull(longKeyHashMap);
            return new BaseHashMap.BaseHashIterator(longKeyHashMap, false);
        }

        @Override
        public int size() {
            return LongKeyHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public Object[] toArray() {
            return LongKeyHashMap.this.toArray(false);
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return LongKeyHashMap.this.toArray(TArray, false);
        }
    }

    private class KeySet<Long>
    extends AbstractReadOnlyCollection<Long>
    implements Set<Long> {
        private KeySet() {
        }

        @Override
        public PrimitiveIterator<Long> iterator() {
            LongKeyHashMap longKeyHashMap = LongKeyHashMap.this;
            Objects.requireNonNull(longKeyHashMap);
            return new BaseHashMap.BaseHashIterator(longKeyHashMap, true);
        }

        @Override
        public int size() {
            return LongKeyHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }

    private class EntrySetIterator
    extends BaseHashMap.BaseHashIterator {
        EntrySetIterator() {
            super(LongKeyHashMap.this, true);
        }

        @Override
        public Map.Entry<Long, V> next() {
            Long l2 = super.nextLong();
            Object object = LongKeyHashMap.this.objectValueTable[this.lookup];
            return new MapEntry<Long, Object>(l2, object);
        }
    }

    private class EntrySet
    extends AbstractReadOnlyCollection<Map.Entry<Long, V>>
    implements Set<Map.Entry<Long, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<Long, V>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return LongKeyHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }
}

