/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.Arrays;
import java.util.NoSuchElementException;

public class LongDeque {
    private long[] list;
    private int firstindex = 0;
    private int endindex = 0;
    private int elementCount;
    private static final int DEFAULT_INITIAL_CAPACITY = 8;

    public LongDeque() {
        this(8);
    }

    public LongDeque(int n2) {
        this.list = new long[n2];
    }

    public int size() {
        return this.elementCount;
    }

    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public long getFirst() throws NoSuchElementException {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.list[this.firstindex];
    }

    public long getLast() throws NoSuchElementException {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.list[this.endindex - 1];
    }

    public long get(int n2) throws IndexOutOfBoundsException {
        int n3 = this.getInternalIndex(n2);
        return this.list[n3];
    }

    public long removeFirst() throws NoSuchElementException {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        long l2 = this.list[this.firstindex];
        this.list[this.firstindex] = 0L;
        ++this.firstindex;
        --this.elementCount;
        if (this.elementCount == 0) {
            this.endindex = 0;
            this.firstindex = 0;
        } else if (this.firstindex == this.list.length) {
            this.firstindex = 0;
        }
        return l2;
    }

    public long removeLast() throws NoSuchElementException {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        --this.endindex;
        long l2 = this.list[this.endindex];
        this.list[this.endindex] = 0L;
        --this.elementCount;
        if (this.elementCount == 0) {
            this.endindex = 0;
            this.firstindex = 0;
        } else if (this.endindex == 0) {
            this.endindex = this.list.length;
        }
        return l2;
    }

    public boolean add(long l2) {
        this.resetCapacity();
        if (this.endindex == this.list.length) {
            this.endindex = 0;
        }
        this.list[this.endindex] = l2;
        ++this.elementCount;
        ++this.endindex;
        return true;
    }

    public boolean addLast(long l2) {
        return this.add(l2);
    }

    public boolean addFirst(long l2) {
        this.resetCapacity();
        --this.firstindex;
        if (this.firstindex < 0) {
            this.firstindex = this.list.length - 1;
            if (this.endindex == 0) {
                this.endindex = this.list.length;
            }
        }
        this.list[this.firstindex] = l2;
        ++this.elementCount;
        return true;
    }

    public int addAll(LongDeque longDeque) {
        int n2 = 0;
        for (int i2 = 0; i2 < longDeque.size(); ++i2) {
            this.add(longDeque.get(i2));
            ++n2;
        }
        return n2;
    }

    public void clear() {
        if (this.elementCount == 0) {
            return;
        }
        this.elementCount = 0;
        this.endindex = 0;
        this.firstindex = 0;
        Arrays.fill(this.list, 0L);
    }

    public void zeroSize() {
        this.elementCount = 0;
        this.endindex = 0;
        this.firstindex = 0;
    }

    public int indexOf(long l2) {
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            int n2 = this.firstindex + i2;
            if (n2 >= this.list.length) {
                n2 -= this.list.length;
            }
            if (this.list[n2] != l2) continue;
            return i2;
        }
        return -1;
    }

    public long remove(int n2) {
        int n3 = this.getInternalIndex(n2);
        long l2 = this.list[n3];
        if (n3 == this.firstindex) {
            this.list[this.firstindex] = 0L;
            ++this.firstindex;
            if (this.firstindex == this.list.length) {
                this.firstindex = 0;
            }
        } else if (n3 > this.firstindex) {
            System.arraycopy(this.list, this.firstindex, this.list, this.firstindex + 1, n3 - this.firstindex);
            this.list[this.firstindex] = 0L;
            ++this.firstindex;
            if (this.firstindex == this.list.length) {
                this.firstindex = 0;
            }
        } else {
            System.arraycopy(this.list, n3 + 1, this.list, n3, this.endindex - n3 - 1);
            --this.endindex;
            this.list[this.endindex] = 0L;
            if (this.endindex == 0) {
                this.endindex = this.list.length;
            }
        }
        --this.elementCount;
        if (this.elementCount == 0) {
            this.endindex = 0;
            this.firstindex = 0;
        }
        return l2;
    }

    public boolean contains(long l2) {
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            int n2 = this.firstindex + i2;
            if (n2 >= this.list.length) {
                n2 -= this.list.length;
            }
            if (this.list[n2] != l2) continue;
            return true;
        }
        return false;
    }

    public void toArray(int[] nArray) {
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            nArray[i2] = (int)this.get(i2);
        }
    }

    public void toArray(long[] lArray) {
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            lArray[i2] = this.get(i2);
        }
    }

    public long[] toArray() {
        long[] lArray = new long[this.elementCount];
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            lArray[i2] = this.get(i2);
        }
        return lArray;
    }

    private int getInternalIndex(int n2) throws IndexOutOfBoundsException {
        if (n2 < 0 || n2 >= this.elementCount) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = this.firstindex + n2;
        if (n3 >= this.list.length) {
            n3 -= this.list.length;
        }
        return n3;
    }

    private void resetCapacity() {
        if (this.elementCount < this.list.length) {
            return;
        }
        long[] lArray = new long[this.list.length * 2];
        System.arraycopy(this.list, this.firstindex, lArray, this.firstindex, this.list.length - this.firstindex);
        if (this.endindex <= this.firstindex) {
            System.arraycopy(this.list, 0, lArray, this.list.length, this.endindex);
            this.endindex = this.list.length + this.endindex;
        }
        this.list = lArray;
    }
}

