/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.NoSuchElementException;
import java.util.Objects;
import org.hsqldb.lib.AbstractReadOnlyCollection;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Map;
import org.hsqldb.lib.MapEntry;
import org.hsqldb.lib.PrimitiveIterator;
import org.hsqldb.lib.Set;
import org.hsqldb.map.BaseHashMap;

public class IntKeyIntValueHashMap
extends BaseHashMap
implements Map<Integer, Integer> {
    private Set<Integer> keySet;
    private Collection<Integer> values;
    private Set<Map.Entry<Integer, Integer>> entries;

    public IntKeyIntValueHashMap() {
        this(8);
    }

    public IntKeyIntValueHashMap(int n2) throws IllegalArgumentException {
        super(n2, 1, 1, false);
    }

    @Override
    public boolean containsKey(Object object) {
        if (object instanceof Integer) {
            int n2 = (Integer)object;
            return super.containsKey(n2);
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return false;
    }

    @Override
    public boolean containsKey(int n2) {
        return super.containsKey(n2);
    }

    @Override
    public boolean containsValue(Object object) {
        if (object instanceof Integer) {
            int n2 = (Integer)object;
            return super.containsValue(n2);
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return false;
    }

    @Override
    public boolean containsValue(int n2) {
        return super.containsValue(n2);
    }

    @Override
    public Integer get(Object object) {
        if (object instanceof Integer) {
            int n2 = (Integer)object;
            try {
                int n3 = this.get(n2);
                return n3;
            }
            catch (NoSuchElementException noSuchElementException) {
                return null;
            }
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return null;
    }

    public int get(int n2) throws NoSuchElementException {
        int n3 = this.getLookup(n2);
        if (n3 != -1) {
            return this.intValueTable[n3];
        }
        throw new NoSuchElementException();
    }

    public int get(int n2, int n3) {
        int n4 = this.getLookup(n2);
        if (n4 != -1) {
            return this.intValueTable[n4];
        }
        return n3;
    }

    public boolean get(int n2, int[] nArray) {
        int n3 = this.getLookup(n2);
        if (n3 != -1) {
            nArray[0] = this.intValueTable[n3];
            return true;
        }
        return false;
    }

    @Override
    public Integer put(Integer n2, Integer n3) {
        if (n2 == null || n3 == null) {
            throw new NullPointerException();
        }
        int n4 = this.size();
        super.addOrUpdate(n2.intValue(), n3.intValue(), null, null);
        if (n4 == this.size()) {
            return null;
        }
        return n3;
    }

    @Override
    public boolean put(int n2, int n3) {
        int n4 = this.size();
        super.addOrUpdate(n2, n3, null, null);
        return n4 != this.size();
    }

    @Override
    public Integer remove(Object object) {
        if (object instanceof Integer) {
            int n2 = (Integer)object;
            return (Integer)super.remove(n2, 0L, null, null, false, false);
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return null;
    }

    public boolean remove(int n2) {
        Integer n3 = (Integer)super.remove(n2, 0L, null, null, false, false);
        return n3 != null;
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends Integer> map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n2 = (Integer)iterator.next();
            int n3 = n2;
            Integer n4 = map.get(n2);
            int n5 = n4;
            this.put(n3, n5);
        }
    }

    public void putAll(IntKeyIntValueHashMap intKeyIntValueHashMap) {
        PrimitiveIterator primitiveIterator = (PrimitiveIterator)intKeyIntValueHashMap.keySet().iterator();
        while (primitiveIterator.hasNext()) {
            int n2 = primitiveIterator.nextInt();
            int n3 = intKeyIntValueHashMap.get(n2);
            this.put(n2, n3);
        }
    }

    public int[] keysToArray(int[] nArray) {
        return this.toIntArray(nArray, true);
    }

    public int[] valuesToArray(int[] nArray) {
        return this.toIntArray(nArray, false);
    }

    @Override
    public Set<Integer> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet<Integer>();
        }
        return this.keySet;
    }

    @Override
    public Collection<Integer> values() {
        if (this.values == null) {
            this.values = new Values<Integer>();
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<Integer, Integer>> entrySet() {
        if (this.entries == null) {
            this.entries = new EntrySet();
        }
        return this.entries;
    }

    private class Values<Integer>
    extends AbstractReadOnlyCollection<Integer> {
        private Values() {
        }

        @Override
        public PrimitiveIterator<Integer> iterator() {
            IntKeyIntValueHashMap intKeyIntValueHashMap = IntKeyIntValueHashMap.this;
            Objects.requireNonNull(intKeyIntValueHashMap);
            return new BaseHashMap.BaseHashIterator(intKeyIntValueHashMap, false);
        }

        @Override
        public int size() {
            return IntKeyIntValueHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }

    private class KeySet<Integer>
    extends AbstractReadOnlyCollection<Integer>
    implements Set<Integer> {
        private KeySet() {
        }

        @Override
        public PrimitiveIterator<Integer> iterator() {
            IntKeyIntValueHashMap intKeyIntValueHashMap = IntKeyIntValueHashMap.this;
            Objects.requireNonNull(intKeyIntValueHashMap);
            return new BaseHashMap.BaseHashIterator(intKeyIntValueHashMap, true);
        }

        @Override
        public int size() {
            return IntKeyIntValueHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }

    private class EntrySetIterator
    extends BaseHashMap.BaseHashIterator {
        EntrySetIterator() {
            super(IntKeyIntValueHashMap.this, true);
        }

        @Override
        public Map.Entry<Integer, Integer> next() {
            Integer n2 = super.nextInt();
            Integer n3 = IntKeyIntValueHashMap.this.intValueTable[this.lookup];
            return new MapEntry<Integer, Integer>(n2, n3);
        }
    }

    private class EntrySet
    extends AbstractReadOnlyCollection<Map.Entry<Integer, Integer>>
    implements Set<Map.Entry<Integer, Integer>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<Integer, Integer>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return IntKeyIntValueHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }
}

