/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hsqldb.lib.AbstractReadOnlyCollection;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.IntKeyHashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Map;
import org.hsqldb.lib.MapEntry;
import org.hsqldb.lib.PrimitiveIterator;
import org.hsqldb.lib.Set;
import org.hsqldb.map.BaseHashMap;

public class IntKeyHashMapConcurrent<V>
extends BaseHashMap
implements Map<Integer, V> {
    private Set<Integer> keySet;
    private Collection<V> values;
    private Set<Map.Entry<Integer, V>> entries;
    ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
    ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
    ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();

    public IntKeyHashMapConcurrent() {
        this(8);
    }

    public IntKeyHashMapConcurrent(int n2) throws IllegalArgumentException {
        super(n2, 1, 3, false);
    }

    public Lock getWriteLock() {
        return this.writeLock;
    }

    @Override
    public boolean containsKey(Object object) {
        if (object instanceof Integer) {
            int n2 = (Integer)object;
            return super.containsKey(n2);
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return false;
    }

    @Override
    public boolean containsKey(int n2) {
        try {
            this.readLock.lock();
            boolean bl = super.containsKey(n2);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean containsValue(Object object) {
        try {
            this.readLock.lock();
            boolean bl = super.containsValue(object);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public V get(Object object) {
        if (object instanceof Integer) {
            int n2 = (Integer)object;
            return this.get(n2);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(int n2) {
        try {
            this.readLock.lock();
            int n3 = this.getLookup(n2);
            if (n3 != -1) {
                Object object = this.objectValueTable[n3];
                return (V)object;
            }
            V v2 = null;
            return v2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public V put(Integer n2, V v2) {
        if (n2 == null) {
            throw new NullPointerException();
        }
        int n3 = n2;
        return this.put(n3, v2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(int n2, V v2) {
        try {
            this.writeLock.lock();
            Object object = super.addOrUpdate(n2, 0L, null, v2);
            return (V)object;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public V remove(Object object) {
        if (object instanceof Integer) {
            int n2 = (Integer)object;
            return this.remove(n2);
        }
        return null;
    }

    public V remove(int n2) {
        try {
            this.writeLock.lock();
            Object object = super.remove(n2, 0L, null, null, false, false);
            return (V)object;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends Integer, ? extends V> map) {
        try {
            this.writeLock.lock();
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Integer n2 = (Integer)iterator.next();
                int n3 = n2;
                this.put(n3, map.get(n2));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(IntKeyHashMap intKeyHashMap) {
        try {
            this.writeLock.lock();
            PrimitiveIterator primitiveIterator = (PrimitiveIterator)intKeyHashMap.keySet().iterator();
            while (primitiveIterator.hasNext()) {
                int n2 = primitiveIterator.nextInt();
                this.put(n2, (V)intKeyHashMap.get(n2));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOrderedKeyMatchCount(int[] nArray) {
        try {
            int n2;
            this.readLock.lock();
            for (n2 = 0; n2 < nArray.length && super.containsKey(nArray[n2]); ++n2) {
            }
            int n3 = n2;
            return n3;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int[] keysToArray(int[] nArray) {
        try {
            this.readLock.lock();
            int[] nArray2 = this.toIntArray(nArray, true);
            return nArray2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public <T> T[] valuesToArray(T[] TArray) {
        try {
            this.readLock.lock();
            T[] TArray2 = this.toArray(TArray, false);
            return TArray2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Set<Integer> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet<Integer>();
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<Integer, V>> entrySet() {
        if (this.entries == null) {
            this.entries = new EntrySet();
        }
        return this.entries;
    }

    private class Values<V>
    extends AbstractReadOnlyCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            IntKeyHashMapConcurrent intKeyHashMapConcurrent = IntKeyHashMapConcurrent.this;
            Objects.requireNonNull(intKeyHashMapConcurrent);
            return new BaseHashMap.BaseHashIterator(intKeyHashMapConcurrent, false);
        }

        @Override
        public int size() {
            return IntKeyHashMapConcurrent.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = new Object[this.size()];
            return IntKeyHashMapConcurrent.this.valuesToArray(objectArray);
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return IntKeyHashMapConcurrent.this.valuesToArray(TArray);
        }
    }

    private class KeySet<Integer>
    extends AbstractReadOnlyCollection<Integer>
    implements Set<Integer> {
        private KeySet() {
        }

        @Override
        public PrimitiveIterator<Integer> iterator() {
            IntKeyHashMapConcurrent intKeyHashMapConcurrent = IntKeyHashMapConcurrent.this;
            Objects.requireNonNull(intKeyHashMapConcurrent);
            return new BaseHashMap.BaseHashIterator(intKeyHashMapConcurrent, true);
        }

        @Override
        public int size() {
            return IntKeyHashMapConcurrent.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }

    private class EntrySetIterator
    extends BaseHashMap.BaseHashIterator {
        EntrySetIterator() {
            super(IntKeyHashMapConcurrent.this, true);
        }

        @Override
        public Map.Entry<Integer, V> next() {
            Integer n2 = super.nextInt();
            Object object = IntKeyHashMapConcurrent.this.objectValueTable[this.lookup];
            return new MapEntry<Integer, Object>(n2, object);
        }
    }

    private class EntrySet
    extends AbstractReadOnlyCollection<Map.Entry<Integer, V>>
    implements Set<Map.Entry<Integer, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<Integer, V>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return IntKeyHashMapConcurrent.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }
}

