/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.Objects;
import org.hsqldb.lib.AbstractReadOnlyCollection;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Map;
import org.hsqldb.lib.MapEntry;
import org.hsqldb.lib.PrimitiveIterator;
import org.hsqldb.lib.Set;
import org.hsqldb.map.BaseHashMap;

public class IntKeyHashMap<V>
extends BaseHashMap
implements Map<Integer, V> {
    private Set<Integer> keySet;
    private Collection<V> values;
    private Set<Map.Entry<Integer, V>> entries;

    public IntKeyHashMap() {
        this(8);
    }

    public IntKeyHashMap(int n2) throws IllegalArgumentException {
        super(n2, 1, 3, false);
    }

    @Override
    public boolean containsKey(Object object) {
        if (object instanceof Integer) {
            int n2 = (Integer)object;
            return this.containsKey(n2);
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return false;
    }

    @Override
    public boolean containsKey(int n2) {
        return super.containsKey(n2);
    }

    @Override
    public boolean containsValue(Object object) {
        return super.containsValue(object);
    }

    @Override
    public V get(Object object) {
        if (object instanceof Integer) {
            int n2 = (Integer)object;
            return this.get(n2);
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return null;
    }

    public V get(int n2) {
        int n3 = this.getLookup(n2);
        if (n3 != -1) {
            return (V)this.objectValueTable[n3];
        }
        return null;
    }

    @Override
    public V put(Integer n2, V v2) {
        if (n2 == null) {
            throw new NullPointerException();
        }
        int n3 = n2;
        return this.put(n3, v2);
    }

    @Override
    public V put(int n2, V v2) {
        return (V)super.addOrUpdate(n2, 0L, null, v2);
    }

    @Override
    public V remove(Object object) {
        if (object instanceof Integer) {
            int n2 = (Integer)object;
            return this.remove(n2);
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return null;
    }

    public V remove(int n2) {
        return (V)super.remove(n2, 0L, null, null, false, false);
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends V> map) {
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n2 = (Integer)iterator.next();
            if (n2 == null) continue;
            int n3 = n2;
            this.put(n3, map.get(n2));
        }
    }

    public void putAll(IntKeyHashMap intKeyHashMap) {
        PrimitiveIterator primitiveIterator = (PrimitiveIterator)intKeyHashMap.keySet().iterator();
        while (primitiveIterator.hasNext()) {
            int n2 = primitiveIterator.nextInt();
            this.put(n2, intKeyHashMap.get(n2));
        }
    }

    public int[] keysToArray(int[] nArray) {
        return this.toIntArray(nArray, true);
    }

    public Object[] valuesToArray() {
        return this.toArray(false);
    }

    public <T> T[] valuesToArray(T[] TArray) {
        return this.toArray(TArray, false);
    }

    @Override
    public Set<Integer> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet<Integer>();
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new Values();
        }
        return this.values;
    }

    @Override
    public Set<Map.Entry<Integer, V>> entrySet() {
        if (this.entries == null) {
            this.entries = new EntrySet();
        }
        return this.entries;
    }

    private class Values<V>
    extends AbstractReadOnlyCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            IntKeyHashMap intKeyHashMap = IntKeyHashMap.this;
            Objects.requireNonNull(intKeyHashMap);
            return new BaseHashMap.BaseHashIterator(intKeyHashMap, false);
        }

        @Override
        public int size() {
            return IntKeyHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public Object[] toArray() {
            return IntKeyHashMap.this.toArray(false);
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return IntKeyHashMap.this.toArray(TArray, false);
        }
    }

    private class KeySet<Integer>
    extends AbstractReadOnlyCollection<Integer>
    implements Set<Integer> {
        private KeySet() {
        }

        @Override
        public PrimitiveIterator<Integer> iterator() {
            IntKeyHashMap intKeyHashMap = IntKeyHashMap.this;
            Objects.requireNonNull(intKeyHashMap);
            return new BaseHashMap.BaseHashIterator(intKeyHashMap, true);
        }

        @Override
        public int size() {
            return IntKeyHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }

    private class EntrySetIterator
    extends BaseHashMap.BaseHashIterator {
        EntrySetIterator() {
            super(IntKeyHashMap.this, true);
        }

        @Override
        public Map.Entry<Integer, V> next() {
            Integer n2 = super.nextInt();
            Object object = IntKeyHashMap.this.objectValueTable[this.lookup];
            return new MapEntry<Integer, Object>(n2, object);
        }
    }

    private class EntrySet
    extends AbstractReadOnlyCollection<Map.Entry<Integer, V>>
    implements Set<Map.Entry<Integer, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<Integer, V>> iterator() {
            return new EntrySetIterator();
        }

        @Override
        public int size() {
            return IntKeyHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }
    }
}

