/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.Arrays;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.DoubleIntIndex;

public class IntIndex {
    private int count = 0;
    private int capacity;
    private boolean sorted = true;
    private final boolean fixedSize;
    private int[] keys;
    private int targetSearchValue;

    public IntIndex(int n2, boolean bl) {
        this.capacity = n2;
        this.keys = new int[n2];
        this.fixedSize = bl;
    }

    public synchronized int getKey(int n2) {
        if (n2 < 0 || n2 >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        return this.keys[n2];
    }

    public synchronized void setKey(int n2, int n3) {
        if (n2 < 0 || n2 >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        this.sorted = false;
        this.keys[n2] = n3;
    }

    public synchronized int size() {
        return this.count;
    }

    public synchronized int capacity() {
        return this.capacity;
    }

    public int[] getKeys() {
        return this.keys;
    }

    public synchronized long getTotalValues() {
        long l2 = 0L;
        for (int i2 = 0; i2 < this.count; ++i2) {
            l2 += (long)this.keys[i2];
        }
        return l2;
    }

    public synchronized boolean addUnsorted(int n2) {
        if (this.count == this.capacity) {
            if (this.fixedSize) {
                return false;
            }
            this.doubleCapacity();
        }
        if (this.sorted && this.count != 0 && n2 < this.keys[this.count - 1]) {
            this.sorted = false;
        }
        this.keys[this.count] = n2;
        ++this.count;
        return true;
    }

    public synchronized boolean addSorted(int n2) {
        if (this.count == this.capacity) {
            if (this.fixedSize) {
                return false;
            }
            this.doubleCapacity();
        }
        if (this.count != 0 && n2 < this.keys[this.count - 1]) {
            return false;
        }
        this.keys[this.count] = n2;
        ++this.count;
        return true;
    }

    public synchronized boolean addUnique(int n2) {
        if (this.count == this.capacity) {
            if (this.fixedSize) {
                return false;
            }
            this.doubleCapacity();
        }
        if (!this.sorted) {
            this.fastQuickSort();
        }
        this.targetSearchValue = n2;
        int n3 = this.binaryEmptySlotSearch();
        if (n3 == -1) {
            return false;
        }
        if (this.count != n3) {
            this.moveRows(n3, n3 + 1, this.count - n3);
        }
        this.keys[n3] = n2;
        ++this.count;
        return true;
    }

    public synchronized int add(int n2) {
        if (this.count == this.capacity) {
            if (this.fixedSize) {
                return -1;
            }
            this.doubleCapacity();
        }
        if (!this.sorted) {
            this.fastQuickSort();
        }
        this.targetSearchValue = n2;
        int n3 = this.binarySlotSearch();
        if (this.count != n3) {
            this.moveRows(n3, n3 + 1, this.count - n3);
        }
        this.keys[n3] = n2;
        ++this.count;
        return n3;
    }

    public void clear() {
        this.removeAll();
    }

    public synchronized int findFirstIndexUnsorted(int n2) {
        for (int i2 = 0; i2 < this.count; ++i2) {
            if (this.keys[i2] != n2) continue;
            return i2;
        }
        return -1;
    }

    public synchronized int findFirstGreaterEqualKeyIndex(int n2) {
        int n3 = this.findFirstGreaterEqualSlotIndex(n2);
        return n3 == this.count ? -1 : n3;
    }

    public synchronized int findFirstEqualKeyIndex(int n2) {
        if (!this.sorted) {
            this.fastQuickSort();
        }
        this.targetSearchValue = n2;
        return this.binaryFirstSearch();
    }

    public synchronized int findFirstConsecutiveKeys(int n2) {
        int n3 = -1;
        if (this.count == 0) {
            return -1;
        }
        if (!this.sorted) {
            this.fastQuickSort();
        }
        if (n2 == 1) {
            return 0;
        }
        for (int i2 = 1; i2 < this.count; ++i2) {
            if (this.keys[i2 - 1] == this.keys[i2] - 1) {
                if (n3 == -1) {
                    n3 = i2 - 1;
                }
                if (i2 - n3 + 1 != n2) continue;
                return n3;
            }
            n3 = -1;
        }
        return -1;
    }

    public synchronized int removeFirstConsecutiveKeys(int n2, int n3) {
        int n4 = this.findFirstConsecutiveKeys(n2);
        if (n4 == -1) {
            return n3;
        }
        int n5 = this.keys[n4];
        this.removeRange(n4, n4 + n2);
        return n5;
    }

    public synchronized int findFirstGreaterEqualSlotIndex(int n2) {
        if (!this.sorted) {
            this.fastQuickSort();
        }
        this.targetSearchValue = n2;
        return this.binarySlotSearch();
    }

    private int binaryFirstSearch() {
        int n2 = 0;
        int n3 = this.count;
        int n4 = 0;
        int n5 = 0;
        int n6 = this.count;
        while (n2 < n3) {
            n4 = n2 + n3 >>> 1;
            n5 = this.compare(n4);
            if (n5 < 0) {
                n3 = n4;
                continue;
            }
            if (n5 > 0) {
                n2 = n4 + 1;
                continue;
            }
            n3 = n4;
            n6 = n4;
        }
        return n6 == this.count ? -1 : n6;
    }

    private int binarySlotSearch() {
        int n2 = 0;
        int n3 = this.count;
        int n4 = 0;
        int n5 = 0;
        while (n2 < n3) {
            n4 = n2 + n3 >>> 1;
            n5 = this.compare(n4);
            if (n5 <= 0) {
                n3 = n4;
                continue;
            }
            n2 = n4 + 1;
        }
        return n2;
    }

    private int binaryEmptySlotSearch() {
        int n2 = 0;
        int n3 = this.count;
        int n4 = 0;
        int n5 = 0;
        while (n2 < n3) {
            n4 = n2 + n3 >>> 1;
            n5 = this.compare(n4);
            if (n5 < 0) {
                n3 = n4;
                continue;
            }
            if (n5 > 0) {
                n2 = n4 + 1;
                continue;
            }
            return -1;
        }
        return n2;
    }

    public synchronized void sort() {
        this.fastQuickSort();
    }

    private synchronized void fastQuickSort() {
        DoubleIntIndex doubleIntIndex = new DoubleIntIndex(32);
        int n2 = 16;
        doubleIntIndex.push(0, this.count - 1);
        while (doubleIntIndex.size() > 0) {
            int n3 = doubleIntIndex.peekKey();
            int n4 = doubleIntIndex.peekValue();
            doubleIntIndex.pop();
            if (n4 - n3 >= n2) {
                int n5 = this.partition(n3, n4, n3 + (n4 - n3 >>> 1));
                doubleIntIndex.push(n3, n5 - 1);
                doubleIntIndex.push(n5 + 1, n4);
                continue;
            }
            this.insertionSort(n3, n4);
        }
        this.sorted = true;
    }

    private int partition(int n2, int n3, int n4) {
        int n5 = n2;
        this.swap(n4, n3);
        for (int i2 = n2; i2 <= n3 - 1; ++i2) {
            if (!this.lessThan(i2, n3)) continue;
            this.swap(i2, n5);
            ++n5;
        }
        this.swap(n5, n3);
        return n5;
    }

    private synchronized void fastQuickSortRecursive() {
        this.quickSort(0, this.count - 1);
        this.insertionSort(0, this.count - 1);
        this.sorted = true;
    }

    private void quickSort(int n2, int n3) {
        int n4 = 16;
        if (n3 - n2 > n4) {
            int n5 = n3 + n2 >>> 1;
            if (this.lessThan(n5, n2)) {
                this.swap(n2, n5);
            }
            if (this.lessThan(n3, n2)) {
                this.swap(n2, n3);
            }
            if (this.lessThan(n3, n5)) {
                this.swap(n5, n3);
            }
            int n6 = n3 - 1;
            this.swap(n5, n6);
            n5 = n2;
            int n7 = n6;
            while (true) {
                if (this.lessThan(++n5, n7)) {
                    continue;
                }
                while (this.lessThan(n7, --n6)) {
                }
                if (n6 < n5) break;
                this.swap(n5, n6);
            }
            this.swap(n5, n3 - 1);
            this.quickSort(n2, n6);
            this.quickSort(n5 + 1, n3);
        }
    }

    private void insertionSort(int n2, int n3) {
        for (int i2 = n2 + 1; i2 <= n3; ++i2) {
            int n4;
            for (n4 = i2; n4 > n2 && this.lessThan(i2, n4 - 1); --n4) {
            }
            if (i2 == n4) continue;
            this.moveAndInsertRow(i2, n4);
        }
    }

    protected void moveAndInsertRow(int n2, int n3) {
        int n4 = this.keys[n2];
        this.moveRows(n3, n3 + 1, n2 - n3);
        this.keys[n3] = n4;
    }

    protected void swap(int n2, int n3) {
        int n4 = this.keys[n2];
        this.keys[n2] = this.keys[n3];
        this.keys[n3] = n4;
    }

    protected int compare(int n2) {
        if (this.targetSearchValue > this.keys[n2]) {
            return 1;
        }
        if (this.targetSearchValue < this.keys[n2]) {
            return -1;
        }
        return 0;
    }

    protected boolean lessThan(int n2, int n3) {
        return this.keys[n2] < this.keys[n3];
    }

    protected void moveRows(int n2, int n3, int n4) {
        System.arraycopy(this.keys, n2, this.keys, n3, n4);
    }

    protected void doubleCapacity() {
        this.keys = (int[])ArrayUtil.resizeArray(this.keys, this.capacity * 2);
        this.capacity *= 2;
    }

    public synchronized void removeRange(int n2, int n3) {
        ArrayUtil.adjustArray(73, this.keys, this.count, n2, n2 - n3);
        this.count -= n3 - n2;
    }

    public synchronized void removeAll() {
        Arrays.fill(this.keys, 0);
        this.count = 0;
    }

    public final synchronized void remove(int n2) {
        this.moveRows(n2 + 1, n2, this.count - n2 - 1);
        --this.count;
        this.keys[this.count] = 0;
    }
}

