/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.NoSuchElementException;
import org.hsqldb.lib.BaseList;
import org.hsqldb.lib.Collection;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.List;

public class HsqlDeque<E>
extends BaseList<E>
implements List<E> {
    private E[] list = new Object[16];
    private int firstindex = 0;
    private int endindex = 0;
    private static final int DEFAULT_INITIAL_CAPACITY = 16;

    @Override
    public int size() {
        return this.elementCount;
    }

    @Override
    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public boolean offer(E e2) {
        return this.add(e2);
    }

    public E remove() {
        return this.removeFirst();
    }

    public E poll() {
        if (this.elementCount == 0) {
            return null;
        }
        return this.removeFirst();
    }

    public E element() {
        return this.getFirst();
    }

    public E peek() {
        if (this.elementCount == 0) {
            return null;
        }
        return this.getFirst();
    }

    public void push(E e2) {
        this.addFirst(e2);
    }

    public E pop() {
        return this.removeFirst();
    }

    public E getFirst() throws NoSuchElementException {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.list[this.firstindex];
    }

    public E getLast() throws NoSuchElementException {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.list[this.endindex - 1];
    }

    @Override
    public E get(int n2) throws IndexOutOfBoundsException {
        int n3 = this.getInternalIndex(n2);
        return this.list[n3];
    }

    @Override
    public void add(int n2, E e2) throws IndexOutOfBoundsException {
        if (n2 == this.elementCount) {
            this.add(e2);
            return;
        }
        this.resetCapacity();
        int n3 = this.getInternalIndex(n2);
        if (n3 < this.endindex && this.endindex < this.list.length) {
            System.arraycopy(this.list, n3, this.list, n3 + 1, this.endindex - n3);
            ++this.endindex;
        } else {
            System.arraycopy(this.list, this.firstindex, this.list, this.firstindex - 1, n3 - this.firstindex);
            --this.firstindex;
            --n3;
        }
        this.list[n3] = e2;
        ++this.elementCount;
    }

    @Override
    public E set(int n2, E e2) throws IndexOutOfBoundsException {
        int n3 = this.getInternalIndex(n2);
        E e3 = this.list[n3];
        this.list[n3] = e2;
        return e3;
    }

    public E removeFirst() throws NoSuchElementException {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        E e2 = this.list[this.firstindex];
        this.list[this.firstindex] = null;
        ++this.firstindex;
        --this.elementCount;
        if (this.elementCount == 0) {
            this.endindex = 0;
            this.firstindex = 0;
        } else if (this.firstindex == this.list.length) {
            this.firstindex = 0;
        }
        return e2;
    }

    public E removeLast() throws NoSuchElementException {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        --this.endindex;
        E e2 = this.list[this.endindex];
        this.list[this.endindex] = null;
        --this.elementCount;
        if (this.elementCount == 0) {
            this.endindex = 0;
            this.firstindex = 0;
        } else if (this.endindex == 0) {
            this.endindex = this.list.length;
        }
        return e2;
    }

    public E peekFirst() {
        return this.getFirst();
    }

    public E peekLast() {
        return this.getLast();
    }

    public boolean offerFirst(E e2) {
        this.addFirst(e2);
        return true;
    }

    public boolean offerLast(E e2) {
        this.addLast(e2);
        return true;
    }

    public E pollFirst() {
        if (this.elementCount == 0) {
            return null;
        }
        return this.removeFirst();
    }

    public E pollLast() {
        if (this.elementCount == 0) {
            return null;
        }
        return this.removeLast();
    }

    public boolean removeFirstOccurrence(Object object) {
        int n2 = this.indexOf(object);
        if (n2 < 1) {
            return false;
        }
        this.remove(n2);
        return true;
    }

    public boolean removeLastOccurrence(Object object) {
        int n2 = this.lastIndexOf(object);
        if (n2 < 1) {
            return false;
        }
        this.remove(n2);
        return true;
    }

    public Iterator<E> descendingIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(E e2) {
        this.resetCapacity();
        if (this.endindex == this.list.length) {
            this.endindex = 0;
        }
        this.list[this.endindex] = e2;
        ++this.elementCount;
        ++this.endindex;
        return true;
    }

    public void addLast(E e2) {
        this.add(e2);
    }

    public void addFirst(E e2) {
        this.resetCapacity();
        --this.firstindex;
        if (this.firstindex < 0) {
            this.firstindex = this.list.length - 1;
            if (this.endindex == 0) {
                this.endindex = this.list.length;
            }
        }
        this.list[this.firstindex] = e2;
        ++this.elementCount;
    }

    @Override
    public void clear() {
        if (this.elementCount == 0) {
            return;
        }
        this.elementCount = 0;
        this.endindex = 0;
        this.firstindex = 0;
        Arrays.fill(this.list, null);
    }

    @Override
    public int indexOf(Object object) {
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            int n2 = this.firstindex + i2;
            if (n2 >= this.list.length) {
                n2 -= this.list.length;
            }
            if (this.list[n2] == object) {
                return i2;
            }
            if (object == null || !this.comparator.equals(object, this.list[n2])) continue;
            return i2;
        }
        return -1;
    }

    public int lastIndexOf(Object object) {
        for (int i2 = this.elementCount - 1; i2 >= 0; --i2) {
            int n2 = this.firstindex + i2;
            if (n2 < 0) {
                n2 += this.list.length;
            }
            if (this.list[n2] == object) {
                return i2;
            }
            if (object == null || !this.comparator.equals(object, this.list[n2])) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public E remove(int n2) {
        int n3 = this.getInternalIndex(n2);
        E e2 = this.list[n3];
        if (n3 == this.firstindex) {
            this.list[this.firstindex] = null;
            ++this.firstindex;
            if (this.firstindex == this.list.length) {
                this.firstindex = 0;
            }
        } else if (n3 > this.firstindex) {
            System.arraycopy(this.list, this.firstindex, this.list, this.firstindex + 1, n3 - this.firstindex);
            this.list[this.firstindex] = null;
            ++this.firstindex;
            if (this.firstindex == this.list.length) {
                this.firstindex = 0;
            }
        } else {
            System.arraycopy(this.list, n3 + 1, this.list, n3, this.endindex - n3 - 1);
            --this.endindex;
            this.list[this.endindex] = null;
            if (this.endindex == 0) {
                this.endindex = this.list.length;
            }
        }
        --this.elementCount;
        if (this.elementCount == 0) {
            this.endindex = 0;
            this.firstindex = 0;
        }
        return e2;
    }

    private int getInternalIndex(int n2) throws IndexOutOfBoundsException {
        if (n2 < 0 || n2 >= this.elementCount) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = this.firstindex + n2;
        if (n3 >= this.list.length) {
            n3 -= this.list.length;
        }
        return n3;
    }

    private void resetCapacity() {
        if (this.elementCount < this.list.length) {
            return;
        }
        Object[] objectArray = new Object[this.list.length * 2];
        System.arraycopy(this.list, this.firstindex, objectArray, this.firstindex, this.list.length - this.firstindex);
        if (this.endindex <= this.firstindex) {
            System.arraycopy(this.list, 0, objectArray, this.list.length, this.endindex);
            this.endindex = this.list.length + this.endindex;
        }
        this.list = objectArray;
    }

    public <T> T[] toArray(T[] objectArray) {
        int n2;
        if (objectArray.length < this.elementCount) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.elementCount);
        }
        if ((n2 = this.list.length - this.firstindex) > this.elementCount) {
            n2 = this.elementCount;
        }
        System.arraycopy(this.list, this.firstindex, objectArray, 0, n2);
        if (this.endindex <= this.firstindex) {
            System.arraycopy(this.list, 0, objectArray, n2, this.endindex);
        }
        return objectArray;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.elementCount];
        return this.toArray(objectArray);
    }

    public List<E> subList(int n2, int n3) {
        throw new UnsupportedOperationException();
    }

    public boolean containsAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean removeAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean retainAll(Collection collection) {
        throw new UnsupportedOperationException();
    }

    public boolean addAll(int n2, Collection collection) {
        throw new UnsupportedOperationException();
    }
}

