/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import org.hsqldb.lib.Collection;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.ObjectComparator;
import org.hsqldb.lib.Set;
import org.hsqldb.map.BaseHashMap;

public class HashSet<E>
extends BaseHashMap
implements Set<E> {
    public HashSet() {
        this(8);
    }

    public HashSet(int n2) throws IllegalArgumentException {
        super(n2, 3, 0, false);
    }

    public HashSet(int n2, ObjectComparator objectComparator) throws IllegalArgumentException {
        this(n2);
        this.comparator = objectComparator;
    }

    public HashSet(Object[] objectArray) {
        this(objectArray.length);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            this.add(objectArray[i2]);
        }
    }

    @Override
    public boolean contains(Object object) {
        return super.containsKey(object);
    }

    public boolean containsAll(Collection<?> collection) {
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public E getOrAdd(E e2) {
        if (e2 == null) {
            throw new NullPointerException();
        }
        E e3 = this.get(e2);
        if (e3 == null) {
            e3 = e2;
            this.add(e2);
        }
        return e3;
    }

    public E get(E e2) {
        if (e2 == null) {
            throw new NullPointerException();
        }
        int n2 = this.getLookup(e2);
        if (n2 < 0) {
            return null;
        }
        return (E)this.objectKeyTable[n2];
    }

    @Override
    public boolean add(E e2) {
        if (e2 == null) {
            throw new NullPointerException();
        }
        return (Boolean)super.addOrUpdate(0L, 0L, e2, null);
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        boolean bl = false;
        Iterator<E> iterator = collection.iterator();
        while (iterator.hasNext()) {
            bl |= this.add(iterator.next());
        }
        return bl;
    }

    public boolean addAll(E[] EArray) {
        boolean bl = false;
        for (int i2 = 0; i2 < EArray.length; ++i2) {
            bl |= this.add(EArray[i2]);
        }
        return bl;
    }

    public boolean addAll(E[] EArray, int n2, int n3) {
        boolean bl = false;
        for (int i2 = n2; i2 < EArray.length && i2 < n3; ++i2) {
            bl |= this.add(EArray[i2]);
        }
        return bl;
    }

    @Override
    public boolean remove(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return (Boolean)super.remove(0L, 0L, object, null, false, false);
    }

    public boolean removeAll(Collection<?> collection) {
        Iterator<?> iterator = collection.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            bl &= this.remove(iterator.next());
        }
        return bl;
    }

    public boolean retainAll(Collection<?> collection) {
        boolean bl = false;
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            if (collection.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public boolean removeAll(E[] EArray) {
        boolean bl = true;
        for (int i2 = 0; i2 < EArray.length; ++i2) {
            bl &= this.remove(EArray[i2]);
        }
        return bl;
    }

    public int getCommonElementCount(Set<E> set) {
        int n2 = 0;
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!set.contains(iterator.next())) continue;
            ++n2;
        }
        return n2;
    }

    public <T> T[] toArray(T[] TArray) {
        return this.toArray(TArray, true);
    }

    public Object[] toArray() {
        return this.toArray(true);
    }

    @Override
    public Iterator<E> iterator() {
        return new BaseHashMap.BaseHashIterator(this, true);
    }

    public String toString() {
        Iterator<E> iterator = this.iterator();
        StringBuilder stringBuilder = new StringBuilder();
        while (iterator.hasNext()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            } else {
                stringBuilder.append('[');
            }
            stringBuilder.append(iterator.next());
        }
        return stringBuilder.toString() + "]";
    }
}

