/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Random;
import org.hsqldb.lib.EventLogInterface;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.FileAccessRes;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.InOutUtil;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.lib.java.JavaSystem;

public class FileUtil
implements FileAccess {
    private static FileUtil fileUtil = new FileUtil();
    private static FileAccessRes fileAccessRes = new FileAccessRes();
    public final boolean fsIsIgnoreCase = new File("A").equals(new File("a"));
    public final boolean fsNormalizesPosixSeparator = new File("/").getPath().endsWith(File.separator);
    final Random random = new Random(System.currentTimeMillis());
    static int discardSuffixLength = 9;

    FileUtil() {
    }

    public static FileUtil getFileUtil() {
        return fileUtil;
    }

    public static FileAccess getFileAccess(boolean bl) {
        return bl ? fileAccessRes : fileUtil;
    }

    @Override
    public boolean isStreamElement(String string) {
        return new File(string).exists();
    }

    @Override
    public InputStream openInputStreamElement(String string) throws IOException {
        try {
            return new FileInputStream(string);
        }
        catch (Throwable throwable) {
            throw JavaSystem.toIOException(throwable);
        }
    }

    @Override
    public void createParentDirs(String string) {
        this.makeParentDirectories(new File(string));
    }

    @Override
    public boolean removeElement(String string) {
        if (this.isStreamElement(string)) {
            return this.delete(string);
        }
        return true;
    }

    @Override
    public boolean renameElement(String string, String string2) {
        return this.renameWithOverwrite(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean renameElementOrCopy(String string, String string2, EventLogInterface eventLogInterface) {
        if (this.renameWithOverwrite(string, string2)) {
            return true;
        }
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = this.openInputStreamElement(string);
            outputStream = this.openOutputStreamElement(string2);
            InOutUtil.copy(inputStream, outputStream);
            this.getFileSync(outputStream).sync();
        }
        catch (IOException iOException) {
            String string3 = String.format("Platform does not allow renaming files and failed to copy file contents from %s to %s", string, string2);
            eventLogInterface.logSevereEvent(string3, iOException);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                eventLogInterface.logWarningEvent("Failed to dispose streams", iOException);
            }
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {
                eventLogInterface.logDetailEvent("Failed to dispose streams");
            }
        }
        if (!this.delete(string)) {
            eventLogInterface.logWarningEvent("Failed to delete renamed file " + string, null);
        }
        String string4 = String.format("Platform does not allow renaming files. Copied file from %s to %s instead", string, string2);
        eventLogInterface.logDetailEvent(string4);
        return true;
    }

    @Override
    public OutputStream openOutputStreamElement(String string) throws IOException {
        return new FileOutputStream(string, false);
    }

    @Override
    public OutputStream openOutputStreamElementAppend(String string) throws IOException {
        return new FileOutputStream(string, true);
    }

    public boolean delete(String string) {
        return new File(string).delete();
    }

    public void deleteOnExit(File file) {
        file.deleteOnExit();
    }

    public boolean exists(String string) {
        return new File(string).exists();
    }

    public boolean exists(String string, boolean bl, Class clazz) {
        if (string == null || string.isEmpty()) {
            return false;
        }
        return bl ? null != clazz.getResource(string) : FileUtil.getFileUtil().exists(string);
    }

    private boolean renameWithOverwrite(String string, String string2) {
        File file = new File(string);
        this.delete(string2);
        boolean bl = file.renameTo(new File(string2));
        if (bl) {
            return true;
        }
        this.delete(string2);
        if (this.exists(string2)) {
            new File(string2).renameTo(new File(FileUtil.newDiscardFileName(string2)));
        }
        return file.renameTo(new File(string2));
    }

    public String absolutePath(String string) {
        return new File(string).getAbsolutePath();
    }

    public File canonicalFile(File file) throws IOException {
        return new File(file.getCanonicalPath());
    }

    public File canonicalFile(String string) throws IOException {
        return new File(new File(string).getCanonicalPath());
    }

    public String canonicalPath(File file) throws IOException {
        return file.getCanonicalPath();
    }

    public String canonicalPath(String string) throws IOException {
        return new File(string).getCanonicalPath();
    }

    public String canonicalOrAbsolutePath(String string) {
        try {
            return this.canonicalPath(string);
        }
        catch (Exception exception) {
            return this.absolutePath(string);
        }
    }

    public void makeParentDirectories(File file) {
        String string = file.getParent();
        if (string != null) {
            new File(string).mkdirs();
        } else {
            string = file.getPath();
            int n2 = string.lastIndexOf(47);
            if (n2 > 0) {
                string = string.substring(0, n2);
                new File(string).mkdirs();
            }
        }
    }

    public static String makeDirectories(String string) {
        try {
            File file = new File(string);
            file.mkdirs();
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public FileAccess.FileSync getFileSync(OutputStream outputStream) throws IOException {
        return new FileSync((FileOutputStream)outputStream);
    }

    public static boolean deleteOrRenameDatabaseFiles(String string) {
        int n2;
        DatabaseFilenameFilter databaseFilenameFilter = new DatabaseFilenameFilter(string);
        File[] fileArray = databaseFilenameFilter.getExistingFileListInDirectory();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            fileArray[i2].delete();
        }
        File file = new File(databaseFilenameFilter.canonicalFile.getPath() + ".tmp");
        if (file.isDirectory()) {
            File[] fileArray2 = file.listFiles();
            if (fileArray2 != null) {
                for (int i3 = 0; i3 < fileArray2.length; ++i3) {
                    fileArray2[i3].delete();
                }
            }
            file.delete();
        }
        if ((fileArray = databaseFilenameFilter.getExistingMainFileSetList()).length == 0) {
            return true;
        }
        for (n2 = 0; n2 < fileArray.length; ++n2) {
            fileArray[n2].delete();
        }
        fileArray = databaseFilenameFilter.getExistingMainFileSetList();
        for (n2 = 0; n2 < fileArray.length; ++n2) {
            fileArray[n2].renameTo(new File(FileUtil.newDiscardFileName(fileArray[n2].getPath())));
        }
        return true;
    }

    public static File[] getDatabaseFileList(String string) {
        DatabaseFilenameFilter databaseFilenameFilter = new DatabaseFilenameFilter(string);
        return databaseFilenameFilter.getExistingFileListInDirectory();
    }

    public static File[] getDatabaseMainFileList(String string) {
        DatabaseFilenameFilter databaseFilenameFilter = new DatabaseFilenameFilter(string, false);
        return databaseFilenameFilter.getExistingFileListInDirectory();
    }

    public static String newDiscardFileName(String string) {
        String string2 = StringUtil.toPaddedString(Integer.toHexString((int)System.currentTimeMillis()), discardSuffixLength - 1, '0', true);
        String string3 = string + "." + string2 + ".old";
        return string3;
    }

    static class DatabaseFilenameFilter
    implements FilenameFilter {
        String[] suffixes = new String[]{".backup", ".properties", ".script", ".data", ".log", ".lobs"};
        String[] extraSuffixes = new String[]{".lck", ".sql.log", ".app.log"};
        private String dbName;
        private File parent;
        private File canonicalFile;
        private boolean extraFiles;

        DatabaseFilenameFilter(String string) {
            this(string, true);
        }

        DatabaseFilenameFilter(String string, boolean bl) {
            this.canonicalFile = new File(string);
            try {
                this.canonicalFile = this.canonicalFile.getCanonicalFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.dbName = this.canonicalFile.getName();
            this.parent = this.canonicalFile.getParentFile();
            this.extraFiles = bl;
        }

        public File[] getCompleteMainFileSetList() {
            File[] fileArray = new File[this.suffixes.length];
            for (int i2 = 0; i2 < this.suffixes.length; ++i2) {
                fileArray[i2] = new File(this.canonicalFile.getPath() + this.suffixes[i2]);
            }
            return fileArray;
        }

        public File[] getExistingMainFileSetList() {
            File[] fileArray = this.getCompleteMainFileSetList();
            HsqlArrayList<File> hsqlArrayList = new HsqlArrayList<File>();
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                if (!fileArray[i2].exists()) continue;
                hsqlArrayList.add(fileArray[i2]);
            }
            fileArray = new File[hsqlArrayList.size()];
            hsqlArrayList.toArray(fileArray);
            return fileArray;
        }

        public File[] getExistingFileListInDirectory() {
            File[] fileArray = this.parent.listFiles(this);
            return fileArray == null ? new File[]{} : fileArray;
        }

        @Override
        public boolean accept(File file, String string) {
            if (this.parent.equals(file) && string.indexOf(this.dbName) == 0) {
                int n2;
                String string2 = string.substring(this.dbName.length());
                if (this.extraFiles) {
                    for (n2 = 0; n2 < this.extraSuffixes.length; ++n2) {
                        if (!string2.equals(this.extraSuffixes[n2])) continue;
                        return true;
                    }
                }
                for (n2 = 0; n2 < this.suffixes.length; ++n2) {
                    if (string2.equals(this.suffixes[n2])) {
                        return true;
                    }
                    if (!this.extraFiles || !string2.startsWith(this.suffixes[n2]) || !(string.endsWith(".new") ? string2.length() == this.suffixes[n2].length() + 4 : string.endsWith(".old") && string2.length() == this.suffixes[n2].length() + discardSuffixLength + 4)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static class FileSync
    implements FileAccess.FileSync {
        FileDescriptor outDescriptor;

        FileSync(FileOutputStream fileOutputStream) throws IOException {
            this.outDescriptor = fileOutputStream.getFD();
        }

        @Override
        public void sync() throws IOException {
            this.outDescriptor.sync();
        }
    }
}

