/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Writer;

public class ClosableCharArrayWriter
extends Writer {
    protected char[] buf;
    protected int count;
    protected boolean closed;
    protected boolean freed;

    public ClosableCharArrayWriter() {
        this(32);
    }

    public ClosableCharArrayWriter(int n2) throws IllegalArgumentException {
        if (n2 < 0) {
            throw new IllegalArgumentException("Negative initial size: " + n2);
        }
        this.buf = new char[n2];
    }

    @Override
    public synchronized void write(int n2) throws IOException {
        this.checkClosed();
        int n3 = this.count + 1;
        if (n3 > this.buf.length) {
            this.buf = this.copyOf(this.buf, Math.max(this.buf.length << 1, n3));
        }
        this.buf[this.count] = (char)n2;
        this.count = n3;
    }

    @Override
    public synchronized void write(char[] cArray, int n2, int n3) throws IOException {
        this.checkClosed();
        if (n2 < 0 || n2 > cArray.length || n3 < 0 || n2 + n3 > cArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return;
        }
        int n4 = this.count + n3;
        if (n4 > this.buf.length) {
            this.buf = this.copyOf(this.buf, Math.max(this.buf.length << 1, n4));
        }
        System.arraycopy(cArray, n2, this.buf, this.count, n3);
        this.count = n4;
    }

    @Override
    public synchronized void write(String string, int n2, int n3) throws IOException {
        this.checkClosed();
        int n4 = string.length();
        if (n2 < 0 || n2 > n4 || n3 < 0 || n2 + n3 > n4 || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return;
        }
        int n5 = this.count + n3;
        if (n5 > this.buf.length) {
            this.buf = this.copyOf(this.buf, Math.max(this.buf.length << 1, n5));
        }
        string.getChars(n2, n2 + n3, this.buf, this.count);
        this.count = n5;
    }

    @Override
    public void flush() throws IOException {
        this.checkClosed();
    }

    public synchronized void writeTo(Writer writer) throws IOException {
        this.checkFreed();
        if (this.count > 0) {
            writer.write(this.buf, 0, this.count);
        }
    }

    public synchronized int capacity() throws IOException {
        this.checkFreed();
        return this.buf.length;
    }

    public synchronized void reset() throws IOException {
        this.checkClosed();
        this.count = 0;
    }

    public synchronized void trimToSize() throws IOException {
        this.checkFreed();
        if (this.buf.length > this.count) {
            this.buf = this.copyOf(this.buf, this.count);
        }
    }

    public synchronized char[] toCharArray() throws IOException {
        this.checkFreed();
        return this.copyOf(this.buf, this.count);
    }

    public synchronized int size() {
        return this.count;
    }

    public synchronized void setSize(int n2) {
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        if (n2 > this.buf.length) {
            this.buf = this.copyOf(this.buf, Math.max(this.buf.length << 1, n2));
        }
        this.count = n2;
    }

    public synchronized CharArrayReader toCharArrayReader() throws IOException {
        this.checkFreed();
        CharArrayReader charArrayReader = new CharArrayReader(this.buf, 0, this.count);
        this.free();
        return charArrayReader;
    }

    public synchronized String toString() {
        try {
            this.checkFreed();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
        return new String(this.buf, 0, this.count);
    }

    @Override
    public synchronized void close() {
        this.closed = true;
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    public synchronized void free() {
        this.closed = true;
        this.freed = true;
        this.buf = null;
        this.count = 0;
    }

    public synchronized boolean isFreed() {
        return this.freed;
    }

    protected synchronized void checkClosed() throws IOException {
        if (this.closed) {
            throw new IOException("writer is closed.");
        }
    }

    protected synchronized void checkFreed() throws IOException {
        if (this.freed) {
            throw new IOException("write buffer is freed.");
        }
    }

    protected char[] copyOf(char[] cArray, int n2) {
        char[] cArray2 = new char[n2];
        System.arraycopy(cArray, 0, cArray2, 0, Math.min(cArray.length, n2));
        return cArray2;
    }
}

