/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;

public class CharArrayWriter {
    protected char[] buffer;
    protected int count;

    public CharArrayWriter(int n2) {
        this.buffer = new char[n2];
    }

    public CharArrayWriter(char[] cArray) {
        this.buffer = cArray;
    }

    public CharArrayWriter(Reader reader, int n2) throws IOException {
        this.buffer = new char[n2];
        int n3 = n2;
        while (n3 > 0) {
            int n4 = reader.read(this.buffer, this.count, n3);
            if (n4 == -1) {
                reader.close();
                throw new EOFException();
            }
            n3 -= n4;
            this.count += n4;
        }
    }

    public CharArrayWriter(Reader reader) throws IOException {
        int n2;
        this.buffer = new char[128];
        while ((n2 = reader.read(this.buffer, this.count, this.buffer.length - this.count)) != -1) {
            this.count += n2;
            if (this.count != this.buffer.length) continue;
            this.ensureRoom(this.count * 2);
        }
    }

    public void write(int n2) {
        if (this.count == this.buffer.length) {
            this.ensureRoom(this.count + 1);
        }
        this.buffer[this.count++] = (char)n2;
    }

    public int write(Reader reader, int n2) throws IOException {
        int n3;
        int n4 = n2;
        while (n4 > 0 && (n3 = reader.read(this.buffer, this.count, n4)) != -1) {
            n4 -= n3;
            this.count += n3;
        }
        return n2 - n4;
    }

    void ensureRoom(int n2) {
        int n3;
        if (n2 <= this.buffer.length) {
            return;
        }
        for (n3 = this.buffer.length; n3 < n2; n3 *= 2) {
        }
        char[] cArray = new char[n3];
        System.arraycopy(this.buffer, 0, cArray, 0, this.count);
        this.buffer = cArray;
    }

    public void write(String string, int n2, int n3) {
        this.ensureRoom(this.count + n3);
        string.getChars(n2, n2 + n3, this.buffer, this.count);
        this.count += n3;
    }

    public void reset() {
        this.count = 0;
    }

    public void reset(char[] cArray) {
        this.count = 0;
        this.buffer = cArray;
    }

    public char[] toCharArray() {
        char[] cArray = new char[this.count];
        System.arraycopy(this.buffer, 0, cArray, 0, this.count);
        return cArray;
    }

    public char[] getBuffer() {
        return this.buffer;
    }

    public int size() {
        return this.count;
    }

    public void setSize(int n2) {
        if (n2 > this.buffer.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.count = n2;
    }

    public String toString() {
        return new String(this.buffer, 0, this.count);
    }
}

