/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc.pool;

import java.net.Inet4Address;
import java.util.Arrays;
import java.util.Random;
import javax.transaction.xa.Xid;

public class JDBCXID
implements Xid {
    int formatID;
    byte[] txID;
    byte[] txBranch;
    int hash;
    boolean hashComputed;
    private static byte[] s_localIp = null;
    private static int s_txnSequenceNumber = 0;
    private static final int UXID_FORMAT_ID = 65261;

    @Override
    public int getFormatId() {
        return this.formatID;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.txID;
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.txBranch;
    }

    public JDBCXID(int n2, byte[] byArray, byte[] byArray2) {
        this.formatID = n2;
        this.txID = byArray;
        this.txBranch = byArray2;
    }

    public int hashCode() {
        if (!this.hashComputed) {
            this.hash = 7;
            this.hash = 83 * this.hash + this.formatID;
            this.hash = 83 * this.hash + Arrays.hashCode(this.txID);
            this.hash = 83 * this.hash + Arrays.hashCode(this.txBranch);
            this.hashComputed = true;
        }
        return this.hash;
    }

    public boolean equals(Object object) {
        if (object instanceof Xid) {
            Xid xid = (Xid)object;
            return this.formatID == xid.getFormatId() && Arrays.equals(this.txID, xid.getGlobalTransactionId()) && Arrays.equals(this.txBranch, xid.getBranchQualifier());
        }
        return false;
    }

    public String toString() {
        int n2;
        int n3;
        StringBuilder stringBuilder = new StringBuilder(512);
        stringBuilder.append("formatId=").append(this.getFormatId());
        stringBuilder.append(" globalTransactionId(").append(this.txID.length).append(")={0x");
        for (n3 = 0; n3 < this.txID.length; ++n3) {
            n2 = this.txID[n3] & 0xFF;
            if (n2 < 16) {
                stringBuilder.append("0").append(Integer.toHexString(this.txID[n3] & 0xFF));
            }
            stringBuilder.append(Integer.toHexString(this.txID[n3] & 0xFF));
        }
        stringBuilder.append("} branchQualifier(").append(this.txBranch.length).append("))={0x");
        for (n3 = 0; n3 < this.txBranch.length; ++n3) {
            n2 = this.txBranch[n3] & 0xFF;
            if (n2 < 16) {
                stringBuilder.append("0");
            }
            stringBuilder.append(Integer.toHexString(this.txBranch[n3] & 0xFF));
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    private static int nextTxnSequenceNumber() {
        return ++s_txnSequenceNumber;
    }

    private static byte[] getLocalIp() {
        if (null == s_localIp) {
            try {
                s_localIp = Inet4Address.getLocalHost().getAddress();
            }
            catch (Exception exception) {
                s_localIp = new byte[]{127, 0, 0, 1};
            }
        }
        return s_localIp;
    }

    public static Xid getUniqueXid(int n2) {
        Random random = new Random(System.currentTimeMillis());
        int n3 = JDBCXID.nextTxnSequenceNumber();
        int n4 = n2;
        int n5 = random.nextInt();
        byte[] byArray = new byte[64];
        byte[] byArray2 = new byte[64];
        byte[] byArray3 = JDBCXID.getLocalIp();
        System.arraycopy(byArray3, 0, byArray, 0, 4);
        System.arraycopy(byArray3, 0, byArray2, 0, 4);
        for (int i2 = 0; i2 <= 3; ++i2) {
            byArray[i2 + 4] = (byte)(n3 % 256);
            byArray2[i2 + 4] = (byte)(n3 % 256);
            n3 >>= 8;
            byArray[i2 + 8] = (byte)(n4 % 256);
            byArray2[i2 + 8] = (byte)(n4 % 256);
            n4 >>= 8;
            byArray[i2 + 12] = (byte)(n5 % 256);
            byArray2[i2 + 12] = (byte)(n5 % 256);
            n5 >>= 8;
        }
        return new JDBCXID(65261, byArray, byArray2);
    }
}

