/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Period;
import java.util.Calendar;
import java.util.Map;
import org.hsqldb.ColumnBase;
import org.hsqldb.HsqlException;
import org.hsqldb.SessionInterface;
import org.hsqldb.jdbc.JDBCArray;
import org.hsqldb.jdbc.JDBCBlob;
import org.hsqldb.jdbc.JDBCBlobClient;
import org.hsqldb.jdbc.JDBCClob;
import org.hsqldb.jdbc.JDBCClobClient;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.JDBCNClob;
import org.hsqldb.jdbc.JDBCPreparedStatement;
import org.hsqldb.jdbc.JDBCResultSetMetaData;
import org.hsqldb.jdbc.JDBCSQLXML;
import org.hsqldb.jdbc.JDBCStatementBase;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.lib.StringInputStream;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.result.ResultProperties;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BinaryUUIDType;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.ClobDataID;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.JavaObjectData;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class JDBCResultSet
implements ResultSet {
    private RowSetNavigator navigator;
    protected ResultMetaData resultMetaData;
    private boolean translateTTIType;
    private int columnCount;
    private boolean wasNullValue;
    private ResultSetMetaData resultSetMetaData;
    private IntValueHashMap columnMap;
    private SQLWarning rootWarning;
    private boolean memoryLobs;
    JDBCStatementBase statement;
    SessionInterface session;
    JDBCConnection connection;
    boolean isScrollable;
    boolean isUpdatable;
    boolean isInsertable;
    int rsProperties;
    int fetchSize;
    boolean autoClose;
    public Result result;
    JDBCPreparedStatement preparedStatement;
    boolean isRowUpdated;
    boolean isOnInsertRow;
    int currentUpdateRowNumber = -1;

    @Override
    public boolean next() throws SQLException {
        this.checkClosed();
        this.rootWarning = null;
        return this.navigator.next();
    }

    @Override
    public void close() throws SQLException {
        if (this.navigator == null) {
            return;
        }
        if (ResultProperties.isHeld(this.rsProperties)) {
            this.session.closeNavigator(this.navigator.getId());
        } else {
            this.navigator.release();
        }
        this.navigator = null;
        if (this.autoClose && this.statement != null) {
            this.statement.close();
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkClosed();
        return this.wasNullValue;
    }

    @Override
    public String getString(int n2) throws SQLException {
        this.checkColumn(n2);
        Type type = this.resultMetaData.columnTypes[n2 - 1];
        if (type.typeCode == 40) {
            ClobDataID clobDataID = (ClobDataID)this.getColumnInType(n2, type);
            if (clobDataID == null) {
                return null;
            }
            long l2 = clobDataID.length(this.session);
            if (l2 > Integer.MAX_VALUE) {
                throw JDBCUtil.sqlException(5561);
            }
            return clobDataID.getSubString(this.session, 0L, (int)l2);
        }
        return (String)this.getColumnInType(n2, Type.SQL_VARCHAR);
    }

    @Override
    public boolean getBoolean(int n2) throws SQLException {
        Object object = this.getColumnInType(n2, Type.SQL_BOOLEAN);
        return object == null ? false : (Boolean)object;
    }

    @Override
    public byte getByte(int n2) throws SQLException {
        Object object = this.getColumnInType(n2, Type.TINYINT);
        return object == null ? (byte)0 : ((Number)object).byteValue();
    }

    @Override
    public short getShort(int n2) throws SQLException {
        Object object = this.getColumnInType(n2, Type.SQL_SMALLINT);
        return object == null ? (short)0 : ((Number)object).shortValue();
    }

    @Override
    public int getInt(int n2) throws SQLException {
        Object object = this.getColumnInType(n2, Type.SQL_INTEGER);
        return object == null ? 0 : ((Number)object).intValue();
    }

    @Override
    public long getLong(int n2) throws SQLException {
        Object object = this.getColumnInType(n2, Type.SQL_BIGINT);
        return object == null ? 0L : ((Number)object).longValue();
    }

    @Override
    public float getFloat(int n2) throws SQLException {
        Object object = this.getColumnInType(n2, Type.SQL_DOUBLE);
        return object == null ? 0.0f : ((Number)object).floatValue();
    }

    @Override
    public double getDouble(int n2) throws SQLException {
        Object object = this.getColumnInType(n2, Type.SQL_DOUBLE);
        return object == null ? 0.0 : ((Number)object).doubleValue();
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        if (n3 < 0) {
            throw JDBCUtil.outOfRangeArgument();
        }
        BigDecimal bigDecimal = this.getBigDecimal(n2);
        if (bigDecimal != null) {
            bigDecimal = bigDecimal.setScale(n3, RoundingMode.DOWN);
        }
        return bigDecimal;
    }

    @Override
    public byte[] getBytes(int n2) throws SQLException {
        this.checkColumn(n2);
        Type type = this.resultMetaData.columnTypes[n2 - 1];
        if (type.typeCode == 30) {
            BlobData blobData = (BlobData)this.getColumnInType(n2, type);
            if (blobData == null) {
                return null;
            }
            long l2 = blobData.length(this.session);
            if (l2 > Integer.MAX_VALUE) {
                throw JDBCUtil.sqlException(5561);
            }
            return blobData.getBytes(this.session, 0L, (int)l2);
        }
        Object object = this.getColumnInType(n2, Type.SQL_VARBINARY);
        if (object == null) {
            return null;
        }
        return ((BinaryData)object).getBytes();
    }

    @Override
    public Date getDate(int n2) throws SQLException {
        Object object = this.getColumnInType(n2, Type.SQL_DATE);
        if (object == null) {
            return null;
        }
        return (Date)Type.SQL_DATE.convertSQLToJava(this.session, object);
    }

    @Override
    public Time getTime(int n2) throws SQLException {
        Object object = this.getColumnInType(n2, Type.SQL_TIME);
        if (object == null) {
            return null;
        }
        return (Time)Type.SQL_TIME.convertSQLToJava(this.session, object);
    }

    @Override
    public Timestamp getTimestamp(int n2) throws SQLException {
        Object object = this.getColumnInType(n2, Type.SQL_TIMESTAMP);
        if (object == null) {
            return null;
        }
        return (Timestamp)Type.SQL_TIMESTAMP.convertSQLToJava(this.session, object);
    }

    @Override
    public InputStream getAsciiStream(int n2) throws SQLException {
        Object object = this.getColumnValue(n2);
        if (object == null) {
            return null;
        }
        if (object instanceof ClobDataID) {
            JDBCClobClient jDBCClobClient = new JDBCClobClient(this.session, (ClobDataID)object);
            return jDBCClobClient.getAsciiStream();
        }
        if (object instanceof Clob) {
            return ((Clob)object).getAsciiStream();
        }
        String string = this.getString(n2);
        try {
            return new ByteArrayInputStream(string.getBytes(JavaSystem.CS_US_ASCII));
        }
        catch (Throwable throwable) {
            throw JDBCUtil.sqlException(throwable);
        }
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int n2) throws SQLException {
        String string = this.getString(n2);
        if (string == null) {
            return null;
        }
        return new StringInputStream(string);
    }

    @Override
    public InputStream getBinaryStream(int n2) throws SQLException {
        Object object = this.getColumnValue(n2);
        if (object == null) {
            return null;
        }
        if (object instanceof BlobDataID) {
            return ((BlobDataID)object).getBinaryStream(this.session);
        }
        if (object instanceof Blob) {
            return ((Blob)object).getBinaryStream();
        }
        if (object instanceof BinaryData) {
            byte[] byArray = this.getBytes(n2);
            return new ByteArrayInputStream(byArray);
        }
        throw JDBCUtil.sqlException(5561);
    }

    @Override
    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    @Override
    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    @Override
    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    @Override
    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    @Override
    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    @Override
    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    @Override
    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String string, int n2) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n2);
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    @Override
    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    @Override
    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.rootWarning;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
        this.rootWarning = null;
    }

    @Override
    public String getCursorName() throws SQLException {
        this.checkClosed();
        if (this.result == null) {
            return "";
        }
        return this.result.getMainString();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkClosed();
        if (this.resultSetMetaData == null) {
            this.resultSetMetaData = new JDBCResultSetMetaData(this.resultMetaData, this.isUpdatable, this.isInsertable, this.connection);
        }
        return this.resultSetMetaData;
    }

    @Override
    public Object getObject(int n2) throws SQLException {
        this.checkColumn(n2);
        Type type = this.resultMetaData.columnTypes[n2 - 1];
        switch (type.typeCode) {
            case 50: {
                return this.getArray(n2);
            }
            case 91: {
                return this.getDate(n2);
            }
            case 92: {
                return this.getTime(n2);
            }
            case 94: {
                return this.getTimeWithZone(n2);
            }
            case 93: {
                return this.getTimestamp(n2);
            }
            case 95: {
                return this.getTimestampWithZone(n2);
            }
            case 60: 
            case 61: {
                return this.getBytes(n2);
            }
            case -11: {
                BinaryData binaryData = (BinaryData)this.getColumnValue(n2);
                return BinaryUUIDType.getJavaUUID(binaryData);
            }
            case 14: {
                BinaryData binaryData = (BinaryData)this.getColumnValue(n2);
                if (this.wasNull()) {
                    return null;
                }
                byte[] byArray = binaryData.getBytes();
                if (byArray.length == 0) {
                    return Boolean.FALSE;
                }
                return byArray[0] == 0 ? Boolean.FALSE : Boolean.TRUE;
            }
            case 40: {
                return this.getClob(n2);
            }
            case 30: {
                return this.getBlob(n2);
            }
            case 1111: 
            case 2000: {
                Object object = this.getColumnInType(n2, type);
                if (object == null) {
                    return null;
                }
                try {
                    return ((JavaObjectData)object).getObject();
                }
                catch (HsqlException hsqlException) {
                    throw JDBCUtil.sqlException(hsqlException);
                }
            }
        }
        return this.getColumnInType(n2, type);
    }

    @Override
    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    @Override
    public int findColumn(String string) throws SQLException {
        int n2;
        int n3;
        this.checkClosed();
        if (string == null) {
            throw JDBCUtil.nullArgument();
        }
        if (this.columnMap != null && (n3 = this.columnMap.get((Object)string, -1)) != -1) {
            return n3;
        }
        String[] stringArray = this.resultMetaData.columnLabels;
        n3 = -1;
        for (int i2 = 0; i2 < this.columnCount; ++i2) {
            if (!string.equalsIgnoreCase(stringArray[i2])) continue;
            n3 = i2;
            break;
        }
        ColumnBase[] columnBaseArray = this.resultMetaData.columns;
        if (n3 < 0) {
            for (n2 = 0; n2 < this.columnCount; ++n2) {
                if (!string.equalsIgnoreCase(columnBaseArray[n2].getNameString())) continue;
                n3 = n2;
                break;
            }
        }
        if (n3 < 0) {
            n2 = string.indexOf(46);
            if (n2 < 0) {
                throw JDBCUtil.sqlException(421, string);
            }
            for (int i3 = 0; i3 < this.columnCount; ++i3) {
                String string2;
                String string3 = columnBaseArray[i3].getTableNameString();
                if (string3 == null || string3.isEmpty()) continue;
                String string4 = columnBaseArray[i3].getNameString();
                if (string.equalsIgnoreCase(string3 + "." + string4)) {
                    n3 = i3;
                    break;
                }
                String string5 = columnBaseArray[i3].getSchemaNameString();
                if (string5 == null || string5.length() == 0 || !string.equalsIgnoreCase(string2 = string5 + '.' + string3 + '.' + string4)) continue;
                n3 = i3;
                break;
            }
        }
        if (n3 < 0) {
            throw JDBCUtil.sqlException(421, string);
        }
        ++n3;
        if (this.columnMap == null) {
            this.columnMap = new IntValueHashMap();
        }
        this.columnMap.put(string, n3);
        return n3;
    }

    @Override
    public Reader getCharacterStream(int n2) throws SQLException {
        this.checkColumn(n2);
        Type type = this.resultMetaData.columnTypes[n2 - 1];
        Object object = this.getColumnInType(n2, type);
        if (object == null) {
            return null;
        }
        if (object instanceof ClobDataID) {
            return ((ClobDataID)object).getCharacterStream(this.session);
        }
        if (object instanceof Clob) {
            return ((Clob)object).getCharacterStream();
        }
        if (object instanceof String) {
            return new StringReader((String)object);
        }
        throw JDBCUtil.sqlException(5561);
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    @Override
    public BigDecimal getBigDecimal(int n2) throws SQLException {
        this.checkColumn(n2);
        Type type = this.resultMetaData.columnTypes[n2 - 1];
        switch (type.typeCode) {
            case 2: 
            case 3: {
                break;
            }
            case -6: 
            case 4: 
            case 5: 
            case 25: {
                type = Type.SQL_DECIMAL;
                break;
            }
            default: {
                type = Type.SQL_DECIMAL_DEFAULT;
            }
        }
        return (BigDecimal)this.getColumnInType(n2, type);
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkClosed();
        if (this.isOnInsertRow) {
            return false;
        }
        return this.navigator.isBeforeFirst();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkClosed();
        if (this.isOnInsertRow) {
            return false;
        }
        return this.navigator.isAfterLast();
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkClosed();
        if (this.isOnInsertRow) {
            return false;
        }
        return this.navigator.isFirst();
    }

    @Override
    public boolean isLast() throws SQLException {
        this.checkClosed();
        if (this.isOnInsertRow) {
            return false;
        }
        return this.navigator.isLast();
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw JDBCUtil.sqlExceptionSQL(3604);
        }
        this.navigator.beforeFirst();
    }

    @Override
    public void afterLast() throws SQLException {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw JDBCUtil.sqlExceptionSQL(3604);
        }
        this.navigator.afterLast();
    }

    @Override
    public boolean first() throws SQLException {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw JDBCUtil.sqlExceptionSQL(3604);
        }
        return this.navigator.first();
    }

    @Override
    public boolean last() throws SQLException {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw JDBCUtil.sqlExceptionSQL(3604);
        }
        return this.navigator.last();
    }

    @Override
    public int getRow() throws SQLException {
        this.checkClosed();
        if (this.navigator.isAfterLast()) {
            return 0;
        }
        return this.navigator.getRowNumber() + 1;
    }

    @Override
    public boolean absolute(int n2) throws SQLException {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw JDBCUtil.sqlExceptionSQL(3604);
        }
        if (n2 > 0) {
            --n2;
        } else {
            if (n2 == 0) {
                return this.navigator.beforeFirst();
            }
            if ((n2 += this.navigator.getSize()) < 0) {
                this.navigator.beforeFirst();
                return false;
            }
        }
        return this.navigator.absolute(n2);
    }

    @Override
    public boolean relative(int n2) throws SQLException {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw JDBCUtil.sqlExceptionSQL(3604);
        }
        return this.navigator.relative(n2);
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkClosed();
        this.checkNotForwardOnly();
        if (this.isOnInsertRow || this.isRowUpdated) {
            throw JDBCUtil.sqlExceptionSQL(3604);
        }
        this.rootWarning = null;
        return this.navigator.previous();
    }

    @Override
    public void setFetchDirection(int n2) throws SQLException {
        this.checkClosed();
        switch (n2) {
            case 1000: {
                break;
            }
            case 1001: {
                this.checkNotForwardOnly();
                break;
            }
            case 1002: {
                this.checkNotForwardOnly();
                break;
            }
            default: {
                throw JDBCUtil.notSupported();
            }
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkClosed();
        return 1000;
    }

    @Override
    public void setFetchSize(int n2) throws SQLException {
        if (n2 < 0) {
            throw JDBCUtil.outOfRangeArgument();
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return this.fetchSize;
    }

    @Override
    public int getType() throws SQLException {
        this.checkClosed();
        return ResultProperties.getJDBCScrollability(this.rsProperties);
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.checkClosed();
        return ResultProperties.getJDBCConcurrency(this.rsProperties);
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.checkClosed();
        return this.isRowUpdated;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public void updateNull(int n2) throws SQLException {
        this.startUpdate(n2);
        this.preparedStatement.setParameter(n2, null);
    }

    @Override
    public void updateBoolean(int n2, boolean bl) throws SQLException {
        Boolean bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
        this.startUpdate(n2);
        this.preparedStatement.setParameter(n2, bl2);
    }

    @Override
    public void updateByte(int n2, byte by) throws SQLException {
        this.startUpdate(n2);
        this.preparedStatement.setIntParameter(n2, by);
    }

    @Override
    public void updateShort(int n2, short s2) throws SQLException {
        this.startUpdate(n2);
        this.preparedStatement.setIntParameter(n2, s2);
    }

    @Override
    public void updateInt(int n2, int n3) throws SQLException {
        this.startUpdate(n2);
        this.preparedStatement.setIntParameter(n2, n3);
    }

    @Override
    public void updateLong(int n2, long l2) throws SQLException {
        this.startUpdate(n2);
        this.preparedStatement.setLongParameter(n2, l2);
    }

    @Override
    public void updateFloat(int n2, float f2) throws SQLException {
        Double d2 = f2;
        this.startUpdate(n2);
        this.preparedStatement.setParameter(n2, d2);
    }

    @Override
    public void updateDouble(int n2, double d2) throws SQLException {
        Double d3 = d2;
        this.startUpdate(n2);
        this.preparedStatement.setParameter(n2, d3);
    }

    @Override
    public void updateBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        this.startUpdate(n2);
        this.preparedStatement.setParameter(n2, bigDecimal);
    }

    @Override
    public void updateString(int n2, String string) throws SQLException {
        this.startUpdate(n2);
        this.preparedStatement.setParameter(n2, string);
    }

    @Override
    public void updateBytes(int n2, byte[] byArray) throws SQLException {
        this.startUpdate(n2);
        this.preparedStatement.setParameter(n2, byArray);
    }

    @Override
    public void updateDate(int n2, Date date) throws SQLException {
        this.startUpdate(n2);
        this.preparedStatement.setParameter(n2, date);
    }

    @Override
    public void updateTime(int n2, Time time) throws SQLException {
        this.startUpdate(n2);
        this.preparedStatement.setParameter(n2, time);
    }

    @Override
    public void updateTimestamp(int n2, Timestamp timestamp) throws SQLException {
        this.startUpdate(n2);
        this.preparedStatement.setParameter(n2, timestamp);
    }

    @Override
    public void updateAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.startUpdate(n2);
        this.preparedStatement.setAsciiStream(n2, inputStream, n3);
    }

    @Override
    public void updateBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.startUpdate(n2);
        this.preparedStatement.setBinaryStream(n2, inputStream, n3);
    }

    @Override
    public void updateCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        this.startUpdate(n2);
        this.preparedStatement.setCharacterStream(n2, reader, n3);
    }

    @Override
    public void updateObject(int n2, Object object, int n3) throws SQLException {
        this.startUpdate(n2);
        this.preparedStatement.setObject(n2, object, 0, n3);
    }

    @Override
    public void updateObject(int n2, Object object) throws SQLException {
        this.startUpdate(n2);
        this.preparedStatement.setParameter(n2, object);
    }

    @Override
    public void updateNull(String string) throws SQLException {
        this.updateNull(this.findColumn(string));
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl);
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    @Override
    public void updateShort(String string, short s2) throws SQLException {
        this.updateShort(this.findColumn(string), s2);
    }

    @Override
    public void updateInt(String string, int n2) throws SQLException {
        this.updateInt(this.findColumn(string), n2);
    }

    @Override
    public void updateLong(String string, long l2) throws SQLException {
        this.updateLong(this.findColumn(string), l2);
    }

    @Override
    public void updateFloat(String string, float f2) throws SQLException {
        this.updateFloat(this.findColumn(string), f2);
    }

    @Override
    public void updateDouble(String string, double d2) throws SQLException {
        this.updateDouble(this.findColumn(string), d2);
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n2);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n2);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n2) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n2);
    }

    @Override
    public void updateObject(String string, Object object, int n2) throws SQLException {
        this.updateObject(this.findColumn(string), object, n2);
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    @Override
    public void insertRow() throws SQLException {
        this.performInsert();
    }

    @Override
    public void updateRow() throws SQLException {
        this.performUpdate();
    }

    @Override
    public void deleteRow() throws SQLException {
        this.performDelete();
    }

    @Override
    public void refreshRow() throws SQLException {
        this.clearUpdates();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.clearUpdates();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.startInsert();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.endInsert();
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.checkClosed();
        return (Statement)((Object)this.statement);
    }

    public Object getObject(int n2, Map map) throws SQLException {
        return this.getObject(n2);
    }

    @Override
    public Ref getRef(int n2) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public Blob getBlob(int n2) throws SQLException {
        this.checkColumn(n2);
        Type type = this.resultMetaData.columnTypes[n2 - 1];
        Object object = this.getColumnInType(n2, type);
        if (object == null) {
            return null;
        }
        if (object instanceof BlobDataID) {
            if (this.memoryLobs) {
                long l2 = ((BlobDataID)object).length(this.session);
                if (l2 > Integer.MAX_VALUE) {
                    throw JDBCUtil.sqlException(3401);
                }
                byte[] byArray = ((BlobDataID)object).getBytes(this.session, 0L, (int)l2);
                return new JDBCBlob(byArray);
            }
            JDBCBlobClient jDBCBlobClient = new JDBCBlobClient(this.session, (BlobDataID)object);
            if (this.isUpdatable && this.resultMetaData.colIndexes[n2 - 1] > 0 && this.resultMetaData.columns[n2 - 1].isWriteable()) {
                jDBCBlobClient.setWritable(this, n2 - 1);
            }
            return jDBCBlobClient;
        }
        if (object instanceof Blob) {
            return (Blob)object;
        }
        if (object instanceof BinaryData) {
            byte[] byArray = this.getBytes(n2);
            return new JDBCBlob(byArray);
        }
        throw JDBCUtil.sqlException(5561);
    }

    @Override
    public Clob getClob(int n2) throws SQLException {
        this.checkColumn(n2);
        Type type = this.resultMetaData.columnTypes[n2 - 1];
        Object object = this.getColumnInType(n2, type);
        if (object == null) {
            return null;
        }
        if (object instanceof ClobDataID) {
            if (this.memoryLobs) {
                long l2 = ((ClobDataID)object).length(this.session);
                if (l2 > Integer.MAX_VALUE) {
                    throw JDBCUtil.sqlException(3401);
                }
                String string = ((ClobDataID)object).getSubString(this.session, 0L, (int)l2);
                return new JDBCClob(string);
            }
            JDBCClobClient jDBCClobClient = new JDBCClobClient(this.session, (ClobDataID)object);
            if (this.isUpdatable && this.resultMetaData.colIndexes[n2 - 1] > 0 && this.resultMetaData.columns[n2 - 1].isWriteable()) {
                jDBCClobClient.setWritable(this, n2 - 1);
            }
            return jDBCClobClient;
        }
        if (object instanceof Clob) {
            return (Clob)object;
        }
        if (object instanceof String) {
            return new JDBCClob((String)object);
        }
        throw JDBCUtil.sqlException(5561);
    }

    @Override
    public Array getArray(int n2) throws SQLException {
        this.checkColumn(n2);
        Type type = this.resultMetaData.columnTypes[n2 - 1];
        Object[] objectArray = (Object[])this.getCurrent()[n2 - 1];
        if (!type.isArrayType()) {
            throw JDBCUtil.sqlException(5561);
        }
        if (this.trackNull(objectArray)) {
            return null;
        }
        return new JDBCArray(objectArray, type.collectionBaseType(), type, this.connection);
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(this.findColumn(string), map);
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        return this.getRef(this.findColumn(string));
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        return this.getClob(this.findColumn(string));
    }

    @Override
    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    @Override
    public Date getDate(int n2, Calendar calendar) throws SQLException {
        TimestampData timestampData = (TimestampData)this.getColumnInType(n2, Type.SQL_DATE);
        if (timestampData == null) {
            return null;
        }
        return (Date)Type.SQL_DATE.convertSQLToJava(this.session, timestampData, calendar);
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    @Override
    public Time getTime(int n2, Calendar calendar) throws SQLException {
        TimeData timeData = (TimeData)this.getColumnInType(n2, Type.SQL_TIME);
        if (timeData == null) {
            return null;
        }
        return (Time)Type.SQL_TIME.convertSQLToJava(this.session, timeData, calendar);
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    @Override
    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        TimestampData timestampData = (TimestampData)this.getColumnInType(n2, Type.SQL_TIMESTAMP);
        if (timestampData == null) {
            return null;
        }
        return (Timestamp)Type.SQL_TIMESTAMP.convertSQLToJava(this.session, timestampData, calendar);
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    @Override
    public URL getURL(int n2) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public URL getURL(String string) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public void updateRef(int n2, Ref ref) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public void updateBlob(int n2, Blob blob) throws SQLException {
        this.startUpdate(n2);
        this.preparedStatement.setBlobParameter(n2, blob);
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        int n2 = this.findColumn(string);
        this.updateBlob(n2, blob);
    }

    @Override
    public void updateClob(int n2, Clob clob) throws SQLException {
        this.startUpdate(n2);
        this.preparedStatement.setClobParameter(n2, clob);
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        int n2 = this.findColumn(string);
        this.updateClob(n2, clob);
    }

    @Override
    public void updateArray(int n2, Array array) throws SQLException {
        this.startUpdate(n2);
        this.preparedStatement.setParameter(n2, array);
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        int n2 = this.findColumn(string);
        this.updateArray(n2, array);
    }

    @Override
    public RowId getRowId(int n2) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public RowId getRowId(String string) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public void updateRowId(int n2, RowId rowId) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public void updateRowId(String string, RowId rowId) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkClosed();
        return ResultProperties.getJDBCHoldability(this.rsProperties);
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.navigator == null;
    }

    @Override
    public void updateNString(int n2, String string) throws SQLException {
        this.updateString(n2, string);
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
        this.updateString(string, string2);
    }

    @Override
    public void updateNClob(int n2, NClob nClob) throws SQLException {
        this.updateClob(n2, (Clob)nClob);
    }

    @Override
    public void updateNClob(String string, NClob nClob) throws SQLException {
        this.updateClob(string, (Clob)nClob);
    }

    @Override
    public NClob getNClob(int n2) throws SQLException {
        String string = this.getString(n2);
        return string == null ? null : new JDBCNClob(string);
    }

    @Override
    public NClob getNClob(String string) throws SQLException {
        return this.getNClob(this.findColumn(string));
    }

    @Override
    public SQLXML getSQLXML(int n2) throws SQLException {
        SQLXML sQLXML;
        this.checkColumn(n2);
        int n3 = this.resultMetaData.columnTypes[n2 - 1].typeCode;
        switch (n3) {
            case 137: {
                Object object = this.getObject(n2);
                if (object == null) {
                    sQLXML = null;
                    break;
                }
                if (object instanceof SQLXML) {
                    sQLXML = (SQLXML)object;
                    break;
                }
                throw JDBCUtil.notSupported();
            }
            case 40: {
                Clob clob = this.getClob(n2);
                if (clob == null) {
                    sQLXML = null;
                    break;
                }
                sQLXML = new JDBCSQLXML(clob.getCharacterStream());
                break;
            }
            case 1: 
            case 12: {
                Reader reader = this.getCharacterStream(n2);
                if (reader == null) {
                    sQLXML = null;
                    break;
                }
                sQLXML = new JDBCSQLXML(reader);
                break;
            }
            case -9: 
            case -8: {
                Reader reader = this.getNCharacterStream(n2);
                if (reader == null) {
                    sQLXML = null;
                    break;
                }
                sQLXML = new JDBCSQLXML(reader);
                break;
            }
            case 30: {
                Blob blob = this.getBlob(n2);
                if (blob == null) {
                    sQLXML = null;
                    break;
                }
                sQLXML = new JDBCSQLXML(blob.getBinaryStream());
                break;
            }
            case 60: 
            case 61: {
                InputStream inputStream = this.getBinaryStream(n2);
                if (inputStream == null) {
                    sQLXML = null;
                    break;
                }
                sQLXML = new JDBCSQLXML(inputStream);
                break;
            }
            case 1111: 
            case 2000: {
                Object object = this.getObject(n2);
                if (object == null) {
                    sQLXML = null;
                    break;
                }
                if (object instanceof SQLXML) {
                    sQLXML = (SQLXML)object;
                    break;
                }
                if (object instanceof String) {
                    sQLXML = new JDBCSQLXML((String)object);
                    break;
                }
                if (object instanceof byte[]) {
                    sQLXML = new JDBCSQLXML((byte[])object);
                    break;
                }
                if (object instanceof Blob) {
                    Blob blob = (Blob)object;
                    sQLXML = new JDBCSQLXML(blob.getBinaryStream());
                    break;
                }
                if (object instanceof Clob) {
                    Clob clob = (Clob)object;
                    sQLXML = new JDBCSQLXML(clob.getCharacterStream());
                    break;
                }
                throw JDBCUtil.notSupported();
            }
            default: {
                throw JDBCUtil.notSupported();
            }
        }
        return sQLXML;
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        return this.getSQLXML(this.findColumn(string));
    }

    @Override
    public void updateSQLXML(int n2, SQLXML sQLXML) throws SQLException {
        this.startUpdate(n2);
        this.preparedStatement.setSQLXML(n2, sQLXML);
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException {
        this.updateSQLXML(this.findColumn(string), sQLXML);
    }

    @Override
    public String getNString(int n2) throws SQLException {
        return this.getString(n2);
    }

    @Override
    public String getNString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    @Override
    public Reader getNCharacterStream(int n2) throws SQLException {
        return this.getCharacterStream(n2);
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    @Override
    public void updateNCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        this.startUpdate(n2);
        this.preparedStatement.setCharacterStream(n2, reader, l2);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l2) throws SQLException {
        this.updateCharacterStream(string, reader, l2);
    }

    @Override
    public void updateAsciiStream(int n2, InputStream inputStream, long l2) throws SQLException {
        this.startUpdate(n2);
        this.preparedStatement.setAsciiStream(n2, inputStream, l2);
    }

    @Override
    public void updateBinaryStream(int n2, InputStream inputStream, long l2) throws SQLException {
        this.startUpdate(n2);
        this.preparedStatement.setBinaryStream(n2, inputStream, l2);
    }

    @Override
    public void updateCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        this.startUpdate(n2);
        this.preparedStatement.setCharacterStream(n2, reader, l2);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l2) throws SQLException {
        int n2 = this.findColumn(string);
        this.startUpdate(n2);
        this.preparedStatement.setAsciiStream(n2, inputStream, l2);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l2) throws SQLException {
        int n2 = this.findColumn(string);
        this.startUpdate(n2);
        this.preparedStatement.setBinaryStream(n2, inputStream, l2);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l2) throws SQLException {
        int n2 = this.findColumn(string);
        this.startUpdate(n2);
        this.preparedStatement.setCharacterStream(n2, reader, l2);
    }

    @Override
    public void updateBlob(int n2, InputStream inputStream, long l2) throws SQLException {
        this.startUpdate(n2);
        this.preparedStatement.setBlob(n2, inputStream, l2);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l2) throws SQLException {
        int n2 = this.findColumn(string);
        this.startUpdate(n2);
        this.preparedStatement.setBlob(n2, inputStream, l2);
    }

    @Override
    public void updateClob(int n2, Reader reader, long l2) throws SQLException {
        this.startUpdate(n2);
        this.preparedStatement.setClob(n2, reader, l2);
    }

    @Override
    public void updateClob(String string, Reader reader, long l2) throws SQLException {
        int n2 = this.findColumn(string);
        this.startUpdate(n2);
        this.preparedStatement.setClob(n2, reader, l2);
    }

    @Override
    public void updateNClob(int n2, Reader reader, long l2) throws SQLException {
        this.startUpdate(n2);
        this.preparedStatement.setClob(n2, reader, l2);
    }

    @Override
    public void updateNClob(String string, Reader reader, long l2) throws SQLException {
        int n2 = this.findColumn(string);
        this.startUpdate(n2);
        this.preparedStatement.setClob(n2, reader, l2);
    }

    @Override
    public void updateNCharacterStream(int n2, Reader reader) throws SQLException {
        this.startUpdate(n2);
        this.preparedStatement.setCharacterStream(n2, reader);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        int n2 = this.findColumn(string);
        this.startUpdate(n2);
        this.preparedStatement.setCharacterStream(n2, reader);
    }

    @Override
    public void updateAsciiStream(int n2, InputStream inputStream) throws SQLException {
        this.startUpdate(n2);
        this.preparedStatement.setAsciiStream(n2, inputStream);
    }

    @Override
    public void updateBinaryStream(int n2, InputStream inputStream) throws SQLException {
        this.startUpdate(n2);
        this.preparedStatement.setBinaryStream(n2, inputStream);
    }

    @Override
    public void updateCharacterStream(int n2, Reader reader) throws SQLException {
        this.startUpdate(n2);
        this.preparedStatement.setCharacterStream(n2, reader);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        int n2 = this.findColumn(string);
        this.startUpdate(n2);
        this.preparedStatement.setAsciiStream(n2, inputStream);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        int n2 = this.findColumn(string);
        this.startUpdate(n2);
        this.preparedStatement.setBinaryStream(n2, inputStream);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        int n2 = this.findColumn(string);
        this.startUpdate(n2);
        this.preparedStatement.setCharacterStream(n2, reader);
    }

    @Override
    public void updateBlob(int n2, InputStream inputStream) throws SQLException {
        this.startUpdate(n2);
        this.preparedStatement.setBlob(n2, inputStream);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        int n2 = this.findColumn(string);
        this.startUpdate(n2);
        this.preparedStatement.setBlob(n2, inputStream);
    }

    @Override
    public void updateClob(int n2, Reader reader) throws SQLException {
        this.startUpdate(n2);
        this.preparedStatement.setClob(n2, reader);
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
        int n2 = this.findColumn(string);
        this.startUpdate(n2);
        this.preparedStatement.setClob(n2, reader);
    }

    @Override
    public void updateNClob(int n2, Reader reader) throws SQLException {
        this.startUpdate(n2);
        this.preparedStatement.setClob(n2, reader);
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException {
        int n2 = this.findColumn(string);
        this.startUpdate(n2);
        this.preparedStatement.setClob(n2, reader);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (this.isWrapperFor(clazz)) {
            return (T)this;
        }
        throw JDBCUtil.invalidArgument("iface: " + clazz);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz != null && clazz.isAssignableFrom(this.getClass());
    }

    @Override
    public <T> T getObject(int n2, Class<T> clazz) throws SQLException {
        if (clazz == null) {
            throw JDBCUtil.nullArgument();
        }
        Object object = this.getColumnValue(n2);
        if (this.wasNullValue) {
            return null;
        }
        Object object2 = null;
        switch (clazz.getName()) {
            case "int": 
            case "java.lang.Integer": {
                object2 = this.getInt(n2);
                break;
            }
            case "double": 
            case "java.lang.Double": {
                object2 = this.getDouble(n2);
                break;
            }
            case "boolean": 
            case "java.lang.Boolean": {
                object2 = this.getBoolean(n2);
                break;
            }
            case "byte": 
            case "java.lang.Byte": {
                object2 = this.getByte(n2);
                break;
            }
            case "short": 
            case "java.lang.Short": {
                object2 = this.getShort(n2);
                break;
            }
            case "long": 
            case "java.lang.Long": {
                object2 = this.getLong(n2);
                break;
            }
            case "[B": {
                object2 = this.getBytes(n2);
                break;
            }
            case "java.lang.Object": {
                object2 = this.getObject(n2);
                break;
            }
            case "java.math.BigDecimal": {
                object2 = this.getBigDecimal(n2);
                break;
            }
            case "java.sql.Blob": {
                object2 = this.getBlob(n2);
                break;
            }
            case "java.sql.Clob": {
                object2 = this.getClob(n2);
                break;
            }
            case "java.lang.String": 
            case "java.lang.CharSequence": {
                object2 = this.getString(n2);
                break;
            }
            case "java.sql.Date": {
                object2 = this.getDate(n2);
                break;
            }
            case "java.sql.Time": {
                object2 = this.getTime(n2);
                break;
            }
            case "java.sql.Timestamp": {
                object2 = this.getTimestamp(n2);
                break;
            }
            case "java.util.UUID": {
                Type type = this.resultMetaData.columnTypes[n2 - 1];
                if (type.isUUIDType()) {
                    object2 = Type.SQL_GUID.convertSQLToJava(this.session, object);
                    break;
                }
                Object object3 = Type.SQL_GUID.convertToTypeJDBC(this.session, object, type);
                object2 = Type.SQL_GUID.convertSQLToJava(this.session, object3);
                break;
            }
            case "java.time.Instant": {
                Type type = this.resultMetaData.columnTypes[n2 - 1];
                if (!type.isDateOrTimestampType()) break;
                TimestampData timestampData = (TimestampData)object;
                object2 = ((DateTimeType)type).toInstant(this.session, timestampData);
                break;
            }
            case "java.time.LocalDate": {
                Type type = this.resultMetaData.columnTypes[n2 - 1];
                if (!type.isDateOrTimestampType()) break;
                TimestampData timestampData = (TimestampData)object;
                object2 = ((DateTimeType)type).toLocalDate(this.session, timestampData);
                break;
            }
            case "java.time.LocalTime": {
                Type type = this.resultMetaData.columnTypes[n2 - 1];
                if (type.isTimeType()) {
                    TimeData timeData = (TimeData)object;
                    object2 = ((DateTimeType)type).toLocalTime(this.session, timeData);
                    break;
                }
                if (!type.isTimestampType()) break;
                TimestampData timestampData = (TimestampData)object;
                object2 = ((DateTimeType)type).toLocalTime(this.session, timestampData);
                break;
            }
            case "java.time.LocalDateTime": {
                Type type = this.resultMetaData.columnTypes[n2 - 1];
                if (!type.isDateOrTimestampType()) break;
                TimestampData timestampData = (TimestampData)object;
                object2 = ((DateTimeType)type).toLocalDateTime(this.session, timestampData);
                break;
            }
            case "java.time.OffsetTime": {
                Type type = this.resultMetaData.columnTypes[n2 - 1];
                if (type.isTimeType()) {
                    TimeData timeData = (TimeData)object;
                    object2 = ((DateTimeType)type).toOffsetTime(this.session, timeData);
                    break;
                }
                if (!type.isTimestampType()) break;
                TimestampData timestampData = (TimestampData)object;
                object2 = ((DateTimeType)type).toOffsetTime(this.session, timestampData);
                break;
            }
            case "java.time.OffsetDateTime": {
                Type type = this.resultMetaData.columnTypes[n2 - 1];
                if (!type.isDateOrTimestampType()) break;
                TimestampData timestampData = (TimestampData)object;
                object2 = ((DateTimeType)type).toOffsetDateTime(this.session, timestampData);
                break;
            }
            case "java.time.Duration": {
                Type type = this.resultMetaData.columnTypes[n2 - 1];
                if (!type.isIntervalDaySecondType()) break;
                IntervalSecondData intervalSecondData = (IntervalSecondData)object;
                object2 = Duration.ofSeconds(intervalSecondData.getSeconds(), intervalSecondData.getNanos());
                break;
            }
            case "java.time.Period": {
                Type type = this.resultMetaData.columnTypes[n2 - 1];
                if (!type.isIntervalYearMonthType()) break;
                IntervalMonthData intervalMonthData = (IntervalMonthData)object;
                int n3 = intervalMonthData.getMonths();
                if (type.typeCode == 102) {
                    object2 = Period.ofMonths(n3);
                    break;
                }
                object2 = Period.of(n3 / 12, n3 % 12, 0);
                break;
            }
            case "java.sql.Array": {
                object2 = this.getArray(n2);
            }
        }
        if (object2 == null) {
            throw JDBCUtil.sqlException(5561);
        }
        return (T)object2;
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) throws SQLException {
        return this.getObject(this.findColumn(string), clazz);
    }

    @Override
    public void updateObject(int n2, Object object, SQLType sQLType, int n3) throws SQLException {
        this.startUpdate(n2);
        this.preparedStatement.setObject(n2, object, sQLType, n3);
    }

    @Override
    public void updateObject(String string, Object object, SQLType sQLType, int n2) throws SQLException {
        this.updateObject(this.findColumn(string), object, sQLType, n2);
    }

    @Override
    public void updateObject(int n2, Object object, SQLType sQLType) throws SQLException {
        this.preparedStatement.setObject(n2, object, sQLType);
    }

    @Override
    public void updateObject(String string, Object object, SQLType sQLType) throws SQLException {
        this.updateObject(this.findColumn(string), object, sQLType);
    }

    private Object getTimestampWithZone(int n2) throws SQLException {
        TimestampData timestampData = (TimestampData)this.getColumnInType(n2, Type.SQL_TIMESTAMP_WITH_TIME_ZONE);
        if (timestampData == null) {
            return null;
        }
        return Type.SQL_TIMESTAMP_WITH_TIME_ZONE.convertSQLToJava(this.session, timestampData);
    }

    private Object getTimeWithZone(int n2) throws SQLException {
        DateTimeType dateTimeType = (DateTimeType)this.resultMetaData.columnTypes[n2 - 1];
        TimeData timeData = (TimeData)this.getColumnValue(n2);
        if (timeData == null) {
            return null;
        }
        return dateTimeType.convertSQLToJava(this.session, timeData);
    }

    protected Object[] getCurrent() throws SQLException {
        RowSetNavigator rowSetNavigator = this.navigator;
        if (rowSetNavigator == null) {
            throw JDBCUtil.sqlException(3601);
        }
        if (rowSetNavigator.isEmpty()) {
            throw JDBCUtil.sqlException(3603, 70);
        }
        if (rowSetNavigator.isBeforeFirst()) {
            throw JDBCUtil.sqlException(3603, 71);
        }
        if (rowSetNavigator.isAfterLast()) {
            throw JDBCUtil.sqlException(3603, 72);
        }
        Object[] objectArray = rowSetNavigator.getCurrent();
        if (objectArray == null) {
            throw JDBCUtil.sqlException(3601);
        }
        return objectArray;
    }

    private void checkClosed() throws SQLException {
        if (this.navigator == null) {
            throw JDBCUtil.sqlException(3601);
        }
    }

    protected void checkColumn(int n2) throws SQLException {
        if (this.navigator == null) {
            throw JDBCUtil.sqlException(3601);
        }
        if (n2 < 1 || n2 > this.columnCount) {
            throw JDBCUtil.sqlException(421, String.valueOf(n2));
        }
    }

    protected boolean trackNull(Object object) {
        this.wasNullValue = object == null;
        return this.wasNullValue;
    }

    protected Object getColumnValue(int n2) throws SQLException {
        Object[] objectArray = this.getCurrent();
        this.checkColumn(n2);
        Object object = objectArray[n2 - 1];
        this.trackNull(object);
        return object;
    }

    protected Object getColumnInType(int n2, Type type) throws SQLException {
        Object object = this.getColumnValue(n2);
        Type type2 = this.resultMetaData.columnTypes[n2 - 1];
        if (object == null) {
            return null;
        }
        if (this.translateTTIType && type.isIntervalType()) {
            type = ((IntervalType)type).getCharacterType();
        }
        if (type2.typeCode != type.typeCode) {
            try {
                object = type.convertToTypeJDBC(this.session, object, type2);
            }
            catch (Exception exception) {
                String string = object instanceof Number || object instanceof String ? object.toString() : "instance of " + object.getClass().getName();
                String string2 = "from SQL type " + type2.getNameString() + " to " + type.getJDBCClassName() + ", value: " + string;
                throw JDBCUtil.sqlException(5561, string2);
            }
        }
        return object;
    }

    private void checkNotForwardOnly() throws SQLException {
        if (!this.isScrollable) {
            throw JDBCUtil.notSupported();
        }
    }

    private void checkUpdatable() throws SQLException {
        this.checkClosed();
        if (!this.isUpdatable) {
            throw JDBCUtil.notUpdatableColumn();
        }
    }

    private void checkUpdatable(int n2) throws SQLException {
        this.checkClosed();
        this.checkColumn(n2);
        if (!this.isUpdatable) {
            throw JDBCUtil.notUpdatableColumn();
        }
        if (this.resultMetaData.colIndexes[--n2] == -1) {
            throw JDBCUtil.notUpdatableColumn();
        }
        if (!this.resultMetaData.columns[n2].isWriteable()) {
            throw JDBCUtil.notUpdatableColumn();
        }
    }

    void startUpdate(int n2) throws SQLException {
        this.checkUpdatable(n2);
        if (!this.isOnInsertRow) {
            if (this.currentUpdateRowNumber != this.navigator.getRowNumber()) {
                this.preparedStatement.clearParameters();
            }
            this.currentUpdateRowNumber = this.navigator.getRowNumber();
        }
        this.isRowUpdated = true;
    }

    private void clearUpdates() throws SQLException {
        this.checkUpdatable();
        this.preparedStatement.clearParameters();
        this.currentUpdateRowNumber = -1;
        this.isRowUpdated = false;
    }

    private void startInsert() throws SQLException {
        this.checkUpdatable();
        this.currentUpdateRowNumber = -2;
        this.isOnInsertRow = true;
    }

    private void endInsert() throws SQLException {
        this.checkUpdatable();
        this.preparedStatement.clearParameters();
        this.currentUpdateRowNumber = -1;
        this.isOnInsertRow = false;
    }

    private void performUpdate() throws SQLException {
        this.preparedStatement.parameterValues[this.columnCount] = this.getCurrent()[this.columnCount];
        for (int i2 = 0; i2 < this.columnCount; ++i2) {
            boolean bl = this.preparedStatement.parameterSet[i2];
            this.preparedStatement.resultOut.metaData.columnTypes[i2] = bl ? this.preparedStatement.parameterTypes[i2] : Type.SQL_ALL_TYPES;
        }
        this.preparedStatement.resultOut.setActionType(91);
        this.preparedStatement.fetchResult();
        this.preparedStatement.clearParameters();
        this.rootWarning = this.preparedStatement.getWarnings();
        this.preparedStatement.clearWarnings();
        this.isRowUpdated = false;
    }

    private void performInsert() throws SQLException {
        this.checkUpdatable();
        for (int i2 = 0; i2 < this.columnCount; ++i2) {
            boolean bl = this.preparedStatement.parameterSet[i2];
            if (!bl && !this.resultMetaData.columns[i2].isIdentity()) {
                throw JDBCUtil.sqlException(3606);
            }
            this.preparedStatement.resultOut.metaData.columnTypes[i2] = this.preparedStatement.parameterTypes[i2];
        }
        this.preparedStatement.resultOut.setActionType(55);
        this.preparedStatement.fetchResult();
        this.preparedStatement.clearParameters();
        this.rootWarning = this.preparedStatement.getWarnings();
        this.preparedStatement.clearWarnings();
        this.isRowUpdated = false;
    }

    private void performDelete() throws SQLException {
        this.checkUpdatable();
        if (this.isOnInsertRow) {
            throw JDBCUtil.sqlExceptionSQL(3603);
        }
        this.preparedStatement.parameterValues[this.columnCount] = this.getCurrent()[this.columnCount];
        this.preparedStatement.resultOut.metaData.columnTypes[this.columnCount] = this.resultMetaData.columnTypes[this.columnCount];
        this.preparedStatement.resultOut.setActionType(18);
        this.preparedStatement.fetchResult();
        this.preparedStatement.clearParameters();
        this.rootWarning = this.preparedStatement.getWarnings();
        this.preparedStatement.clearWarnings();
    }

    RowSetNavigator getNavigator() {
        return this.navigator;
    }

    void setNavigator(RowSetNavigator rowSetNavigator) {
        this.navigator = rowSetNavigator;
    }

    public JDBCResultSet(JDBCConnection jDBCConnection, JDBCStatementBase jDBCStatementBase, Result result, ResultMetaData resultMetaData) {
        this(jDBCConnection, result, resultMetaData);
        this.statement = jDBCStatementBase;
        this.isScrollable = ResultProperties.isScrollable(this.rsProperties);
        if (ResultProperties.isUpdatable(this.rsProperties)) {
            this.isUpdatable = true;
            this.isInsertable = true;
            for (int i2 = 0; i2 < resultMetaData.colIndexes.length; ++i2) {
                if (resultMetaData.colIndexes[i2] >= 0) continue;
                this.isInsertable = false;
                break;
            }
            this.preparedStatement = new JDBCPreparedStatement(jDBCStatementBase.connection, this.result);
        }
    }

    public JDBCResultSet(JDBCConnection jDBCConnection, Result result, ResultMetaData resultMetaData) {
        this.session = jDBCConnection == null ? null : jDBCConnection.sessionProxy;
        this.result = result;
        this.connection = jDBCConnection;
        this.rsProperties = result.rsProperties;
        this.navigator = result.getNavigator();
        this.resultMetaData = resultMetaData;
        this.columnCount = this.resultMetaData.getColumnCount();
        if (jDBCConnection != null) {
            this.translateTTIType = jDBCConnection.isTranslateTTIType;
            this.memoryLobs = jDBCConnection.isMemoryLobs;
        }
    }

    public static JDBCResultSet newJDBCResultSet(Result result, ResultMetaData resultMetaData) {
        return new JDBCResultSetBasic(result, resultMetaData);
    }

    public static JDBCResultSet newEmptyResultSet() {
        ResultMetaData resultMetaData = ResultMetaData.newResultMetaData(1);
        ColumnBase columnBase = new ColumnBase(null, null, null, "C1");
        columnBase.setType(Type.SQL_INTEGER);
        resultMetaData.columnTypes[0] = Type.SQL_INTEGER;
        resultMetaData.columns[0] = columnBase;
        Result result = Result.newSingleColumnResult(resultMetaData);
        return JDBCResultSet.newJDBCResultSet(result, resultMetaData);
    }

    static class JDBCResultSetBasic
    extends JDBCResultSet {
        JDBCResultSetBasic(Result result, ResultMetaData resultMetaData) {
            super(null, result, resultMetaData);
        }

        @Override
        protected Object getColumnInType(int n2, Type type) throws SQLException {
            Object[] objectArray = this.getCurrent();
            this.checkColumn(n2);
            Type type2 = this.resultMetaData.columnTypes[--n2];
            Object object = objectArray[n2];
            if (this.trackNull(object)) {
                return null;
            }
            if (type2.typeCode != type.typeCode) {
                throw JDBCUtil.sqlException(5561);
            }
            return object;
        }

        @Override
        public Date getDate(int n2) throws SQLException {
            return (Date)this.getColumnInType(n2, Type.SQL_DATE);
        }

        @Override
        public Time getTime(int n2) throws SQLException {
            return (Time)this.getColumnInType(n2, Type.SQL_DATE);
        }

        @Override
        public Timestamp getTimestamp(int n2) throws SQLException {
            return (Timestamp)this.getColumnInType(n2, Type.SQL_DATE);
        }

        @Override
        public InputStream getBinaryStream(int n2) throws SQLException {
            throw JDBCUtil.notSupported();
        }

        @Override
        public Reader getCharacterStream(int n2) throws SQLException {
            throw JDBCUtil.notSupported();
        }

        @Override
        public Blob getBlob(int n2) throws SQLException {
            this.checkColumn(n2);
            Type type = this.resultMetaData.columnTypes[n2 - 1];
            Object object = this.getColumnInType(n2, type);
            if (object == null) {
                return null;
            }
            if (object instanceof Blob) {
                return (Blob)object;
            }
            if (object instanceof byte[]) {
                return new JDBCBlob((byte[])object);
            }
            throw JDBCUtil.sqlException(5561);
        }

        @Override
        public Clob getClob(int n2) throws SQLException {
            this.checkColumn(n2);
            Type type = this.resultMetaData.columnTypes[n2 - 1];
            Object object = this.getColumnInType(n2, type);
            if (object == null) {
                return null;
            }
            if (object instanceof Clob) {
                return (Clob)object;
            }
            if (object instanceof String) {
                return new JDBCClob((String)object);
            }
            throw JDBCUtil.sqlException(5561);
        }

        @Override
        public Time getTime(int n2, Calendar calendar) throws SQLException {
            throw JDBCUtil.notSupported();
        }

        @Override
        public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
            throw JDBCUtil.notSupported();
        }
    }
}

