/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Calendar;
import java.util.UUID;
import org.hsqldb.HsqlException;
import org.hsqldb.SessionInterface;
import org.hsqldb.jdbc.JDBCArray;
import org.hsqldb.jdbc.JDBCBlob;
import org.hsqldb.jdbc.JDBCBlobClient;
import org.hsqldb.jdbc.JDBCClob;
import org.hsqldb.jdbc.JDBCClobClient;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.JDBCParameterMetaData;
import org.hsqldb.jdbc.JDBCResultSet;
import org.hsqldb.jdbc.JDBCResultSetMetaData;
import org.hsqldb.jdbc.JDBCStatementBase;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.lib.CharArrayWriter;
import org.hsqldb.lib.CountdownInputStream;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultLob;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.result.ResultProperties;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BinaryUUIDType;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.BlobInputStream;
import org.hsqldb.types.ClobDataID;
import org.hsqldb.types.ClobInputStream;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.JavaObjectData;
import org.hsqldb.types.JavaObjectDataInternal;
import org.hsqldb.types.LobData;
import org.hsqldb.types.Type;

public class JDBCPreparedStatement
extends JDBCStatementBase
implements PreparedStatement {
    boolean poolable = true;
    protected Object[] parameterValues;
    protected boolean[] parameterSet;
    protected Type[] parameterTypes;
    protected byte[] parameterModes;
    protected long[] streamLengths;
    protected boolean hasLOBs;
    protected boolean isBatch;
    protected ResultMetaData resultMetaData;
    protected ResultMetaData parameterMetaData;
    protected JDBCResultSetMetaData resultSetMetaData;
    protected ParameterMetaData pmd;
    protected String sql;
    protected long statementID;
    protected int statementRetType;
    protected final boolean isResult;
    protected SessionInterface session;

    @Override
    public synchronized ResultSet executeQuery() throws SQLException {
        if (this.statementRetType != 2) {
            this.checkStatementType(2);
        }
        this.fetchResult();
        return this.getResultSet();
    }

    @Override
    public synchronized int executeUpdate() throws SQLException {
        if (this.statementRetType != 1) {
            this.checkStatementType(1);
        }
        this.fetchResult();
        return this.resultIn.getUpdateCount();
    }

    @Override
    public synchronized void setNull(int n2, int n3) throws SQLException {
        this.setParameter(n2, null);
    }

    @Override
    public synchronized void setBoolean(int n2, boolean bl) throws SQLException {
        Boolean bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
        this.setParameter(n2, bl2);
    }

    @Override
    public synchronized void setByte(int n2, byte by) throws SQLException {
        this.setIntParameter(n2, by);
    }

    @Override
    public synchronized void setShort(int n2, short s2) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        this.setIntParameter(n2, s2);
    }

    @Override
    public synchronized void setInt(int n2, int n3) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        this.setIntParameter(n2, n3);
    }

    @Override
    public synchronized void setLong(int n2, long l2) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        this.setLongParameter(n2, l2);
    }

    @Override
    public synchronized void setFloat(int n2, float f2) throws SQLException {
        this.setDouble(n2, f2);
    }

    @Override
    public synchronized void setDouble(int n2, double d2) throws SQLException {
        Double d3 = d2;
        this.setParameter(n2, d3);
    }

    @Override
    public synchronized void setBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        this.setParameter(n2, bigDecimal);
    }

    @Override
    public synchronized void setString(int n2, String string) throws SQLException {
        this.setParameter(n2, string);
    }

    @Override
    public synchronized void setBytes(int n2, byte[] byArray) throws SQLException {
        this.setParameter(n2, byArray);
    }

    @Override
    public synchronized void setDate(int n2, Date date) throws SQLException {
        this.setDate(n2, date, null);
    }

    @Override
    public synchronized void setTime(int n2, Time time) throws SQLException {
        this.setParameter(n2, time);
    }

    @Override
    public synchronized void setTimestamp(int n2, Timestamp timestamp) throws SQLException {
        this.setParameter(n2, timestamp);
    }

    @Override
    public synchronized void setAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.setAsciiStream(n2, inputStream, (long)n3);
    }

    @Override
    @Deprecated
    public synchronized void setUnicodeStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.checkSetParameterIndex(n2);
        if (inputStream == null) {
            throw JDBCUtil.nullArgument("x");
        }
        String string = "UTF8";
        StringWriter stringWriter = new StringWriter();
        try {
            int n4;
            CountdownInputStream countdownInputStream = new CountdownInputStream(inputStream);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)countdownInputStream, string);
            char[] cArray = new char[1024];
            countdownInputStream.setCount(n3);
            while (-1 != (n4 = inputStreamReader.read(cArray))) {
                stringWriter.write(cArray, 0, n4);
            }
        }
        catch (IOException iOException) {
            throw JDBCUtil.sqlException(401, iOException.toString(), iOException);
        }
        this.setParameter(n2, stringWriter.toString());
    }

    @Override
    public synchronized void setBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        this.setBinaryStream(n2, inputStream, (long)n3);
    }

    @Override
    public synchronized void clearParameters() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        Arrays.fill(this.parameterValues, null);
        Arrays.fill(this.parameterSet, false);
        Arrays.fill(this.streamLengths, 0, this.streamLengths.length, 0L);
    }

    @Override
    public synchronized void setObject(int n2, Object object, int n3, int n4) throws SQLException {
        if (object instanceof InputStream) {
            this.setBinaryStream(n2, (InputStream)object, n4);
        } else if (object instanceof Reader) {
            this.setCharacterStream(n2, (Reader)object, n4);
        } else {
            this.setObject(n2, object);
        }
    }

    @Override
    public synchronized void setObject(int n2, Object object, int n3) throws SQLException {
        this.setObject(n2, object);
    }

    @Override
    public synchronized void setObject(int n2, Object object) throws SQLException {
        this.setParameter(n2, object);
    }

    @Override
    public synchronized boolean execute() throws SQLException {
        this.fetchResult();
        return this.statementRetType == 2;
    }

    @Override
    public synchronized void addBatch() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        this.checkParametersSet();
        if (!this.isBatch) {
            this.resultOut.setBatchedPreparedExecuteRequest();
            this.isBatch = true;
        }
        try {
            this.performPreExecute();
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
        int n2 = this.parameterValues.length;
        Object[] objectArray = new Object[n2];
        System.arraycopy(this.parameterValues, 0, objectArray, 0, n2);
        this.resultOut.addBatchedPreparedExecuteRequest(objectArray);
    }

    @Override
    public synchronized void setCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        this.setCharacterStream(n2, reader, (long)n3);
    }

    @Override
    public void setRef(int n2, Ref ref) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized void setBlob(int n2, Blob blob) throws SQLException {
        this.checkSetParameterIndex(n2);
        Type type = this.parameterTypes[n2 - 1];
        switch (type.typeCode) {
            case 60: 
            case 61: {
                this.setBlobForBinaryParameter(n2, blob);
                return;
            }
            case 30: {
                this.setBlobParameter(n2, blob);
                break;
            }
            default: {
                throw JDBCUtil.invalidArgument();
            }
        }
    }

    private void setBlobForBinaryParameter(int n2, Blob blob) throws SQLException {
        if (blob instanceof JDBCBlob) {
            this.setParameter(n2, ((JDBCBlob)blob).data());
            return;
        }
        if (blob == null) {
            this.setParameter(n2, null);
            return;
        }
        long l2 = blob.length();
        if (l2 > Integer.MAX_VALUE) {
            String string = "Maximum Blob input octet length exceeded: " + l2;
            throw JDBCUtil.sqlException(422, string);
        }
        try {
            InputStream inputStream = blob.getBinaryStream();
            HsqlByteArrayOutputStream hsqlByteArrayOutputStream = new HsqlByteArrayOutputStream(inputStream, (int)l2);
            this.setParameter(n2, hsqlByteArrayOutputStream.toByteArray());
            hsqlByteArrayOutputStream.close();
        }
        catch (Throwable throwable) {
            throw JDBCUtil.sqlException(422, throwable.toString(), throwable);
        }
    }

    @Override
    public synchronized void setClob(int n2, Clob clob) throws SQLException {
        this.checkSetParameterIndex(n2);
        Type type = this.parameterTypes[n2 - 1];
        switch (type.typeCode) {
            case 1: 
            case 12: {
                this.setClobForStringParameter(n2, clob);
                return;
            }
            case 40: {
                this.setClobParameter(n2, clob);
                return;
            }
        }
        throw JDBCUtil.invalidArgument();
    }

    private void setClobForStringParameter(int n2, Clob clob) throws SQLException {
        if (clob instanceof JDBCClob) {
            this.setParameter(n2, ((JDBCClob)clob).getData());
            return;
        }
        if (clob == null) {
            this.setParameter(n2, null);
            return;
        }
        long l2 = clob.length();
        if (l2 > Integer.MAX_VALUE) {
            String string = "Max Clob input character length exceeded: " + l2;
            throw JDBCUtil.sqlException(422, string);
        }
        try {
            Reader reader = clob.getCharacterStream();
            CharArrayWriter charArrayWriter = new CharArrayWriter(reader, (int)l2);
            this.setParameter(n2, charArrayWriter.toString());
        }
        catch (Throwable throwable) {
            throw JDBCUtil.sqlException(401, throwable.toString(), throwable);
        }
    }

    @Override
    public synchronized void setArray(int n2, Array array) throws SQLException {
        this.checkParameterIndex(n2);
        int n3 = n2 - 1;
        Type type = this.parameterMetaData.columnTypes[n3];
        if (!type.isArrayType()) {
            throw JDBCUtil.sqlException(5561);
        }
        if (array == null) {
            this.parameterValues[n3] = null;
            this.parameterSet[n3] = true;
            return;
        }
        Object[] objectArray = null;
        if (array instanceof JDBCArray) {
            Type type2 = type.collectionBaseType();
            Object[] objectArray2 = ((JDBCArray)array).getArrayInternal();
            Type type3 = ((JDBCArray)array).arrayType;
            objectArray = (Object[])type.convertToType(this.session, objectArray2, type3);
        } else {
            Object object = array.getArray();
            if (object instanceof Object[]) {
                Type type4 = type.collectionBaseType();
                Object[] objectArray3 = (Object[])object;
                objectArray = new Object[objectArray3.length];
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    objectArray[i2] = type4.convertJavaToSQL(this.session, objectArray3[i2]);
                }
            } else {
                throw JDBCUtil.notSupported();
            }
        }
        this.parameterValues[n3] = objectArray;
        this.parameterSet[n3] = true;
    }

    @Override
    public synchronized ResultSetMetaData getMetaData() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (this.statementRetType != 2) {
            return null;
        }
        if (this.resultSetMetaData == null) {
            boolean bl = ResultProperties.isUpdatable(this.rsProperties);
            boolean bl2 = bl;
            if (bl2) {
                for (int i2 = 0; i2 < this.resultMetaData.colIndexes.length; ++i2) {
                    if (this.resultMetaData.colIndexes[i2] >= 0) continue;
                    bl2 = false;
                    break;
                }
            }
            this.resultSetMetaData = new JDBCResultSetMetaData(this.resultMetaData, bl, bl2, this.connection);
        }
        return this.resultSetMetaData;
    }

    @Override
    public synchronized void setDate(int n2, Date date, Calendar calendar) throws SQLException {
        Object object;
        this.checkSetParameterIndex(n2);
        int n3 = n2 - 1;
        if (date == null) {
            this.parameterValues[n3] = null;
            this.parameterSet[n3] = true;
            return;
        }
        Type type = this.parameterTypes[n3];
        switch (type.typeCode) {
            case 91: 
            case 93: 
            case 95: {
                break;
            }
            default: {
                throw JDBCUtil.sqlException(5561);
            }
        }
        this.parameterValues[n3] = object = ((DateTimeType)type).convertJavaToSQL(this.session, date, calendar);
        this.parameterSet[n3] = true;
    }

    @Override
    public synchronized void setTime(int n2, Time time, Calendar calendar) throws SQLException {
        Object object;
        this.checkSetParameterIndex(n2);
        int n3 = n2 - 1;
        if (time == null) {
            this.parameterValues[n3] = null;
            this.parameterSet[n3] = true;
            return;
        }
        Type type = this.parameterTypes[n3];
        switch (type.typeCode) {
            case 92: 
            case 94: {
                break;
            }
            default: {
                throw JDBCUtil.sqlException(5561);
            }
        }
        this.parameterValues[n3] = object = ((DateTimeType)type).convertJavaToSQL(this.session, time, calendar);
        this.parameterSet[n3] = true;
    }

    @Override
    public synchronized void setTimestamp(int n2, Timestamp timestamp, Calendar calendar) throws SQLException {
        Object object;
        this.checkSetParameterIndex(n2);
        int n3 = n2 - 1;
        if (timestamp == null) {
            this.parameterValues[n3] = null;
            this.parameterSet[n3] = true;
            return;
        }
        Type type = this.parameterTypes[n3];
        switch (type.typeCode) {
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                break;
            }
            default: {
                throw JDBCUtil.sqlException(5561);
            }
        }
        this.parameterValues[n3] = object = ((DateTimeType)type).convertJavaToSQL(this.session, timestamp, calendar);
        this.parameterSet[n3] = true;
    }

    @Override
    public synchronized void setNull(int n2, int n3, String string) throws SQLException {
        this.setParameter(n2, null);
    }

    @Override
    public synchronized int[] executeBatch() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        this.checkStatementType(1);
        if (!this.isBatch) {
            if (this.connection.isAllowEmptyBatch) {
                return new int[0];
            }
            throw JDBCUtil.sqlExceptionSQL(1256);
        }
        this.generatedResult = null;
        int n2 = this.resultOut.getNavigator().getSize();
        this.resultIn = null;
        try {
            this.resultIn = this.session.execute(this.resultOut);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
        finally {
            this.performPostExecute();
            this.resultOut.getNavigator().clear();
            this.isBatch = false;
        }
        if (this.resultIn.mode == 2) {
            throw JDBCUtil.sqlException(this.resultIn);
        }
        RowSetNavigator rowSetNavigator = this.resultIn.getNavigator();
        int[] nArray = new int[rowSetNavigator.getSize()];
        int n3 = 0;
        while (rowSetNavigator.next()) {
            Object[] objectArray = rowSetNavigator.getCurrent();
            nArray[n3] = (Integer)objectArray[0];
            ++n3;
        }
        if (nArray.length != n2) {
            if (this.errorResult == null) {
                throw new BatchUpdateException(nArray);
            }
            throw new BatchUpdateException(this.errorResult.getMainString(), this.errorResult.getSubString(), this.errorResult.getErrorCode(), nArray);
        }
        return nArray;
    }

    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.checkClosed();
    }

    @Override
    public void addBatch(String string) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized ResultSet executeQuery(String string) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public boolean execute(String string) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        this.closeResultData();
        HsqlException hsqlException = null;
        try {
            if (!this.connection.isClosed) {
                this.session.execute(Result.newFreeStmtRequest(this.statementID));
            }
        }
        catch (HsqlException hsqlException2) {
            hsqlException = hsqlException2;
        }
        this.parameterValues = null;
        this.parameterSet = null;
        this.parameterTypes = null;
        this.parameterModes = null;
        this.resultMetaData = null;
        this.parameterMetaData = null;
        this.resultSetMetaData = null;
        this.pmd = null;
        this.connection = null;
        this.session = null;
        this.resultIn = null;
        this.resultOut = null;
        this.isClosed = true;
        if (hsqlException != null) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    public synchronized String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        String string = this.sql;
        Object[] objectArray = this.parameterValues;
        if (string == null || objectArray == null) {
            stringBuilder.append("[closed]");
            return stringBuilder.toString();
        }
        stringBuilder.append("[sql=[").append(string).append("]");
        if (objectArray.length > 0) {
            stringBuilder.append(", parameters=[");
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                stringBuilder.append('[');
                stringBuilder.append(objectArray[i2]);
                stringBuilder.append("], ");
            }
            stringBuilder.setLength(stringBuilder.length() - 2);
            stringBuilder.append(']');
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public void setURL(int n2, URL uRL) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkClosed();
        if (this.pmd == null) {
            this.pmd = new JDBCParameterMetaData(this.connection, this.parameterMetaData);
        }
        return this.pmd;
    }

    @Override
    public int executeUpdate(String string, int n2) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public boolean execute(String string, int n2) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized boolean getMoreResults(int n2) throws SQLException {
        return super.getMoreResults(n2);
    }

    @Override
    public synchronized ResultSet getGeneratedKeys() throws SQLException {
        return this.getGeneratedResultSet();
    }

    @Override
    public synchronized int getResultSetHoldability() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        return ResultProperties.getJDBCHoldability(this.rsProperties);
    }

    @Override
    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public void setRowId(int n2, RowId rowId) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized void setNString(int n2, String string) throws SQLException {
        this.setString(n2, string);
    }

    @Override
    public synchronized void setNCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        this.setCharacterStream(n2, reader, l2);
    }

    @Override
    public synchronized void setNClob(int n2, NClob nClob) throws SQLException {
        this.setClob(n2, nClob);
    }

    @Override
    public synchronized void setClob(int n2, Reader reader, long l2) throws SQLException {
        this.setCharacterStream(n2, reader, l2);
    }

    @Override
    public synchronized void setBlob(int n2, InputStream inputStream, long l2) throws SQLException {
        this.setBinaryStream(n2, inputStream, l2);
    }

    @Override
    public synchronized void setNClob(int n2, Reader reader, long l2) throws SQLException {
        this.setClob(n2, reader, l2);
    }

    @Override
    public void setSQLXML(int n2, SQLXML sQLXML) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized void setAsciiStream(int n2, InputStream inputStream, long l2) throws SQLException {
        if (l2 < 0L) {
            throw JDBCUtil.sqlException(423, "length: " + l2);
        }
        this.setAscStream(n2, inputStream, l2);
    }

    void setAscStream(int n2, InputStream inputStream, long l2) throws SQLException {
        if (l2 > Integer.MAX_VALUE) {
            throw JDBCUtil.sqlException(3401);
        }
        if (inputStream == null) {
            throw JDBCUtil.nullArgument("x");
        }
        try {
            String string = StringConverter.inputStreamToString(inputStream, "US-ASCII");
            if (l2 >= 0L && (long)string.length() > l2) {
                string = string.substring(0, (int)l2);
            }
            this.setParameter(n2, string);
        }
        catch (IOException iOException) {
            throw JDBCUtil.sqlException(422, null, iOException);
        }
    }

    @Override
    public synchronized void setBinaryStream(int n2, InputStream inputStream, long l2) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (l2 < 0L) {
            throw JDBCUtil.sqlException(423, "length: " + l2);
        }
        if (l2 > this.parameterTypes[n2 - 1].precision) {
            throw JDBCUtil.sqlException(3401, "length: " + l2);
        }
        this.setBinStream(n2, inputStream, -1L);
    }

    private void setBinStream(int n2, InputStream inputStream, long l2) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (this.parameterTypes[n2 - 1].typeCode == 30) {
            this.setBlobParameter(n2, inputStream, l2);
            return;
        }
        if (l2 > Integer.MAX_VALUE) {
            String string = "Maximum Blob input length exceeded: " + l2;
            throw JDBCUtil.sqlException(422, string);
        }
        try {
            HsqlByteArrayOutputStream hsqlByteArrayOutputStream = l2 < 0L ? new HsqlByteArrayOutputStream(inputStream) : new HsqlByteArrayOutputStream(inputStream, (int)l2);
            this.setParameter(n2, hsqlByteArrayOutputStream.toByteArray());
        }
        catch (Throwable throwable) {
            throw JDBCUtil.sqlException(422, throwable.toString(), throwable);
        }
    }

    @Override
    public synchronized void setCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (l2 < 0L) {
            throw JDBCUtil.sqlException(423, "length: " + l2);
        }
        if (l2 > this.parameterTypes[n2 - 1].precision) {
            throw JDBCUtil.sqlException(3401, "length: " + l2);
        }
        this.setCharStream(n2, reader, -1L);
    }

    private void setCharStream(int n2, Reader reader, long l2) throws SQLException {
        this.checkSetParameterIndex(n2);
        if (this.parameterTypes[n2 - 1].typeCode == 40) {
            this.setClobParameter(n2, reader, l2);
            return;
        }
        if (l2 > Integer.MAX_VALUE) {
            String string = "Maximum Clob input length exceeded: " + l2;
            throw JDBCUtil.sqlException(422, string);
        }
        try {
            CharArrayWriter charArrayWriter = l2 < 0L ? new CharArrayWriter(reader) : new CharArrayWriter(reader, (int)l2);
            this.setParameter(n2, charArrayWriter.toString());
        }
        catch (Throwable throwable) {
            throw JDBCUtil.sqlException(422, throwable.toString(), throwable);
        }
    }

    @Override
    public synchronized void setAsciiStream(int n2, InputStream inputStream) throws SQLException {
        this.setAscStream(n2, inputStream, -1L);
    }

    @Override
    public synchronized void setBinaryStream(int n2, InputStream inputStream) throws SQLException {
        this.setBinStream(n2, inputStream, -1L);
    }

    @Override
    public synchronized void setCharacterStream(int n2, Reader reader) throws SQLException {
        this.setCharStream(n2, reader, -1L);
    }

    @Override
    public synchronized void setNCharacterStream(int n2, Reader reader) throws SQLException {
        this.setCharStream(n2, reader, -1L);
    }

    @Override
    public synchronized void setClob(int n2, Reader reader) throws SQLException {
        this.setCharStream(n2, reader, -1L);
    }

    @Override
    public synchronized void setBlob(int n2, InputStream inputStream) throws SQLException {
        this.setBinStream(n2, inputStream, -1L);
    }

    @Override
    public synchronized void setNClob(int n2, Reader reader) throws SQLException {
        this.setCharStream(n2, reader, -1L);
    }

    @Override
    public synchronized int getMaxFieldSize() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        return 0;
    }

    @Override
    public synchronized void setMaxFieldSize(int n2) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (n2 < 0) {
            throw JDBCUtil.outOfRangeArgument();
        }
    }

    @Override
    public synchronized int getMaxRows() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        return this.maxRows;
    }

    @Override
    public synchronized void setMaxRows(int n2) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (n2 < 0) {
            throw JDBCUtil.outOfRangeArgument();
        }
        this.maxRows = n2;
    }

    @Override
    public synchronized int getQueryTimeout() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        return this.queryTimeout;
    }

    @Override
    public synchronized void setQueryTimeout(int n2) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (n2 < 0) {
            throw JDBCUtil.outOfRangeArgument();
        }
        if (n2 > Short.MAX_VALUE) {
            n2 = Short.MAX_VALUE;
        }
        this.queryTimeout = n2;
    }

    @Override
    public synchronized void cancel() throws SQLException {
        this.checkClosed();
        String string = this.resultOut.getMainString();
        int n2 = this.connection.sessionProxy.getRandomId();
        Result result = Result.newCancelRequest(n2, -1L, string);
        try {
            Result result2 = this.connection.sessionProxy.cancel(result);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized SQLWarning getWarnings() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        return this.rootWarning;
    }

    @Override
    public synchronized void clearWarnings() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        this.rootWarning = null;
    }

    @Override
    public void setCursorName(String string) throws SQLException {
        this.checkClosed();
    }

    @Override
    public synchronized ResultSet getResultSet() throws SQLException {
        return super.getResultSet();
    }

    @Override
    public synchronized int getUpdateCount() throws SQLException {
        return super.getUpdateCount();
    }

    @Override
    public synchronized boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    @Override
    public synchronized void setFetchDirection(int n2) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (n2 != 1000 && n2 != 1001 && n2 != 1002) {
            throw JDBCUtil.notSupported();
        }
        this.fetchDirection = n2;
    }

    @Override
    public synchronized int getFetchDirection() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        return this.fetchDirection;
    }

    @Override
    public synchronized void setFetchSize(int n2) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (n2 < 0) {
            throw JDBCUtil.outOfRangeArgument();
        }
        this.fetchSize = n2;
    }

    @Override
    public synchronized int getFetchSize() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        return this.fetchSize;
    }

    @Override
    public synchronized int getResultSetConcurrency() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        return ResultProperties.getJDBCConcurrency(this.rsProperties);
    }

    @Override
    public synchronized int getResultSetType() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        return ResultProperties.getJDBCScrollability(this.rsProperties);
    }

    @Override
    public synchronized void clearBatch() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (this.isBatch) {
            this.resultOut.getNavigator().clear();
        }
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        return this.connection;
    }

    @Override
    public synchronized void setPoolable(boolean bl) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        this.poolable = bl;
    }

    @Override
    public synchronized boolean isPoolable() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        return this.poolable;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (this.isWrapperFor(clazz)) {
            return (T)this;
        }
        throw JDBCUtil.invalidArgument("iface: " + clazz);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz != null && clazz.isAssignableFrom(this.getClass());
    }

    @Override
    public synchronized long getLargeUpdateCount() throws SQLException {
        return super.getUpdateCount();
    }

    @Override
    public synchronized void setLargeMaxRows(long l2) throws SQLException {
        int n2 = l2 > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
        this.setMaxRows(n2);
    }

    @Override
    public synchronized long getLargeMaxRows() throws SQLException {
        return this.maxRows;
    }

    @Override
    public synchronized long[] executeLargeBatch() throws SQLException {
        int[] nArray = this.executeBatch();
        long[] lArray = new long[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            lArray[i2] = nArray[i2];
        }
        return lArray;
    }

    @Override
    public synchronized void setObject(int n2, Object object, SQLType sQLType, int n3) throws SQLException {
        int n4 = sQLType.getVendorTypeNumber();
        this.setObject(n2, object, n4, n3);
    }

    @Override
    public synchronized void setObject(int n2, Object object, SQLType sQLType) throws SQLException {
        int n3 = sQLType.getVendorTypeNumber();
        this.setObject(n2, object, n3);
    }

    @Override
    public synchronized long executeLargeUpdate() throws SQLException {
        return this.executeUpdate();
    }

    JDBCPreparedStatement(JDBCConnection jDBCConnection, String string, int n2, int n3, int n4, int n5, int[] nArray, String[] stringArray) throws HsqlException, SQLException {
        this.isResult = false;
        this.connection = jDBCConnection;
        this.connectionIncarnation = this.connection.incarnation;
        this.session = jDBCConnection.sessionProxy;
        string = jDBCConnection.nativeSQL(string);
        this.resultOut = Result.newPrepareStatementRequest();
        int n6 = ResultProperties.getValueForJDBC(n2, n3, n4);
        this.resultOut.setPrepareOrExecuteProperties(string, 0, 0, 0, this.queryTimeout, n6, n5, nArray, stringArray);
        Result result = this.session.execute(this.resultOut);
        if (result.mode == 2) {
            throw JDBCUtil.sqlException(result);
        }
        this.rootWarning = null;
        Result result2 = result;
        while (result2.getChainedResult() != null) {
            if (!(result2 = result2.getUnlinkChainedResult()).isWarning()) continue;
            SQLWarning sQLWarning = JDBCUtil.sqlWarning(result2);
            if (this.rootWarning == null) {
                this.rootWarning = sQLWarning;
                continue;
            }
            this.rootWarning.setNextWarning(sQLWarning);
        }
        this.connection.setWarnings(this.rootWarning);
        this.statementID = result.getStatementID();
        this.statementRetType = result.getStatementType();
        this.resultMetaData = result.metaData;
        this.parameterMetaData = result.parameterMetaData;
        this.parameterTypes = this.parameterMetaData.getParameterTypes();
        this.parameterModes = this.parameterMetaData.paramModes;
        this.rsProperties = result.rsProperties;
        int n7 = this.parameterMetaData.getColumnCount();
        this.parameterValues = new Object[n7];
        this.parameterSet = new boolean[n7];
        this.streamLengths = new long[n7];
        for (int i2 = 0; i2 < n7; ++i2) {
            if (!this.parameterTypes[i2].isLobType()) continue;
            this.hasLOBs = true;
            break;
        }
        this.resultOut = Result.newPreparedExecuteRequest(this.parameterTypes, this.statementID);
        this.resultOut.setStatement(result.getStatement());
        this.sql = string;
    }

    JDBCPreparedStatement(JDBCConnection jDBCConnection, Result result) {
        this.isResult = true;
        this.connection = jDBCConnection;
        this.connectionIncarnation = this.connection.incarnation;
        this.session = jDBCConnection.sessionProxy;
        int n2 = result.metaData.getExtendedColumnCount();
        this.parameterMetaData = result.metaData;
        this.parameterTypes = result.metaData.columnTypes;
        this.parameterModes = new byte[n2];
        this.parameterValues = new Object[n2];
        this.parameterSet = new boolean[n2];
        this.streamLengths = new long[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.parameterModes[i2] = 1;
            if (!this.parameterTypes[i2].isLobType()) continue;
            this.hasLOBs = true;
        }
        this.resultOut = Result.newUpdateResultRequest(this.parameterTypes, result.getResultId());
    }

    protected void checkStatementType(int n2) throws SQLException {
        if (n2 != this.statementRetType) {
            if (this.statementRetType == 1) {
                throw JDBCUtil.sqlException(1254);
            }
            throw JDBCUtil.sqlException(1253);
        }
    }

    protected void checkParameterIndex(int n2) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (n2 < 1 || n2 > this.parameterValues.length) {
            String string = "parameter index out of range: " + n2;
            throw JDBCUtil.outOfRangeArgument(string);
        }
    }

    protected void checkSetParameterIndex(int n2) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (n2 < 1 || n2 > this.parameterValues.length) {
            String string = "parameter index out of range: " + n2;
            throw JDBCUtil.outOfRangeArgument(string);
        }
        if (this.parameterModes[n2 - 1] == 4) {
            String string = "Not IN or INOUT mode for parameter: " + n2;
            throw JDBCUtil.invalidArgument(string);
        }
    }

    protected void checkGetParameterIndex(int n2) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (n2 < 1 || n2 > this.parameterValues.length) {
            String string = "parameter index out of range: " + n2;
            throw JDBCUtil.outOfRangeArgument(string);
        }
        byte by = this.parameterModes[n2 - 1];
        switch (by) {
            case 0: 
            case 2: 
            case 4: {
                break;
            }
            default: {
                String string = "Not OUT or INOUT mode for parameter: " + n2;
                throw JDBCUtil.invalidArgument(string);
            }
        }
    }

    private void checkParametersSet() throws SQLException {
        if (this.isResult) {
            return;
        }
        for (int i2 = 0; i2 < this.parameterSet.length; ++i2) {
            if (this.parameterModes[i2] == 4 || this.parameterSet[i2]) continue;
            throw JDBCUtil.sqlException(424);
        }
    }

    void setParameter(int n2, Object object) throws SQLException {
        this.checkSetParameterIndex(n2);
        int n3 = n2 - 1;
        if (object == null) {
            this.parameterValues[n3] = null;
            this.parameterSet[n3] = true;
            return;
        }
        Type type = this.parameterTypes[n3];
        switch (type.typeCode) {
            case 1111: {
                try {
                    if (this.connection.isStoreLiveObject) {
                        object = new JavaObjectDataInternal(object);
                        break;
                    }
                    if (object instanceof Serializable) {
                        object = new JavaObjectData((Serializable)object);
                        break;
                    }
                }
                catch (HsqlException hsqlException) {
                    throw JDBCUtil.sqlException(hsqlException);
                }
                throw JDBCUtil.sqlException(5563);
            }
            case 14: 
            case 15: {
                try {
                    if (object instanceof Boolean) {
                        object = type.convertToDefaultType(this.session, object);
                        break;
                    }
                    if (object instanceof Integer) {
                        object = type.convertToDefaultType(this.session, object);
                        break;
                    }
                    if (object instanceof byte[]) {
                        object = type.convertToDefaultType(this.session, object);
                        break;
                    }
                    if (object instanceof String) {
                        object = type.convertToDefaultType(this.session, object);
                        break;
                    }
                    if (object instanceof BitSet) {
                        object = type.convertToDefaultType(this.session, object);
                        break;
                    }
                }
                catch (HsqlException hsqlException) {
                    throw JDBCUtil.sqlException(hsqlException);
                }
                throw JDBCUtil.sqlException(5563);
            }
            case -11: 
            case 60: 
            case 61: {
                if (object instanceof byte[]) {
                    object = new BinaryData((byte[])object, !this.connection.isNetConn);
                    break;
                }
                if (object instanceof UUID) {
                    object = BinaryUUIDType.getBinary((UUID)object);
                    break;
                }
                try {
                    if (object instanceof String) {
                        object = type.convertToDefaultType(this.session, object);
                        break;
                    }
                }
                catch (HsqlException hsqlException) {
                    throw JDBCUtil.sqlException(hsqlException);
                }
                throw JDBCUtil.sqlException(5563);
            }
            case 50: {
                if (object instanceof Array) {
                    this.setArray(n2, (Array)object);
                    return;
                }
                if (object instanceof ArrayList) {
                    object = ((ArrayList)object).toArray();
                }
                if (object instanceof Object[]) {
                    Type type2 = type.collectionBaseType();
                    Object object2 = object;
                    Object[] objectArray = new Object[((Object[])object2).length];
                    for (int i2 = 0; i2 < objectArray.length; ++i2) {
                        objectArray[i2] = type2.convertJavaToSQL(this.session, object2[i2]);
                    }
                    object = objectArray;
                    break;
                }
                throw JDBCUtil.sqlException(5563);
            }
            case 30: {
                this.setBlobParameter(n2, object);
                return;
            }
            case 40: {
                this.setClobParameter(n2, object);
                return;
            }
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                try {
                    if (object instanceof String) {
                        object = type.convertToType(this.session, object, Type.SQL_VARCHAR);
                        break;
                    }
                    object = type.convertJavaToSQL(this.session, object);
                    break;
                }
                catch (HsqlException hsqlException) {
                    throw JDBCUtil.sqlException(hsqlException);
                }
            }
            case -6: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 25: {
                try {
                    if (object instanceof String) {
                        object = type.convertToType(this.session, object, Type.SQL_VARCHAR);
                        break;
                    }
                    if (object instanceof Boolean) {
                        boolean bl = (Boolean)object;
                        object = bl ? Integer.valueOf(1) : Integer.valueOf(0);
                    }
                    object = type.convertToDefaultType(this.session, object);
                    break;
                }
                catch (HsqlException hsqlException) {
                    throw JDBCUtil.sqlException(hsqlException);
                }
            }
            case 12: {
                if (object instanceof String) break;
                try {
                    object = type.convertToDefaultType(this.session, object);
                    break;
                }
                catch (HsqlException hsqlException) {
                    throw JDBCUtil.sqlException(hsqlException);
                }
            }
            case 1: {
                if (object instanceof String) break;
                if (type.precision == 1L) {
                    if (object instanceof Character) {
                        object = String.valueOf(((Character)object).charValue());
                        break;
                    }
                    if (object instanceof Boolean) {
                        object = (Boolean)object != false ? "1" : "0";
                        break;
                    }
                }
                try {
                    object = type.convertToDefaultType(this.session, object);
                    break;
                }
                catch (HsqlException hsqlException) {
                    throw JDBCUtil.sqlException(hsqlException);
                }
            }
            default: {
                try {
                    if (type.isIntervalType()) {
                        object = type.convertJavaToSQL(this.session, object);
                        break;
                    }
                    object = type.convertToDefaultType(this.session, object);
                    break;
                }
                catch (HsqlException hsqlException) {
                    throw JDBCUtil.sqlException(hsqlException);
                }
            }
        }
        this.parameterValues[n3] = object;
        this.parameterSet[n3] = true;
    }

    void setClobParameter(int n2, Object object) throws SQLException {
        this.setClobParameter(n2, object, 0L);
    }

    void setClobParameter(int n2, Object object, long l2) throws SQLException {
        if (object instanceof JDBCClobClient) {
            JDBCClobClient jDBCClobClient = (JDBCClobClient)object;
            if (!jDBCClobClient.session.getDatabaseUniqueName().equals(this.session.getDatabaseUniqueName())) {
                l2 = jDBCClobClient.length();
                Reader reader = jDBCClobClient.getCharacterStream();
                this.parameterValues[n2 - 1] = reader;
                this.streamLengths[n2 - 1] = l2;
                this.parameterSet[n2 - 1] = true;
                return;
            }
            this.parameterValues[n2 - 1] = object;
            this.parameterSet[n2 - 1] = Boolean.TRUE;
            return;
        }
        if (object instanceof Clob) {
            this.parameterValues[n2 - 1] = object;
            this.parameterSet[n2 - 1] = Boolean.TRUE;
            return;
        }
        if (object instanceof ClobInputStream) {
            ClobInputStream clobInputStream = (ClobInputStream)object;
            if (clobInputStream.session.getDatabaseUniqueName().equals(this.session.getDatabaseUniqueName())) {
                throw JDBCUtil.sqlException(423, "invalid Reader");
            }
            this.parameterValues[n2 - 1] = object;
            this.streamLengths[n2 - 1] = l2;
            this.parameterSet[n2 - 1] = true;
            return;
        }
        if (object instanceof Reader) {
            this.parameterValues[n2 - 1] = object;
            this.streamLengths[n2 - 1] = l2;
            this.parameterSet[n2 - 1] = true;
            return;
        }
        if (object instanceof String) {
            JDBCClob jDBCClob = new JDBCClob((String)object);
            this.parameterValues[n2 - 1] = jDBCClob;
            this.parameterSet[n2 - 1] = true;
            return;
        }
        throw JDBCUtil.invalidArgument();
    }

    void setBlobParameter(int n2, Object object) throws SQLException {
        this.setBlobParameter(n2, object, 0L);
    }

    void setBlobParameter(int n2, Object object, long l2) throws SQLException {
        if (object instanceof JDBCBlobClient) {
            JDBCBlobClient jDBCBlobClient = (JDBCBlobClient)object;
            if (!jDBCBlobClient.session.getDatabaseUniqueName().equals(this.session.getDatabaseUniqueName())) {
                l2 = jDBCBlobClient.length();
                InputStream inputStream = jDBCBlobClient.getBinaryStream();
                this.parameterValues[n2 - 1] = inputStream;
                this.streamLengths[n2 - 1] = l2;
                this.parameterSet[n2 - 1] = true;
                return;
            }
            this.parameterValues[n2 - 1] = object;
            this.parameterSet[n2 - 1] = Boolean.TRUE;
            return;
        }
        if (object instanceof Blob) {
            this.parameterValues[n2 - 1] = object;
            this.parameterSet[n2 - 1] = true;
            return;
        }
        if (object instanceof BlobInputStream) {
            BlobInputStream blobInputStream = (BlobInputStream)object;
            if (blobInputStream.session.getDatabaseUniqueName().equals(this.session.getDatabaseUniqueName())) {
                throw JDBCUtil.sqlException(423, "invalid Reader");
            }
            this.parameterValues[n2 - 1] = object;
            this.streamLengths[n2 - 1] = l2;
            this.parameterSet[n2 - 1] = true;
            return;
        }
        if (object instanceof InputStream) {
            this.parameterValues[n2 - 1] = object;
            this.streamLengths[n2 - 1] = l2;
            this.parameterSet[n2 - 1] = true;
            return;
        }
        if (object instanceof byte[]) {
            JDBCBlob jDBCBlob = new JDBCBlob((byte[])object);
            this.parameterValues[n2 - 1] = jDBCBlob;
            this.parameterSet[n2 - 1] = true;
            return;
        }
        throw JDBCUtil.invalidArgument();
    }

    void setIntParameter(int n2, int n3) throws SQLException {
        this.checkSetParameterIndex(n2);
        int n4 = n2 - 1;
        int n5 = this.parameterTypes[n4].typeCode;
        switch (n5) {
            case -6: 
            case 4: 
            case 5: {
                Integer n6 = n3;
                this.parameterValues[n4] = n6;
                this.parameterSet[n4] = true;
                break;
            }
            case 25: {
                Long l2 = n3;
                this.parameterValues[n4] = l2;
                this.parameterSet[n4] = true;
                break;
            }
            case 60: 
            case 61: 
            case 1111: {
                throw JDBCUtil.sqlException(5563);
            }
            default: {
                this.setParameter(n2, n3);
            }
        }
    }

    void setLongParameter(int n2, long l2) throws SQLException {
        this.checkSetParameterIndex(n2);
        int n3 = n2 - 1;
        int n4 = this.parameterTypes[n3].typeCode;
        switch (n4) {
            case 25: {
                Long l3 = l2;
                this.parameterValues[n3] = l3;
                this.parameterSet[n3] = true;
                break;
            }
            case 60: 
            case 61: 
            case 1111: {
                throw JDBCUtil.sqlException(5563);
            }
            default: {
                this.setParameter(n2, l2);
            }
        }
    }

    private void performPreExecute() throws SQLException, HsqlException {
        if (!this.hasLOBs) {
            return;
        }
        for (int i2 = 0; i2 < this.parameterValues.length; ++i2) {
            ResultLob resultLob;
            Closeable closeable;
            ResultLob resultLob2;
            Closeable closeable2;
            long l2;
            long l3;
            LobData lobData;
            Object object = this.parameterValues[i2];
            if (object == null) continue;
            if (this.parameterTypes[i2].typeCode == 30) {
                lobData = null;
                if (object instanceof JDBCBlobClient) {
                    lobData = ((JDBCBlobClient)object).blob;
                    l3 = ((BlobDataID)lobData).getId();
                } else if (object instanceof Blob) {
                    l2 = ((Blob)object).length();
                    lobData = this.session.createBlob(l2);
                    l3 = ((BlobDataID)lobData).getId();
                    closeable2 = ((Blob)object).getBinaryStream();
                    resultLob2 = ResultLob.newLobCreateBlobRequest(this.session.getId(), l3, (InputStream)closeable2, l2);
                    this.session.allocateResultLob(resultLob2);
                    this.resultOut.addLobResult(resultLob2);
                } else if (object instanceof InputStream) {
                    l2 = this.streamLengths[i2];
                    long l4 = l2 > 0L ? l2 : 0L;
                    lobData = this.session.createBlob(l4);
                    l3 = ((BlobDataID)lobData).getId();
                    closeable = (InputStream)object;
                    resultLob = ResultLob.newLobCreateBlobRequest(this.session.getId(), l3, closeable, l2);
                    this.session.allocateResultLob(resultLob);
                    this.resultOut.addLobResult(resultLob);
                } else if (object instanceof BlobDataID) {
                    lobData = (BlobDataID)object;
                }
                this.parameterValues[i2] = lobData;
                continue;
            }
            if (this.parameterTypes[i2].typeCode != 40) continue;
            lobData = null;
            if (object instanceof JDBCClobClient) {
                lobData = ((JDBCClobClient)object).clob;
                l3 = ((ClobDataID)lobData).getId();
            } else if (object instanceof Clob) {
                l2 = ((Clob)object).length();
                closeable2 = ((Clob)object).getCharacterStream();
                lobData = this.session.createClob(l2);
                l3 = ((ClobDataID)lobData).getId();
                resultLob2 = ResultLob.newLobCreateClobRequest(this.session.getId(), l3, closeable2, l2);
                this.session.allocateResultLob(resultLob2);
                this.resultOut.addLobResult(resultLob2);
            } else if (object instanceof Reader) {
                l2 = this.streamLengths[i2];
                long l5 = l2 > 0L ? l2 : 0L;
                lobData = this.session.createClob(l5);
                l3 = ((ClobDataID)lobData).getId();
                closeable = (Reader)object;
                resultLob = ResultLob.newLobCreateClobRequest(this.session.getId(), l3, (Reader)closeable, l2);
                this.session.allocateResultLob(resultLob);
                this.resultOut.addLobResult(resultLob);
            } else if (object instanceof ClobDataID) {
                lobData = (ClobDataID)object;
            }
            this.parameterValues[i2] = lobData;
        }
    }

    void fetchResult() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        this.closeResultData();
        this.checkParametersSet();
        if (this.isBatch) {
            throw JDBCUtil.sqlExceptionSQL(1255);
        }
        if (this.isResult) {
            this.resultOut.setPreparedResultUpdateProperties(this.parameterValues);
        } else {
            this.resultOut.setPreparedExecuteProperties(this.parameterValues, this.maxRows, this.fetchSize, this.rsProperties, this.queryTimeout);
        }
        try {
            this.performPreExecute();
            this.resultIn = this.session.execute(this.resultOut);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
        finally {
            this.performPostExecute();
        }
        if (this.resultIn.mode == 2) {
            throw JDBCUtil.sqlException(this.resultIn);
        }
        if (this.resultIn.isData()) {
            this.currentResultSet = new JDBCResultSet(this.connection, this, this.resultIn, this.resultIn.metaData);
        } else if (this.statementRetType == 2) {
            this.getMoreResults();
        }
    }

    @Override
    void performPostExecute() throws SQLException {
        super.performPostExecute();
    }

    public String getSQL() {
        return this.sql;
    }

    public long getStatementID() {
        return this.statementID;
    }

    public boolean isRowCount() {
        return this.statementRetType == 1;
    }

    public JDBCResultSetMetaData getResultSetMetaData() {
        return this.resultSetMetaData;
    }

    public ResultMetaData getParameterMetaDataDirect() {
        return this.parameterMetaData;
    }
}

