/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.sql.Wrapper;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.Type;

public class JDBCParameterMetaData
implements ParameterMetaData,
Wrapper {
    ResultMetaData rmd;
    int parameterCount;
    private boolean translateTTIType;

    @Override
    public int getParameterCount() throws SQLException {
        return this.parameterCount;
    }

    @Override
    public int isNullable(int n2) throws SQLException {
        this.checkRange(n2);
        return 2;
    }

    @Override
    public boolean isSigned(int n2) throws SQLException {
        this.checkRange(n2);
        Type type = this.translateType(this.rmd.columnTypes[--n2]);
        return type.isNumberType();
    }

    @Override
    public int getPrecision(int n2) throws SQLException {
        this.checkRange(n2);
        Type type = this.translateType(this.rmd.columnTypes[--n2]);
        if (type.isDateTimeType()) {
            return type.displaySize();
        }
        long l2 = type.precision;
        if (l2 > Integer.MAX_VALUE) {
            l2 = 0L;
        }
        return (int)l2;
    }

    @Override
    public int getScale(int n2) throws SQLException {
        this.checkRange(n2);
        Type type = this.translateType(this.rmd.columnTypes[--n2]);
        return type.scale;
    }

    @Override
    public int getParameterType(int n2) throws SQLException {
        this.checkRange(n2);
        Type type = this.translateType(this.rmd.columnTypes[--n2]);
        return type.getJDBCTypeCode();
    }

    @Override
    public String getParameterTypeName(int n2) throws SQLException {
        this.checkRange(n2);
        Type type = this.translateType(this.rmd.columnTypes[--n2]);
        return type.getNameString();
    }

    @Override
    public String getParameterClassName(int n2) throws SQLException {
        this.checkRange(n2);
        Type type = this.translateType(this.rmd.columnTypes[--n2]);
        return type.getJDBCClassName();
    }

    @Override
    public int getParameterMode(int n2) throws SQLException {
        this.checkRange(n2);
        return this.rmd.paramModes[--n2];
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (this.isWrapperFor(clazz)) {
            return (T)this;
        }
        throw JDBCUtil.invalidArgument("iface: " + clazz);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return clazz != null && clazz.isAssignableFrom(this.getClass());
    }

    JDBCParameterMetaData(JDBCConnection jDBCConnection, ResultMetaData resultMetaData) {
        this.rmd = resultMetaData;
        this.parameterCount = this.rmd.getColumnCount();
        this.translateTTIType = jDBCConnection.isTranslateTTIType;
    }

    private Type translateType(Type type) {
        if (this.translateTTIType && type.isIntervalType()) {
            type = ((IntervalType)type).getCharacterType();
        }
        return type;
    }

    void checkRange(int n2) throws SQLException {
        if (n2 < 1 || n2 > this.parameterCount) {
            String string = n2 + " is out of range";
            throw JDBCUtil.outOfRangeArgument(string);
        }
    }

    public String toString() {
        try {
            return this.toStringImpl();
        }
        catch (Throwable throwable) {
            return super.toString() + "[toStringImpl_exception=" + throwable + "]";
        }
    }

    private String toStringImpl() throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        int n2 = this.getParameterCount();
        if (n2 == 0) {
            stringBuilder.append("[parameterCount=0]");
            return stringBuilder.toString();
        }
        Method[] methodArray = this.getClass().getDeclaredMethods();
        stringBuilder.append('[');
        int n3 = methodArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append('\n');
            stringBuilder.append("    parameter_");
            stringBuilder.append(i2 + 1);
            stringBuilder.append('=');
            stringBuilder.append('[');
            for (int i3 = 0; i3 < n3; ++i3) {
                Method method = methodArray[i3];
                if (!Modifier.isPublic(method.getModifiers()) || method.getParameterTypes().length != 1) continue;
                stringBuilder.append(method.getName());
                stringBuilder.append('=');
                stringBuilder.append(method.invoke((Object)this, i2 + 1));
                if (i3 + 1 >= n3) continue;
                stringBuilder.append(',');
                stringBuilder.append(' ');
            }
            stringBuilder.append(']');
            if (i2 + 1 >= n2) continue;
            stringBuilder.append(',');
            stringBuilder.append(' ');
        }
        stringBuilder.append('\n');
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

