/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.Executor;
import org.hsqldb.ClientConnection;
import org.hsqldb.ClientConnectionHTTP;
import org.hsqldb.DatabaseManager;
import org.hsqldb.DatabaseURL;
import org.hsqldb.HsqlException;
import org.hsqldb.SessionInterface;
import org.hsqldb.jdbc.JDBCArray;
import org.hsqldb.jdbc.JDBCBlob;
import org.hsqldb.jdbc.JDBCCallableStatement;
import org.hsqldb.jdbc.JDBCClob;
import org.hsqldb.jdbc.JDBCConnectionEventListener;
import org.hsqldb.jdbc.JDBCDatabaseMetaData;
import org.hsqldb.jdbc.JDBCNClob;
import org.hsqldb.jdbc.JDBCPreparedStatement;
import org.hsqldb.jdbc.JDBCSQLXML;
import org.hsqldb.jdbc.JDBCSavepoint;
import org.hsqldb.jdbc.JDBCStatement;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.result.ResultProperties;
import org.hsqldb.types.ArrayType;
import org.hsqldb.types.Type;

public class JDBCConnection
implements Connection {
    TimeZone timeZone = TimeZone.getDefault();
    int rsHoldability = 1;
    HsqlProperties connProperties;
    HsqlProperties clientProperties;
    SessionInterface sessionProxy;
    boolean isInternal;
    protected boolean isNetConn;
    boolean isClosed;
    private SQLWarning rootWarning;
    private final Object rootWarning_mutex = new Object();
    private int savepointIDSequence;
    int incarnation;
    boolean isPooled;
    JDBCConnectionEventListener poolEventListener;
    boolean isCloseResultSet;
    boolean isDefaultSchema;
    boolean isMemoryLobs;
    boolean isUseColumnName = true;
    boolean isTranslateTTIType = true;
    boolean isAllowEmptyBatch = false;
    boolean isStoreLiveObject = false;

    @Override
    public synchronized Statement createStatement() throws SQLException {
        this.checkClosed();
        int n2 = ResultProperties.getValueForJDBC(1003, 1007, this.rsHoldability);
        JDBCStatement jDBCStatement = new JDBCStatement(this, n2);
        return jDBCStatement;
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCPreparedStatement(this, string, 1003, 1007, this.rsHoldability, 2, null, null);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized CallableStatement prepareCall(String string) throws SQLException {
        this.checkClosed();
        try {
            JDBCCallableStatement jDBCCallableStatement = new JDBCCallableStatement(this, string, 1003, 1007, this.rsHoldability);
            return jDBCCallableStatement;
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized String nativeSQL(String string) throws SQLException {
        this.checkClosed();
        if (string == null || string.isEmpty() || string.indexOf(123) == -1) {
            return string;
        }
        boolean bl = false;
        int n2 = 0;
        int n3 = string.length();
        int n4 = 0;
        StringBuilder stringBuilder = null;
        int n5 = 0;
        block6: for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = string.charAt(i2);
            switch (n2) {
                case 0: {
                    if (c2 == '\'') {
                        n2 = 1;
                        continue block6;
                    }
                    if (c2 == '\"') {
                        n2 = 2;
                        continue block6;
                    }
                    if (c2 != '{') continue block6;
                    if (stringBuilder == null) {
                        stringBuilder = new StringBuilder(string.length());
                    }
                    stringBuilder.append(string, n5, i2);
                    n5 = i2 = this.onStartEscapeSequence(string, stringBuilder, i2);
                    bl = true;
                    ++n4;
                    n2 = 3;
                    continue block6;
                }
                case 1: 
                case 4: {
                    if (c2 != '\'') continue block6;
                    --n2;
                    continue block6;
                }
                case 2: 
                case 5: {
                    if (c2 != '\"') continue block6;
                    n2 -= 2;
                    continue block6;
                }
                case 3: {
                    if (c2 == '\'') {
                        n2 = 4;
                        continue block6;
                    }
                    if (c2 == '\"') {
                        n2 = 5;
                        continue block6;
                    }
                    if (c2 == '}') {
                        stringBuilder.append(string, n5, i2);
                        stringBuilder.append(' ');
                        n5 = ++i2;
                        bl = true;
                        n2 = --n4 == 0 ? 0 : 3;
                        continue block6;
                    }
                    if (c2 != '{') continue block6;
                    stringBuilder.append(string, n5, i2);
                    n5 = i2 = this.onStartEscapeSequence(string, stringBuilder, i2);
                    bl = true;
                    ++n4;
                    n2 = 3;
                    continue block6;
                }
            }
        }
        if (!bl) {
            return string;
        }
        stringBuilder.append(string.substring(n5));
        return stringBuilder.toString();
    }

    @Override
    public synchronized void setAutoCommit(boolean bl) throws SQLException {
        this.checkClosed();
        try {
            this.sessionProxy.setAutoCommit(bl);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized boolean getAutoCommit() throws SQLException {
        this.checkClosed();
        try {
            return this.sessionProxy.isAutoCommit();
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized void commit() throws SQLException {
        this.checkClosed();
        try {
            this.sessionProxy.commit(false);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized void rollback() throws SQLException {
        this.checkClosed();
        try {
            this.sessionProxy.rollback(false);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.isInternal || this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.rootWarning = null;
        this.connProperties = null;
        if (this.isPooled) {
            if (this.poolEventListener != null) {
                this.poolEventListener.connectionClosed();
                this.poolEventListener = null;
            }
        } else if (this.sessionProxy != null) {
            this.sessionProxy.close();
            this.sessionProxy = null;
        }
    }

    @Override
    public synchronized boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return new JDBCDatabaseMetaData(this);
    }

    @Override
    public synchronized void setReadOnly(boolean bl) throws SQLException {
        this.checkClosed();
        try {
            this.sessionProxy.setReadOnlyDefault(bl);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized boolean isReadOnly() throws SQLException {
        this.checkClosed();
        try {
            return this.sessionProxy.isReadOnlyDefault();
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized void setCatalog(String string) throws SQLException {
        this.checkClosed();
        try {
            this.sessionProxy.setAttribute(3, string);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized String getCatalog() throws SQLException {
        this.checkClosed();
        try {
            return (String)this.sessionProxy.getAttribute(3);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized void setTransactionIsolation(int n2) throws SQLException {
        this.checkClosed();
        switch (n2) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                throw JDBCUtil.invalidArgument();
            }
        }
        try {
            this.sessionProxy.setIsolationDefault(n2);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized int getTransactionIsolation() throws SQLException {
        this.checkClosed();
        try {
            return this.sessionProxy.getIsolation();
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return this.rootWarning;
    }

    @Override
    public synchronized void clearWarnings() throws SQLException {
        this.checkClosed();
        this.rootWarning = null;
    }

    @Override
    public synchronized Statement createStatement(int n2, int n3) throws SQLException {
        this.checkClosed();
        int n4 = ResultProperties.getValueForJDBC(n2, n3, this.rsHoldability);
        return new JDBCStatement(this, n4);
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string, int n2, int n3) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCPreparedStatement(this, string, n2, n3, this.rsHoldability, 2, null, null);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized CallableStatement prepareCall(String string, int n2, int n3) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCCallableStatement(this, string, n2, n3, this.rsHoldability);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized Map<String, Class<?>> getTypeMap() throws SQLException {
        this.checkClosed();
        return new HashMap();
    }

    @Override
    public synchronized void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.checkClosed();
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized void setHoldability(int n2) throws SQLException {
        this.checkClosed();
        switch (n2) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw JDBCUtil.invalidArgument();
            }
        }
        this.rsHoldability = n2;
    }

    @Override
    public synchronized int getHoldability() throws SQLException {
        this.checkClosed();
        return this.rsHoldability;
    }

    @Override
    public synchronized Savepoint setSavepoint() throws SQLException {
        this.checkClosed();
        if (this.getAutoCommit()) {
            throw JDBCUtil.sqlException(4821);
        }
        JDBCSavepoint jDBCSavepoint = new JDBCSavepoint(this);
        try {
            this.sessionProxy.savepoint(jDBCSavepoint.name);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
        return jDBCSavepoint;
    }

    @Override
    public synchronized Savepoint setSavepoint(String string) throws SQLException {
        this.checkClosed();
        if (this.getAutoCommit()) {
            throw JDBCUtil.sqlException(4821);
        }
        if (string == null) {
            throw JDBCUtil.nullArgument();
        }
        if (string.startsWith("SYSTEM_SAVEPOINT_")) {
            throw JDBCUtil.invalidArgument();
        }
        try {
            this.sessionProxy.savepoint(string);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
        return new JDBCSavepoint(string, this);
    }

    @Override
    public synchronized void rollback(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        if (savepoint == null) {
            throw JDBCUtil.nullArgument();
        }
        if (!(savepoint instanceof JDBCSavepoint)) {
            throw JDBCUtil.invalidArgument(4821);
        }
        JDBCSavepoint jDBCSavepoint = (JDBCSavepoint)savepoint;
        if (jDBCSavepoint.name == null) {
            throw JDBCUtil.invalidArgument(4821);
        }
        if (this != jDBCSavepoint.connection) {
            throw JDBCUtil.invalidArgument(4821);
        }
        if (this.getAutoCommit()) {
            jDBCSavepoint.name = null;
            jDBCSavepoint.connection = null;
            throw JDBCUtil.sqlException(4821);
        }
        try {
            this.sessionProxy.rollbackToSavepoint(jDBCSavepoint.name);
            jDBCSavepoint.connection = null;
            jDBCSavepoint.name = null;
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        if (savepoint == null) {
            throw JDBCUtil.nullArgument();
        }
        if (!(savepoint instanceof JDBCSavepoint)) {
            throw JDBCUtil.invalidArgument(4821);
        }
        JDBCSavepoint jDBCSavepoint = (JDBCSavepoint)savepoint;
        if (jDBCSavepoint.name == null) {
            throw JDBCUtil.invalidArgument(4821);
        }
        if (this != jDBCSavepoint.connection) {
            throw JDBCUtil.invalidArgument(4821);
        }
        if (this.getAutoCommit()) {
            jDBCSavepoint.name = null;
            jDBCSavepoint.connection = null;
            throw JDBCUtil.invalidArgument(4821);
        }
        try {
            this.sessionProxy.releaseSavepoint(jDBCSavepoint.name);
            jDBCSavepoint.connection = null;
            jDBCSavepoint.name = null;
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized Statement createStatement(int n2, int n3, int n4) throws SQLException {
        this.checkClosed();
        int n5 = ResultProperties.getValueForJDBC(n2, n3, n4);
        return new JDBCStatement(this, n5);
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string, int n2, int n3, int n4) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCPreparedStatement(this, string, n2, n3, n4, 2, null, null);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized CallableStatement prepareCall(String string, int n2, int n3, int n4) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCCallableStatement(this, string, n2, n3, n4);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string, int n2) throws SQLException {
        this.checkClosed();
        try {
            if (n2 != 1 && n2 != 2 && n2 != 31) {
                throw JDBCUtil.invalidArgument("autoGeneratedKeys");
            }
            return new JDBCPreparedStatement(this, string, 1003, 1007, this.rsHoldability, n2, null, null);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCPreparedStatement(this, string, 1003, 1007, this.rsHoldability, 21, nArray, null);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        this.checkClosed();
        try {
            return new JDBCPreparedStatement(this, string, 1003, 1007, this.rsHoldability, 11, null, stringArray);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        this.checkClosed();
        return new JDBCClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.checkClosed();
        return new JDBCBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.checkClosed();
        return new JDBCNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.checkClosed();
        return new JDBCSQLXML();
    }

    @Override
    public boolean isValid(int n2) throws SQLException {
        if (n2 < 0) {
            throw JDBCUtil.outOfRangeArgument("timeout: " + n2);
        }
        if (this.isInternal) {
            return true;
        }
        if (!this.isNetConn) {
            return !this.isClosed();
        }
        if (this.isClosed()) {
            return false;
        }
        final boolean[] blArray = new boolean[]{true};
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    JDBCConnection.this.getMetaData().getDatabaseMajorVersion();
                }
                catch (Throwable throwable) {
                    blArray[0] = false;
                }
            }
        };
        if (n2 > 60) {
            n2 = 60;
        }
        n2 *= 1000;
        try {
            thread.start();
            long l2 = System.currentTimeMillis();
            thread.join(n2);
            try {
                thread.setContextClassLoader(null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (n2 == 0) {
                return blArray[0];
            }
            return blArray[0] && System.currentTimeMillis() - l2 < (long)n2;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        SQLClientInfoException sQLClientInfoException = new SQLClientInfoException();
        sQLClientInfoException.initCause(JDBCUtil.notSupported());
        throw sQLClientInfoException;
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        if (!this.isClosed && (properties == null || properties.isEmpty())) {
            return;
        }
        SQLClientInfoException sQLClientInfoException = new SQLClientInfoException();
        if (this.isClosed) {
            sQLClientInfoException.initCause(JDBCUtil.connectionClosedException());
        } else {
            sQLClientInfoException.initCause(JDBCUtil.notSupported());
        }
        throw sQLClientInfoException;
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        this.checkClosed();
        if (string == null) {
            throw JDBCUtil.nullArgument();
        }
        int n2 = Type.getTypeNr(string = string.toUpperCase());
        if (n2 == Integer.MIN_VALUE) {
            throw JDBCUtil.invalidArgument(string);
        }
        Type type = Type.getDefaultType(n2);
        if (type.isArrayType() || type.isLobType() || type.isRowType()) {
            throw JDBCUtil.invalidArgument(string);
        }
        Object[] objectArray2 = new Object[objectArray.length];
        try {
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Object object = type.convertJavaToSQL(this.sessionProxy, objectArray[i2]);
                objectArray2[i2] = type.convertToTypeLimits(this.sessionProxy, object);
            }
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
        ArrayType arrayType = new ArrayType(type, objectArray2.length);
        return new JDBCArray(objectArray2, type, (Type)arrayType, this);
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        this.checkClosed();
        throw JDBCUtil.notSupported();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        this.checkClosed();
        if (this.isWrapperFor(clazz)) {
            return (T)this;
        }
        throw JDBCUtil.invalidArgument("iface: " + clazz);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        this.checkClosed();
        return clazz != null && clazz.isAssignableFrom(this.getClass());
    }

    @Override
    public synchronized void setSchema(String string) throws SQLException {
        this.checkClosed();
        if (string == null) {
            throw JDBCUtil.nullArgument("schema");
        }
        if (string.length() == 0) {
            throw JDBCUtil.invalidArgument("Zero-length schema");
        }
        new JDBCDatabaseMetaData(this).setConnectionDefaultSchema(string);
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkClosed();
        return new JDBCDatabaseMetaData(this).getConnectionDefaultSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (executor == null) {
            throw JDBCUtil.nullArgument("executor");
        }
        this.close();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int n2) throws SQLException {
        this.checkClosed();
        throw JDBCUtil.notSupported();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return 0;
    }

    public JDBCConnection(HsqlProperties hsqlProperties) throws SQLException {
        String string = hsqlProperties.getProperty("user");
        String string2 = hsqlProperties.getProperty("password");
        String string3 = hsqlProperties.getProperty("connection_type");
        String string4 = hsqlProperties.getProperty("host");
        int n2 = hsqlProperties.getIntegerProperty("port", 0);
        String string5 = hsqlProperties.getProperty("path");
        String string6 = hsqlProperties.getProperty("database");
        boolean bl = "hsqls://".equals(string3) || "https://".equals(string3);
        boolean bl2 = hsqlProperties.isPropertyTrue("tls_wrapper", false);
        bl2 &= bl;
        if (string == null) {
            string = "SA";
        }
        if (string2 == null) {
            string2 = "";
        }
        try {
            if (DatabaseURL.isInProcessDatabaseType(string3)) {
                this.sessionProxy = DatabaseManager.newSession(string3, string6, string, string2, hsqlProperties, this.timeZone);
            } else if ("hsql://".equals(string3) || "hsqls://".equals(string3)) {
                this.sessionProxy = new ClientConnection(string4, n2, string5, string6, bl, bl2, string, string2, this.timeZone);
                this.isNetConn = true;
            } else if ("http://".equals(string3) || "https://".equals(string3)) {
                this.sessionProxy = new ClientConnectionHTTP(string4, n2, string5, string6, bl, bl2, string, string2, this.timeZone);
                this.isNetConn = true;
            } else {
                throw JDBCUtil.invalidArgument(string3);
            }
            this.sessionProxy.setJDBCConnection(this);
            this.connProperties = hsqlProperties;
            this.clientProperties = this.sessionProxy.getClientProperties();
            this.setLocalVariables();
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    public JDBCConnection(SessionInterface sessionInterface) {
        this.isInternal = true;
        this.sessionProxy = sessionInterface;
    }

    public JDBCConnection(JDBCConnection jDBCConnection, JDBCConnectionEventListener jDBCConnectionEventListener) {
        this.sessionProxy = jDBCConnection.sessionProxy;
        this.connProperties = jDBCConnection.connProperties;
        this.clientProperties = jDBCConnection.clientProperties;
        this.isPooled = true;
        this.poolEventListener = jDBCConnectionEventListener;
        this.setLocalVariables();
    }

    private void setLocalVariables() {
        String string;
        if (this.connProperties == null) {
            return;
        }
        this.isMemoryLobs = this.connProperties.isPropertyTrue("memory_lobs", false);
        this.isCloseResultSet = this.connProperties.isPropertyTrue("close_result", false);
        this.isDefaultSchema = this.connProperties.isPropertyTrue("default_schema", false);
        this.isAllowEmptyBatch = this.connProperties.isPropertyTrue("allow_empty_batch", false);
        this.isUseColumnName = this.connProperties.isPropertyTrue("get_column_name", true);
        this.isTranslateTTIType = this.clientProperties.isPropertyTrue("jdbc.translate_tti_types", true);
        this.isStoreLiveObject = this.clientProperties.isPropertyTrue("sql.live_object", false);
        if (this.isStoreLiveObject && !"mem:".equals(string = this.connProperties.getProperty("connection_type"))) {
            this.isStoreLiveObject = false;
        }
    }

    synchronized int getSavepointID() {
        return this.savepointIDSequence++;
    }

    public synchronized String getURL() throws SQLException {
        this.checkClosed();
        return this.isInternal ? this.sessionProxy.getInternalConnectionURL() : this.connProperties.getProperty("url");
    }

    synchronized void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw JDBCUtil.connectionClosedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addWarning(SQLWarning sQLWarning) {
        Object object = this.rootWarning_mutex;
        synchronized (object) {
            if (this.rootWarning == null) {
                this.rootWarning = sQLWarning;
            } else {
                this.rootWarning.setNextWarning(sQLWarning);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setWarnings(SQLWarning sQLWarning) {
        Object object = this.rootWarning_mutex;
        synchronized (object) {
            this.rootWarning = sQLWarning;
        }
    }

    public void reset() throws SQLException {
        try {
            ++this.incarnation;
            this.sessionProxy.resetSession();
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(1305, hsqlException.getMessage(), hsqlException);
        }
    }

    public void closeFully() {
        try {
            this.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (this.sessionProxy != null) {
                this.sessionProxy.close();
                this.sessionProxy = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public SessionInterface getSession() {
        return this.sessionProxy;
    }

    private int onStartEscapeSequence(String string, StringBuilder stringBuilder, int n2) throws SQLException {
        stringBuilder.append(' ');
        ++n2;
        n2 = StringUtil.skipSpaces(string, n2);
        if (string.regionMatches(true, n2, "fn ", 0, 3) || string.regionMatches(true, n2, "oj ", 0, 3)) {
            n2 += 2;
        } else if (string.regionMatches(true, n2, "ts ", 0, 3)) {
            stringBuilder.append("TIMESTAMP");
            n2 += 2;
        } else if (string.regionMatches(true, n2, "d ", 0, 2)) {
            stringBuilder.append("DATE");
            ++n2;
        } else if (string.regionMatches(true, n2, "t ", 0, 2)) {
            stringBuilder.append("TIME");
            ++n2;
        } else if (string.regionMatches(true, n2, "call ", 0, 5)) {
            stringBuilder.append("CALL");
            n2 += 4;
        } else if (string.regionMatches(true, n2, "?= call ", 0, 8)) {
            stringBuilder.append("CALL");
            n2 += 7;
        } else if (string.regionMatches(true, n2, "? = call ", 0, 8)) {
            stringBuilder.append("CALL");
            n2 += 8;
        } else if (string.regionMatches(true, n2, "escape ", 0, 7)) {
            n2 += 6;
        } else {
            throw JDBCUtil.sqlException(425, string.substring(--n2));
        }
        return n2;
    }

    public boolean isInternal() {
        return this.isInternal;
    }

    public boolean isNetwork() {
        return this.isNetConn;
    }

    public HsqlProperties getConnProperties() {
        HsqlProperties hsqlProperties = new HsqlProperties();
        hsqlProperties.addProperties(this.connProperties);
        return hsqlProperties;
    }
}

