/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Scanner;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.hsqldb.jdbc.JDBCBlobFile;
import org.hsqldb.jdbc.JDBCClob;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.FrameworkLogger;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.InOutUtil;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.List;

public class JDBCClobFile
implements Clob {
    private static final FrameworkLogger LOG = FrameworkLogger.getLog(JDBCClobFile.class);
    public static final String TEMP_FILE_PREFIX = "hsql_jdbc_clob_file_";
    public static final String TEMP_FILE_SUFFIX = ".tmp";
    private final File m_file;
    private boolean m_closed;
    private boolean m_deleteOnFree;
    private String m_encoding;
    private Charset m_charset;
    private CharsetEncoder m_encoder;
    private boolean m_fixedWidthCharset;
    private int m_maxCharWidth;
    private List m_streams = new HsqlArrayList();

    @Override
    public long length() throws SQLException {
        long l2;
        this.checkClosed();
        if (this.m_fixedWidthCharset) {
            return this.m_file.length() / (long)this.m_maxCharWidth;
        }
        ReaderAdapter readerAdapter = null;
        try {
            long l3;
            readerAdapter = new ReaderAdapter(this.m_file, 0L, Long.MAX_VALUE);
            l2 = l3 = readerAdapter.skip(Long.MAX_VALUE);
        }
        catch (IOException iOException) {
            try {
                throw JDBCUtil.sqlException(iOException);
            }
            catch (Throwable throwable) {
                JDBCClobFile.closeSafely(readerAdapter);
                throw throwable;
            }
        }
        JDBCClobFile.closeSafely(readerAdapter);
        return l2;
    }

    @Override
    public String getSubString(long l2, int n2) throws SQLException {
        String string;
        Reader reader = null;
        int n3 = Math.min(8192, n2);
        try {
            reader = this.getCharacterStream(l2, n2);
            CharArrayWriter charArrayWriter = new CharArrayWriter(n3);
            InOutUtil.copy(reader, charArrayWriter, (long)n2);
            string = charArrayWriter.toString();
        }
        catch (IOException iOException) {
            try {
                throw JDBCUtil.sqlException(iOException);
            }
            catch (Throwable throwable) {
                JDBCClobFile.closeSafely(reader);
                throw throwable;
            }
        }
        JDBCClobFile.closeSafely(reader);
        return string;
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        return this.getCharacterStream(1L, Long.MAX_VALUE);
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        JDBCBlobFile.InputStreamAdapter inputStreamAdapter;
        final List list = this.m_streams;
        try {
            inputStreamAdapter = new JDBCBlobFile.InputStreamAdapter(this.m_file, 0L, Long.MAX_VALUE){
                private boolean closed;
                private InputStream self;
                {
                    super(file, l2, l3);
                    this.self = this;
                }

                @Override
                public synchronized void close() throws IOException {
                    if (this.closed) {
                        return;
                    }
                    this.closed = true;
                    try {
                        super.close();
                    }
                    finally {
                        list.remove(this.self);
                    }
                }
            };
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw JDBCUtil.sqlException(fileNotFoundException);
        }
        catch (IOException iOException) {
            throw JDBCUtil.sqlException(iOException);
        }
        catch (SecurityException securityException) {
            throw JDBCUtil.sqlException(securityException);
        }
        catch (NullPointerException nullPointerException) {
            throw JDBCUtil.sqlException(nullPointerException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw JDBCUtil.sqlException(illegalArgumentException);
        }
        list.add(inputStreamAdapter);
        return inputStreamAdapter;
    }

    public long position(char[] cArray, long l2) throws SQLException {
        if (l2 < 1L) {
            throw JDBCUtil.outOfRangeArgument("start: " + l2);
        }
        if (cArray == null || cArray.length == 0) {
            return -1L;
        }
        long l3 = this.length();
        if (l2 > l3 || (long)cArray.length > l3 || l2 > l3 - (long)cArray.length) {
            return -1L;
        }
        return this.position0(new String(cArray), l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long position0(String string, long l2) throws SQLException {
        Scanner scanner;
        ReaderAdapter readerAdapter;
        Pattern pattern;
        block13: {
            try {
                pattern = Pattern.compile(Pattern.quote(string));
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw JDBCUtil.sqlException(patternSyntaxException);
            }
            readerAdapter = null;
            scanner = null;
            boolean bl = false;
            try {
                readerAdapter = new ReaderAdapter(this.m_file, l2 - 1L, this.m_file.length());
                scanner = new Scanner(readerAdapter);
                bl = true;
                if (bl) break block13;
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    throw JDBCUtil.sqlException(fileNotFoundException);
                    catch (IOException iOException) {
                        throw JDBCUtil.sqlException(iOException);
                    }
                    catch (SecurityException securityException) {
                        throw JDBCUtil.sqlException(securityException);
                    }
                    catch (NullPointerException nullPointerException) {
                        throw JDBCUtil.sqlException(nullPointerException);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw JDBCUtil.sqlException(illegalArgumentException);
                    }
                }
                catch (Throwable throwable) {
                    if (bl) throw throwable;
                    JDBCClobFile.closeSafely(scanner);
                    JDBCClobFile.closeSafely(readerAdapter);
                    throw throwable;
                }
            }
            JDBCClobFile.closeSafely(scanner);
            JDBCClobFile.closeSafely(readerAdapter);
        }
        int n2 = -1;
        try {
            if (!scanner.hasNext()) return n2;
            boolean bl = null != scanner.findWithinHorizon(pattern, 0);
            if (!bl) return n2;
            MatchResult matchResult = scanner.match();
            n2 = matchResult.start() + 1;
            return n2;
        }
        finally {
            JDBCClobFile.closeSafely(scanner);
            JDBCClobFile.closeSafely(readerAdapter);
        }
    }

    @Override
    public long position(String string, long l2) throws SQLException {
        if (l2 < 1L) {
            throw JDBCUtil.outOfRangeArgument("start: " + l2);
        }
        if (string == null || string.isEmpty()) {
            return -1L;
        }
        long l3 = this.length();
        int n2 = string.length();
        if (l2 > l3 || (long)n2 > l3 || l2 > l3 - (long)n2) {
            return -1L;
        }
        return this.position0(string, l2);
    }

    @Override
    public long position(Clob clob, long l2) throws SQLException {
        String string;
        if (l2 < 1L) {
            throw JDBCUtil.outOfRangeArgument("start: " + l2);
        }
        long l3 = clob == null ? 0L : clob.length();
        if (l3 == 0L) {
            return -1L;
        }
        if (l3 > Integer.MAX_VALUE) {
            throw JDBCUtil.outOfRangeArgument("pattern.length(): " + l3);
        }
        long l4 = this.length();
        if (l2 > l4 || l3 > l4 || l2 > l4 - l3) {
            return -1L;
        }
        if (clob instanceof JDBCClob) {
            string = ((JDBCClob)clob).getData();
        } else {
            Reader reader = null;
            StringWriter stringWriter = new StringWriter();
            try {
                reader = clob.getCharacterStream();
                InOutUtil.copy(reader, stringWriter, l3);
            }
            catch (IOException iOException) {
                throw JDBCUtil.sqlException(iOException);
            }
            catch (Throwable throwable) {
                throw JDBCUtil.sqlException(throwable);
            }
            finally {
                JDBCClobFile.closeSafely(reader);
            }
            string = stringWriter.toString();
        }
        return this.position0(string, l2);
    }

    @Override
    public int setString(long l2, String string) throws SQLException {
        return this.setString(l2, string, 0, string == null ? 0 : string.length());
    }

    @Override
    public int setString(long l2, String string, int n2, int n3) throws SQLException {
        this.checkClosed();
        if (string == null) {
            throw JDBCUtil.nullArgument("str");
        }
        int n4 = string.length();
        if (n2 < 0 || n2 > n4) {
            throw JDBCUtil.outOfRangeArgument("offset: " + n2);
        }
        if (n3 < 0 || n3 > n4 - n2) {
            throw JDBCUtil.outOfRangeArgument("len: " + n3);
        }
        if (l2 < 1L) {
            throw JDBCUtil.outOfRangeArgument("pos: " + l2);
        }
        long l3 = this.length();
        if (l2 > l3 + 1L) {
            this.fillSpace(l3 + 1L, l2);
        }
        Writer writer = null;
        try {
            writer = this.setCharacterStream(l2);
            writer.write(string, n2, n3);
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (IOException iOException) {
            throw JDBCUtil.sqlException(iOException);
        }
        catch (Throwable throwable) {
            throw JDBCUtil.sqlException(throwable);
        }
        finally {
            JDBCClobFile.closeSafely(writer);
        }
        return n3;
    }

    private void fillSpace(long l2, long l3) throws SQLException {
        Writer writer = null;
        try {
            writer = this.setCharacterStream(l2);
            for (long i2 = l3 - l2; i2 >= 0L; --i2) {
                writer.append(' ');
            }
        }
        catch (IOException iOException) {
            throw JDBCUtil.sqlException(iOException);
        }
        catch (Throwable throwable) {
            throw JDBCUtil.sqlException(throwable);
        }
        finally {
            JDBCClobFile.closeSafely(writer);
        }
    }

    @Override
    public OutputStream setAsciiStream(long l2) throws SQLException {
        JDBCBlobFile.OutputStreamAdapter outputStreamAdapter;
        if (l2 < 1L) {
            throw JDBCUtil.invalidArgument("pos: " + l2);
        }
        this.checkClosed();
        this.createFile();
        long l3 = this.length();
        if (l2 > l3 + 1L) {
            this.fillSpace(l3 + 1L, l2);
        }
        try {
            outputStreamAdapter = new JDBCBlobFile.OutputStreamAdapter(this.m_file, l2 - 1L){

                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        JDBCClobFile.this.m_streams.remove(this);
                    }
                }
            };
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw JDBCUtil.sqlException(fileNotFoundException);
        }
        catch (IOException iOException) {
            throw JDBCUtil.sqlException(iOException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw JDBCUtil.sqlException(illegalArgumentException);
        }
        catch (NullPointerException nullPointerException) {
            throw JDBCUtil.sqlException(nullPointerException);
        }
        catch (SecurityException securityException) {
            throw JDBCUtil.sqlException(securityException);
        }
        this.m_streams.add(outputStreamAdapter);
        return outputStreamAdapter;
    }

    @Override
    public Writer setCharacterStream(long l2) throws SQLException {
        BufferedWriter bufferedWriter;
        WriterAdapter writerAdapter;
        if (l2 < 1L) {
            throw JDBCUtil.invalidArgument("pos: " + l2);
        }
        this.checkClosed();
        this.createFile();
        long l3 = this.length();
        if (l2 > l3 + 1L) {
            this.fillSpace(l3 + 1L, l2);
        }
        try {
            writerAdapter = new WriterAdapter(this.m_file, l2 - 1L){

                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        JDBCClobFile.this.m_streams.remove(this);
                    }
                }
            };
            bufferedWriter = new BufferedWriter(writerAdapter);
        }
        catch (IOException iOException) {
            throw JDBCUtil.sqlException(iOException);
        }
        catch (Throwable throwable) {
            throw JDBCUtil.sqlException(throwable);
        }
        this.m_streams.add(writerAdapter);
        return bufferedWriter;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void truncate(long l2) throws SQLException {
        if (l2 < 0L) {
            throw JDBCUtil.invalidArgument("len: " + l2);
        }
        this.checkClosed();
        ReaderAdapter readerAdapter = null;
        RandomAccessFile randomAccessFile = null;
        try {
            readerAdapter = new ReaderAdapter(this.m_file, l2, Long.MAX_VALUE);
            long l3 = readerAdapter.getFilePointer();
            readerAdapter.close();
            randomAccessFile = new RandomAccessFile(this.m_file, "rw");
            randomAccessFile.setLength(l3);
        }
        catch (IOException iOException) {
            try {
                throw JDBCUtil.sqlException(iOException);
                catch (Throwable throwable) {
                    throw JDBCUtil.sqlException(throwable);
                }
            }
            catch (Throwable throwable) {
                JDBCClobFile.closeSafely(readerAdapter);
                JDBCClobFile.closeSafely(randomAccessFile);
                throw throwable;
            }
        }
        JDBCClobFile.closeSafely(readerAdapter);
        JDBCClobFile.closeSafely(randomAccessFile);
    }

    @Override
    public synchronized void free() throws SQLException {
        if (this.m_closed) {
            return;
        }
        this.m_closed = true;
        List list = this.m_streams;
        this.m_streams = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            this.closeSafely(e2);
        }
        if (this.m_deleteOnFree) {
            try {
                this.m_file.delete();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    @Override
    public Reader getCharacterStream(long l2, long l3) throws SQLException {
        ReaderAdapter readerAdapter;
        if (l2 < 1L) {
            throw JDBCUtil.outOfRangeArgument("pos: " + l2);
        }
        if (l3 < 0L) {
            throw JDBCUtil.outOfRangeArgument("length: " + l3);
        }
        final List list = this.m_streams;
        try {
            readerAdapter = new ReaderAdapter(this.m_file, l2 - 1L, l3){

                @Override
                public void close() throws IOException {
                    try {
                        super.close();
                    }
                    finally {
                        list.remove(this);
                    }
                }
            };
        }
        catch (IOException iOException) {
            throw JDBCUtil.sqlException(iOException);
        }
        catch (Throwable throwable) {
            throw JDBCUtil.sqlException(throwable);
        }
        list.add(readerAdapter);
        return readerAdapter;
    }

    public File getFile() {
        return this.m_file;
    }

    public String getEncoding() {
        return this.m_encoding;
    }

    public boolean isDeleteOnFree() {
        return this.m_deleteOnFree;
    }

    public void setDeleteOnFree(boolean bl) {
        this.m_deleteOnFree = bl;
    }

    public JDBCClobFile() throws SQLException {
        this((String)null);
    }

    public JDBCClobFile(String string) throws SQLException {
        try {
            this.setEncoding(string);
            this.m_file = File.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX);
            this.m_deleteOnFree = true;
        }
        catch (IOException iOException) {
            throw JDBCUtil.sqlException(iOException);
        }
        catch (SecurityException securityException) {
            throw JDBCUtil.sqlException(securityException);
        }
    }

    public JDBCClobFile(File file) throws SQLException {
        this(file, null);
    }

    public JDBCClobFile(File file, String string) throws SQLException {
        if (file == null) {
            throw JDBCUtil.nullArgument("file");
        }
        try {
            this.setEncoding(string);
            this.m_file = file.getCanonicalFile();
            this.checkIsFile(false);
            this.m_deleteOnFree = false;
        }
        catch (IOException iOException) {
            throw JDBCUtil.sqlException(iOException);
        }
        catch (SQLException sQLException) {
            throw JDBCUtil.sqlException(sQLException);
        }
    }

    protected final void setEncoding(String string) throws UnsupportedEncodingException {
        boolean bl;
        Charset charset = JDBCClobFile.charsetForName(string);
        CharsetEncoder charsetEncoder = charset.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        float f2 = charsetEncoder.maxBytesPerChar();
        float f3 = charsetEncoder.averageBytesPerChar();
        this.m_fixedWidthCharset = bl = f2 == (float)Math.round(f2) && f2 == f3;
        this.m_maxCharWidth = Math.round(f2);
        this.m_charset = charset;
        this.m_encoder = charsetEncoder;
        this.m_encoding = this.m_charset.name();
    }

    protected static Charset charsetForName(String string) throws UnsupportedEncodingException {
        String string2 = string;
        if (string2 == null) {
            string2 = Charset.defaultCharset().name();
        }
        try {
            if (Charset.isSupported(string2)) {
                return Charset.forName(string2);
            }
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            LOG.warning(illegalCharsetNameException.getMessage(), illegalCharsetNameException);
        }
        throw new UnsupportedEncodingException(string2);
    }

    protected final void checkIsFile(boolean bl) throws SQLException {
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            bl2 = this.m_file.exists();
        }
        catch (Exception exception) {
            throw JDBCUtil.sqlException(exception);
        }
        if (bl2) {
            try {
                bl3 = this.m_file.isFile();
            }
            catch (Exception exception) {
                throw JDBCUtil.sqlException(exception);
            }
        }
        if (bl2) {
            if (!bl3) {
                throw JDBCUtil.invalidArgument("Is not a file: " + this.m_file);
            }
        } else if (bl) {
            throw JDBCUtil.invalidArgument("Does not exist: " + this.m_file);
        }
    }

    protected void checkClosed() throws SQLException {
        if (this.m_closed) {
            throw JDBCUtil.sqlException(1251);
        }
    }

    protected void createFile() throws SQLException {
        try {
            if (!this.m_file.exists()) {
                FileUtil.getFileUtil().makeParentDirectories(this.m_file);
                this.m_file.createNewFile();
            }
        }
        catch (IOException iOException) {
            throw JDBCUtil.sqlException(iOException);
        }
        catch (Throwable throwable) {
            throw JDBCUtil.sqlException(throwable);
        }
        this.checkIsFile(true);
    }

    private static void closeSafely(RandomAccessFile randomAccessFile) {
        if (randomAccessFile != null) {
            try {
                randomAccessFile.close();
            }
            catch (IOException iOException) {
                LOG.info(iOException.getMessage(), iOException);
            }
            catch (Throwable throwable) {
                LOG.info(throwable.getMessage(), throwable);
            }
        }
    }

    private static void closeSafely(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                LOG.info(iOException.getMessage(), iOException);
            }
            catch (Throwable throwable) {
                LOG.info(throwable.getMessage(), throwable);
            }
        }
    }

    private static void closeSafely(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                LOG.info(iOException.getMessage(), iOException);
            }
            catch (Throwable throwable) {
                LOG.info(throwable.getMessage(), throwable);
            }
        }
    }

    private static void closeSafely(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                LOG.info(iOException.getMessage(), iOException);
            }
            catch (Throwable throwable) {
                LOG.info(throwable.getMessage(), throwable);
            }
        }
    }

    private static void closeSafely(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {
                LOG.info(iOException.getMessage(), iOException);
            }
            catch (Throwable throwable) {
                LOG.info(throwable.getMessage(), throwable);
            }
        }
    }

    private static void closeSafely(Scanner scanner) {
        if (scanner != null) {
            try {
                scanner.close();
            }
            catch (Throwable throwable) {
                LOG.info(throwable.getMessage(), throwable);
            }
        }
    }

    private void closeSafely(Object object) {
        if (object instanceof RandomAccessFile) {
            JDBCClobFile.closeSafely((RandomAccessFile)object);
        } else if (object instanceof InputStream) {
            JDBCClobFile.closeSafely((InputStream)object);
        } else if (object instanceof OutputStream) {
            JDBCClobFile.closeSafely((OutputStream)object);
        } else if (object instanceof Reader) {
            JDBCClobFile.closeSafely((Reader)object);
        } else if (object instanceof Writer) {
            JDBCClobFile.closeSafely((Writer)object);
        } else if (object instanceof Scanner) {
            JDBCClobFile.closeSafely((Scanner)object);
        }
    }

    protected class ReaderAdapter
    extends Reader {
        private static final int CHARBUFFER_CAPACTIY = 128;
        private final Reader m_reader;
        private long m_remaining = Long.MAX_VALUE;
        private long m_filePointer;
        private ByteBuffer m_byteBuffer;
        private CharBuffer m_charBuffer;

        protected ReaderAdapter(File file, long l2, long l3) throws FileNotFoundException, IOException, NullPointerException, IllegalArgumentException, SecurityException {
            long l4;
            if (file == null) {
                throw new NullPointerException("file");
            }
            if (l2 < 0L) {
                throw new IllegalArgumentException("pos: " + l2);
            }
            if (l3 < 0L) {
                throw new IllegalArgumentException("length: " + l3);
            }
            long l5 = file.length();
            long l6 = l4 = JDBCClobFile.this.m_fixedWidthCharset ? Math.round((double)l5 / (double)JDBCClobFile.this.m_maxCharWidth) : l5;
            if (l4 - l2 < 0L) {
                throw new IllegalArgumentException("pos: " + l2);
            }
            if (!JDBCClobFile.this.m_fixedWidthCharset) {
                int n2 = 128 * JDBCClobFile.this.m_maxCharWidth;
                this.m_charBuffer = CharBuffer.allocate(128);
                this.m_byteBuffer = ByteBuffer.allocate(n2);
            }
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)bufferedInputStream, JDBCClobFile.this.m_charset);
                this.m_reader = inputStreamReader;
            }
            catch (FileNotFoundException fileNotFoundException) {
                JDBCClobFile.closeSafely(fileInputStream);
                throw fileNotFoundException;
            }
            catch (SecurityException securityException) {
                JDBCClobFile.closeSafely(fileInputStream);
                throw securityException;
            }
            catch (NullPointerException nullPointerException) {
                JDBCClobFile.closeSafely(fileInputStream);
                throw nullPointerException;
            }
            catch (RuntimeException runtimeException) {
                JDBCClobFile.closeSafely(fileInputStream);
                throw runtimeException;
            }
            long l7 = this.skip(l2);
            if (l7 < l2) {
                throw new IllegalArgumentException("pos: " + l2);
            }
            this.m_remaining = l3;
        }

        @Override
        public int read(char[] cArray, int n2, int n3) throws IOException {
            int n4;
            int n5;
            long l2 = this.m_remaining;
            if (l2 <= 0L) {
                return -1;
            }
            if (l2 < (long)n3) {
                n3 = (int)l2;
            }
            if ((n5 = this.m_reader.read(cArray, n2, n3)) == -1) {
                return -1;
            }
            if ((long)n5 > l2) {
                n5 = (int)l2;
                this.m_remaining = 0L;
            } else {
                this.m_remaining -= (long)n5;
            }
            if (JDBCClobFile.this.m_fixedWidthCharset) {
                n4 = JDBCClobFile.this.m_maxCharWidth * n5;
            } else {
                boolean bl = n5 > this.m_charBuffer.capacity();
                CharBuffer charBuffer = bl ? CharBuffer.allocate(n5) : this.m_charBuffer;
                ByteBuffer byteBuffer = bl ? ByteBuffer.allocate(n5 * JDBCClobFile.this.m_maxCharWidth) : this.m_byteBuffer;
                charBuffer.clear();
                byteBuffer.clear();
                charBuffer.put(cArray, n2, n5);
                charBuffer.flip();
                JDBCClobFile.this.m_encoder.encode(charBuffer, byteBuffer, true);
                byteBuffer.flip();
                n4 = byteBuffer.limit();
                if (bl) {
                    this.m_byteBuffer = byteBuffer;
                    this.m_charBuffer = charBuffer;
                }
            }
            this.m_filePointer += (long)n4;
            return n5;
        }

        @Override
        public void close() throws IOException {
            this.m_reader.close();
        }

        public long getFilePointer() {
            return this.m_filePointer;
        }
    }

    protected class WriterAdapter
    extends Writer {
        protected final Writer m_writer;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected WriterAdapter(File file, long l2) throws FileNotFoundException, IOException, SecurityException, NullPointerException, IllegalArgumentException {
            long l3;
            if (file == null) {
                throw new NullPointerException("file");
            }
            if (l2 < 0L) {
                throw new IllegalArgumentException("pos: " + l2);
            }
            ReaderAdapter readerAdapter = null;
            try {
                readerAdapter = new ReaderAdapter(file, l2, Long.MAX_VALUE);
                l3 = readerAdapter.getFilePointer();
            }
            catch (Throwable throwable) {
                JDBCClobFile.closeSafely(readerAdapter);
                throw throwable;
            }
            JDBCClobFile.closeSafely(readerAdapter);
            RandomAccessFile randomAccessFile = null;
            boolean bl = false;
            try {
                randomAccessFile = new RandomAccessFile(file, "rw");
                randomAccessFile.seek(l3);
                bl = true;
            }
            finally {
                if (!bl) {
                    JDBCClobFile.closeSafely(randomAccessFile);
                }
            }
            JDBCBlobFile.OutputStreamAdapter outputStreamAdapter = new JDBCBlobFile.OutputStreamAdapter(randomAccessFile);
            this.m_writer = JDBCClobFile.this.m_encoding == null ? new OutputStreamWriter(outputStreamAdapter) : new OutputStreamWriter((OutputStream)outputStreamAdapter, JDBCClobFile.this.m_charset);
        }

        @Override
        public void flush() throws IOException {
            this.m_writer.flush();
        }

        @Override
        public void close() throws IOException {
            this.m_writer.close();
        }

        @Override
        public void write(char[] cArray, int n2, int n3) throws IOException {
            this.m_writer.write(cArray, n2, n3);
        }
    }
}

