/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import org.hsqldb.HsqlException;
import org.hsqldb.SessionInterface;
import org.hsqldb.jdbc.JDBCResultSet;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.types.ClobDataID;
import org.hsqldb.types.ClobInputStream;

public class JDBCClobClient
implements Clob {
    ClobDataID originalClob;
    ClobDataID clob;
    SessionInterface session;
    int colIndex;
    private boolean isClosed;
    private boolean isWritable;
    JDBCResultSet resultSet;

    @Override
    public synchronized InputStream getAsciiStream() throws SQLException {
        this.checkClosed();
        return new InputStream(){
            private Reader reader;
            {
                this.reader = JDBCClobClient.this.clob.getCharacterStream(JDBCClobClient.this.session);
            }

            @Override
            public int read() throws IOException {
                int n2 = this.reader.read();
                if (n2 < 0) {
                    return -1;
                }
                if (n2 >= 256) {
                    if (Character.isHighSurrogate((char)n2)) {
                        this.reader.read();
                    }
                    n2 = 63;
                }
                return n2;
            }

            @Override
            public int read(byte[] byArray, int n2, int n3) throws IOException {
                int n4;
                if (byArray == null) {
                    throw new NullPointerException();
                }
                if (n2 < 0 || n3 < 0 || n3 > byArray.length - n2) {
                    throw new IndexOutOfBoundsException();
                }
                if (n3 == 0) {
                    return 0;
                }
                int n5 = 0;
                for (int i2 = 0; i2 < n3 && (n4 = this.reader.read()) >= 0; ++i2) {
                    if (n4 >= 256) {
                        if (Character.isHighSurrogate((char)n4)) {
                            this.reader.read();
                        }
                        n4 = 63;
                    }
                    byArray[n2 + i2] = (byte)n4;
                    ++n5;
                }
                return n5 == 0 ? -1 : n5;
            }

            @Override
            public void close() throws IOException {
                try {
                    this.reader.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
    }

    @Override
    public synchronized Reader getCharacterStream() throws SQLException {
        this.checkClosed();
        return new ClobInputStream(this.session, this.clob, 0L, this.length());
    }

    @Override
    public synchronized String getSubString(long l2, int n2) throws SQLException {
        this.checkClosed();
        if (!JDBCClobClient.isInLimits(Long.MAX_VALUE, l2 - 1L, n2)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        try {
            return this.clob.getSubString(this.session, l2 - 1L, n2);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized long length() throws SQLException {
        this.checkClosed();
        try {
            return this.clob.length(this.session);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized long position(String string, long l2) throws SQLException {
        this.checkClosed();
        if (!JDBCClobClient.isInLimits(Long.MAX_VALUE, l2 - 1L, 0L)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        try {
            return this.clob.position(this.session, string, l2 - 1L);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized long position(Clob clob, long l2) throws SQLException {
        this.checkClosed();
        if (!JDBCClobClient.isInLimits(Long.MAX_VALUE, l2 - 1L, 0L)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        if (clob instanceof JDBCClobClient) {
            ClobDataID clobDataID = ((JDBCClobClient)clob).clob;
            try {
                return this.clob.position(this.session, clobDataID, l2 - 1L);
            }
            catch (HsqlException hsqlException) {
                throw JDBCUtil.sqlException(hsqlException);
            }
        }
        if (!JDBCClobClient.isInLimits(Integer.MAX_VALUE, 0L, clob.length())) {
            throw JDBCUtil.outOfRangeArgument();
        }
        return this.position(clob.getSubString(1L, (int)clob.length()), l2);
    }

    @Override
    public synchronized OutputStream setAsciiStream(final long l2) throws SQLException {
        return new OutputStream(){
            Writer writer;
            {
                this.writer = JDBCClobClient.this.setCharacterStream(l2);
            }

            @Override
            public void write(int n2) throws IOException {
                this.writer.write(n2 & 0xFF);
            }

            @Override
            public void write(byte[] byArray, int n2, int n3) throws IOException {
                if (byArray == null) {
                    throw new NullPointerException();
                }
                if (n2 < 0 || n3 < 0 || n3 > byArray.length - n2) {
                    throw new IndexOutOfBoundsException();
                }
                if (n3 == 0) {
                    return;
                }
                char[] cArray = new char[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    cArray[i2] = (char)byArray[n2 + i2];
                }
                this.writer.write(cArray, 0, n3);
            }

            @Override
            public void close() throws IOException {
                this.writer.close();
            }
        };
    }

    @Override
    public synchronized Writer setCharacterStream(final long l2) throws SQLException {
        this.checkClosed();
        if (l2 < 1L) {
            throw JDBCUtil.outOfRangeArgument("pos: " + l2);
        }
        if (!this.isWritable) {
            throw JDBCUtil.notUpdatableColumn();
        }
        this.startUpdate();
        return new Writer(){
            private long m_clobPosition;
            private boolean m_closed;
            {
                this.m_clobPosition = l2 - 1L;
            }

            @Override
            public void write(char[] cArray, int n2, int n3) throws IOException {
                this.checkClosed();
                JDBCClobClient.this.clob.setChars(JDBCClobClient.this.session, this.m_clobPosition, cArray, n2, n3);
                this.m_clobPosition += (long)n3;
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
                this.m_closed = true;
            }

            private void checkClosed() throws IOException {
                if (this.m_closed || JDBCClobClient.this.isClosed()) {
                    throw new IOException("The stream is closed");
                }
            }
        };
    }

    @Override
    public synchronized int setString(long l2, String string) throws SQLException {
        return this.setString(l2, string, 0, string.length());
    }

    @Override
    public synchronized int setString(long l2, String string, int n2, int n3) throws SQLException {
        this.checkClosed();
        if (!JDBCClobClient.isInLimits(string.length(), n2, n3)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        if (l2 < 1L) {
            throw JDBCUtil.outOfRangeArgument("pos: " + l2);
        }
        if (!this.isWritable) {
            throw JDBCUtil.notUpdatableColumn();
        }
        try {
            this.startUpdate();
            string = string.substring(n2, n2 + n3);
            this.clob.setString(this.session, l2 - 1L, string);
            return n3;
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized void truncate(long l2) throws SQLException {
        this.checkClosed();
        if (l2 < 0L) {
            throw JDBCUtil.outOfRangeArgument("len: " + l2);
        }
        try {
            this.clob.truncate(this.session, l2);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized void free() throws SQLException {
        this.isClosed = true;
        this.clob = null;
        this.session = null;
    }

    @Override
    public synchronized Reader getCharacterStream(long l2, long l3) throws SQLException {
        this.checkClosed();
        if (!JDBCClobClient.isInLimits(this.length(), l2 - 1L, l3)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        return new ClobInputStream(this.session, this.clob, l2 - 1L, l3);
    }

    char[] getChars(long l2, int n2) throws SQLException {
        try {
            return this.clob.getChars(this.session, l2 - 1L, n2);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    public JDBCClobClient(SessionInterface sessionInterface, ClobDataID clobDataID) {
        this.session = sessionInterface;
        this.clob = clobDataID;
    }

    public ClobDataID getClob() {
        return this.clob;
    }

    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    public synchronized void setWritable(JDBCResultSet jDBCResultSet, int n2) {
        this.isWritable = true;
        this.resultSet = jDBCResultSet;
        this.colIndex = n2;
    }

    public synchronized void clearUpdates() {
        if (this.originalClob != null) {
            this.clob = this.originalClob;
            this.originalClob = null;
        }
    }

    private void startUpdate() throws SQLException {
        if (this.originalClob != null) {
            return;
        }
        this.originalClob = this.clob;
        this.clob = (ClobDataID)this.clob.duplicate(this.session);
        this.resultSet.startUpdate(this.colIndex + 1);
        this.resultSet.preparedStatement.parameterValues[this.colIndex] = this.clob;
        this.resultSet.preparedStatement.parameterSet[this.colIndex] = true;
    }

    private void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw JDBCUtil.sqlException(1852);
        }
    }

    static boolean isInLimits(long l2, long l3, long l4) {
        return l2 >= 0L && l3 >= 0L && l4 >= 0L && l3 <= l2 - l4;
    }
}

