/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.lib.java.JavaSystem;

public class JDBCClob
implements Clob {
    private static final long MIN_POS = 1L;
    private static final long MAX_POS = 0x80000000L;
    private boolean m_closed;
    private String m_data;
    private final boolean m_createdByConnection;

    @Override
    public long length() throws SQLException {
        return this.getData().length();
    }

    @Override
    public String getSubString(long l2, int n2) throws SQLException {
        String string = this.getData();
        int n3 = string.length();
        if (l2 == 1L && n2 == n3) {
            return string;
        }
        if (l2 < 1L || l2 > (long)n3) {
            throw JDBCUtil.outOfRangeArgument("pos: " + l2);
        }
        long l3 = l2 - 1L;
        if (n2 < 0 || (long)n2 > (long)n3 - l3) {
            throw JDBCUtil.outOfRangeArgument("length: " + n2);
        }
        return string.substring((int)l3, (int)l3 + n2);
    }

    @Override
    public Reader getCharacterStream() throws SQLException {
        return new StringReader(this.getData());
    }

    @Override
    public InputStream getAsciiStream() throws SQLException {
        try {
            return new ByteArrayInputStream(this.getData().getBytes(JavaSystem.CS_US_ASCII));
        }
        catch (Throwable throwable) {
            throw JDBCUtil.sqlException(throwable);
        }
    }

    @Override
    public long position(String string, long l2) throws SQLException {
        String string2 = this.getData();
        if (l2 < 1L) {
            throw JDBCUtil.outOfRangeArgument("start: " + l2);
        }
        if (string == null || l2 > 0x80000000L) {
            return -1L;
        }
        int n2 = string2.indexOf(string, (int)l2 - 1);
        return n2 == -1 ? -1L : (long)(n2 + 1);
    }

    @Override
    public long position(Clob clob, long l2) throws SQLException {
        long l3;
        String string = this.getData();
        if (l2 < 1L) {
            throw JDBCUtil.outOfRangeArgument("start: " + l2);
        }
        if (clob == null) {
            return -1L;
        }
        long l4 = l2 - 1L;
        long l5 = string.length();
        if (l4 > l5 - (l3 = clob.length())) {
            return -1L;
        }
        String string2 = clob instanceof JDBCClob ? ((JDBCClob)clob).getData() : clob.getSubString(1L, (int)l3);
        int n2 = string.indexOf(string2, (int)l4);
        return n2 == -1 ? -1L : (long)(n2 + 1);
    }

    @Override
    public int setString(long l2, String string) throws SQLException {
        return this.setString(l2, string, 0, string == null ? 0 : string.length());
    }

    @Override
    public int setString(long l2, String string, int n2, int n3) throws SQLException {
        char[] cArray;
        this.checkReadonly();
        String string2 = this.getData();
        if (string == null) {
            throw JDBCUtil.nullArgument("str");
        }
        int n4 = string.length();
        int n5 = string2.length();
        int n6 = (int)(l2 - 1L);
        if (n2 == 0 && n3 == n4 && n6 == 0 && n3 >= n5) {
            this.setData(string);
            return n3;
        }
        if (n2 < 0 || n2 > n4) {
            throw JDBCUtil.outOfRangeArgument("offset: " + n2);
        }
        if (n3 < 0 || n3 > n4 - n2) {
            throw JDBCUtil.outOfRangeArgument("len: " + n3);
        }
        if (l2 < 1L || l2 - 1L > (long)(Integer.MAX_VALUE - n3)) {
            throw JDBCUtil.outOfRangeArgument("pos: " + l2);
        }
        long l3 = l2 + (long)n3;
        if (l2 > (long)n5) {
            cArray = new char[(int)l3 - 1];
            string2.getChars(0, n5, cArray, 0);
            for (int i2 = n5; i2 < n6; ++i2) {
                cArray[i2] = 32;
            }
            string.getChars(n2, n2 + n3, cArray, n6);
        } else if (l3 > (long)n5) {
            cArray = new char[(int)l3 - 1];
            string2.getChars(0, n6, cArray, 0);
            string.getChars(n2, n2 + n3, cArray, n6);
        } else {
            cArray = new char[n5];
            string2.getChars(0, n6, cArray, 0);
            string.getChars(n2, n2 + n3, cArray, n6);
            int n7 = n6 + n3;
            string2.getChars(n7, n5, cArray, n7);
        }
        this.setData(new String(cArray));
        return n3;
    }

    @Override
    public OutputStream setAsciiStream(final long l2) throws SQLException {
        this.checkReadonly();
        this.checkClosed();
        if (l2 < 1L || l2 > 0x80000000L) {
            throw JDBCUtil.outOfRangeArgument("pos: " + l2);
        }
        return new ByteArrayOutputStream(){
            boolean closed = false;

            @Override
            public synchronized void close() throws IOException {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                byte[] byArray = this.buf;
                int n2 = this.count;
                this.buf = null;
                this.count = 0;
                try {
                    String string = new String(byArray, 0, n2, JavaSystem.CS_US_ASCII);
                    JDBCClob.this.setString(l2, string);
                }
                catch (Throwable throwable) {
                    throw JavaSystem.toIOException(throwable);
                }
            }
        };
    }

    @Override
    public Writer setCharacterStream(final long l2) throws SQLException {
        this.checkReadonly();
        this.checkClosed();
        if (l2 < 1L || l2 > 0x80000000L) {
            throw JDBCUtil.outOfRangeArgument("pos: " + l2);
        }
        return new StringWriter(){
            private boolean closed = false;

            @Override
            public synchronized void close() throws IOException {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                StringBuffer stringBuffer = super.getBuffer();
                try {
                    JDBCClob.this.setStringBuffer(l2, stringBuffer, 0, stringBuffer.length());
                }
                catch (SQLException sQLException) {
                    throw JavaSystem.toIOException(sQLException);
                }
                finally {
                    stringBuffer.setLength(0);
                    stringBuffer.trimToSize();
                }
            }
        };
    }

    @Override
    public void truncate(long l2) throws SQLException {
        this.checkReadonly();
        String string = this.getData();
        long l3 = string.length();
        if (l2 == l3) {
            return;
        }
        if (l2 < 0L || l2 > l3) {
            throw JDBCUtil.outOfRangeArgument("len: " + l2);
        }
        this.setData(string.substring(0, (int)l2));
    }

    @Override
    public synchronized void free() throws SQLException {
        this.m_closed = true;
        this.m_data = null;
    }

    @Override
    public Reader getCharacterStream(long l2, long l3) throws SQLException {
        if (l3 > Integer.MAX_VALUE) {
            throw JDBCUtil.outOfRangeArgument("length: " + l3);
        }
        String string = this.getData();
        int n2 = string.length();
        if (l2 == 1L && l3 == (long)n2) {
            return new StringReader(string);
        }
        if (l2 < 1L || l2 > (long)n2) {
            throw JDBCUtil.outOfRangeArgument("pos: " + l2);
        }
        long l4 = l2 - 1L;
        if (l3 < 0L || l3 > (long)n2 - l4) {
            throw JDBCUtil.outOfRangeArgument("length: " + l3);
        }
        int n3 = (int)(l4 + l3);
        char[] cArray = new char[(int)l3];
        string.getChars((int)l4, n3, cArray, 0);
        return new CharArrayReader(cArray);
    }

    public JDBCClob(String string) throws SQLException {
        if (string == null) {
            throw JDBCUtil.nullArgument();
        }
        this.m_data = string;
        this.m_createdByConnection = false;
    }

    protected JDBCClob() {
        this.m_data = "";
        this.m_createdByConnection = true;
    }

    protected void checkReadonly() throws SQLException {
        if (!this.m_createdByConnection) {
            throw JDBCUtil.sqlException(3706, "Clob is read-only");
        }
    }

    protected synchronized void checkClosed() throws SQLException {
        if (this.m_closed) {
            throw JDBCUtil.sqlException(1251);
        }
    }

    synchronized String getData() throws SQLException {
        this.checkClosed();
        return this.m_data;
    }

    private synchronized void setData(String string) throws SQLException {
        this.checkClosed();
        this.m_data = string;
    }

    public int setStringBuffer(long l2, StringBuffer stringBuffer, int n2, int n3) throws SQLException {
        char[] cArray;
        this.checkReadonly();
        String string = this.getData();
        if (stringBuffer == null) {
            throw JDBCUtil.nullArgument("sb");
        }
        int n4 = stringBuffer.length();
        int n5 = string.length();
        int n6 = (int)(l2 - 1L);
        if (n2 == 0 && n3 == n4 && n6 == 0 && n3 >= n5) {
            this.setData(stringBuffer.toString());
            return n3;
        }
        if (n2 < 0 || n2 > n4) {
            throw JDBCUtil.outOfRangeArgument("offset: " + n2);
        }
        if (n3 > n4 - n2) {
            throw JDBCUtil.outOfRangeArgument("len: " + n3);
        }
        if (l2 < 1L || l2 - 1L > (long)(Integer.MAX_VALUE - n3)) {
            throw JDBCUtil.outOfRangeArgument("pos: " + l2);
        }
        long l3 = l2 + (long)n3;
        if (l2 > (long)n5) {
            cArray = new char[(int)l3 - 1];
            string.getChars(0, n5, cArray, 0);
            for (int i2 = n5; i2 < n6; ++i2) {
                cArray[i2] = 32;
            }
            stringBuffer.getChars(n2, n2 + n3, cArray, n6);
        } else if (l3 > (long)n5) {
            cArray = new char[(int)l3 - 1];
            string.getChars(0, n6, cArray, 0);
            stringBuffer.getChars(n2, n2 + n3, cArray, n6);
        } else {
            cArray = new char[n5];
            string.getChars(0, n6, cArray, 0);
            stringBuffer.getChars(n2, n2 + n3, cArray, n6);
            int n7 = n6 + n3;
            string.getChars(n7, n5, cArray, n7);
        }
        this.setData(new String(cArray));
        return n3;
    }
}

