/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.hsqldb.HsqlException;
import org.hsqldb.SessionInterface;
import org.hsqldb.jdbc.JDBCResultSet;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.BlobInputStream;

public class JDBCBlobClient
implements Blob {
    BlobDataID originalBlob;
    BlobDataID blob;
    SessionInterface session;
    int colIndex;
    private boolean isClosed;
    private boolean isWritable;
    JDBCResultSet resultSet;

    @Override
    public synchronized long length() throws SQLException {
        this.checkClosed();
        try {
            return this.blob.length(this.session);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized byte[] getBytes(long l2, int n2) throws SQLException {
        this.checkClosed();
        if (!JDBCBlobClient.isInLimits(Long.MAX_VALUE, l2 - 1L, n2)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        try {
            return this.blob.getBytes(this.session, l2 - 1L, n2);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized InputStream getBinaryStream() throws SQLException {
        this.checkClosed();
        return new BlobInputStream(this.session, this.blob, 0L, this.length());
    }

    @Override
    public synchronized long position(byte[] byArray, long l2) throws SQLException {
        this.checkClosed();
        if (!JDBCBlobClient.isInLimits(Long.MAX_VALUE, l2 - 1L, 0L)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        try {
            long l3 = this.blob.position(this.session, byArray, l2 - 1L);
            if (l3 >= 0L) {
                ++l3;
            }
            return l3;
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized long position(Blob blob, long l2) throws SQLException {
        this.checkClosed();
        if (!JDBCBlobClient.isInLimits(Long.MAX_VALUE, l2 - 1L, 0L)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        if (blob instanceof JDBCBlobClient) {
            BlobDataID blobDataID = ((JDBCBlobClient)blob).blob;
            try {
                long l3 = this.blob.position(this.session, blobDataID, l2 - 1L);
                if (l3 >= 0L) {
                    ++l3;
                }
                return l3;
            }
            catch (HsqlException hsqlException) {
                throw JDBCUtil.sqlException(hsqlException);
            }
        }
        if (!JDBCBlobClient.isInLimits(Integer.MAX_VALUE, 0L, blob.length())) {
            throw JDBCUtil.outOfRangeArgument();
        }
        byte[] byArray = blob.getBytes(1L, (int)blob.length());
        return this.position(byArray, l2);
    }

    @Override
    public synchronized int setBytes(long l2, byte[] byArray) throws SQLException {
        return this.setBytes(l2, byArray, 0, byArray.length);
    }

    @Override
    public synchronized int setBytes(long l2, byte[] byArray, int n2, int n3) throws SQLException {
        this.checkClosed();
        if (!JDBCBlobClient.isInLimits(byArray.length, n2, n3)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        if (!JDBCBlobClient.isInLimits(Long.MAX_VALUE, l2 - 1L, n3)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        if (!this.isWritable) {
            throw JDBCUtil.notUpdatableColumn();
        }
        try {
            this.startUpdate();
            this.blob.setBytes(this.session, l2 - 1L, byArray, n2, n3);
            return n3;
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized OutputStream setBinaryStream(long l2) throws SQLException {
        throw JDBCUtil.notSupported();
    }

    @Override
    public synchronized void truncate(long l2) throws SQLException {
        this.checkClosed();
        if (!JDBCBlobClient.isInLimits(Long.MAX_VALUE, 0L, l2)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        try {
            this.blob.truncate(this.session, l2);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized void free() throws SQLException {
        this.isClosed = true;
    }

    @Override
    public synchronized InputStream getBinaryStream(long l2, long l3) throws SQLException {
        this.checkClosed();
        if (!JDBCBlobClient.isInLimits(this.length(), l2 - 1L, l3)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        return new BlobInputStream(this.session, this.blob, l2 - 1L, l3);
    }

    public JDBCBlobClient(SessionInterface sessionInterface, BlobDataID blobDataID) {
        this.session = sessionInterface;
        this.blob = blobDataID;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public BlobDataID getBlob() {
        return this.blob;
    }

    public synchronized void setWritable(JDBCResultSet jDBCResultSet, int n2) {
        this.isWritable = true;
        this.resultSet = jDBCResultSet;
        this.colIndex = n2;
    }

    public synchronized void clearUpdates() {
        if (this.originalBlob != null) {
            this.blob = this.originalBlob;
            this.originalBlob = null;
        }
    }

    private void startUpdate() throws SQLException {
        if (this.originalBlob != null) {
            return;
        }
        this.originalBlob = this.blob;
        this.blob = (BlobDataID)this.blob.duplicate(this.session);
        this.resultSet.startUpdate(this.colIndex + 1);
        this.resultSet.preparedStatement.parameterValues[this.colIndex] = this.blob;
        this.resultSet.preparedStatement.parameterSet[this.colIndex] = true;
    }

    private void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw JDBCUtil.sqlException(1852);
        }
    }

    static boolean isInLimits(long l2, long l3, long l4) {
        return l3 >= 0L && l4 >= 0L && l3 + l4 <= l2;
    }
}

