/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.error;

import java.lang.reflect.Field;
import org.hsqldb.HsqlException;
import org.hsqldb.error.ErrorCode;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.resources.ResourceBundleHandler;
import org.hsqldb.result.Result;

public final class Error {
    public static boolean TRACE = false;
    public static boolean TRACESYSTEMOUT = false;
    private static final String defaultMessage = "S1000 General error";
    private static final String errPropsName = "sql-state-messages";
    private static final int bundleHandle = ResourceBundleHandler.getBundleHandle("sql-state-messages", null);
    private static final String MESSAGE_TAG = "$$";
    private static final int SQL_STATE_DIGITS = 5;
    private static final int SQL_CODE_DIGITS = 4;
    private static final int ERROR_CODE_BASE = 11;

    public static RuntimeException runtimeError(int n2, String string) {
        HsqlException hsqlException = Error.error(n2, string);
        return new RuntimeException(hsqlException.getMessage());
    }

    public static HsqlException error(int n2, String string) {
        return Error.error(null, n2, string);
    }

    public static HsqlException error(Throwable throwable, int n2, String string) {
        Object object = Error.getMessage(n2);
        if (string != null) {
            object = (String)object + ": " + string;
        }
        return new HsqlException(throwable, ((String)object).substring(6), ((String)object).substring(0, 5), -n2);
    }

    public static HsqlException parseError(int n2, String string, int n3) {
        Object object = Error.getMessage(n2);
        if (string != null) {
            object = (String)object + ": " + string;
        }
        if (n3 > 1) {
            string = Error.getMessage(24);
            object = (String)object + " :" + string + n3;
        }
        return new HsqlException(null, ((String)object).substring(6), ((String)object).substring(0, 5), -n2);
    }

    public static HsqlException error(int n2) {
        return Error.error(null, n2, 0, null);
    }

    public static HsqlException error(int n2, Throwable throwable) {
        String string = Error.getMessage(n2, 0, null);
        return new HsqlException(throwable, string.substring(0, 5), -n2);
    }

    public static HsqlException error(Throwable throwable, int n2, int n3, String[] stringArray) {
        String string = Error.getMessage(n2, n3, stringArray);
        int n4 = n3 < 11 ? n2 : n3;
        return new HsqlException(throwable, string.substring(6), string.substring(0, 5), -n4);
    }

    public static HsqlException parseError(int n2, int n3, int n4, String[] stringArray) {
        Object object = Error.getMessage(n2, n3, stringArray);
        if (n4 > 1) {
            String string = Error.getMessage(24);
            object = (String)object + " :" + string + n4;
        }
        int n5 = n3 < 11 ? n2 : n3;
        return new HsqlException(null, ((String)object).substring(6), ((String)object).substring(0, 5), -n5);
    }

    public static HsqlException error(int n2, int n3) {
        return Error.error(n2, Error.getMessage(n3));
    }

    public static HsqlException error(String string, String string2) {
        int n2 = Error.getCode(string2);
        if (n2 < 1000) {
            n2 = 5800;
        }
        if (string == null) {
            string = Error.getMessage(n2);
        }
        return new HsqlException(null, string, string2, n2);
    }

    private static String insertStrings(String string, String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + 32);
        int n2 = 0;
        int n3 = string.length();
        for (int i2 = 0; i2 < stringArray.length && (n3 = string.indexOf(MESSAGE_TAG, n2)) != -1; ++i2) {
            stringBuilder.append(string, n2, n3);
            stringBuilder.append(stringArray[i2] == null ? "null exception message" : stringArray[i2]);
            n2 = n3 + MESSAGE_TAG.length();
        }
        n3 = string.length();
        stringBuilder.append(string, n2, n3);
        return stringBuilder.toString();
    }

    public static String getMessage(int n2) {
        return Error.getMessage(n2, 0, null);
    }

    public static String getStateString(int n2) {
        return Error.getMessage(n2, 0, null).substring(0, 5);
    }

    public static String getMessage(int n2, int n3, String[] stringArray) {
        Object object = Error.getResourceString(n2);
        if (n3 != 0) {
            object = (String)object + " " + Error.getResourceString(n3);
        }
        if (stringArray != null) {
            object = Error.insertStrings((String)object, stringArray);
        }
        return object;
    }

    private static String getResourceString(int n2) {
        String string = StringUtil.toZeroPaddedString(n2, 4, 4);
        String string2 = ResourceBundleHandler.getString(bundleHandle, string);
        if (string2 == null) {
            string2 = defaultMessage;
        }
        return string2;
    }

    public static HsqlException error(Result result) {
        return new HsqlException(result);
    }

    public static void printSystemOut(String string) {
        if (TRACESYSTEMOUT) {
            System.out.println(string);
        }
    }

    public static int getCode(String string) {
        try {
            Field[] fieldArray = ErrorCode.class.getDeclaredFields();
            for (int i2 = 0; i2 < fieldArray.length; ++i2) {
                String string2 = fieldArray[i2].getName();
                if (string2.length() != 7 || !string2.endsWith(string)) continue;
                return fieldArray[i2].getInt(ErrorCode.class);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return -1;
    }
}

