/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.RowAction;
import org.hsqldb.RowActionBase;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Statement;
import org.hsqldb.Table;
import org.hsqldb.TransactionManager;
import org.hsqldb.TransactionManagerCommon;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlDeque;
import org.hsqldb.lib.LongDeque;
import org.hsqldb.persist.PersistentStore;

public class TransactionManagerMVCC
extends TransactionManagerCommon
implements TransactionManager {
    HsqlDeque committedTransactions = new HsqlDeque();
    LongDeque committedTransactionSCNs = new LongDeque();
    boolean isLockedMode;
    Session catalogWriteSession;
    long lockTxTs;
    long lockSessionId;
    long unlockTxTs;
    long unlockSessionId;
    int redoCount = 0;

    public TransactionManagerMVCC(Database database) {
        super(database);
        this.lobSession = this.database.sessionManager.getSysLobSession();
        this.txModel = 2;
    }

    @Override
    public long getSystemChangeNumber() {
        return this.systemChangeNumber.get();
    }

    @Override
    public void setSystemChangeNumber(long l2) {
        this.systemChangeNumber.set(l2);
    }

    @Override
    public boolean isMVRows() {
        return true;
    }

    @Override
    public boolean isMVCC() {
        return true;
    }

    @Override
    public boolean is2PL() {
        return false;
    }

    @Override
    public int getTransactionControl() {
        return 2;
    }

    @Override
    public void setTransactionControl(Session session, int n2) {
        super.setTransactionControl(session, n2);
    }

    @Override
    public void completeActions(Session session) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean prepareCommitActions(Session session) {
        if (session.abortTransaction) {
            return false;
        }
        this.writeLock.lock();
        try {
            Object object;
            int n2;
            int n3 = session.rowActionList.size();
            for (n2 = 0; n2 < n3; ++n2) {
                object = (RowAction)session.rowActionList.get(n2);
                if (((RowAction)object).canCommit(session)) continue;
                boolean bl = false;
                return bl;
            }
            session.actionSCN = this.getNextSystemChangeNumber();
            for (n2 = 0; n2 < n3; ++n2) {
                object = (RowAction)session.rowActionList.get(n2);
                ((RowAction)object).prepareCommit(session);
            }
            for (n2 = 0; n2 < session.actionSet.size(); ++n2) {
                object = ((RowActionBase)session.actionSet.get((int)n2)).session;
                ((Session)object).abortTransaction = true;
            }
            n2 = 1;
            return n2 != 0;
        }
        finally {
            this.writeLock.unlock();
            session.actionSet.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean commitTransaction(Session session) {
        if (session.abortTransaction) {
            return false;
        }
        this.writeLock.lock();
        try {
            Object object;
            int n2;
            int n3 = session.rowActionList.size();
            for (n2 = 0; n2 < n3; ++n2) {
                object = (RowAction)session.rowActionList.get(n2);
                if (object.canCommit(session)) continue;
                boolean bl = false;
                return bl;
            }
            session.transactionEndSCN = session.actionSCN = this.getNextSystemChangeNumber();
            this.endTransaction(session);
            for (n2 = 0; n2 < n3; ++n2) {
                object = (RowAction)session.rowActionList.get(n2);
                object.commit(session);
            }
            for (n2 = 0; n2 < session.actionSet.size(); ++n2) {
                object = ((RowActionBase)session.actionSet.get((int)n2)).session;
                object.abortTransaction = true;
            }
            this.adjustLobUsage(session);
            this.persistCommit(session);
            n2 = session.rowActionList.size();
            if (n2 > n3) {
                object = session.rowActionList.getArray();
                this.mergeTransaction((Object[])object, n3, n2, session.actionSCN);
                this.finaliseRows(session, (Object[])object, n3, n2);
                session.rowActionList.setSize(n3);
            }
            if (session == this.lobSession || this.getFirstLiveTransactionTimestamp() > session.actionSCN) {
                object = session.rowActionList.getArray();
                this.mergeTransaction((Object[])object, 0, n3, session.actionSCN);
                this.finaliseRows(session, (Object[])object, 0, n3);
            } else if (session.rowActionList.size() > 0) {
                object = session.rowActionList.toArray();
                this.addToCommittedQueue(session, (Object[])object);
            }
            this.endTransactionTPL(session);
            session.isTransaction = false;
            this.countDownLatches(session);
        }
        finally {
            session.actionSet.clear();
            this.writeLock.unlock();
        }
        return true;
    }

    @Override
    public void rollback(Session session) {
        this.writeLock.lock();
        try {
            session.abortTransaction = false;
            session.transactionEndSCN = session.actionSCN = this.getNextSystemChangeNumber();
            this.rollbackPartial(session, 0, session.transactionSCN);
            this.endTransaction(session);
            session.logSequences();
            this.endTransactionTPL(session);
            session.isTransaction = false;
            this.countDownLatches(session);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void rollbackSavepoint(Session session, int n2) {
        long l2 = session.sessionContext.savepointTimestamps.get(n2);
        Integer n3 = (Integer)session.sessionContext.savepoints.get(n2);
        int n4 = n3;
        while (session.sessionContext.savepoints.size() > n2 + 1) {
            session.sessionContext.savepoints.removeEntry(session.sessionContext.savepoints.size() - 1);
            session.sessionContext.savepointTimestamps.removeLast();
        }
        this.rollbackPartial(session, n4, l2);
    }

    @Override
    public void rollbackAction(Session session) {
        this.rollbackPartial(session, session.actionIndex, session.actionStartSCN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollbackPartial(Session session, int n2, long l2) {
        int n3 = session.rowActionList.size();
        if (n2 == n3) {
            return;
        }
        for (int i2 = n3 - 1; i2 >= n2; --i2) {
            RowAction rowAction = (RowAction)session.rowActionList.get(i2);
            if (rowAction == null || rowAction.type == 0 || rowAction.type == 3) continue;
            Row row = rowAction.memoryRow;
            if (row == null) {
                row = (Row)rowAction.store.get(rowAction.getPos(), false);
            }
            if (row == null) continue;
            this.writeLock.lock();
            try {
                rowAction.rollback(session, l2);
                int n4 = rowAction.mergeRollback(session, l2);
                if (rowAction.type == 3) {
                    if (rowAction.deleteComplete) continue;
                    rowAction.deleteComplete = true;
                }
                rowAction.store.rollbackRow(session, row, n4, this.txModel);
                continue;
            }
            finally {
                this.writeLock.unlock();
            }
        }
        session.rowActionList.setSize(n2);
    }

    @Override
    public RowAction addDeleteAction(Session session, Table table, PersistentStore persistentStore, Row row, int[] nArray) {
        RowAction rowAction = persistentStore.addDeleteActionToRow(session, row, nArray, true);
        if (table.isTemp) {
            persistentStore.delete(session, row);
            row.rowAction = null;
            if (table.persistenceScope == 20) {
                return rowAction;
            }
        }
        Session session2 = null;
        boolean bl = true;
        if (rowAction == null) {
            this.writeLock.lock();
            try {
                this.rollbackAction(session);
                if (session.isolationLevel == 4 || session.isolationLevel == 8) {
                    session.actionSet.clear();
                    session.redoAction = false;
                    session.abortTransaction = session.txConflictRollback;
                    throw Error.error(4871);
                }
                if (row.rowAction != null && row.rowAction.isDeleted()) {
                    session.actionSet.clear();
                    session.redoAction = true;
                    ++this.redoCount;
                    throw Error.error(4871);
                }
                boolean bl2 = bl = !session.actionSet.isEmpty();
                if (bl) {
                    session2 = ((RowActionBase)session.actionSet.get((int)0)).session;
                    session.actionSet.clear();
                    if (session2 != null) {
                        bl = this.checkDeadlock(session, session2);
                    }
                }
                if (bl) {
                    session.redoAction = true;
                    if (session2 != null) {
                        session2.waitingSessions.add(session);
                        session.waitedSessions.add(session2);
                        session.latch.setCount(session.waitedSessions.size());
                    }
                    ++this.redoCount;
                } else {
                    session.redoAction = false;
                    session.abortTransaction = session.txConflictRollback;
                }
                throw Error.error(4871);
            }
            catch (Throwable throwable) {
                this.writeLock.unlock();
                throw throwable;
            }
        }
        session.rowActionList.add(rowAction);
        return rowAction;
    }

    @Override
    public void addInsertAction(Session session, Table table, PersistentStore persistentStore, Row row, int[] nArray) {
        RowAction rowAction = row.rowAction;
        Session session2 = null;
        boolean bl = false;
        boolean bl2 = true;
        HsqlException hsqlException = null;
        if (rowAction == null) {
            throw Error.runtimeError(458, "TXManager - null insert action ");
        }
        try {
            persistentStore.indexRow(session, row);
        }
        catch (HsqlException hsqlException2) {
            if (session.actionSet.isEmpty()) {
                throw hsqlException2;
            }
            bl = true;
            hsqlException = hsqlException2;
        }
        if (!bl) {
            if (table.isTemp) {
                row.rowAction = null;
                if (table.persistenceScope == 20) {
                    return;
                }
            }
            session.rowActionList.add(rowAction);
            return;
        }
        this.writeLock.lock();
        try {
            this.rollbackAction(session);
            RowActionBase rowActionBase = (RowActionBase)session.actionSet.get(0);
            session2 = rowActionBase.session;
            session.actionSet.clear();
            if (rowActionBase.commitSCN != 0L) {
                bl2 = false;
            }
            switch (session.isolationLevel) {
                case 4: 
                case 8: {
                    bl = false;
                    break;
                }
                default: {
                    bl = this.checkDeadlock(session, session2);
                }
            }
            if (bl) {
                session.redoAction = true;
                if (bl2) {
                    session2.waitingSessions.add(session);
                    session.waitedSessions.add(session2);
                    session.latch.setCount(session.waitedSessions.size());
                }
                ++this.redoCount;
            } else {
                session.abortTransaction = session.txConflictRollback;
                session.redoAction = false;
            }
            throw Error.error(hsqlException, 4871, null);
        }
        catch (Throwable throwable) {
            this.writeLock.unlock();
            throw throwable;
        }
    }

    public boolean canRead(Session session, PersistentStore persistentStore, Row row, int n2, int[] nArray) {
        RowAction rowAction = row.rowAction;
        if (rowAction == null) {
            return true;
        }
        if (rowAction.table.isTemp) {
            return true;
        }
        if (n2 == 0) {
            return rowAction.canRead(session, 0);
        }
        if (n2 == 2) {
            return rowAction.canRead(session, 0);
        }
        return rowAction.canRead(session, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToCommittedQueue(Session session, Object[] objectArray) {
        LongDeque longDeque = this.committedTransactionSCNs;
        synchronized (longDeque) {
            this.committedTransactions.addLast(objectArray);
            this.committedTransactionSCNs.addLast(session.actionSCN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeExpiredTransactions(Session session) {
        long l2 = this.getFirstLiveTransactionTimestamp();
        while (true) {
            Object[] objectArray;
            long l3;
            LongDeque longDeque = this.committedTransactionSCNs;
            synchronized (longDeque) {
                if (this.committedTransactionSCNs.isEmpty()) {
                    break;
                }
                l3 = this.committedTransactionSCNs.getFirst();
                if (l3 >= l2) {
                    break;
                }
                this.committedTransactionSCNs.removeFirst();
                objectArray = (Object[])this.committedTransactions.removeFirst();
            }
            this.mergeTransaction(objectArray, 0, objectArray.length, l3);
            this.finaliseRows(session, objectArray, 0, objectArray.length);
        }
    }

    @Override
    public void beginTransaction(Session session) {
        this.writeLock.lock();
        try {
            if (!session.isTransaction) {
                this.beginTransactionCommon(session);
                this.liveTransactionSCNs.addLast(session.transactionSCN);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void beginAction(Session session, Statement statement) {
        if (session.isTransaction) {
            return;
        }
        if (statement == null) {
            return;
        }
        this.writeLock.lock();
        try {
            if (this.hasExpired) {
                session.redoAction = true;
                return;
            }
            if ((statement = this.updateCurrentStatement(session, statement)) == null) {
                return;
            }
            if (session.abortTransaction) {
                return;
            }
            session.isPreTransaction = true;
            if (!this.isLockedMode && !statement.isCatalogLock(this.txModel)) {
                return;
            }
            this.beginActionTPL(session, statement);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void beginActionResume(Session session) {
        this.writeLock.lock();
        try {
            if (session.isTransaction) {
                session.actionStartSCN = session.actionSCN = this.getNextSystemChangeNumber();
            } else {
                this.beginTransactionCommon(session);
                this.liveTransactionSCNs.addLast(session.transactionSCN);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    void endTransaction(Session session) {
        long l2 = session.transactionSCN;
        int n2 = this.liveTransactionSCNs.indexOf(l2);
        if (n2 >= 0) {
            this.transactionCount.decrementAndGet();
            this.liveTransactionSCNs.remove(n2);
            this.mergeExpiredTransactions(session);
        }
    }

    private void countDownLatches(Session session) {
        for (int i2 = 0; i2 < session.waitingSessions.size(); ++i2) {
            Session session2 = (Session)session.waitingSessions.get(i2);
            session2.waitedSessions.remove(session);
            session2.latch.setCount(session2.waitedSessions.size());
        }
        session.waitedSessions.clear();
        session.waitingSessions.clear();
    }

    @Override
    void endTransactionTPL(Session session) {
        Session session2;
        int n2;
        if (this.catalogWriteSession != session) {
            return;
        }
        Session session3 = null;
        for (n2 = 0; n2 < session.waitingSessions.size(); ++n2) {
            session2 = (Session)session.waitingSessions.get(n2);
            Statement statement = session2.sessionContext.currentStatement;
            if (statement == null || !statement.isCatalogLock(this.txModel)) continue;
            session3 = session2;
            break;
        }
        if (session3 == null) {
            this.catalogWriteSession = null;
            this.isLockedMode = false;
        } else {
            for (n2 = 0; n2 < session.waitingSessions.size(); ++n2) {
                session2 = (Session)session.waitingSessions.get(n2);
                if (session2 == session3) continue;
                session2.waitedSessions.add(session3);
                session3.waitingSessions.add(session2);
                session2.latch.setCount(session2.waitedSessions.size());
            }
            this.catalogWriteSession = session3;
        }
        this.unlockTxTs = session.actionSCN;
        this.unlockSessionId = session.getId();
    }

    boolean beginActionTPL(Session session, Statement statement) {
        if (session == this.catalogWriteSession) {
            return true;
        }
        session.tempSet.clear();
        if (statement.isCatalogLock(this.txModel) && this.catalogWriteSession == null) {
            this.catalogWriteSession = session;
            this.isLockedMode = true;
            this.lockTxTs = session.actionSCN;
            this.lockSessionId = session.getId();
            this.getTransactionAndPreSessions(session);
            if (!session.tempSet.isEmpty()) {
                session.waitedSessions.addAll(session.tempSet);
                this.setWaitingSessionTPL(session);
            }
            return true;
        }
        if (!this.isLockedMode) {
            return true;
        }
        if (statement.getTableNamesForWrite().length > 0 ? statement.getTableNamesForWrite()[0].schema == SqlInvariants.LOBS_SCHEMA_HSQLNAME : statement.getTableNamesForRead().length > 0 && statement.getTableNamesForRead()[0].schema == SqlInvariants.LOBS_SCHEMA_HSQLNAME) {
            return true;
        }
        if (session.waitingSessions.contains(this.catalogWriteSession)) {
            return true;
        }
        if (this.catalogWriteSession.waitingSessions.add(session)) {
            session.waitedSessions.add(this.catalogWriteSession);
            session.latch.setCount(session.waitedSessions.size());
        }
        return true;
    }

    @Override
    public void resetSession(Session session, Session session2, long l2, int n2) {
        super.resetSession(session, session2, l2, n2);
    }
}

