/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.PeriodDefinition;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableWorks;
import org.hsqldb.error.Error;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.TimestampData;

class TablePeriodWorks {
    private Table table;
    private Session session;

    public TablePeriodWorks(Session session, Table table) {
        this.table = table;
        this.session = session;
    }

    void addSystemPeriod(PeriodDefinition periodDefinition) {
        if (this.table.systemPeriod != null) {
            throw Error.error(5517);
        }
        TableWorks tableWorks = new TableWorks(this.session, this.table);
        tableWorks.addSystemPeriod(periodDefinition);
    }

    void addApplicationPeriod(PeriodDefinition periodDefinition) {
        throw Error.error(1551);
    }

    void addSystemVersioning() {
        if (this.table.isSystemVersioned) {
            throw Error.error(5518);
        }
        if (this.table.systemPeriod == null) {
            throw Error.error(5518);
        }
        this.table.isSystemVersioned = true;
    }

    void dropSystemPeriod(boolean bl) {
        if (this.table.isSystemVersioned) {
            throw Error.error(5518);
        }
        if (this.table.systemPeriod == null) {
            throw Error.error(5517);
        }
        TableWorks tableWorks = new TableWorks(this.session, this.table);
        tableWorks.dropSystemPeriod(bl);
    }

    void dropApplicationPeriod(boolean bl) {
        throw Error.error(1551);
    }

    void dropSystemVersioning(boolean bl) {
        if (!this.table.isSystemVersioned()) {
            throw Error.error(5518);
        }
        TableWorks tableWorks = new TableWorks(this.session, this.table);
        tableWorks.dropSystemVersioning(bl);
        long l2 = DateTimeType.epochLimitTimestamp.getSeconds();
        this.removeOldRows(l2);
        this.table.isSystemVersioned = false;
    }

    long removeOldRows(long l2) {
        int n2 = this.table.systemPeriodEndColumn;
        long l3 = 0L;
        RowIterator rowIterator = this.table.rowIterator(this.session);
        while (rowIterator.next()) {
            TimestampData timestampData = (TimestampData)rowIterator.getField(n2);
            if (timestampData.getSeconds() >= l2) continue;
            rowIterator.removeCurrent();
        }
        return l3;
    }
}

