/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.types.Type;

public class TableBase
implements Cloneable {
    public static final int INFO_SCHEMA_TABLE = 1;
    public static final int SYSTEM_SUBQUERY = 2;
    public static final int TEMP_TABLE = 3;
    public static final int MEMORY_TABLE = 4;
    public static final int CACHED_TABLE = 5;
    public static final int TEMP_TEXT_TABLE = 6;
    public static final int TEXT_TABLE = 7;
    public static final int VIEW_TABLE = 8;
    public static final int RESULT_TABLE = 9;
    public static final int TRANSITION_TABLE = 10;
    public static final int FUNCTION_TABLE = 11;
    public static final int SYSTEM_TABLE = 12;
    public static final int CHANGE_SET_TABLE = 13;
    public static final int MODULE_TABLE = 14;
    public static final int SCOPE_ROUTINE = 20;
    public static final int SCOPE_STATEMENT = 21;
    public static final int SCOPE_TRANSACTION = 22;
    public static final int SCOPE_SESSION = 23;
    public static final int SCOPE_FULL = 24;
    public PersistentStore store;
    public int persistenceScope;
    public long persistenceId;
    int tableSpace = 7;
    Index[] indexList;
    public Database database;
    int[] bestRowIdentifierCols;
    boolean bestRowIdentifierStrict;
    int[] bestIndexForColumn;
    Index bestIndex;
    Index fullIndex;
    boolean[] colNotNull;
    Type[] colTypes;
    protected int columnCount;
    boolean[] emptyColumnCheckList;
    int tableType;
    protected boolean isReadOnly;
    protected boolean isTemp;
    protected boolean isCached;
    protected boolean isText;
    boolean isView;
    protected boolean isWithDataSource;
    public boolean isSessionBased;
    protected boolean isSchemaBased;
    protected boolean isLogged;
    public boolean isSystemVersioned;
    boolean hasLobColumn;

    TableBase() {
    }

    public TableBase duplicate() {
        TableBase tableBase;
        try {
            tableBase = (TableBase)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw Error.runtimeError(201, "Expression");
        }
        tableBase.persistenceId = this.database.persistentStoreCollection.getNextId();
        return tableBase;
    }

    public final int getTableType() {
        return this.tableType;
    }

    public final void setTableType(int n2) {
        if (this.tableType == 4 && n2 == 1) {
            this.tableType = n2;
            this.persistenceScope = 22;
            this.isSessionBased = true;
            this.tableType = n2;
        }
    }

    public long getPersistenceId() {
        return this.persistenceId;
    }

    public int getSpaceID() {
        return this.tableSpace;
    }

    public void setSpaceID(int n2) {
        this.tableSpace = n2;
    }

    int getId() {
        return 0;
    }

    public final boolean onCommitPreserve() {
        return this.persistenceScope == 23;
    }

    public final RowIterator rowIterator(Session session) {
        PersistentStore persistentStore = this.getRowStore(session);
        return this.getDefaultIndex().firstRow(session, persistentStore, null, 0, null);
    }

    public final RowIterator rowIterator(PersistentStore persistentStore) {
        return this.getDefaultIndex().firstRow(persistentStore);
    }

    public final int getIndexCount() {
        return this.indexList.length;
    }

    public final Index getPrimaryIndex() {
        return this.indexList.length > 0 ? this.indexList[0] : null;
    }

    public Index getDefaultIndex() {
        return this.indexList[0];
    }

    public final Type[] getPrimaryKeyTypes() {
        return this.indexList[0].getColumnTypes();
    }

    public final boolean hasPrimaryKey() {
        return this.indexList[0].getColumnCount() > 0;
    }

    public final int[] getPrimaryKey() {
        return this.indexList[0].getColumns();
    }

    public final Type[] getColumnTypes() {
        return this.colTypes;
    }

    public final Index getIndex(int n2) {
        return this.indexList[n2];
    }

    public final Index[] getIndexList() {
        return this.indexList;
    }

    public final boolean[] getNewColumnCheckList() {
        return new boolean[this.getColumnCount()];
    }

    public final boolean[] getEmptyColumnCheckList() {
        return this.emptyColumnCheckList;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public final int getDataColumnCount() {
        return this.colTypes.length;
    }

    public boolean isSystemVersioned() {
        return this.isSystemVersioned;
    }

    public final void setBestRowIdentifiers() {
        int[] nArray = null;
        int n2 = 0;
        boolean bl = false;
        int n3 = 0;
        if (this.colNotNull == null) {
            return;
        }
        this.bestIndex = null;
        this.bestIndexForColumn = new int[this.colTypes.length];
        ArrayUtil.fillArray(this.bestIndexForColumn, -1);
        for (int i2 = 0; i2 < this.indexList.length; ++i2) {
            Index index = this.indexList[i2];
            int[] nArray2 = index.getColumns();
            int n4 = index.getColumnCount();
            if (n4 == 0) continue;
            if (i2 == 0) {
                bl = true;
            }
            if (this.bestIndexForColumn[nArray2[0]] == -1) {
                this.bestIndexForColumn[nArray2[0]] = i2;
            } else {
                Index index2 = this.indexList[this.bestIndexForColumn[nArray2[0]]];
                if (n4 > index2.getColumns().length) {
                    this.bestIndexForColumn[nArray2[0]] = i2;
                }
            }
            if (!index.isUnique()) {
                if (this.bestIndex != null) continue;
                this.bestIndex = index;
                continue;
            }
            int n5 = 0;
            for (int i3 = 0; i3 < n4; ++i3) {
                if (!this.colNotNull[nArray2[i3]]) continue;
                ++n5;
            }
            if (this.bestIndex != null) {
                this.bestIndex = index;
            }
            if (n5 == n4) {
                if (nArray != null && n2 == n3 && n4 >= n2) continue;
                nArray = nArray2;
                n2 = n4;
                n3 = n4;
                bl = true;
                continue;
            }
            if (bl || nArray != null && n4 >= n2 && n5 <= n3) continue;
            nArray = nArray2;
            n2 = n4;
            n3 = n5;
        }
        this.bestRowIdentifierCols = nArray == null || n2 == nArray.length ? nArray : ArrayUtil.arraySlice(nArray, 0, n2);
        this.bestRowIdentifierStrict = bl;
        if (this.indexList[0].getColumnCount() > 0) {
            this.bestIndex = this.indexList[0];
        }
    }

    public boolean[] getColumnNotNull() {
        return this.colNotNull;
    }

    public final void createPrimaryIndex(int[] nArray, Type[] typeArray, HsqlNameManager.HsqlName hsqlName) {
        Index index = this.getNewPrimaryIndex(nArray, typeArray, hsqlName);
        this.addIndexStructure(index);
    }

    Index getNewPrimaryIndex(int[] nArray, Type[] typeArray, HsqlNameManager.HsqlName hsqlName) {
        long l2 = this.database.persistentStoreCollection.getNextId();
        return this.database.logger.newIndex(hsqlName, l2, this, nArray, null, null, typeArray, true, nArray.length > 0, nArray.length > 0, false);
    }

    public final Index createAndAddIndexStructure(Session session, HsqlNameManager.HsqlName hsqlName, int[] nArray, boolean[] blArray, boolean[] blArray2, boolean bl, boolean bl2, boolean bl3) {
        Index index = this.createIndexStructure(hsqlName, nArray, blArray, blArray2, false, bl, bl2, bl3);
        this.addIndex(session, index);
        return index;
    }

    public final Index createIndexStructure(HsqlNameManager.HsqlName hsqlName, int[] nArray, boolean[] blArray, boolean[] blArray2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        int n2 = nArray.length;
        int[] nArray2 = new int[n2];
        Type[] typeArray = new Type[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray2[i2] = nArray[i2];
            typeArray[i2] = this.colTypes[nArray2[i2]];
        }
        long l2 = this.database.persistentStoreCollection.getNextId();
        Index index = this.database.logger.newIndex(hsqlName, l2, this, nArray2, blArray, blArray2, typeArray, bl, bl2, bl3, bl4);
        return index;
    }

    public void dropIndex(Session session, int n2) {
        Index[] indexArray = (Index[])ArrayUtil.toAdjustedArray(this.indexList, null, n2, -1);
        for (int i2 = 0; i2 < indexArray.length; ++i2) {
            indexArray[i2].setPosition(i2);
        }
        this.resetAccessorKeys(session, indexArray);
        this.indexList = indexArray;
        this.setBestRowIdentifiers();
    }

    final void addIndexStructure(Index index) {
        this.indexList = TableBase.getNewIndexArray(index, this.indexList);
        this.setBestRowIdentifiers();
    }

    static Index[] getNewIndexArray(Index index, Index[] indexArray) {
        boolean bl;
        int n2;
        for (n2 = 0; n2 < indexArray.length; ++n2) {
            Index index2 = indexArray[n2];
            int n3 = index.getIndexOrderValue() - index2.getIndexOrderValue();
            if (n3 < 0) break;
        }
        boolean bl2 = bl = index.isPrimaryKey() && indexArray.length > 0 && indexArray[0].isPrimaryKey();
        if (bl) {
            indexArray = (Index[])ArrayUtil.duplicateArray(indexArray);
            indexArray[0] = index;
        } else {
            indexArray = (Index[])ArrayUtil.toAdjustedArray(indexArray, index, n2, 1);
        }
        for (n2 = 0; n2 < indexArray.length; ++n2) {
            indexArray[n2].setPosition(n2);
        }
        return indexArray;
    }

    final void addIndex(Session session, Index index) {
        Index[] indexArray = TableBase.getNewIndexArray(index, this.indexList);
        try {
            this.resetAccessorKeys(session, indexArray);
        }
        catch (HsqlException hsqlException) {
            for (int i2 = 0; i2 < this.indexList.length; ++i2) {
                this.indexList[i2].setPosition(i2);
            }
            throw hsqlException;
        }
        this.indexList = indexArray;
        this.setBestRowIdentifiers();
    }

    private void resetAccessorKeys(Session session, Index[] indexArray) {
        if (this.store != null) {
            this.store.resetAccessorKeys(session, indexArray);
        }
    }

    public final void setIndexes(Index[] indexArray) {
        this.indexList = indexArray;
    }

    public final Object[] getEmptyRowData() {
        return new Object[this.getDataColumnCount()];
    }

    public final Index createIndex(Session session, HsqlNameManager.HsqlName hsqlName, int[] nArray, boolean[] blArray, boolean[] blArray2, boolean bl, boolean bl2, boolean bl3) {
        Index index = this.createAndAddIndexStructure(session, hsqlName, nArray, blArray, blArray2, bl, bl2, bl3);
        return index;
    }

    public final boolean isEmpty(Session session) {
        if (this.getIndexCount() == 0) {
            return true;
        }
        PersistentStore persistentStore = this.getRowStore(session);
        return this.getIndex(0).isEmpty(persistentStore);
    }

    public PersistentStore getRowStore(Session session) {
        return this.store == null ? session.sessionData.persistentStoreCollection.getStore(this) : this.store;
    }
}

