/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Constraint;
import org.hsqldb.Expression;
import org.hsqldb.HsqlException;
import org.hsqldb.ParserDQL;
import org.hsqldb.QueryExpression;
import org.hsqldb.RangeVariable;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.StatementDML;
import org.hsqldb.Table;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.navigator.RowSetNavigatorClient;
import org.hsqldb.navigator.RowSetNavigatorDataChange;
import org.hsqldb.navigator.RowSetNavigatorDataChangeMemory;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.Result;
import org.hsqldb.types.Type;

public class StatementInsert
extends StatementDML {
    static final int isNone = 0;
    static final int isIgnore = 1;
    static final int isReplace = 2;
    static final int isUpdate = 3;
    int overrideUserValue = -1;
    int specialAction = 0;

    StatementInsert(Session session, Table table, RangeVariable[] rangeVariableArray, int[] nArray, Expression expression, boolean[] blArray, Expression[] expressionArray, boolean[] blArray2, int[] nArray2, Expression[] expressionArray2, int n2, ParserDQL.CompileContext compileContext) {
        super(55, session.getCurrentSchemaHsqlName());
        this.targetTable = table;
        this.targetRangeVariables = rangeVariableArray;
        this.baseTable = table.isTriggerInsertable() ? table : table.getBaseTable();
        this.insertColumnMap = nArray;
        this.insertCheckColumns = blArray;
        this.insertExpression = expression;
        this.updateCheckColumns = blArray2;
        this.updateExpressions = expressionArray;
        this.updateColumnMap = nArray2;
        this.targets = expressionArray2;
        this.specialAction = n2;
        this.setupChecks();
        this.setDatabaseObjects(session, compileContext);
        this.checkAccessRights(session);
        this.isSimpleInsert = expression != null && expression.nodes.length == 1 && this.updatableTableCheck == null && n2 == 0;
    }

    StatementInsert(Session session, Table table, RangeVariable[] rangeVariableArray, int[] nArray, boolean[] blArray, QueryExpression queryExpression, Expression[] expressionArray, boolean[] blArray2, int[] nArray2, Expression[] expressionArray2, int n2, int n3, ParserDQL.CompileContext compileContext) {
        super(55, session.getCurrentSchemaHsqlName());
        this.targetTable = table;
        this.targetRangeVariables = rangeVariableArray;
        this.baseTable = table.isTriggerInsertable() ? table : table.getBaseTable();
        this.insertColumnMap = nArray;
        this.insertCheckColumns = blArray;
        this.queryExpression = queryExpression;
        this.overrideUserValue = n3;
        this.updateCheckColumns = blArray2;
        this.updateExpressions = expressionArray;
        this.updateColumnMap = nArray2;
        this.targets = expressionArray2;
        this.specialAction = n2;
        this.setupChecks();
        this.setDatabaseObjects(session, compileContext);
        this.checkAccessRights(session);
    }

    @Override
    Result getResult(Session session) {
        Object object;
        Result result = null;
        PersistentStore persistentStore = this.baseTable.getRowStore(session);
        int n2 = 0;
        session.getTransactionUTC();
        if (this.isSimpleInsert) {
            Type[] typeArray = this.baseTable.getColumnTypes();
            Object[] objectArray = this.getInsertData(session, typeArray, this.insertExpression.nodes[0].nodes);
            return this.insertSingleRow(session, persistentStore, objectArray);
        }
        RowSetNavigator rowSetNavigator = this.queryExpression == null ? this.getInsertValuesNavigator(session) : this.getInsertSelectNavigator(session);
        RowSetNavigatorDataChange rowSetNavigatorDataChange = null;
        if (this.specialAction != 0) {
            while (rowSetNavigator.next()) {
                boolean bl = false;
                object = rowSetNavigator.getCurrent();
                for (Constraint constraint : this.baseTable.constraintList) {
                    if (!constraint.isUniqueOrPK()) continue;
                    RowIterator rowIterator = constraint.findUniqueRows(session, (Object[])object);
                    while (rowIterator.next()) {
                        Row row;
                        bl = true;
                        if (this.specialAction == 1) break;
                        if (rowSetNavigatorDataChange == null) {
                            rowSetNavigatorDataChange = new RowSetNavigatorDataChangeMemory(session);
                        }
                        if (constraint.core.mainIndex.compareRowNonUnique(session, (row = rowIterator.getCurrentRow()).getData(), (Object[])object, constraint.core.mainCols) != 0) break;
                        rowSetNavigatorDataChange.addRow(session, row, (Object[])object, this.baseTable.getColumnTypes(), this.baseTable.defaultColumnMap);
                        ++n2;
                    }
                    rowIterator.release();
                }
                if (!bl) continue;
                rowSetNavigator.removeCurrent();
            }
        }
        if (this.specialAction == 2 && rowSetNavigatorDataChange != null) {
            n2 = this.update(session, this.baseTable, rowSetNavigatorDataChange, null);
            rowSetNavigatorDataChange.endMainDataSet();
        } else if (this.specialAction == 3 && rowSetNavigatorDataChange != null) {
            Type[] typeArray = this.baseTable.getColumnTypes();
            session.sessionContext.setRangeIterator(rowSetNavigatorDataChange);
            session.sessionContext.setRangeIterator(rowSetNavigatorDataChange.getUpdateRowIterator());
            while (rowSetNavigatorDataChange.next()) {
                session.sessionData.startRowProcessing();
                object = rowSetNavigatorDataChange.getCurrentRow();
                Object[] objectArray = ((Row)object).getDataCopy();
                StatementInsert.getUpdatedData(session, this.targets, this.baseTable, this.updateColumnMap, this.updateExpressions, typeArray, objectArray);
                rowSetNavigatorDataChange.addUpdate((Row)object, objectArray, this.updateColumnMap);
                ++session.sessionContext.rownum;
            }
            n2 = this.update(session, this.baseTable, rowSetNavigatorDataChange, null);
            rowSetNavigatorDataChange.endMainDataSet();
        }
        if (rowSetNavigator.getSize() != 0) {
            RowSetNavigator rowSetNavigator2 = null;
            if (this.generatedIndexes != null) {
                result = Result.newUpdateCountResult(this.generatedResultMetaData, 0);
                rowSetNavigator2 = result.getChainedResult().getNavigator();
            }
            this.insertRowSet(session, rowSetNavigator2, rowSetNavigator);
            n2 += rowSetNavigator.getSize();
        }
        if (this.baseTable.triggerLists[0].length > 0) {
            this.baseTable.fireTriggers(session, 0, rowSetNavigator);
        }
        if (result == null) {
            result = new Result(1, n2);
        } else {
            result.setUpdateCount(n2);
        }
        if (n2 == 0) {
            session.addWarning(HsqlException.noDataCondition);
        }
        session.sessionContext.diagnosticsVariables[2] = n2;
        return result;
    }

    RowSetNavigator getInsertSelectNavigator(Session session) {
        Type[] typeArray = this.baseTable.getColumnTypes();
        int[] nArray = this.insertColumnMap;
        Result result = this.queryExpression.getResult(session, 0);
        RowSetNavigator rowSetNavigator = result.initialiseNavigator();
        Type[] typeArray2 = result.metaData.columnTypes;
        RowSetNavigatorClient rowSetNavigatorClient = new RowSetNavigatorClient(rowSetNavigator.getSize());
        while (rowSetNavigator.next()) {
            Object[] objectArray = this.baseTable.getNewRowData(session);
            Object[] objectArray2 = rowSetNavigator.getCurrent();
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                int n2 = nArray[i2];
                if (n2 == this.overrideUserValue) continue;
                Type type = typeArray2[i2];
                objectArray[n2] = typeArray[n2].convertToType(session, objectArray2[i2], type);
            }
            rowSetNavigatorClient.add(objectArray);
        }
        return rowSetNavigatorClient;
    }

    RowSetNavigator getInsertValuesNavigator(Session session) {
        Type[] typeArray = this.baseTable.getColumnTypes();
        Expression[] expressionArray = this.insertExpression.nodes;
        RowSetNavigatorClient rowSetNavigatorClient = new RowSetNavigatorClient(expressionArray.length);
        for (int i2 = 0; i2 < expressionArray.length; ++i2) {
            Expression[] expressionArray2 = expressionArray[i2].nodes;
            Object[] objectArray = this.getInsertData(session, typeArray, expressionArray2);
            rowSetNavigatorClient.add(objectArray);
        }
        return rowSetNavigatorClient;
    }
}

