/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.ExpressionOp;
import org.hsqldb.ExpressionOrderBy;
import org.hsqldb.QueryExpression;
import org.hsqldb.QuerySpecification;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.types.Collation;
import org.hsqldb.types.Type;

public final class SortAndSlice {
    public static final SortAndSlice noSort = new SortAndSlice();
    static final int[] defaultLimits = new int[]{0, Integer.MAX_VALUE, Integer.MAX_VALUE};
    public int[] sortOrder;
    public boolean[] sortDescending;
    public boolean[] sortNullsLast;
    public Collation[] collations;
    boolean hasCollation;
    boolean sortUnion;
    HsqlArrayList exprList = new HsqlArrayList();
    ExpressionOp limitCondition;
    public int columnCount;
    boolean hasNullsLast;
    boolean noZeroLimit;
    boolean zeroLimitIsZero;
    boolean usingIndex;
    boolean descendingSort;
    public boolean skipSort = false;
    public boolean skipFullResult = false;
    public Index index;
    public Table primaryTable;
    public Index primaryTableIndex;
    public int[] colIndexes;
    public boolean isGenerated;

    public HsqlArrayList getExpressionList() {
        return this.exprList;
    }

    public boolean hasOrder() {
        return this.exprList.size() != 0;
    }

    public boolean hasLimit() {
        return this.limitCondition != null;
    }

    public int getOrderLength() {
        return this.exprList.size();
    }

    public void addOrderExpression(Expression expression) {
        this.exprList.add(expression);
    }

    public void addLimitCondition(ExpressionOp expressionOp) {
        this.limitCondition = expressionOp;
    }

    public void setStrictLimit() {
        this.noZeroLimit = true;
    }

    public void setZeroLimitIsZero() {
        this.zeroLimitIsZero = true;
    }

    public void setUsingIndex() {
        this.usingIndex = true;
    }

    public void prepareSingleColumn(int n2) {
        this.sortOrder = new int[1];
        this.sortDescending = new boolean[1];
        this.sortNullsLast = new boolean[1];
        this.sortOrder[0] = n2;
        this.columnCount = 1;
    }

    public void prepareMultiColumn(int n2) {
        this.sortOrder = new int[n2];
        this.sortDescending = new boolean[n2];
        this.sortNullsLast = new boolean[n2];
        this.columnCount = n2;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.sortOrder[i2] = i2;
        }
    }

    public void prepareExtraColumn(int n2) {
        this.columnCount = this.exprList.size();
        if (this.columnCount == 0) {
            return;
        }
        this.sortOrder = new int[this.columnCount + n2];
        this.sortDescending = new boolean[this.columnCount + n2];
        this.sortNullsLast = new boolean[this.columnCount + n2];
        ArrayUtil.fillSequence(this.sortOrder);
        for (int i2 = 0; i2 < this.columnCount; ++i2) {
            ExpressionOrderBy expressionOrderBy = (ExpressionOrderBy)this.exprList.get(i2);
            this.sortDescending[i2] = expressionOrderBy.isDescending();
            this.sortNullsLast[i2] = expressionOrderBy.isNullsLast();
            this.hasNullsLast |= this.sortNullsLast[i2];
        }
    }

    public void prepare(int n2) {
        this.columnCount = this.exprList.size();
        if (this.columnCount == 0) {
            return;
        }
        this.sortOrder = new int[this.columnCount];
        this.sortDescending = new boolean[this.columnCount];
        this.sortNullsLast = new boolean[this.columnCount];
        this.collations = new Collation[this.columnCount];
        for (int i2 = 0; i2 < this.columnCount; ++i2) {
            ExpressionOrderBy expressionOrderBy = (ExpressionOrderBy)this.exprList.get(i2);
            int n3 = expressionOrderBy.getLeftNode().resultTableColumnIndex;
            this.sortOrder[i2] = n3 == -1 ? n2 + i2 : n3;
            this.sortDescending[i2] = expressionOrderBy.isDescending();
            this.sortNullsLast[i2] = expressionOrderBy.isNullsLast();
            this.collations[i2] = expressionOrderBy.collation;
            this.hasNullsLast |= this.sortNullsLast[i2];
            if (expressionOrderBy.collation == null) continue;
            this.hasCollation = true;
        }
    }

    void setSortIndex(QuerySpecification querySpecification) {
        int n2;
        Cloneable cloneable;
        int n3;
        if (this == noSort) {
            return;
        }
        if (this.isGenerated) {
            return;
        }
        for (n3 = 0; n3 < this.columnCount; ++n3) {
            ExpressionOrderBy expressionOrderBy = (ExpressionOrderBy)this.exprList.get(n3);
            cloneable = expressionOrderBy.getLeftNode().getDataType();
            if (!((Type)cloneable).isLobType()) continue;
            throw Error.error(5534);
        }
        if (querySpecification == null) {
            return;
        }
        if ((querySpecification.isDistinctSelect || querySpecification.isGrouped || querySpecification.isAggregated) && !querySpecification.isSimpleDistinct) {
            return;
        }
        if (this.columnCount == 0) {
            if (this.limitCondition == null) {
                return;
            }
            this.skipFullResult = true;
            return;
        }
        if (this.hasCollation) {
            return;
        }
        this.colIndexes = new int[this.columnCount];
        n3 = 0;
        for (n2 = 0; n2 < this.columnCount; ++n2) {
            cloneable = ((Expression)this.exprList.get(n2)).getLeftNode();
            if (((Expression)cloneable).getType() != 2) {
                return;
            }
            if (((Expression)cloneable).getRangeVariable() != querySpecification.rangeVariables[0]) {
                return;
            }
            this.colIndexes[n2] = ((Expression)cloneable).columnIndex;
            if (((Expression)cloneable).getColumn().getNullability() == 0) continue;
            n3 = 1;
        }
        if (this.hasNullsLast && n3 != 0) {
            return;
        }
        n2 = ArrayUtil.countTrueElements(this.sortDescending);
        boolean bl = this.descendingSort = n2 == this.columnCount;
        if (!this.descendingSort && n2 > 0) {
            return;
        }
        this.primaryTable = querySpecification.rangeVariables[0].getTable();
        this.primaryTableIndex = this.primaryTable.getFullIndexForColumns(this.colIndexes);
    }

    void setSortRange(QuerySpecification querySpecification) {
        Index index;
        if (this == noSort) {
            return;
        }
        if (this.primaryTableIndex == null) {
            if (querySpecification.isSimpleDistinct) {
                this.setSortIndex(querySpecification);
            }
            if (this.primaryTableIndex == null) {
                return;
            }
        }
        if ((index = querySpecification.rangeVariables[0].getSortIndex()) == null) {
            return;
        }
        if (this.primaryTable != querySpecification.rangeVariables[0].rangeTable) {
            return;
        }
        if (index == this.primaryTableIndex) {
            if (this.descendingSort) {
                if (querySpecification.isDistinctSelect) {
                    return;
                }
                boolean bl = querySpecification.rangeVariables[0].reverseOrder();
                if (!bl) {
                    return;
                }
            }
            this.skipSort = true;
            this.skipFullResult = true;
        } else if (!querySpecification.rangeVariables[0].joinConditions[0].hasIndexCondition() && querySpecification.rangeVariables[0].setSortIndex(this.primaryTableIndex, this.descendingSort)) {
            this.skipSort = true;
            this.skipFullResult = true;
        }
    }

    public boolean prepareSpecial(Session session, QuerySpecification querySpecification) {
        Expression expression = querySpecification.exprColumns[querySpecification.indexStartAggregates];
        int n2 = expression.getType();
        if ((expression = expression.getLeftNode()).getType() != 2) {
            return false;
        }
        if (expression.getRangeVariable() != querySpecification.rangeVariables[0]) {
            return false;
        }
        Index index = querySpecification.rangeVariables[0].getSortIndex();
        if (index == null) {
            return false;
        }
        if (querySpecification.rangeVariables[0].hasAnyTerminalCondition()) {
            return false;
        }
        if (querySpecification.rangeVariables[0].hasSingleIndexCondition()) {
            int[] nArray = index.getColumns();
            if (nArray[0] != expression.getColumnIndex()) {
                return false;
            }
            if (n2 == 77) {
                querySpecification.rangeVariables[0].reverseOrder();
            }
        } else {
            if (querySpecification.rangeVariables[0].hasAnyIndexCondition()) {
                return false;
            }
            Table table = querySpecification.rangeVariables[0].getTable();
            Index index2 = table.getIndexForColumn(session, expression.getColumnIndex());
            if (index2 == null) {
                return false;
            }
            Expression[] expressionArray = new Expression[]{ExpressionLogical.newNotNullCondition(expression)};
            querySpecification.rangeVariables[0].joinConditions[0].addIndexCondition(expressionArray, index2, 1);
            if (n2 == 77) {
                querySpecification.rangeVariables[0].reverseOrder();
            }
        }
        this.columnCount = 1;
        this.sortOrder = new int[this.columnCount];
        this.sortDescending = new boolean[this.columnCount];
        this.sortNullsLast = new boolean[this.columnCount];
        this.skipSort = true;
        this.skipFullResult = true;
        return true;
    }

    int[] getLimits(Session session, QueryExpression queryExpression, int n2) {
        if (this == noSort && n2 == 0) {
            return defaultLimits;
        }
        int n3 = 0;
        int n4 = Integer.MAX_VALUE;
        int n5 = Integer.MAX_VALUE;
        boolean bl = false;
        if (this.hasLimit()) {
            Integer n6 = (Integer)this.limitCondition.getLeftNode().getValue(session);
            if (n6 == null || n6 < 0) {
                throw Error.error(3453);
            }
            n3 = n6;
            boolean bl2 = bl = n3 != 0;
            if (this.limitCondition.getRightNode() != null) {
                n6 = (Integer)this.limitCondition.getRightNode().getValue(session);
                if (n6 == null || n6 < 0 || this.noZeroLimit && n6 == 0) {
                    throw Error.error(3452);
                }
                if (n6 == 0 && !this.zeroLimitIsZero) {
                    n4 = Integer.MAX_VALUE;
                } else {
                    n4 = n6;
                    bl = true;
                }
            }
        }
        if (n2 != 0) {
            if (n2 < n4) {
                n4 = n2;
            }
            bl = true;
        }
        boolean bl3 = false;
        if (queryExpression instanceof QuerySpecification) {
            QuerySpecification querySpecification = (QuerySpecification)queryExpression;
            if (!querySpecification.isDistinctSelect && !querySpecification.isGrouped) {
                bl3 = true;
            }
            if (querySpecification.isSimpleDistinct) {
                bl3 = true;
            }
        }
        if (bl) {
            if (!(!bl3 || this.hasOrder() && !this.skipSort || this.hasLimit() && !this.skipFullResult || n5 - n3 <= n4)) {
                n5 = n3 + n4;
            }
            return new int[]{n3, n4, n5};
        }
        return defaultLimits;
    }

    public void setIndex(Session session, TableBase tableBase) {
        this.index = this.getNewIndex(session, tableBase);
    }

    public Index getNewIndex(Session session, TableBase tableBase) {
        if (this.hasOrder()) {
            Index index = tableBase.createAndAddIndexStructure(session, null, this.sortOrder, this.sortDescending, this.sortNullsLast, false, false, false);
            if (this.hasCollation) {
                for (int i2 = 0; i2 < this.columnCount; ++i2) {
                    if (this.collations[i2] == null) continue;
                    Type type = index.getColumnTypes()[i2];
                    index.getColumnTypes()[i2] = type = Type.getType(type.typeCode, type.getCharacterSet(), this.collations[i2], type.precision, type.scale);
                }
            }
            return index;
        }
        return null;
    }
}

