/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicLong;
import org.hsqldb.Database;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Session;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.LongKeyHashMap;
import org.hsqldb.rights.User;

public class SessionManager {
    AtomicLong sessionIdCount = new AtomicLong();
    private LongKeyHashMap sessionMap = new LongKeyHashMap();
    private Session sysSession;
    private Session sysLobSession;

    public SessionManager(Database database) {
        User user = database.getUserManager().getSysUser();
        this.sysSession = new Session(database, user, false, false, this.sessionIdCount.getAndIncrement(), TimeZone.getTimeZone("GMT"));
        this.sysLobSession = new Session(database, user, true, false, this.sessionIdCount.getAndIncrement(), TimeZone.getTimeZone("GMT"));
    }

    public synchronized Session newSession(Database database, User user, boolean bl, boolean bl2, TimeZone timeZone) {
        long l2 = this.sessionIdCount.getAndIncrement();
        Session session = new Session(database, user, bl2, bl, l2, timeZone);
        this.sessionMap.put(l2, session);
        return session;
    }

    public synchronized Session newSessionForLog(Database database) {
        long l2 = this.sessionIdCount.getAndIncrement();
        Session session = new Session(database, database.getUserManager().getSysUser(), false, false, l2, TimeZone.getTimeZone("GMT"));
        session.isProcessingLog = true;
        this.sessionMap.put(l2, session);
        return session;
    }

    public Session getSysSessionForScript(Database database) {
        Session session = new Session(database, database.getUserManager().getSysUser(), false, false, 0L, TimeZone.getTimeZone("GMT"));
        session.setCurrentSchemaHsqlName(database.schemaManager.defaultSchemaHsqlName);
        session.isProcessingScript = true;
        return session;
    }

    public Session getSysLobSession() {
        return this.sysLobSession;
    }

    public Session getSysSession() {
        this.sysSession.currentSchema = this.sysSession.database.schemaManager.getDefaultSchemaHsqlName();
        this.sysSession.isProcessingScript = false;
        this.sysSession.isProcessingLog = false;
        this.sysSession.setUser(this.sysSession.database.getUserManager().getSysUser());
        return this.sysSession;
    }

    public synchronized Session newSysSession() {
        long l2 = this.sessionIdCount.getAndIncrement();
        Session session = new Session(this.sysSession.database, this.sysSession.getUser(), false, false, l2, TimeZone.getTimeZone("GMT"));
        session.currentSchema = this.sysSession.database.schemaManager.getDefaultSchemaHsqlName();
        this.sessionMap.put(l2, session);
        return session;
    }

    public synchronized Session newSysSession(HsqlNameManager.HsqlName hsqlName, User user) {
        long l2 = this.sessionIdCount.getAndIncrement();
        Session session = new Session(this.sysSession.database, user, false, false, l2, TimeZone.getTimeZone("GMT"));
        session.currentSchema = hsqlName;
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllSessions() {
        Session[] sessionArray = this.getAllSessions();
        for (int i2 = 0; i2 < sessionArray.length; ++i2) {
            sessionArray[i2].close();
        }
        SessionManager sessionManager = this;
        synchronized (sessionManager) {
            this.sessionMap.clear();
        }
    }

    synchronized void removeSession(Session session) {
        this.sessionMap.remove(session.getId());
    }

    synchronized void close() {
        this.closeAllSessions();
        this.sysSession.close();
        this.sysLobSession.close();
    }

    synchronized boolean isEmpty() {
        return this.sessionMap.isEmpty();
    }

    public synchronized Session[] getVisibleSessions(Session session) {
        Session[] sessionArray;
        if (session.isAdmin()) {
            sessionArray = this.getAllSessions();
        } else {
            Session[] sessionArray2 = new Session[1];
            sessionArray = sessionArray2;
            sessionArray2[0] = session;
        }
        return sessionArray;
    }

    synchronized Session getSession(long l2) {
        return (Session)this.sessionMap.get(l2);
    }

    public synchronized Session[] getAllSessions() {
        Session[] sessionArray = new Session[this.sessionMap.size()];
        Iterator iterator = this.sessionMap.values().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            sessionArray[n2] = (Session)iterator.next();
            ++n2;
        }
        return sessionArray;
    }

    public synchronized boolean isUserActive(String string) {
        Iterator iterator = this.sessionMap.values().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            Session session = (Session)iterator.next();
            if (!session.isClosed() && string.equals(session.getUser().getName().getNameString())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public synchronized void removeSchemaReference(HsqlNameManager.HsqlName hsqlName) {
        Iterator iterator = this.sessionMap.values().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            Session session = (Session)iterator.next();
            if (session.getCurrentSchemaHsqlName() == hsqlName) {
                session.resetSchema();
            }
            ++n2;
        }
    }

    public synchronized void resetLoggedSchemas() {
        Iterator iterator = this.sessionMap.values().iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            Session session = (Session)iterator.next();
            session.loggedSchema = null;
            ++n2;
        }
        this.sysLobSession.loggedSchema = null;
    }
}

