/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.math.BigDecimal;
import java.util.Locale;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.Token;
import org.hsqldb.Tokens;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.CharArrayWriter;
import org.hsqldb.lib.HsqlByteArrayOutputStream;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.map.BitMap;
import org.hsqldb.map.ValuePool;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BinaryType;
import org.hsqldb.types.BitType;
import org.hsqldb.types.CharacterType;
import org.hsqldb.types.DTIType;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class Scanner {
    static final char[] specials = new char[]{'\"', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '\\', ':', ';', '<', '=', '>', '?', '[', ']', '^', '_', '|', '{', '}'};
    static final String[] multi = new String[]{"??(", "??)", "<>", ">=", "<=", "||", "->", "::", "..", "--", "/*", "*/"};
    static final char[] whitespace = new char[]{'\t', '\n', '\u000b', '\f', '\r', ' ', '\u0085', ' ', '\u00a0', '\u1680', '\u180e', '\u2000', '\u2001', '\u2002', '\u2003', '\u2004', '\u2005', '\u2006', '\u2007', '\u2008', '\u2009', '\u200a', '\u202f', '\u205f', '\u3000', '\u2028', '\u2029'};
    static final OrderedIntHashSet whiteSpaceSet = new OrderedIntHashSet(32);
    String sqlString;
    int currentPosition;
    int tokenPosition;
    int limit;
    Token token = new Token();
    boolean nullAndBooleanAsValue;
    boolean backtickQuoting;
    boolean hyphenInBinary;
    boolean charLiteral = true;
    private boolean hasNonSpaceSeparator;
    private static final int maxPooledStringLength;
    char[] charBuffer = new char[256];
    CharArrayWriter charWriter = new CharArrayWriter(this.charBuffer);
    byte[] byteBuffer = new byte[256];
    HsqlByteArrayOutputStream byteOutputStream = new HsqlByteArrayOutputStream(this.byteBuffer);
    private String intervalString;
    private int intervalPosition;
    private int intervalPrecision;
    private int fractionPrecision;
    Type dateTimeType;

    public Scanner() {
    }

    public Scanner(Session session, String string) {
        this.reset(session, string);
    }

    public void reset(Session session, String string) {
        this.reset(string);
        if (session != null) {
            this.backtickQuoting = session.database.sqlSyntaxMys;
            this.charLiteral = session.database.sqlCharLiteral;
        }
    }

    public void reset(String string) {
        this.sqlString = string;
        this.currentPosition = 0;
        this.tokenPosition = 0;
        this.limit = this.sqlString.length();
        this.hasNonSpaceSeparator = false;
        this.token.reset();
        this.token.tokenType = 1015;
    }

    void resetState() {
        this.tokenPosition = this.currentPosition;
        this.token.reset();
    }

    public void setNullAndBooleanAsValue() {
        this.nullAndBooleanAsValue = true;
    }

    public void scanNext() {
        if (this.currentPosition == this.limit) {
            this.resetState();
            this.token.tokenType = 1014;
            return;
        }
        if (this.scanSeparator()) {
            // empty if block
        }
        if (this.currentPosition == this.limit) {
            this.resetState();
            this.token.tokenType = 1014;
            return;
        }
        boolean bl = !this.token.isDelimiter;
        this.scanToken();
        if (!bl || !this.token.isDelimiter) {
            // empty if block
        }
        if (this.token.isMalformed) {
            this.token.fullString = this.getPart(this.tokenPosition, this.currentPosition);
        }
    }

    public void scanEnd() {
        if (this.currentPosition == this.limit) {
            this.resetState();
            this.token.tokenType = 1014;
        }
    }

    public Token getToken() {
        return this.token;
    }

    public String getString() {
        return this.token.tokenString;
    }

    public int getTokenType() {
        return this.token.tokenType;
    }

    public Object getValue() {
        return this.token.tokenValue;
    }

    public Type getDataType() {
        return this.token.dataType;
    }

    public void replaceToken(String string) {
        this.sqlString = this.sqlString.substring(0, this.tokenPosition) + string + this.sqlString.substring(this.currentPosition);
        this.limit = this.sqlString.length();
        this.currentPosition = this.tokenPosition + string.length();
    }

    public int getLineNumber() {
        return Scanner.countEndOfLines(this.sqlString, this.tokenPosition) + 1;
    }

    int getTokenPosition() {
        return this.tokenPosition;
    }

    void position(int n2) {
        this.currentPosition = this.tokenPosition = n2;
    }

    String getPart(int n2, int n3) {
        return this.sqlString.substring(n2, n3);
    }

    private int charAt(int n2) {
        if (n2 >= this.limit) {
            return -1;
        }
        return this.sqlString.charAt(n2);
    }

    void scanBinaryString() {
        this.byteOutputStream.reset(this.byteBuffer);
        do {
            this.scanBinaryStringPart();
            if (!this.token.isMalformed) continue;
            return;
        } while (this.scanSeparator() && this.charAt(this.currentPosition) == 39);
        this.token.tokenValue = new BinaryData(this.byteOutputStream.toByteArray(), false);
        this.byteOutputStream.reset(this.byteBuffer);
    }

    static int getHexValue(int n2) {
        n2 = n2 >= 48 && n2 <= 57 ? (n2 -= 48) : (n2 >= 97 && n2 <= 102 ? (n2 -= 87) : (n2 >= 65 && n2 <= 70 ? (n2 -= 55) : -1));
        return n2;
    }

    public void scanUUIDStringWithQuote() {
        try {
            this.hyphenInBinary = true;
            this.scanBinaryStringWithQuote();
            if (this.token.tokenValue instanceof BinaryData && ((BinaryData)this.token.tokenValue).length(null) != 16L) {
                this.token.tokenType = 1022;
                this.token.isMalformed = true;
            }
        }
        finally {
            this.hyphenInBinary = false;
        }
    }

    public void scanBinaryStringWithQuote() {
        this.resetState();
        this.scanSeparator();
        if (this.charAt(this.currentPosition) != 39) {
            this.token.tokenType = 1022;
            this.token.isMalformed = true;
            return;
        }
        this.scanBinaryString();
    }

    void scanBinaryStringPart() {
        boolean bl = false;
        boolean bl2 = true;
        byte by = 0;
        ++this.currentPosition;
        while (this.currentPosition < this.limit) {
            int n2 = this.sqlString.charAt(this.currentPosition);
            if (!(this.hyphenInBinary && n2 == 45 || n2 == 32)) {
                if (n2 == 39) {
                    bl = true;
                    ++this.currentPosition;
                    break;
                }
                if ((n2 = Scanner.getHexValue(n2)) == -1) {
                    this.token.tokenType = 1022;
                    this.token.isMalformed = true;
                    return;
                }
                if (bl2) {
                    by = (byte)(n2 << 4);
                    bl2 = false;
                } else {
                    by = (byte)(by + (byte)n2);
                    this.byteOutputStream.writeByte(by);
                    bl2 = true;
                }
            }
            ++this.currentPosition;
        }
        if (!bl2) {
            this.token.tokenType = 1022;
            this.token.isMalformed = true;
            return;
        }
        if (!bl) {
            this.token.tokenType = 1022;
            this.token.isMalformed = true;
        }
    }

    void scanBitString() {
        BitMap bitMap = new BitMap(0, true);
        do {
            this.scanBitStringPart(bitMap);
            if (!this.token.isMalformed) continue;
            return;
        } while (this.scanSeparator() && this.charAt(this.currentPosition) == 39);
        this.token.tokenValue = BinaryData.getBitData(bitMap.getBytes(), bitMap.size());
    }

    public void scanBitStringWithQuote() {
        this.resetState();
        this.scanSeparator();
        if (this.charAt(this.currentPosition) != 39) {
            this.token.tokenType = 1021;
            this.token.isMalformed = true;
            return;
        }
        this.scanBitString();
    }

    void scanBitStringPart(BitMap bitMap) {
        boolean bl = false;
        int n2 = bitMap.size();
        ++this.currentPosition;
        while (this.currentPosition < this.limit) {
            char c2 = this.sqlString.charAt(this.currentPosition);
            if (c2 != ' ') {
                if (c2 == '\'') {
                    bl = true;
                    ++this.currentPosition;
                    break;
                }
                if (c2 == '0') {
                    bitMap.unset(n2);
                    ++n2;
                } else if (c2 == '1') {
                    bitMap.set(n2);
                    ++n2;
                } else {
                    this.token.tokenType = 1021;
                    this.token.isMalformed = true;
                    return;
                }
            }
            ++this.currentPosition;
        }
        if (!bl) {
            this.token.tokenType = 1021;
            this.token.isMalformed = true;
            return;
        }
        bitMap.setSize(n2);
    }

    void convertUnicodeString(int n2) {
        this.charWriter.reset(this.charBuffer);
        int n3 = 0;
        while (true) {
            int n4;
            if ((n4 = this.token.tokenString.indexOf(n2, n3)) < 0) {
                n4 = this.token.tokenString.length();
            }
            this.charWriter.write(this.token.tokenString, n3, n4 - n3);
            if (n4 == this.token.tokenString.length()) break;
            if (++n4 == this.token.tokenString.length()) {
                this.token.tokenType = 1023;
                this.token.isMalformed = true;
                return;
            }
            if (this.token.tokenString.charAt(n4) == n2) {
                this.charWriter.write(n2);
                n3 = ++n4;
                continue;
            }
            if (n4 > this.token.tokenString.length() - 4) {
                this.token.tokenType = 1023;
                this.token.isMalformed = true;
                return;
            }
            int n5 = 4;
            int n6 = 0;
            int n7 = 0;
            if (this.token.tokenString.charAt(n4) == '+') {
                if (++n4 > this.token.tokenString.length() - 6) {
                    this.token.tokenType = 1023;
                    this.token.isMalformed = true;
                    return;
                }
                n6 = 2;
                n5 = 8;
            }
            n3 = n4;
            while (n6 < n5) {
                int n8 = this.token.tokenString.charAt(n3++);
                if ((n8 = Scanner.getHexValue(n8)) == -1) {
                    this.token.tokenType = 1023;
                    this.token.isMalformed = true;
                    return;
                }
                n7 |= n8 << (n5 - n6 - 1) * 4;
                ++n6;
            }
            if (n5 == 8) {
                this.charWriter.write(n7 >>> 16);
            }
            this.charWriter.write(n7 & (n7 & 0xFFFF));
        }
        this.token.tokenValue = this.charWriter.toString();
    }

    public boolean scanSpecialIdentifier(String string) {
        int n2 = string.length();
        if (this.limit - this.currentPosition < n2) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == this.sqlString.charAt(this.currentPosition + i2) || c2 == Character.toUpperCase(this.sqlString.charAt(this.currentPosition + i2))) continue;
            return false;
        }
        this.currentPosition += n2;
        return true;
    }

    private int scanEscapeDefinition() {
        int n2 = this.charAt(this.currentPosition);
        if (n2 == 39) {
            ++this.currentPosition;
            if (!this.scanWhitespace() && Scanner.getHexValue(n2 = this.charAt(this.currentPosition)) == -1 && n2 != 43 && n2 != 39 && n2 != 34) {
                int n3 = n2;
                ++this.currentPosition;
                n2 = this.charAt(this.currentPosition);
                if (n2 == 39) {
                    ++this.currentPosition;
                    return n3;
                }
            }
        }
        return -1;
    }

    private void scanUnicodeString() {
        int n2 = 92;
        this.scanCharacterString();
        this.scanSeparator();
        int n3 = this.charAt(this.currentPosition);
        if ((n3 == 117 || n3 == 85) && this.scanSpecialIdentifier("UESCAPE")) {
            this.scanSeparator();
            n2 = this.scanEscapeDefinition();
            if (n2 == -1) {
                this.token.tokenType = 1026;
                this.token.isMalformed = true;
                return;
            }
        }
        this.convertUnicodeString(n2);
    }

    private boolean scanUnicodeIdentifier() {
        int n2 = 92;
        this.scanStringPart('\"');
        if (this.token.isMalformed) {
            return false;
        }
        this.token.tokenString = this.charWriter.toString();
        int n3 = this.charAt(this.currentPosition);
        if ((n3 == 117 || n3 == 85) && this.scanSpecialIdentifier("UESCAPE")) {
            this.scanSeparator();
            n2 = this.scanEscapeDefinition();
            if (n2 == -1) {
                this.token.tokenType = 1026;
                this.token.isMalformed = true;
                return false;
            }
        }
        this.convertUnicodeString(n2);
        return !this.token.isMalformed;
    }

    boolean shiftPrefixes() {
        if (this.token.namePrePrePrefix != null) {
            return false;
        }
        this.token.namePrePrePrefix = this.token.namePrePrefix;
        this.token.isDelimitedPrePrePrefix = this.token.isDelimitedPrePrefix;
        this.token.namePrePrefix = this.token.namePrefix;
        this.token.isDelimitedPrePrefix = this.token.isDelimitedPrefix;
        this.token.namePrefix = this.token.tokenString;
        this.token.isDelimitedPrefix = this.token.tokenType == 1013;
        return true;
    }

    private void scanIdentifierChain() {
        boolean bl;
        int n2 = this.charAt(this.currentPosition);
        switch (n2) {
            case 96: {
                if (!this.backtickQuoting) break;
                this.charWriter.reset(this.charBuffer);
                this.scanStringPart('`');
                if (this.token.isMalformed) {
                    return;
                }
                this.token.tokenType = 1013;
                this.token.tokenString = this.charWriter.toString();
                this.token.isDelimiter = true;
                break;
            }
            case 34: {
                this.charWriter.reset(this.charBuffer);
                this.scanStringPart('\"');
                if (this.token.isMalformed) {
                    return;
                }
                this.token.tokenType = 1013;
                this.token.tokenString = this.charWriter.toString();
                this.token.isDelimiter = true;
                break;
            }
            case 85: 
            case 117: {
                if (this.charAt(this.currentPosition + 1) == 38 && this.charAt(this.currentPosition + 1) == 34) {
                    this.currentPosition += 3;
                    bl = this.scanUnicodeIdentifier();
                    if (!bl) {
                        return;
                    }
                    this.token.tokenType = 1013;
                    this.token.isDelimiter = false;
                    break;
                }
            }
            default: {
                bl = this.scanUndelimitedIdentifier();
                if (!bl) {
                    return;
                }
                this.token.tokenType = 1012;
                this.token.isDelimiter = false;
            }
        }
        bl = this.scanWhitespace();
        n2 = this.charAt(this.currentPosition);
        if (n2 == 46) {
            int n3;
            if (bl && (n3 = this.charAt(this.currentPosition + 1)) >= 48 && n3 <= 57) {
                return;
            }
            ++this.currentPosition;
            this.scanWhitespace();
            n2 = this.charAt(this.currentPosition);
            if (n2 == 42) {
                ++this.currentPosition;
                this.shiftPrefixes();
                this.token.tokenString = "*";
                this.token.tokenType = 921;
            } else {
                this.shiftPrefixes();
                this.scanIdentifierChain();
            }
        }
    }

    public boolean scanUndelimitedIdentifier() {
        int n2;
        int n3;
        boolean bl;
        if (this.currentPosition == this.limit) {
            return false;
        }
        char c2 = this.sqlString.charAt(this.currentPosition);
        boolean bl2 = bl = c2 == '_' || c2 == '$';
        if (!bl && !Character.isLetter(c2)) {
            this.token.tokenString = Character.toString(c2);
            this.token.tokenType = -1;
            this.token.isMalformed = true;
            return false;
        }
        for (n3 = this.currentPosition + 1; n3 < this.limit; ++n3) {
            n2 = this.sqlString.charAt(n3);
            if (n2 == 36) {
                bl = true;
                continue;
            }
            if (n2 != 95 && !Character.isLetterOrDigit((char)n2)) break;
        }
        this.token.tokenString = this.sqlString.substring(this.currentPosition, n3).toUpperCase(Locale.ENGLISH);
        this.currentPosition = n3;
        if (this.nullAndBooleanAsValue && ((n2 = this.currentPosition - this.tokenPosition) == 4 || n2 == 5)) {
            switch (c2) {
                case 'T': 
                case 't': {
                    if (!"TRUE".equals(this.token.tokenString)) break;
                    this.token.tokenString = "TRUE";
                    this.token.tokenType = 1011;
                    this.token.tokenValue = Boolean.TRUE;
                    this.token.dataType = Type.SQL_BOOLEAN;
                    return false;
                }
                case 'F': 
                case 'f': {
                    if (!"FALSE".equals(this.token.tokenString)) break;
                    this.token.tokenString = "FALSE";
                    this.token.tokenType = 1011;
                    this.token.tokenValue = Boolean.FALSE;
                    this.token.dataType = Type.SQL_BOOLEAN;
                    return false;
                }
                case 'N': 
                case 'n': {
                    if (!"NULL".equals(this.token.tokenString)) break;
                    this.token.tokenString = "NULL";
                    this.token.tokenType = 1011;
                    this.token.tokenValue = null;
                    return false;
                }
            }
        }
        if (bl) {
            this.token.hasIrregularChar = true;
        }
        return true;
    }

    void scanNumber() {
        boolean bl = false;
        boolean bl2 = false;
        int n2 = -1;
        this.token.tokenType = 1011;
        this.token.dataType = Type.SQL_INTEGER;
        int n3 = this.currentPosition;
        while (this.currentPosition < this.limit) {
            boolean bl3 = false;
            int n4 = this.charAt(this.currentPosition);
            switch (n4) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    bl = true;
                    break;
                }
                case 46: {
                    this.token.dataType = Type.SQL_NUMERIC;
                    if (bl2 || n2 != -1) {
                        this.token.tokenString = this.sqlString.substring(n3, this.currentPosition + 1);
                        this.token.tokenType = 1020;
                        this.token.isMalformed = true;
                        return;
                    }
                    bl2 = true;
                    break;
                }
                case 69: 
                case 101: {
                    this.token.dataType = Type.SQL_DOUBLE;
                    if (n2 != -1 || !bl) {
                        this.token.tokenString = this.sqlString.substring(n3, this.currentPosition + 1);
                        this.token.tokenType = 1020;
                        this.token.isMalformed = true;
                        return;
                    }
                    bl2 = true;
                    n2 = this.currentPosition;
                    break;
                }
                case 43: 
                case 45: {
                    if (n2 == this.currentPosition - 1) break;
                    bl3 = true;
                    break;
                }
                case 71: 
                case 75: 
                case 77: 
                case 80: 
                case 84: 
                case 103: 
                case 107: 
                case 109: 
                case 112: 
                case 116: {
                    if (!bl || bl2) {
                        this.token.tokenType = 1020;
                        this.token.isMalformed = true;
                        return;
                    }
                    String string = Character.toString((char)n4).toUpperCase(Locale.ENGLISH);
                    this.token.lobMultiplierType = Tokens.getNonKeywordID(string, 1020);
                    if (this.token.lobMultiplierType == 1020) {
                        this.token.tokenType = 1020;
                        this.token.isMalformed = true;
                        return;
                    }
                    try {
                        this.token.tokenValue = ValuePool.getInt(Integer.parseInt(this.sqlString.substring(n3, this.currentPosition)));
                        this.token.tokenType = 1018;
                        ++this.currentPosition;
                        this.token.fullString = this.getPart(this.tokenPosition, this.currentPosition);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.token.tokenType = 1020;
                        this.token.isMalformed = true;
                    }
                    return;
                }
                default: {
                    bl3 = true;
                }
            }
            if (bl3) break;
            ++this.currentPosition;
        }
        this.token.tokenString = this.sqlString.substring(n3, this.currentPosition);
        switch (this.token.dataType.typeCode) {
            case 4: {
                if (this.token.tokenString.length() < 20) {
                    try {
                        long l2 = Long.parseLong(this.token.tokenString);
                        if (this.token.tokenString.length() < 11 && l2 <= Integer.MAX_VALUE) {
                            this.token.tokenValue = ValuePool.getInt((int)l2);
                            return;
                        }
                        this.token.dataType = Type.SQL_BIGINT;
                        this.token.tokenValue = ValuePool.getLong(l2);
                        return;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.token.dataType = Type.SQL_NUMERIC;
            }
            case 2: {
                try {
                    BigDecimal bigDecimal = new BigDecimal(this.token.tokenString);
                    this.token.tokenValue = bigDecimal;
                    this.token.dataType = NumberType.getNumberTypeForLiteral(bigDecimal);
                }
                catch (Exception exception) {
                    this.token.tokenType = 1020;
                    this.token.isMalformed = true;
                    return;
                }
                return;
            }
            case 8: {
                try {
                    double d2 = Double.parseDouble(this.token.tokenString);
                    long l3 = Double.doubleToLongBits(d2);
                    this.token.tokenValue = ValuePool.getDouble(l3);
                }
                catch (Exception exception) {
                    this.token.tokenType = 1020;
                    this.token.isMalformed = true;
                    return;
                }
                return;
            }
        }
    }

    boolean scanSeparator() {
        boolean bl = false;
        while (true) {
            boolean bl2 = this.scanWhitespace();
            bl |= bl2;
            if (!this.scanCommentAsInlineSeparator()) break;
            bl = true;
            this.hasNonSpaceSeparator = true;
        }
        return bl;
    }

    boolean scanCommentAsInlineSeparator() {
        int n2 = this.charAt(this.currentPosition);
        if (n2 == 45 && this.charAt(this.currentPosition + 1) == 45) {
            int n3 = this.sqlString.indexOf(13, this.currentPosition + 2);
            if (n3 == -1) {
                n3 = this.sqlString.indexOf(10, this.currentPosition + 2);
            } else if (this.charAt(n3 + 1) == 10) {
                ++n3;
            }
            this.currentPosition = n3 == -1 ? this.limit : n3 + 1;
            return true;
        }
        if (n2 == 47 && this.charAt(this.currentPosition + 1) == 42) {
            return this.skipBracketedComment();
        }
        return false;
    }

    public boolean scanWhitespace() {
        boolean bl = false;
        while (this.currentPosition < this.limit) {
            char c2 = this.sqlString.charAt(this.currentPosition);
            if (c2 == ' ') {
                bl = true;
            } else {
                if (!whiteSpaceSet.contains(c2)) break;
                this.hasNonSpaceSeparator = true;
                bl = true;
            }
            ++this.currentPosition;
        }
        return bl;
    }

    private static int countEndOfLines(String string, int n2) {
        int n3 = -2;
        char c2 = '\u0000';
        int n4 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c3 = string.charAt(i2);
            if (c3 != '\r' && c3 != '\n') continue;
            if (i2 == n3 + 1) {
                if (c3 != '\n' || c2 == c3) {
                    ++n4;
                }
            } else {
                ++n4;
            }
            n3 = i2;
            c2 = c3;
        }
        return n4;
    }

    void scanCharacterString() {
        this.charWriter.reset(this.charBuffer);
        do {
            this.scanStringPart('\'');
            if (!this.token.isMalformed) continue;
            return;
        } while (this.scanSeparator() && this.charAt(this.currentPosition) == 39);
        this.token.tokenString = this.charWriter.toString();
        this.token.tokenValue = this.token.tokenString;
    }

    public void scanStringPart(char c2) {
        int n2;
        ++this.currentPosition;
        while (true) {
            if ((n2 = this.sqlString.indexOf(c2, this.currentPosition)) < 0) {
                this.token.tokenString = this.sqlString.substring(this.currentPosition, this.limit);
                this.token.tokenType = c2 == '\'' ? 1019 : 1025;
                this.token.isMalformed = true;
                return;
            }
            if (this.charAt(n2 + 1) != c2) break;
            this.charWriter.write(this.sqlString, this.currentPosition, ++n2 - this.currentPosition);
            this.currentPosition = n2 + 1;
        }
        this.charWriter.write(this.sqlString, this.currentPosition, n2 - this.currentPosition);
        this.currentPosition = n2 + 1;
    }

    void scanToken() {
        int n2 = this.charAt(this.currentPosition);
        this.resetState();
        this.token.tokenType = 1012;
        switch (n2) {
            case 91: {
                this.token.tokenString = "[";
                this.token.tokenType = 932;
                ++this.currentPosition;
                this.token.isDelimiter = true;
                return;
            }
            case 93: {
                this.token.tokenString = "]";
                this.token.tokenType = 942;
                ++this.currentPosition;
                this.token.isDelimiter = true;
                return;
            }
            case 40: {
                this.token.tokenString = "(";
                this.token.tokenType = 937;
                ++this.currentPosition;
                this.token.isDelimiter = true;
                return;
            }
            case 41: {
                this.token.tokenString = ")";
                this.token.tokenType = 922;
                ++this.currentPosition;
                this.token.isDelimiter = true;
                return;
            }
            case 44: {
                this.token.tokenString = ",";
                this.token.tokenType = 924;
                ++this.currentPosition;
                this.token.isDelimiter = true;
                return;
            }
            case 42: {
                this.token.tokenString = "*";
                this.token.tokenType = 921;
                ++this.currentPosition;
                this.token.isDelimiter = true;
                return;
            }
            case 61: {
                this.token.tokenString = "=";
                this.token.tokenType = 420;
                ++this.currentPosition;
                this.token.isDelimiter = true;
                return;
            }
            case 59: {
                this.token.tokenString = ";";
                this.token.tokenType = 943;
                ++this.currentPosition;
                this.token.isDelimiter = true;
                return;
            }
            case 43: {
                this.token.tokenString = "+";
                this.token.tokenType = 938;
                ++this.currentPosition;
                this.token.isDelimiter = true;
                return;
            }
            case 58: {
                if (this.charAt(this.currentPosition + 1) == 58) {
                    this.currentPosition += 2;
                    this.token.tokenString = "::";
                    this.token.tokenType = 927;
                    this.token.isDelimiter = true;
                    return;
                }
                this.token.tokenString = ":";
                this.token.tokenType = 923;
                ++this.currentPosition;
                this.token.isDelimiter = true;
                return;
            }
            case 63: {
                if (this.charAt(this.currentPosition + 1) == 63) {
                    if (this.charAt(this.currentPosition + 2) == 40) {
                        this.token.tokenString = "[";
                        this.token.tokenType = 932;
                        this.currentPosition += 3;
                        this.token.isDelimiter = true;
                        return;
                    }
                    if (this.charAt(this.currentPosition + 2) == 41) {
                        this.token.tokenString = "]";
                        this.token.tokenType = 942;
                        this.currentPosition += 3;
                        this.token.isDelimiter = true;
                        return;
                    }
                }
                this.token.tokenString = "?";
                this.token.tokenType = 939;
                ++this.currentPosition;
                this.token.isDelimiter = true;
                return;
            }
            case 33: {
                if (this.charAt(this.currentPosition + 1) == 61) {
                    this.token.tokenString = "<>";
                    this.token.tokenType = 936;
                    this.currentPosition += 2;
                    this.token.isDelimiter = true;
                    return;
                }
                this.token.tokenString = this.sqlString.substring(this.currentPosition, this.currentPosition + 2);
                this.token.tokenType = -1;
                this.token.isDelimiter = true;
                return;
            }
            case 60: {
                if (this.charAt(this.currentPosition + 1) == 62) {
                    this.token.tokenString = "<>";
                    this.token.tokenType = 936;
                    this.currentPosition += 2;
                    this.token.isDelimiter = true;
                    return;
                }
                if (this.charAt(this.currentPosition + 1) == 61) {
                    this.token.tokenString = "<=";
                    this.token.tokenType = 934;
                    this.currentPosition += 2;
                    this.token.isDelimiter = true;
                    return;
                }
                this.token.tokenString = "<";
                this.token.tokenType = 933;
                ++this.currentPosition;
                this.token.isDelimiter = true;
                return;
            }
            case 62: {
                if (this.charAt(this.currentPosition + 1) == 61) {
                    this.token.tokenString = ">=";
                    this.token.tokenType = 930;
                    this.currentPosition += 2;
                    this.token.isDelimiter = true;
                    return;
                }
                this.token.tokenString = ">";
                this.token.tokenType = 929;
                ++this.currentPosition;
                this.token.isDelimiter = true;
                return;
            }
            case 124: {
                if (this.charAt(this.currentPosition + 1) == 124) {
                    this.token.tokenString = "||";
                    this.token.tokenType = 925;
                    this.currentPosition += 2;
                    this.token.isDelimiter = true;
                    return;
                }
                this.token.tokenString = this.sqlString.substring(this.currentPosition, this.currentPosition + 2);
                this.token.tokenType = -1;
                this.token.isDelimiter = true;
                return;
            }
            case 47: {
                if (this.charAt(this.currentPosition + 1) == 47) {
                    int n3 = this.sqlString.indexOf(13, this.currentPosition + 2);
                    if (n3 == -1) {
                        n3 = this.sqlString.indexOf(10, this.currentPosition + 2);
                    }
                    if (n3 == -1) {
                        n3 = this.limit;
                    }
                    this.token.tokenString = this.sqlString.substring(this.currentPosition + 2, n3);
                    this.token.tokenType = 1016;
                    this.token.isDelimiter = true;
                    return;
                }
                if (this.charAt(this.currentPosition + 1) == 42) {
                    this.scanBracketedComment();
                    return;
                }
                this.token.tokenString = "/";
                this.token.tokenType = 926;
                ++this.currentPosition;
                this.token.isDelimiter = true;
                return;
            }
            case 45: {
                if (this.charAt(this.currentPosition + 1) == 45) {
                    int n4 = this.sqlString.indexOf(13, this.currentPosition + 2);
                    if (n4 == -1) {
                        n4 = this.sqlString.indexOf(10, this.currentPosition + 2);
                    }
                    if (n4 == -1) {
                        n4 = this.limit;
                    }
                    this.token.tokenString = this.sqlString.substring(this.currentPosition + 2, n4);
                    this.token.tokenType = 1016;
                    this.token.isDelimiter = true;
                    return;
                }
                this.token.tokenString = "-";
                this.token.tokenType = 935;
                ++this.currentPosition;
                this.token.isDelimiter = true;
                return;
            }
            case 34: {
                this.token.tokenType = 1013;
                break;
            }
            case 96: {
                if (!this.backtickQuoting) break;
                this.token.tokenType = 1013;
                break;
            }
            case 39: {
                this.scanCharacterString();
                if (this.token.isMalformed) {
                    return;
                }
                int n5 = this.charLiteral ? 1 : 12;
                this.token.dataType = CharacterType.getCharacterType(n5, this.token.tokenString.length());
                this.token.tokenType = 1011;
                this.token.isDelimiter = true;
                return;
            }
            case 88: 
            case 120: {
                if (this.charAt(this.currentPosition + 1) != 39) break;
                ++this.currentPosition;
                this.scanBinaryString();
                if (this.token.isMalformed) {
                    return;
                }
                this.token.dataType = BinaryType.getBinaryType(61, ((BinaryData)this.token.tokenValue).length(null));
                this.token.tokenType = 1011;
                return;
            }
            case 66: 
            case 98: {
                if (this.charAt(this.currentPosition + 1) != 39) break;
                ++this.currentPosition;
                this.scanBitString();
                if (this.token.isMalformed) {
                    return;
                }
                this.token.dataType = BitType.getBitType(14, ((BinaryData)this.token.tokenValue).bitLength(null));
                this.token.tokenType = 1011;
                return;
            }
            case 78: 
            case 110: {
                if (this.charAt(this.currentPosition + 1) != 39) break;
                ++this.currentPosition;
                this.scanCharacterString();
                if (this.token.isMalformed) {
                    return;
                }
                int n6 = this.charLiteral ? 1 : 12;
                this.token.dataType = CharacterType.getCharacterType(n6, this.token.tokenString.length());
                this.token.tokenType = 1011;
                return;
            }
            case 85: 
            case 117: {
                if (this.charAt(this.currentPosition + 1) != 38 || this.charAt(this.currentPosition + 2) != 39) break;
                this.currentPosition += 2;
                this.token.dataType = Type.SQL_CHAR;
                this.token.tokenType = 1011;
                this.scanUnicodeString();
                if (this.token.isMalformed) {
                    return;
                }
                int n7 = this.charLiteral ? 1 : 12;
                this.token.dataType = CharacterType.getCharacterType(n7, ((String)this.token.tokenValue).length());
                return;
            }
            case 95: {
                int n8 = this.currentPosition++;
                this.scanIdentifierChain();
                if (this.token.isMalformed) {
                    return;
                }
                if (this.token.tokenType != 1012) {
                    this.token.tokenType = 1019;
                    this.token.isMalformed = true;
                    return;
                }
                this.scanSeparator();
                if (this.charAt(this.currentPosition) == 39) {
                    if (this.token.namePrePrefix != null) {
                        this.token.tokenType = 1019;
                        this.token.isMalformed = true;
                        return;
                    }
                    this.token.charsetSchema = this.token.namePrefix;
                    this.token.charsetName = this.token.tokenString;
                    this.scanCharacterString();
                    this.token.tokenType = 1011;
                    this.token.dataType = CharacterType.getCharacterType(1, this.token.tokenString.length());
                    this.token.isDelimiter = true;
                    return;
                }
                this.position(n8);
                this.resetState();
                break;
            }
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.token.tokenType = 1011;
                this.scanNumber();
                return;
            }
        }
        this.scanIdentifierChain();
        this.setIdentifierProperties();
    }

    private boolean skipBracketedComment() {
        int n2 = this.sqlString.indexOf("*/", this.currentPosition + 2);
        if (n2 == -1) {
            this.token.tokenString = this.sqlString.substring(this.currentPosition, this.currentPosition + 2);
            this.token.tokenType = 1024;
            this.token.isMalformed = true;
            return false;
        }
        String string = this.sqlString.substring(this.currentPosition + 2, n2);
        this.currentPosition = n2 + 2;
        return true;
    }

    private boolean scanBracketedComment() {
        int n2 = this.sqlString.indexOf("*/", this.currentPosition + 2);
        if (n2 == -1) {
            this.token.tokenString = this.sqlString.substring(this.currentPosition, this.currentPosition + 2);
            this.token.tokenType = -1;
            this.token.isDelimiter = true;
            return false;
        }
        this.token.tokenString = this.sqlString.substring(this.currentPosition + 2, n2);
        this.token.tokenType = 1016;
        this.token.isDelimiter = true;
        return true;
    }

    private void setIdentifierProperties() {
        if (this.token.tokenType == 1012) {
            this.token.isUndelimitedIdentifier = true;
            if (this.token.namePrefix == null) {
                this.token.tokenType = Tokens.getKeywordID(this.token.tokenString, 1012);
                if (this.token.tokenType == 1012) {
                    this.token.tokenType = Tokens.getNonKeywordID(this.token.tokenString, 1012);
                } else {
                    this.token.isReservedIdentifier = true;
                    this.token.isCoreReservedIdentifier = Tokens.isCoreKeyword(this.token.tokenType);
                }
            }
        } else if (this.token.tokenType == 1013) {
            this.token.isDelimitedIdentifier = true;
        }
    }

    public boolean scanNull() {
        this.scanSeparator();
        int n2 = this.charAt(this.currentPosition);
        return (n2 == 78 || n2 == 110) && this.scanSpecialIdentifier("NULL");
    }

    private void scanNext(int n2) {
        this.scanNext();
        if (this.token.isMalformed) {
            throw Error.error(n2);
        }
    }

    IntervalType scanIntervalType() {
        int n2;
        int n3 = -1;
        int n4 = -1;
        int n5 = n2 = this.token.tokenType;
        this.scanNext(3406);
        if (this.token.tokenType == 937) {
            this.scanNext(3406);
            if (this.token.dataType == null || this.token.dataType.typeCode != 4) {
                throw Error.error(3406);
            }
            n3 = ((Number)this.token.tokenValue).intValue();
            this.scanNext(3406);
            if (this.token.tokenType == 924) {
                if (n5 != 264) {
                    throw Error.error(3406);
                }
                this.scanNext(3406);
                if (this.token.dataType == null || this.token.dataType.typeCode != 4) {
                    throw Error.error(3406);
                }
                n4 = ((Number)this.token.tokenValue).intValue();
                this.scanNext(3406);
            }
            if (this.token.tokenType != 922) {
                throw Error.error(3406);
            }
            this.scanNext(3406);
        }
        if (this.token.tokenType == 301) {
            this.scanNext(3406);
            n2 = this.token.tokenType;
            this.scanNext(3406);
        }
        if (this.token.tokenType == 937) {
            if (n2 != 264 || n2 == n5) {
                throw Error.error(3406);
            }
            this.scanNext(3406);
            if (this.token.dataType == null || this.token.dataType.typeCode != 4) {
                throw Error.error(3406);
            }
            n4 = ((Number)this.token.tokenValue).intValue();
            this.scanNext(3406);
            if (this.token.tokenType != 922) {
                throw Error.error(3406);
            }
            this.scanNext(3406);
        }
        int n6 = ArrayUtil.find(Tokens.SQL_INTERVAL_FIELD_CODES, n5);
        int n7 = ArrayUtil.find(Tokens.SQL_INTERVAL_FIELD_CODES, n2);
        return IntervalType.getIntervalType(n6, n7, n3, n4);
    }

    public TimestampData newDate(String string) {
        this.intervalPosition = 0;
        this.fractionPrecision = 0;
        this.dateTimeType = null;
        this.intervalString = string;
        this.scanDateParts(2);
        if (this.intervalPosition != string.length()) {
            throw Error.error(3407);
        }
        long l2 = HsqlDateTime.getDateSeconds(string);
        return new TimestampData(l2);
    }

    public TimestampData newTimestamp(String string) {
        long l2 = 0L;
        int n2 = 0;
        int n3 = string.length();
        boolean bl = false;
        this.intervalPosition = 0;
        this.fractionPrecision = 0;
        this.dateTimeType = null;
        this.intervalString = string;
        this.scanDateParts(5);
        if (this.intervalPosition == 10) {
            long l3 = HsqlDateTime.getDateSeconds(string.substring(0, this.intervalPosition));
            this.dateTimeType = Type.SQL_TIMESTAMP_NO_FRACTION;
            return new TimestampData(l3, n2, (int)l2);
        }
        long l4 = HsqlDateTime.getTimestampSeconds(string.substring(0, this.intervalPosition));
        n2 = this.scanIntervalFraction(9);
        int n4 = this.intervalPosition;
        boolean bl2 = this.scanIntervalSign();
        if (bl2 || n4 != this.intervalPosition) {
            l2 = this.scanIntervalValue(Type.SQL_INTERVAL_HOUR_TO_MINUTE);
            bl = true;
            if (bl2) {
                l2 = -l2;
            }
        }
        if (l2 >= (long)DTIType.yearToSecondFactors[2] || l2 > 64800L || -l2 > 64800L) {
            throw Error.error(3409);
        }
        if (this.intervalPosition != n3) {
            throw Error.error(3407);
        }
        int n5 = bl ? 95 : 93;
        this.dateTimeType = DateTimeType.getDateTimeType(n5, this.fractionPrecision);
        if (bl) {
            l4 -= l2;
        }
        if (l4 > DateTimeType.epochLimitSeconds) {
            throw Error.error(3408);
        }
        return new TimestampData(l4, n2, (int)l2);
    }

    void scanDateParts(int n2) {
        byte[] byArray = DTIType.yearToSecondSeparators;
        int n3 = this.intervalPosition;
        int n4 = 0;
        int n5 = 0;
        while (n4 <= n2) {
            boolean bl = false;
            if (n3 == this.intervalString.length()) {
                if (n4 == n2) {
                    bl = true;
                } else {
                    if (n4 < 2) {
                        throw Error.error(3407);
                    }
                    bl = true;
                }
            } else {
                char c2 = this.intervalString.charAt(n3);
                if (c2 >= '0' && c2 <= '9') {
                    ++n5;
                    ++n3;
                } else if (c2 == byArray[n4]) {
                    bl = true;
                    if (n4 != n2) {
                        ++n3;
                    }
                } else if (n4 == n2) {
                    bl = true;
                } else {
                    throw Error.error(3407);
                }
            }
            if (!bl) continue;
            if (n4 == 0 ? n5 < 4 : n5 == 0 || n5 > 2) {
                throw Error.error(3407);
            }
            ++n4;
            n5 = 0;
            if (n3 != this.intervalString.length()) continue;
            break;
        }
        this.intervalPosition = n3;
    }

    public TimeData newTime(String string) {
        this.intervalPosition = 0;
        this.fractionPrecision = 0;
        this.dateTimeType = null;
        this.intervalString = string;
        long l2 = this.scanIntervalValue(Type.SQL_INTERVAL_HOUR_TO_SECOND);
        int n2 = this.scanIntervalFraction(9);
        long l3 = 0L;
        int n3 = this.intervalPosition;
        boolean bl = false;
        boolean bl2 = this.scanIntervalSign();
        if (n3 != this.intervalPosition) {
            l3 = this.scanIntervalValue(Type.SQL_INTERVAL_HOUR_TO_MINUTE);
            bl = true;
        }
        if (this.intervalPosition != string.length()) {
            throw Error.error(3409);
        }
        if (l2 >= (long)DTIType.yearToSecondFactors[2]) {
            throw Error.error(3408);
        }
        if (l3 > 64800L) {
            throw Error.error(3409);
        }
        if (bl2) {
            l3 = -l3;
        }
        int n4 = bl ? 94 : 92;
        this.dateTimeType = DateTimeType.getDateTimeType(n4, this.fractionPrecision);
        if (bl) {
            l2 -= l3;
        }
        return new TimeData((int)l2, n2, (int)l3);
    }

    public Object newInterval(String string, IntervalType intervalType) {
        this.intervalPosition = 0;
        this.fractionPrecision = 0;
        this.intervalString = string;
        boolean bl = this.scanIntervalSign();
        long l2 = this.scanIntervalValue(intervalType);
        int n2 = 0;
        if (intervalType.endIntervalType == 106) {
            n2 = this.scanIntervalFraction(intervalType.scale);
        }
        if (this.intervalPosition != string.length()) {
            throw Error.error(3406);
        }
        if (bl) {
            l2 = -l2;
            n2 = -n2;
        }
        this.dateTimeType = intervalType;
        if (intervalType.defaultPrecision) {
            this.dateTimeType = IntervalType.getIntervalType(intervalType.typeCode, intervalType.startIntervalType, intervalType.endIntervalType, this.intervalPrecision, this.fractionPrecision, false);
        }
        if (intervalType.endPartIndex <= 1) {
            return new IntervalMonthData(l2);
        }
        return new IntervalSecondData(l2, n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long scanIntervalValue(IntervalType intervalType) {
        byte[] byArray = DTIType.yearToSecondSeparators;
        int[] nArray = DTIType.yearToSecondFactors;
        int[] nArray2 = DTIType.yearToSecondLimits;
        int n2 = intervalType.startPartIndex;
        int n3 = intervalType.endPartIndex;
        long l2 = 0L;
        long l3 = 0L;
        int n4 = this.intervalPosition;
        int n5 = n2;
        int n6 = 0;
        while (n5 <= n3) {
            int n7;
            boolean bl = false;
            if (n4 == this.intervalString.length()) {
                if (n5 != n3) throw Error.error(3406);
                bl = true;
            } else {
                n7 = this.intervalString.charAt(n4);
                if (n7 >= 48 && n7 <= 57) {
                    int n8 = n7 - 48;
                    l3 *= 10L;
                    l3 += (long)n8;
                    ++n6;
                    ++n4;
                } else if (n7 == byArray[n5]) {
                    bl = true;
                    if (n5 != n3) {
                        ++n4;
                    }
                } else {
                    if (n5 != n3) throw Error.error(3406);
                    bl = true;
                }
            }
            if (!bl) continue;
            if (n5 == n2) {
                if (!intervalType.defaultPrecision && (long)n6 > intervalType.precision) {
                    throw Error.error(3435);
                }
                if (n6 == 0) {
                    throw Error.error(3406);
                }
                n7 = nArray[n5];
                l2 += l3 * (long)n7;
                this.intervalPrecision = n6;
            } else {
                if (l3 >= (long)nArray2[n5]) {
                    throw Error.error(3435);
                }
                if (n6 == 0 || n6 > 2) {
                    throw Error.error(3406);
                }
                l2 += l3 * (long)nArray[n5];
            }
            ++n5;
            l3 = 0L;
            n6 = 0;
            if (n4 != this.intervalString.length()) continue;
            break;
        }
        this.intervalPosition = n4;
        return l2;
    }

    boolean scanIntervalSign() {
        boolean bl = false;
        if (this.intervalPosition == this.intervalString.length()) {
            return false;
        }
        if (this.intervalString.charAt(this.intervalPosition) == '-') {
            bl = true;
            ++this.intervalPosition;
        } else if (this.intervalString.charAt(this.intervalPosition) == '+') {
            ++this.intervalPosition;
        }
        return bl;
    }

    int scanIntervalFraction(int n2) {
        char c2;
        if (this.intervalPosition == this.intervalString.length()) {
            return 0;
        }
        if (this.intervalString.charAt(this.intervalPosition) != '.') {
            return 0;
        }
        ++this.intervalPosition;
        int n3 = 0;
        int n4 = 0;
        while (this.intervalPosition < this.intervalString.length() && (c2 = this.intervalString.charAt(this.intervalPosition)) >= '0' && c2 <= '9') {
            int n5 = c2 - 48;
            n3 *= 10;
            n3 += n5;
            ++this.intervalPosition;
            if (++n4 != 9) continue;
            break;
        }
        this.fractionPrecision = n4;
        n3 = DTIType.normaliseFraction(n3, n4, n2);
        return n3;
    }

    void scanIntervalSpaces() {
        while (this.intervalPosition < this.intervalString.length() && this.intervalString.charAt(this.intervalPosition) == ' ') {
            ++this.intervalPosition;
        }
    }

    public synchronized Number convertToNumber(String string, NumberType numberType) {
        boolean bl = false;
        this.reset(string);
        this.resetState();
        this.scanWhitespace();
        this.scanToken();
        this.scanWhitespace();
        switch (this.token.tokenType) {
            case 935: {
                bl = true;
                this.scanToken();
                this.scanWhitespace();
                if (this.token.tokenType != 646) break;
                bl = false;
                this.token.tokenType = 1011;
                this.token.dataType = Type.SQL_DOUBLE;
                this.token.tokenValue = Double.NEGATIVE_INFINITY;
                break;
            }
            case 938: {
                this.scanToken();
                this.scanWhitespace();
                break;
            }
            case 662: {
                this.token.tokenType = 1011;
                this.token.dataType = Type.SQL_DOUBLE;
                this.token.tokenValue = Double.NaN;
                break;
            }
            case 646: {
                this.token.tokenType = 1011;
                this.token.dataType = Type.SQL_DOUBLE;
                this.token.tokenValue = Double.POSITIVE_INFINITY;
            }
        }
        if (!this.hasNonSpaceSeparator && this.token.tokenType == 1011 && this.token.tokenValue instanceof Number) {
            Number number = (Number)this.token.tokenValue;
            Type type = this.token.dataType;
            if (bl) {
                number = (Number)this.token.dataType.negate(number);
            }
            this.scanEnd();
            if (this.token.tokenType == 1014) {
                number = (Number)numberType.convertToType(null, number, type);
                return number;
            }
        }
        throw Error.error(3438);
    }

    /*
     * Enabled aggressive block sorting
     */
    public synchronized BinaryData convertToBinary(String string, boolean bl) {
        boolean bl2 = true;
        byte by = 0;
        this.reset(string);
        this.resetState();
        this.byteOutputStream.reset(this.byteBuffer);
        while (this.currentPosition < this.limit) {
            block9: {
                char c2 = this.sqlString.charAt(this.currentPosition);
                int n2 = Scanner.getHexValue(c2);
                if (n2 == -1) {
                    if (bl && c2 == '-' && bl2) {
                        bl2 = !bl2;
                        break block9;
                    } else {
                        this.token.tokenType = 1022;
                        this.token.isMalformed = true;
                        break;
                    }
                }
                if (bl2) {
                    by = (byte)(n2 << 4);
                } else {
                    by = (byte)(by + (byte)n2);
                    this.byteOutputStream.writeByte(by);
                }
            }
            ++this.currentPosition;
            bl2 = !bl2;
        }
        if (!bl2) {
            this.token.tokenType = 1022;
            this.token.isMalformed = true;
        }
        if (bl && this.byteOutputStream.size() != 16) {
            this.token.tokenType = 1022;
            this.token.isMalformed = true;
        }
        if (this.token.isMalformed) {
            throw Error.error(3438);
        }
        BinaryData binaryData = new BinaryData(this.byteOutputStream.toByteArray(), false);
        this.byteOutputStream.reset(this.byteBuffer);
        return binaryData;
    }

    public synchronized BinaryData convertToBit(String string) {
        BitMap bitMap = new BitMap(0, true);
        int n2 = 0;
        this.reset(string);
        this.resetState();
        this.byteOutputStream.reset(this.byteBuffer);
        while (this.currentPosition < this.limit) {
            char c2 = this.sqlString.charAt(this.currentPosition);
            if (c2 == '0') {
                bitMap.unset(n2);
                ++n2;
            } else if (c2 == '1') {
                bitMap.set(n2);
                ++n2;
            } else {
                this.token.tokenType = 1021;
                this.token.isMalformed = true;
                throw Error.error(3438);
            }
            ++this.currentPosition;
        }
        bitMap.setSize(n2);
        return BinaryData.getBitData(bitMap.getBytes(), bitMap.size());
    }

    public synchronized Object convertToDatetimeInterval(SessionInterface sessionInterface, String string, DTIType dTIType) {
        IntervalType intervalType = null;
        int n2 = -1;
        int n3 = dTIType.isDateTimeType() ? 3407 : 3406;
        this.reset(string);
        this.resetState();
        this.scanToken();
        this.scanWhitespace();
        switch (this.token.tokenType) {
            case 77: 
            case 150: 
            case 297: 
            case 298: {
                n2 = this.token.tokenType;
                this.scanToken();
                if (this.token.tokenType != 1011 || !this.token.dataType.isCharacterType()) {
                    throw Error.error(n3);
                }
                string = this.token.tokenString;
                this.scanNext(3407);
                if (dTIType.isIntervalType()) {
                    intervalType = this.scanIntervalType();
                }
                if (this.token.tokenType == 1014) break;
                throw Error.error(n3);
            }
        }
        switch (dTIType.typeCode) {
            case 91: {
                if (n2 != -1 && n2 != 77) {
                    throw Error.error(n3);
                }
                TimestampData timestampData = this.newDate(string);
                return dTIType.convertToType(sessionInterface, timestampData, Type.SQL_DATE);
            }
            case 92: 
            case 94: {
                if (n2 != -1 && n2 != 297) {
                    throw Error.error(n3);
                }
                TimeData timeData = this.newTime(string);
                return dTIType.convertToType(sessionInterface, timeData, this.dateTimeType);
            }
            case 93: 
            case 95: {
                if (n2 != -1 && n2 != 298) {
                    throw Error.error(n3);
                }
                TimestampData timestampData = this.newTimestamp(string);
                return dTIType.convertToType(sessionInterface, timestampData, this.dateTimeType);
            }
        }
        if (n2 != -1 && n2 != 150) {
            throw Error.error(n3);
        }
        if (dTIType.isIntervalType()) {
            Object object = this.newInterval(string, (IntervalType)dTIType);
            if (intervalType != null && (intervalType.startIntervalType != dTIType.startIntervalType || intervalType.endIntervalType != dTIType.endIntervalType)) {
                throw Error.error(n3);
            }
            return dTIType.convertToType(sessionInterface, object, this.dateTimeType);
        }
        throw Error.runtimeError(201, "Scanner");
    }

    static {
        for (int i2 = 0; i2 < whitespace.length; ++i2) {
            whiteSpaceSet.add(whitespace[i2]);
        }
        maxPooledStringLength = ValuePool.getMaxStringLength();
    }
}

