/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Row;
import org.hsqldb.RowActionBase;
import org.hsqldb.Session;
import org.hsqldb.TableBase;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.persist.PersistentStore;

public class RowAction
extends RowActionBase {
    final TableBase table;
    final PersistentStore store;
    final Row memoryRow;
    final long rowId;
    RowAction updatedAction;

    public static RowAction addInsertAction(Session session, TableBase tableBase, PersistentStore persistentStore, Row row) {
        RowAction rowAction;
        row.rowAction = rowAction = new RowAction(session, tableBase, persistentStore, 1, row, null);
        return rowAction;
    }

    public static RowAction addDeleteAction(Session session, TableBase tableBase, PersistentStore persistentStore, Row row, int[] nArray) {
        RowAction rowAction = row.rowAction;
        if (rowAction == null) {
            row.rowAction = rowAction = new RowAction(session, tableBase, persistentStore, 2, row, nArray);
            return rowAction;
        }
        return rowAction.addDeleteAction(session, nArray);
    }

    public static boolean addRefAction(Session session, Row row, int[] nArray) {
        RowAction rowAction = row.rowAction;
        if (rowAction == null) {
            row.rowAction = rowAction = new RowAction(session, row.getTable(), null, 5, row, nArray);
            return true;
        }
        return rowAction.addRefAction(session, nArray);
    }

    public RowAction(Session session, TableBase tableBase, PersistentStore persistentStore, byte by, Row row, int[] nArray) {
        this.session = session;
        this.type = by;
        this.actionSCN = session.actionSCN;
        this.table = tableBase;
        this.store = persistentStore;
        this.memoryRow = row;
        this.rowId = row.getPos();
        this.changeColumnMap = nArray;
    }

    public synchronized int getType() {
        return this.type;
    }

    synchronized RowAction addDeleteAction(Session session, int[] nArray) {
        if (this.type == 0) {
            this.setNoOpAsAction(session, (byte)2);
            this.changeColumnMap = nArray;
        } else {
            RowActionBase rowActionBase = this;
            while (true) {
                if (rowActionBase.rolledback) {
                    if (rowActionBase.next == null) break;
                    rowActionBase = rowActionBase.next;
                    continue;
                }
                switch (rowActionBase.type) {
                    case 1: {
                        if (rowActionBase.commitSCN != 0L || session == rowActionBase.session) break;
                        throw Error.runtimeError(201, "RowAction");
                    }
                    case 2: 
                    case 3: {
                        if (session == rowActionBase.session) break;
                        if (rowActionBase.commitSCN == 0L) {
                            if (!session.actionSet.isEmpty()) {
                                session.actionSet.clear();
                            }
                            session.actionSet.add(rowActionBase);
                        }
                        return null;
                    }
                    case 5: {
                        if (session == rowActionBase.session || rowActionBase.commitSCN != 0L || nArray != null && !ArrayUtil.haveCommonElement(nArray, rowActionBase.changeColumnMap)) break;
                        if (!session.actionSet.isEmpty()) {
                            session.actionSet.clear();
                        }
                        session.actionSet.add(rowActionBase);
                        return null;
                    }
                }
                if (rowActionBase.next == null) break;
                rowActionBase = rowActionBase.next;
            }
            RowActionBase rowActionBase2 = new RowActionBase(session, 2);
            rowActionBase2.changeColumnMap = nArray;
            rowActionBase.next = rowActionBase2;
        }
        return this;
    }

    synchronized boolean addRefAction(Session session, int[] nArray) {
        if (this.type == 0) {
            this.setNoOpAsAction(session, (byte)5);
            this.changeColumnMap = nArray;
            return true;
        }
        RowActionBase rowActionBase = this;
        while (true) {
            if (session == rowActionBase.session) {
                if (rowActionBase.type == 5 && rowActionBase.changeColumnMap == nArray && rowActionBase.commitSCN == 0L) {
                    return false;
                }
                if (rowActionBase.type == 1 && rowActionBase.commitSCN == 0L) {
                    return false;
                }
            } else if (rowActionBase.type == 2 && rowActionBase.commitSCN == 0L && (rowActionBase.changeColumnMap == null || ArrayUtil.haveCommonElement(nArray, rowActionBase.changeColumnMap))) {
                if (!session.actionSet.isEmpty()) {
                    session.actionSet.clear();
                }
                session.actionSet.add(rowActionBase);
                return false;
            }
            if (rowActionBase.next == null) break;
            rowActionBase = rowActionBase.next;
        }
        RowActionBase rowActionBase2 = new RowActionBase(session, 5);
        rowActionBase2.changeColumnMap = nArray;
        rowActionBase.next = rowActionBase2;
        return true;
    }

    synchronized void setNoOpAsAction(Session session, byte by) {
        this.session = session;
        this.type = by;
        this.actionSCN = session.actionSCN;
    }

    @Override
    synchronized void setAsAction(RowActionBase rowActionBase) {
        super.setAsAction(rowActionBase);
    }

    synchronized void setAsNoOp() {
        this.session = null;
        this.type = 0;
        this.actionSCN = 0L;
        this.commitSCN = 0L;
        this.rolledback = false;
        this.deleteComplete = false;
        this.prepared = false;
        this.changeColumnMap = null;
        this.next = null;
    }

    private void setAsDeleteFinal(long l2) {
        this.type = (byte)3;
        this.actionSCN = 0L;
        this.commitSCN = l2;
        this.rolledback = false;
        this.deleteComplete = false;
        this.prepared = false;
        this.changeColumnMap = null;
        this.next = null;
    }

    synchronized void prepareCommit(Session session) {
        RowActionBase rowActionBase = this;
        do {
            if (rowActionBase.session != session || rowActionBase.commitSCN != 0L) continue;
            rowActionBase.prepared = true;
        } while ((rowActionBase = rowActionBase.next) != null);
    }

    synchronized int commit(Session session) {
        RowActionBase rowActionBase = this;
        int n2 = 0;
        do {
            if (rowActionBase.session != session || rowActionBase.commitSCN != 0L) continue;
            rowActionBase.commitSCN = session.actionSCN;
            rowActionBase.prepared = false;
            if (rowActionBase.type == 1) {
                n2 = rowActionBase.type;
                continue;
            }
            if (rowActionBase.type != 2) continue;
            n2 = n2 == 1 ? 4 : (int)rowActionBase.type;
        } while ((rowActionBase = rowActionBase.next) != null);
        return n2;
    }

    public boolean isDeleted() {
        RowActionBase rowActionBase = this;
        do {
            if (rowActionBase.commitSCN == 0L || rowActionBase.type != 2 && rowActionBase.type != 3) continue;
            return true;
        } while ((rowActionBase = rowActionBase.next) != null);
        return false;
    }

    public boolean isDeleteComplete() {
        return this.deleteComplete;
    }

    public synchronized void setDeleteComplete() {
        this.deleteComplete = true;
    }

    synchronized int getCommitTypeOn(long l2) {
        RowActionBase rowActionBase = this;
        int n2 = 0;
        do {
            if (rowActionBase.commitSCN != l2) continue;
            if (rowActionBase.type == 1) {
                n2 = rowActionBase.type;
                continue;
            }
            if (rowActionBase.type != 2) continue;
            n2 = n2 == 1 ? 4 : (int)rowActionBase.type;
        } while ((rowActionBase = rowActionBase.next) != null);
        return n2;
    }

    synchronized boolean canCommit(Session session) {
        long l2 = session.transactionSCN;
        long l3 = 0L;
        boolean bl = session.isolationLevel == 2;
        boolean bl2 = false;
        RowActionBase rowActionBase = this;
        if (bl) {
            do {
                if (rowActionBase.session != session || rowActionBase.type != 2 || rowActionBase.commitSCN != 0L) continue;
                l2 = rowActionBase.actionSCN;
            } while ((rowActionBase = rowActionBase.next) != null);
            rowActionBase = this;
        }
        do {
            if (rowActionBase.session == session) {
                if (rowActionBase.type == 2) {
                    bl2 = true;
                }
            } else {
                if (rowActionBase.rolledback || rowActionBase.type != 2) {
                    rowActionBase = rowActionBase.next;
                    continue;
                }
                if (rowActionBase.prepared) {
                    return false;
                }
                if (rowActionBase.commitSCN == 0L) {
                    session.actionSet.add(rowActionBase);
                } else if (rowActionBase.commitSCN > l3) {
                    l3 = rowActionBase.commitSCN;
                }
            }
            rowActionBase = rowActionBase.next;
        } while (rowActionBase != null);
        if (!bl2) {
            return true;
        }
        return l3 < l2;
    }

    synchronized boolean complete(Session session, OrderedHashSet orderedHashSet) {
        boolean bl = session.isolationLevel == 2;
        boolean bl2 = true;
        RowActionBase rowActionBase = this;
        do {
            if (rowActionBase.rolledback || rowActionBase.type == 0) {
                rowActionBase = rowActionBase.next;
                continue;
            }
            if (rowActionBase.session != session) {
                if (rowActionBase.prepared) {
                    orderedHashSet.add(rowActionBase.session);
                    return false;
                }
                if (bl) {
                    if (rowActionBase.commitSCN > session.actionSCN) {
                        orderedHashSet.add(session);
                        bl2 = false;
                    } else if (rowActionBase.commitSCN == 0L) {
                        orderedHashSet.add(rowActionBase.session);
                        bl2 = false;
                    }
                } else if (rowActionBase.commitSCN > session.transactionSCN) {
                    return false;
                }
            }
            rowActionBase = rowActionBase.next;
        } while (rowActionBase != null);
        return bl2;
    }

    public long getPos() {
        return this.rowId;
    }

    public Row getRow() {
        return this.memoryRow;
    }

    private int getRollbackType(Session session) {
        int n2 = 0;
        RowActionBase rowActionBase = this;
        do {
            if (rowActionBase.session != session || !rowActionBase.rolledback) continue;
            if (rowActionBase.type == 2) {
                if (n2 == 1) {
                    n2 = 4;
                    continue;
                }
                n2 = rowActionBase.type;
                continue;
            }
            if (rowActionBase.type != 1) continue;
            n2 = rowActionBase.type;
        } while ((rowActionBase = rowActionBase.next) != null);
        return n2;
    }

    synchronized void rollback(Session session, long l2) {
        RowActionBase rowActionBase = this;
        do {
            if (rowActionBase.session != session || rowActionBase.commitSCN != 0L || rowActionBase.actionSCN < l2) continue;
            rowActionBase.commitSCN = session.actionSCN;
            rowActionBase.rolledback = true;
            rowActionBase.prepared = false;
        } while ((rowActionBase = rowActionBase.next) != null);
    }

    synchronized int mergeRollback(Session session, long l2) {
        RowActionBase rowActionBase = this;
        RowAction rowAction = null;
        RowAction rowAction2 = null;
        int n2 = this.getRollbackType(session);
        do {
            if (rowActionBase.session == session && rowActionBase.rolledback) {
                if (rowAction2 == null) continue;
                rowAction2.next = null;
                continue;
            }
            if (rowAction == null) {
                rowAction = rowAction2 = rowActionBase;
                continue;
            }
            rowAction2.next = rowActionBase;
            rowAction2 = rowActionBase;
        } while ((rowActionBase = rowActionBase.next) != null);
        if (rowAction == null) {
            switch (n2) {
                case 1: 
                case 4: {
                    this.setAsDeleteFinal(l2);
                    break;
                }
                default: {
                    this.setAsNoOp();
                    break;
                }
            }
        } else if (rowAction != this) {
            this.setAsAction(rowAction);
        }
        return n2;
    }

    synchronized void mergeToTimestamp(long l2) {
        RowActionBase rowActionBase = this;
        RowAction rowAction = null;
        RowAction rowAction2 = null;
        int n2 = this.getCommitTypeOn(l2);
        if (this.type == 3 || this.type == 0) {
            return;
        }
        if (n2 == 2 || n2 == 4) {
            this.setAsDeleteFinal(l2);
            return;
        }
        do {
            boolean bl = false;
            if (rowActionBase.commitSCN != 0L) {
                if (rowActionBase.commitSCN <= l2) {
                    bl = true;
                } else if (rowActionBase.type == 5) {
                    bl = true;
                }
            }
            if (bl) {
                if (rowAction2 == null) continue;
                rowAction2.next = null;
                continue;
            }
            if (rowAction == null) {
                rowAction = rowAction2 = rowActionBase;
                continue;
            }
            rowAction2.next = rowActionBase;
            rowAction2 = rowActionBase;
        } while ((rowActionBase = rowActionBase.next) != null);
        if (rowAction == null) {
            switch (n2) {
                case 2: 
                case 4: {
                    this.setAsDeleteFinal(l2);
                    break;
                }
                default: {
                    this.setAsNoOp();
                    break;
                }
            }
        } else if (rowAction != this) {
            this.setAsAction(rowAction);
        }
        this.mergeExpiredRefActions();
    }

    public synchronized boolean canRead(Session session, int n2) {
        long l2;
        int n3 = 0;
        if (this.type == 3) {
            return false;
        }
        if (this.type == 0) {
            return true;
        }
        RowActionBase rowActionBase = this;
        if (session == null) {
            l2 = Long.MAX_VALUE;
        } else {
            switch (session.isolationLevel) {
                case 1: {
                    l2 = Long.MAX_VALUE;
                    break;
                }
                case 2: {
                    l2 = session.actionSCN;
                    break;
                }
                default: {
                    l2 = session.transactionSCN;
                }
            }
        }
        do {
            if (rowActionBase.type == 5) {
                rowActionBase = rowActionBase.next;
                continue;
            }
            if (rowActionBase.rolledback) {
                if (rowActionBase.type == 1) {
                    n3 = 2;
                }
                rowActionBase = rowActionBase.next;
                continue;
            }
            if (session == rowActionBase.session) {
                if (rowActionBase.type == 2) {
                    n3 = rowActionBase.type;
                } else if (rowActionBase.type == 1) {
                    n3 = rowActionBase.type;
                }
                rowActionBase = rowActionBase.next;
                continue;
            }
            if (rowActionBase.commitSCN == 0L) {
                if (rowActionBase.type == 0) {
                    throw Error.runtimeError(201, "RowAction");
                }
                if (rowActionBase.type == 1) {
                    if (n2 == 0) {
                        n3 = 2;
                        break;
                    }
                    if (n2 == 1) {
                        n3 = 1;
                        session.actionSet.clear();
                        session.actionSet.add(rowActionBase);
                        break;
                    }
                    if (n2 != 2) break;
                    n3 = 2;
                    break;
                }
                if (rowActionBase.type == 2 && n2 != 1 && n2 == 2) {
                    n3 = 2;
                }
                rowActionBase = rowActionBase.next;
                continue;
            }
            if (rowActionBase.commitSCN < l2) {
                if (rowActionBase.type == 2) {
                    n3 = 2;
                } else if (rowActionBase.type == 1) {
                    n3 = 1;
                }
            } else if (rowActionBase.type == 1) {
                if (n2 == 0) {
                    n3 = 2;
                } else if (n2 == 1) {
                    n3 = 1;
                    session.actionSet.clear();
                    session.actionSet.add(rowActionBase);
                } else if (n2 == 2) {
                    n3 = 2;
                }
            }
            rowActionBase = rowActionBase.next;
        } while (rowActionBase != null);
        return n3 == 0 || n3 == 1;
    }

    public boolean hasCurrentRefAction() {
        RowActionBase rowActionBase = this;
        do {
            if (rowActionBase.type != 5 || rowActionBase.commitSCN != 0L) continue;
            return true;
        } while ((rowActionBase = rowActionBase.next) != null);
        return false;
    }

    private RowAction mergeExpiredRefActions() {
        if (this.updatedAction != null) {
            this.updatedAction = this.updatedAction.mergeExpiredRefActions();
        }
        if (this.hasCurrentRefAction()) {
            return this;
        }
        return this.updatedAction;
    }

    public synchronized String describe(Session session) {
        StringBuilder stringBuilder = new StringBuilder();
        RowActionBase rowActionBase = this;
        do {
            if (rowActionBase == this) {
                stringBuilder.append(this.rowId).append(' ');
            }
            stringBuilder.append(rowActionBase.session.getId()).append(' ');
            stringBuilder.append(rowActionBase.type).append(' ').append(rowActionBase.actionSCN);
            stringBuilder.append(' ').append(rowActionBase.commitSCN);
            if (rowActionBase.commitSCN != 0L) {
                if (rowActionBase.rolledback) {
                    stringBuilder.append('r');
                } else {
                    stringBuilder.append('c');
                }
            }
            stringBuilder.append(" - ");
        } while ((rowActionBase = rowActionBase.next) != null);
        return stringBuilder.toString();
    }
}

