/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.Locale;
import org.hsqldb.ColumnBase;
import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.ExpressionLogical;
import org.hsqldb.ExpressionOp;
import org.hsqldb.ExpressionOrderBy;
import org.hsqldb.GroupSet;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.OpTypes;
import org.hsqldb.ParserDQL;
import org.hsqldb.QueryExpression;
import org.hsqldb.RangeGroup;
import org.hsqldb.RangeVariable;
import org.hsqldb.RangeVariableResolver;
import org.hsqldb.Session;
import org.hsqldb.SetFunction;
import org.hsqldb.SortAndSlice;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Table;
import org.hsqldb.TableDerived;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayListIdentity;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.List;
import org.hsqldb.lib.OrderedHashMap;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.lib.Set;
import org.hsqldb.map.ValuePool;
import org.hsqldb.navigator.RangeIterator;
import org.hsqldb.navigator.RowSetNavigatorData;
import org.hsqldb.navigator.RowSetNavigatorDataTable;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.types.Type;

public class QuerySpecification
extends QueryExpression {
    public int resultRangePosition;
    public boolean isDistinctSelect;
    public boolean isAggregated;
    public boolean isGrouped;
    public boolean isGroupingSets;
    boolean isDistinctGroups;
    public boolean isOrderSensitive;
    public boolean isSimpleDistinct;
    RangeVariable[] rangeVariables;
    private HsqlArrayList rangeVariableList;
    int startInnerRange = -1;
    int endInnerRange = -1;
    Expression queryCondition;
    Expression checkQueryCondition;
    Expression[] exprColumns;
    HsqlArrayList exprColumnList;
    GroupSet groupSet;
    private int groupByColumnCount;
    private int havingColumnCount;
    public int indexLimitVisible;
    private int indexLimitRowId;
    private int indexStartHaving;
    public int indexStartOrderBy;
    public int indexStartAggregates;
    private int indexLimitExpressions;
    public int indexLimitData;
    private boolean hasRowID;
    private boolean isSimpleCount;
    private boolean isSingleMemoryTable;
    public boolean isUniqueResultRows;
    Type[] resultColumnTypes;
    private ArrayListIdentity aggregateSet;
    private ArrayListIdentity resolvedSubqueryExpressions = null;
    private boolean[] aggregateCheck;
    private OrderedHashSet tempSet = new OrderedHashSet();
    int[] columnMap;
    private Table baseTable;
    public Index groupIndex;
    private RangeGroup[] outerRanges;

    QuerySpecification(Session session, Table table, ParserDQL.CompileContext compileContext, boolean bl) {
        this(compileContext);
        this.isValueList = bl;
        RangeVariable rangeVariable = new RangeVariable(table, null, null, null, compileContext);
        rangeVariable.addTableColumns(this.exprColumnList, 0, null);
        this.indexLimitVisible = this.exprColumnList.size();
        this.addRangeVariable(session, rangeVariable);
        this.sortAndSlice = SortAndSlice.noSort;
        this.isBaseMergeable = true;
        this.isMergeable = true;
        this.isTable = true;
    }

    QuerySpecification(ParserDQL.CompileContext compileContext) {
        super(compileContext);
        this.resultRangePosition = compileContext.getNextResultRangeVarIndex();
        this.rangeVariableList = new HsqlArrayList();
        this.exprColumnList = new HsqlArrayList();
        this.sortAndSlice = SortAndSlice.noSort;
        this.isBaseMergeable = true;
        this.isMergeable = true;
    }

    void addRangeVariable(Session session, RangeVariable rangeVariable) {
        this.rangeVariableList.add(rangeVariable);
    }

    public TableDerived getValueListTable() {
        if (this.isValueList) {
            RangeVariable rangeVariable = null;
            if (this.rangeVariables == null) {
                if (this.rangeVariableList.size() == 1) {
                    rangeVariable = (RangeVariable)this.rangeVariableList.get(0);
                }
            } else if (this.rangeVariables.length == 1) {
                rangeVariable = this.rangeVariables[0];
            }
            if (rangeVariable != null) {
                return (TableDerived)rangeVariable.getTable();
            }
        }
        return null;
    }

    @Override
    public RangeVariable[] getRangeVariables() {
        return this.rangeVariables;
    }

    public int getCurrentRangeVariableCount() {
        return this.rangeVariableList.size();
    }

    private void resolveRangeVariables(Session session, RangeGroup[] rangeGroupArray) {
        if (this.rangeVariables == null || this.rangeVariables.length < this.rangeVariableList.size()) {
            this.rangeVariables = new RangeVariable[this.rangeVariableList.size()];
            this.rangeVariableList.toArray(this.rangeVariables);
        }
        for (int i2 = 0; i2 < this.rangeVariables.length; ++i2) {
            RangeGroup rangeGroup;
            if (this.rangeVariables[i2].isLateral) {
                RangeVariable[] rangeVariableArray = (RangeVariable[])ArrayUtil.resizeArray(this.rangeVariables, i2);
                rangeGroup = new RangeGroup.RangeGroupSimple(rangeVariableArray, this);
            } else {
                rangeGroup = rangeGroupArray == RangeGroup.emptyArray ? RangeGroup.emptyGroup : new RangeGroup.RangeGroupSimple(RangeVariable.emptyArray, this);
            }
            this.rangeVariables[i2].resolveRangeTable(session, rangeGroup, rangeGroupArray);
        }
    }

    void addSelectColumnExpression(Expression expression) {
        if (expression.getType() == 25) {
            throw Error.error(5564);
        }
        if (this.indexLimitVisible > 0) {
            if (expression.opType == 99 && ((ExpressionColumn)expression).getTableName() == null) {
                throw Error.error(5578);
            }
            Expression expression2 = (Expression)this.exprColumnList.get(0);
            if (expression2.opType == 99 && ((ExpressionColumn)expression2).getTableName() == null) {
                throw Error.error(5578);
            }
        }
        this.exprColumnList.add(expression);
        ++this.indexLimitVisible;
    }

    void addQueryCondition(Expression expression) {
        this.queryCondition = expression;
    }

    void setDistinctSelect() {
        this.isDistinctSelect = true;
    }

    void setDistinctGroups() {
        this.isDistinctGroups = true;
    }

    void addGroupingSets(Expression[] expressionArray) {
        this.groupSet = new GroupSet(expressionArray, this.isDistinctGroups);
    }

    void resolveColumnReferencesInGroupingSets(Session session, RangeGroup[] rangeGroupArray) {
        Expression expression;
        if (this.groupSet == null) {
            return;
        }
        Expression[] expressionArray = this.groupSet.groupExpressions;
        for (int i2 = 0; i2 < expressionArray.length; ++i2) {
            expression = expressionArray[i2];
            this.tempSet.clear();
            expression.resolveColumnReferences(session, this, this.rangeVariables.length, rangeGroupArray, this.tempSet, false);
            if (this.tempSet.isEmpty()) continue;
            if (session.database.sqlEnforceRefs) {
                ExpressionColumn.checkColumnsResolved(this.tempSet);
                continue;
            }
            Expression[] expressionArray2 = new Expression[this.exprColumnList.size()];
            this.exprColumnList.toArray(expressionArray2);
            Expression expression2 = expression.replaceAliasInOrderBy(session, expressionArray2, this.indexLimitVisible);
            if (expression2 != expression) {
                expressionArray[i2] = expression2;
            }
            this.tempSet.clear();
            expression2.resolveColumnReferences(session, this, this.rangeVariables.length, RangeGroup.emptyArray, this.tempSet, false);
            ExpressionColumn.checkColumnsResolved(this.tempSet);
        }
        this.tempSet.clear();
        this.addGroupingExpressions(expressionArray, this.tempSet);
        Iterator iterator = this.tempSet.iterator();
        while (iterator.hasNext()) {
            expression = (Expression)iterator.next();
            if (expression.getType() == 25) {
                throw Error.error(5564);
            }
            expression.resultTableColumnIndex = this.indexLimitVisible + this.groupByColumnCount;
            this.exprColumnList.add(expression.resultTableColumnIndex, expression);
            ++this.groupByColumnCount;
        }
        this.groupSet.process();
    }

    void addGroupingExpressions(Expression[] expressionArray, OrderedHashSet orderedHashSet) {
        for (int i2 = 0; i2 < expressionArray.length; ++i2) {
            Expression expression = expressionArray[i2];
            if (expression.groupingType != 0) {
                this.isGroupingSets = true;
            }
            if (expression.opType == 25 || expression.opType == 26) {
                for (int i3 = 0; i3 < expression.nodes.length; ++i3) {
                    this.addGroupingExpressions(expression.nodes, orderedHashSet);
                }
                continue;
            }
            if (expression.opType == 0) continue;
            expressionArray[i2] = orderedHashSet.getOrAdd(expression);
            this.isGrouped = true;
        }
    }

    void addHavingExpression(Expression expression) {
        this.exprColumnList.add(expression);
        this.havingColumnCount = 1;
    }

    @Override
    void addSortAndSlice(SortAndSlice sortAndSlice) {
        this.sortAndSlice = sortAndSlice;
    }

    @Override
    public void resolveReferences(Session session, RangeGroup[] rangeGroupArray) {
        if (this.isReferencesResolved) {
            return;
        }
        this.outerRanges = rangeGroupArray;
        this.resolveRangeVariables(session, rangeGroupArray);
        this.resolveColumnReferencesForAsterisk();
        this.resolveColumnReferencesInGroupingSets(session, rangeGroupArray);
        this.setColumnIndexes();
        this.finaliseColumns();
        this.resolveColumnReferences(session, rangeGroupArray);
        this.setReferenceableColumns();
        this.unresolvedExpressions = Expression.resolveColumnSet(session, RangeVariable.emptyArray, rangeGroupArray, this.unresolvedExpressions);
        this.unionColumnTypes = new Type[this.indexLimitVisible];
        this.isReferencesResolved = true;
    }

    @Override
    public boolean hasReference(RangeVariable rangeVariable) {
        if (this.unresolvedExpressions == null) {
            return false;
        }
        for (int i2 = 0; i2 < this.unresolvedExpressions.size(); ++i2) {
            if (!((Expression)this.unresolvedExpressions.get(i2)).hasReference(rangeVariable)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean areColumnsResolved() {
        return super.areColumnsResolved();
    }

    @Override
    public void resolveTypes(Session session) {
        if (this.isResolved) {
            return;
        }
        this.resolveTypesPartOne(session);
        this.resolveTypesPartTwo(session);
        this.resolveTypesPartThree(session);
        ArrayUtil.copyArray(this.resultTable.colTypes, this.unionColumnTypes, this.unionColumnTypes.length);
    }

    @Override
    void resolveTypesPartOne(Session session) {
        if (this.isPartOneResolved) {
            return;
        }
        this.resolveExpressionTypes(session);
        this.resolveAggregates();
        for (int i2 = 0; i2 < this.unionColumnTypes.length; ++i2) {
            this.unionColumnTypes[i2] = Type.getAggregateType(this.unionColumnTypes[i2], this.exprColumns[i2].getDataType());
        }
        this.isPartOneResolved = true;
    }

    @Override
    void resolveTypesPartTwoRecursive(Session session) {
        for (int i2 = 0; i2 < this.unionColumnTypes.length; ++i2) {
            Type type = this.unionColumnTypes[i2];
            this.exprColumns[i2].setDataType(session, type);
        }
        this.setResultColumnTypes();
        this.createResultMetaData(session);
        this.createTable(session);
    }

    @Override
    void resolveTypesPartTwo(Session session) {
        int n2;
        if (this.isPartTwoResolved) {
            return;
        }
        this.resolveGroups();
        this.resolveGroupingSets();
        for (n2 = 0; n2 < this.unionColumnTypes.length; ++n2) {
            Type type = this.unionColumnTypes[n2];
            if (type == null) {
                if (session.database.sqlEnforceTypes) {
                    throw Error.error(5567);
                }
                this.unionColumnTypes[n2] = type = Type.SQL_VARCHAR_DEFAULT;
            }
            this.exprColumns[n2].setDataType(session, type);
            if (!this.exprColumns[n2].dataType.isArrayType() || this.exprColumns[n2].dataType.collectionBaseType() != null) continue;
            throw Error.error(5567);
        }
        for (n2 = this.indexLimitVisible; n2 < this.indexStartHaving; ++n2) {
            if (this.exprColumns[n2].dataType != null) continue;
            throw Error.error(5567);
        }
        this.checkLobUsage();
        this.setMergeability();
        this.setUpdatability(session);
        this.setResultColumnTypes();
        this.createResultMetaData(session);
        this.createTable(session);
        this.mergeQuery(session);
        this.isPartTwoResolved = true;
    }

    @Override
    void resolveTypesPartThree(Session session) {
        if (this.isResolved) {
            return;
        }
        this.sortAndSlice.setSortIndex(this);
        this.setRangeVariableConditions(session);
        this.setDistinctConditions(session);
        this.setAggregateConditions(session);
        this.sortAndSlice.setSortRange(this);
        for (int i2 = 0; i2 < this.rangeVariables.length; ++i2) {
            this.rangeVariables[i2].resolveRangeTableTypes(session, this.rangeVariables);
        }
        this.setResultNullability();
        this.rangeVariableList = null;
        this.tempSet = null;
        this.compileContext = null;
        this.outerRanges = null;
        this.isResolved = true;
    }

    @Override
    public void addExtraConditions(Expression expression) {
        if (this.isAggregated || this.isGrouped) {
            return;
        }
        this.queryCondition = ExpressionLogical.andExpressions(this.queryCondition, expression);
    }

    private void resolveColumnReferences(Session session, RangeGroup[] rangeGroupArray) {
        Object object;
        int n2;
        if (this.isDistinctSelect || this.isGrouped) {
            this.acceptsSequences = false;
        }
        for (n2 = 0; n2 < this.rangeVariables.length; ++n2) {
            object = this.rangeVariables[n2].getJoinCondition();
            if (object == null) continue;
            this.resolveColumnReferencesAndAllocate(session, (Expression)object, n2 + 1, rangeGroupArray, false);
        }
        this.resolveColumnReferencesAndAllocate(session, this.queryCondition, this.rangeVariables.length, rangeGroupArray, false);
        if (this.resolvedSubqueryExpressions != null) {
            this.resolvedSubqueryExpressions.setSize(0);
        }
        for (n2 = 0; n2 < this.indexLimitVisible; ++n2) {
            this.resolveColumnReferencesAndAllocate(session, this.exprColumns[n2], this.rangeVariables.length, rangeGroupArray, this.acceptsSequences);
            if (this.isGrouped || this.isDistinctSelect) continue;
            object = this.exprColumns[n2].collectAllSubqueries(null);
            if (object != null) {
                this.isMergeable = false;
            }
            if ((object = this.exprColumns[n2].collectAllExpressions(null, OpTypes.sequenceExpressionSet, OpTypes.subqueryAggregateExpressionSet)) == null) continue;
            this.isOrderSensitive = true;
            this.isMergeable = false;
            this.isBaseMergeable = false;
        }
        for (n2 = this.indexStartHaving; n2 < this.indexStartOrderBy; ++n2) {
            this.resolveColumnReferencesAndAllocate(session, this.exprColumns[n2], this.rangeVariables.length, rangeGroupArray, false);
        }
        this.resolveColumnReferencesInOrderBy(session, rangeGroupArray, this.sortAndSlice);
    }

    void resolveColumnReferencesInOrderBy(Session session, RangeGroup[] rangeGroupArray, SortAndSlice sortAndSlice) {
        int n2 = sortAndSlice.getOrderLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            boolean bl;
            ExpressionOrderBy expressionOrderBy = (ExpressionOrderBy)sortAndSlice.exprList.get(i2);
            this.replaceColumnIndexInOrderBy(expressionOrderBy);
            if (expressionOrderBy.getLeftNode().resultTableColumnIndex != -1) continue;
            if (sortAndSlice.sortUnion && expressionOrderBy.getLeftNode().getType() != 2) {
                throw Error.error(5576);
            }
            expressionOrderBy.replaceAliasInOrderBy(session, this.exprColumns, this.indexLimitVisible);
            this.resolveColumnReferencesAndAllocate(session, expressionOrderBy, this.rangeVariables.length, RangeGroup.emptyArray, false);
            if (!this.isAggregated && !this.isGrouped || (bl = expressionOrderBy.getLeftNode().isComposedOf(this.exprColumns, 0, this.indexLimitVisible + this.groupByColumnCount, OpTypes.aggregateFunctionSet))) continue;
            throw Error.error(5576);
        }
        if (sortAndSlice.limitCondition != null) {
            this.unresolvedExpressions = sortAndSlice.limitCondition.resolveColumnReferences(session, this, rangeGroupArray, this.unresolvedExpressions);
        }
        sortAndSlice.prepare(this.indexStartOrderBy);
    }

    private boolean resolveColumnReferences(Session session, Expression expression, int n2, boolean bl) {
        if (expression == null) {
            return true;
        }
        int n3 = this.unresolvedExpressions == null ? 0 : this.unresolvedExpressions.size();
        this.unresolvedExpressions = expression.resolveColumnReferences(session, this, n2, RangeGroup.emptyArray, this.unresolvedExpressions, bl);
        int n4 = this.unresolvedExpressions == null ? 0 : this.unresolvedExpressions.size();
        return n3 == n4;
    }

    private void resolveColumnReferencesForAsterisk() {
        int n2 = 0;
        while (n2 < this.indexLimitVisible) {
            Expression expression = (Expression)this.exprColumnList.get(n2);
            if (expression.getType() == 99) {
                int n3;
                this.exprColumnList.remove(n2);
                String string = ((ExpressionColumn)expression).getTableName();
                if (string == null) {
                    this.addAllJoinedColumns(expression);
                } else {
                    n3 = 0;
                    for (int i2 = 0; i2 < this.rangeVariables.length; ++i2) {
                        RangeVariable rangeVariable = this.rangeVariables[i2].getRangeForTableName(string);
                        if (rangeVariable == null) continue;
                        HashSet hashSet = this.getAllNamedJoinColumns();
                        this.rangeVariables[i2].addTableColumns(rangeVariable, expression, hashSet);
                        n3 = 1;
                        break;
                    }
                    if (n3 == 0) {
                        throw Error.error(5501, string);
                    }
                }
                for (n3 = 0; n3 < expression.nodes.length; ++n3) {
                    this.exprColumnList.add(n2, expression.nodes[n3]);
                    ++n2;
                }
                this.indexLimitVisible += expression.nodes.length - 1;
                continue;
            }
            ++n2;
        }
    }

    private void resolveColumnReferencesAndAllocate(Session session, Expression expression, int n2, RangeGroup[] rangeGroupArray, boolean bl) {
        if (expression == null) {
            return;
        }
        List list = expression.resolveColumnReferences(session, this, n2, rangeGroupArray, null, bl);
        if (list != null) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Expression expression2 = (Expression)list.get(i2);
                boolean bl2 = true;
                if (expression2.isSelfAggregate()) {
                    for (int i3 = 0; i3 < expression2.nodes.length; ++i3) {
                        List list2 = expression2.nodes[i3].resolveColumnReferences(session, this, n2, RangeGroup.emptyArray, null, false);
                        for (int i4 = 0; i4 < rangeGroupArray.length; ++i4) {
                            if (!rangeGroupArray[i4].isVariable()) continue;
                            list2 = Expression.resolveColumnSet(session, rangeGroupArray[i4].getRangeVariables(), RangeGroup.emptyArray, list2);
                        }
                        bl2 &= list2 == null;
                    }
                } else {
                    bl2 = this.resolveColumnReferences(session, expression2, n2, bl);
                }
                if (bl2) {
                    if (expression2.isSelfAggregate()) {
                        this.addAggregateToSet(expression, expression2);
                    }
                    if (this.resolvedSubqueryExpressions == null) {
                        this.resolvedSubqueryExpressions = new ArrayListIdentity();
                    }
                    this.resolvedSubqueryExpressions.add(expression2);
                    continue;
                }
                if (this.unresolvedExpressions == null) {
                    this.unresolvedExpressions = new ArrayListIdentity();
                }
                this.unresolvedExpressions.add(expression2);
            }
        }
    }

    private void addAggregateToSet(Expression expression, Expression expression2) {
        if (this.aggregateSet == null) {
            this.aggregateSet = new ArrayListIdentity();
        }
        this.aggregateSet.add(expression2);
        this.isAggregated = true;
        expression.setAggregate();
        expression2.setCorrelatedReferences(this);
    }

    private HashSet getAllNamedJoinColumns() {
        HashSet hashSet = null;
        for (int i2 = 0; i2 < this.rangeVariableList.size(); ++i2) {
            RangeVariable rangeVariable = (RangeVariable)this.rangeVariableList.get(i2);
            if (rangeVariable.namedJoinColumns == null) continue;
            if (hashSet == null) {
                hashSet = new HashSet();
            }
            hashSet.addAll(rangeVariable.namedJoinColumns);
        }
        return hashSet;
    }

    public Expression getEquiJoinExpressions(OrderedHashSet orderedHashSet, RangeVariable rangeVariable, boolean bl) {
        HashSet<String> hashSet = new HashSet<String>();
        Expression expression = null;
        OrderedHashSet<String> orderedHashSet2 = new OrderedHashSet<String>();
        for (int i2 = this.rangeVariableList.size() - 1; i2 >= 0; --i2) {
            RangeVariable rangeVariable2 = (RangeVariable)this.rangeVariableList.get(i2);
            OrderedHashMap orderedHashMap = rangeVariable2.rangeTable.columnList;
            for (int i3 = 0; i3 < orderedHashMap.size(); ++i3) {
                boolean bl2;
                ColumnSchema columnSchema = (ColumnSchema)orderedHashMap.get(i3);
                String string = rangeVariable2.getColumnAlias((int)i3).name;
                boolean bl3 = orderedHashSet.contains(string);
                boolean bl4 = rangeVariable2.namedJoinColumns != null && rangeVariable2.namedJoinColumns.contains(string);
                boolean bl5 = bl2 = !bl4 && !hashSet.add(string);
                if (bl2 && (!bl || bl3)) {
                    throw Error.error(5578, string);
                }
                if (!bl3) continue;
                orderedHashSet2.add(string);
                int n2 = rangeVariable2.rangeTable.getColumnIndex(columnSchema.getNameString());
                int n3 = rangeVariable.rangeTable.getColumnIndex(string);
                ExpressionLogical expressionLogical = new ExpressionLogical(rangeVariable2, n2, rangeVariable, n3);
                ExpressionColumn expressionColumn = rangeVariable2.getColumnExpression(string);
                if (expressionColumn == null) {
                    expressionColumn = new ExpressionColumn(new Expression[]{expressionLogical.getLeftNode(), expressionLogical.getRightNode()}, string);
                    rangeVariable2.addNamedJoinColumnExpression(string, expressionColumn, n2);
                    expression = ExpressionLogical.andExpressions(expression, expressionLogical);
                    rangeVariable.addNamedJoinColumnExpression(string, expressionColumn, n3);
                    continue;
                }
                if (rangeVariable.getColumnExpression(string) != null || rangeVariable2.isLeftJoin && !rangeVariable2.isRightJoin) continue;
                if (rangeVariable2.isLeftJoin && rangeVariable2.isRightJoin) {
                    expressionLogical = new ExpressionLogical(expressionColumn, expressionLogical.getRightNode());
                }
                expressionColumn.nodes = (Expression[])ArrayUtil.resizeArray(expressionColumn.nodes, expressionColumn.nodes.length + 1);
                expressionColumn.nodes[expressionColumn.nodes.length - 1] = expressionLogical.getRightNode();
                expression = ExpressionLogical.andExpressions(expression, expressionLogical);
                rangeVariable.addNamedJoinColumnExpression(string, expressionColumn, n3);
            }
            if (!rangeVariable2.isJoin) break;
        }
        if (bl && !orderedHashSet2.containsAll(orderedHashSet)) {
            throw Error.error(5501);
        }
        rangeVariable.addNamedJoinColumns(orderedHashSet2);
        return expression;
    }

    private void addAllJoinedColumns(Expression expression) {
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        for (int i2 = 0; i2 < this.rangeVariables.length; ++i2) {
            this.rangeVariables[i2].addTableColumns(hsqlArrayList);
        }
        Expression[] expressionArray = new Expression[hsqlArrayList.size()];
        hsqlArrayList.toArray(expressionArray);
        expression.nodes = expressionArray;
    }

    private void setColumnIndexes() {
        int n2 = 0;
        while (n2 < this.indexLimitVisible) {
            Expression expression = (Expression)this.exprColumnList.get(n2);
            expression.resultTableColumnIndex = n2++;
        }
        this.indexLimitRowId = this.indexLimitVisible;
        this.indexStartHaving = this.indexLimitRowId + this.groupByColumnCount;
        this.indexStartOrderBy = this.indexStartHaving + this.havingColumnCount;
        this.indexLimitData = this.indexLimitExpressions = (this.indexStartAggregates = this.indexStartOrderBy + this.sortAndSlice.getOrderLength());
    }

    private void finaliseColumns() {
        this.exprColumns = new Expression[this.indexLimitExpressions];
        this.exprColumnList.toArray(this.exprColumns);
        this.exprColumnList = null;
        if (this.sortAndSlice.hasOrder()) {
            for (int i2 = 0; i2 < this.sortAndSlice.getOrderLength(); ++i2) {
                this.exprColumns[this.indexStartOrderBy + i2] = (Expression)this.sortAndSlice.exprList.get(i2);
            }
        }
    }

    private int replaceColumnIndexInOrderBy(Expression expression) {
        int n2;
        Expression expression2 = expression.getLeftNode();
        if (expression2.getType() != 1) {
            return -1;
        }
        Type type = expression2.getDataType();
        if (type != null && type.typeCode == 4 && 0 < (n2 = ((Integer)expression2.getValue(null)).intValue()) && n2 <= this.indexLimitVisible) {
            expression.setLeftNode(this.exprColumns[n2 - 1]);
            return n2;
        }
        throw Error.error(5576);
    }

    @Override
    OrderedHashSet collectRangeVariables(RangeVariable[] rangeVariableArray, OrderedHashSet orderedHashSet) {
        int n2;
        for (n2 = 0; n2 < this.indexStartAggregates; ++n2) {
            orderedHashSet = this.exprColumns[n2].collectRangeVariables(rangeVariableArray, orderedHashSet);
        }
        if (this.queryCondition != null) {
            orderedHashSet = this.queryCondition.collectRangeVariables(rangeVariableArray, orderedHashSet);
        }
        for (n2 = 0; n2 < this.rangeVariables.length; ++n2) {
            orderedHashSet = this.rangeVariables[n2].collectRangeVariables(rangeVariableArray, orderedHashSet);
        }
        return orderedHashSet;
    }

    @Override
    OrderedHashSet collectRangeVariables(OrderedHashSet orderedHashSet) {
        for (int i2 = 0; i2 < this.indexStartAggregates; ++i2) {
            orderedHashSet = this.exprColumns[i2].collectRangeVariables(orderedHashSet);
        }
        if (this.queryCondition != null) {
            orderedHashSet = this.queryCondition.collectRangeVariables(orderedHashSet);
        }
        return orderedHashSet;
    }

    public void resolveExpressionTypes(Session session) {
        Expression expression;
        int n2;
        Expression expression2 = new Expression(25, this.exprColumns);
        for (n2 = 0; n2 < this.indexStartAggregates; ++n2) {
            expression = this.exprColumns[n2];
            expression.resolveTypes(session, expression2);
            if (expression.getType() == 25) {
                throw Error.error(5565);
            }
            if (expression.getType() == 22 && expression.getDegree() > 1) {
                throw Error.error(5565);
            }
            if (expression.getDataType() == null || expression.getDataType().typeCode != 19) continue;
            throw Error.error(5565);
        }
        expression2.nodes = new Expression[1];
        for (n2 = 0; n2 < this.rangeVariables.length; ++n2) {
            expression = this.rangeVariables[n2].getJoinCondition();
            if (expression == null) continue;
            expression2.setLeftNode(expression);
            expression.resolveTypes(session, expression2);
            expression = expression2.getLeftNode();
            this.rangeVariables[n2].setJoinCondition(expression);
            if (expression.getDataType() == Type.SQL_BOOLEAN) continue;
            throw Error.error(5568);
        }
        if (this.queryCondition != null) {
            expression2.setLeftNode(this.queryCondition);
            this.queryCondition.resolveTypes(session, expression2);
            this.queryCondition = expression2.getLeftNode();
            if (this.queryCondition.getDataType() != Type.SQL_BOOLEAN) {
                throw Error.error(5568);
            }
        }
        if (this.havingColumnCount != 0 && this.exprColumns[this.indexStartHaving].getDataType() != Type.SQL_BOOLEAN) {
            throw Error.error(5568);
        }
        if (this.sortAndSlice.limitCondition != null) {
            this.sortAndSlice.limitCondition.resolveTypes(session, null);
        }
    }

    private void resolveAggregates() {
        this.tempSet.clear();
        if (this.isAggregated) {
            this.aggregateCheck = new boolean[this.indexStartAggregates];
            this.tempSet.addAll(this.aggregateSet);
            this.indexLimitData = this.indexLimitExpressions = this.exprColumns.length + this.tempSet.size();
            this.exprColumns = (Expression[])ArrayUtil.resizeArray(this.exprColumns, this.indexLimitExpressions);
            int n2 = this.indexStartAggregates;
            int n3 = 0;
            while (n2 < this.indexLimitExpressions) {
                Expression expression = (Expression)this.tempSet.get(n3);
                this.exprColumns[n2] = expression.duplicate();
                this.exprColumns[n2].nodes = expression.nodes;
                this.exprColumns[n2].dataType = expression.dataType;
                ++n2;
                ++n3;
            }
            this.tempSet.clear();
        }
    }

    private void setRangeVariableConditions(Session session) {
        RangeVariableResolver rangeVariableResolver = new RangeVariableResolver(session, this);
        rangeVariableResolver.processConditions();
        this.rangeVariables = rangeVariableResolver.rangeVariables;
        if (this.rangeVariables.length > 1) {
            this.isMergeable = false;
        }
    }

    private void setDistinctConditions(Session session) {
        Index index;
        int n2;
        int[] nArray;
        if (!this.isDistinctSelect && !this.isGrouped) {
            return;
        }
        if (this.isAggregated) {
            return;
        }
        for (int i2 = 0; i2 < this.rangeVariables.length; ++i2) {
            if (!this.rangeVariables[i2].isRightJoin) continue;
            return;
        }
        RangeVariable rangeVariable = null;
        if (this.isGrouped) {
            nArray = new int[this.groupByColumnCount];
            for (n2 = 0; n2 < this.groupByColumnCount; ++n2) {
                if (this.exprColumns[this.indexLimitRowId + n2].getType() != 2) {
                    return;
                }
                if (rangeVariable == null) {
                    rangeVariable = this.exprColumns[this.indexLimitRowId + n2].getRangeVariable();
                } else if (rangeVariable != this.exprColumns[this.indexLimitRowId + n2].getRangeVariable()) {
                    return;
                }
                nArray[n2] = this.exprColumns[n2].columnIndex;
            }
        } else {
            nArray = new int[this.indexLimitVisible];
        }
        for (n2 = 0; n2 < this.indexLimitVisible; ++n2) {
            if (this.exprColumns[n2].getType() != 2) {
                return;
            }
            if (rangeVariable == null) {
                rangeVariable = this.exprColumns[n2].getRangeVariable();
            } else if (rangeVariable != this.exprColumns[n2].getRangeVariable()) {
                return;
            }
            if (this.isGrouped) continue;
            nArray[n2] = this.exprColumns[n2].columnIndex;
        }
        if (rangeVariable != this.rangeVariables[0]) {
            return;
        }
        n2 = ArrayUtil.areAllIntIndexesAsBooleanArray(nArray, rangeVariable.usedColumns) ? 1 : 0;
        if (n2 == 0) {
            return;
        }
        if (!rangeVariable.hasAnyIndexCondition() && (index = rangeVariable.rangeTable.getIndexForAllColumns(nArray)) != null) {
            rangeVariable.setSortIndex(index, false);
        }
        this.isSimpleDistinct = rangeVariable.setDistinctColumnsOnIndex(nArray);
    }

    private void setAggregateConditions(Session session) {
        if (!this.isAggregated) {
            return;
        }
        if (this.isGrouped) {
            this.setGroupedAggregateConditions(session);
        } else if (!this.sortAndSlice.hasOrder() && !this.sortAndSlice.hasLimit() && this.aggregateSet.size() == 1 && this.indexLimitVisible == 1) {
            Expression expression = this.exprColumns[this.indexStartAggregates];
            int n2 = expression.getType();
            Expression expression2 = expression.getLeftNode();
            switch (n2) {
                case 76: 
                case 77: {
                    if (expression.hasCondition()) break;
                    SortAndSlice sortAndSlice = new SortAndSlice();
                    sortAndSlice.isGenerated = true;
                    sortAndSlice.addLimitCondition(ExpressionOp.limitOneExpression);
                    if (!sortAndSlice.prepareSpecial(session, this)) break;
                    this.sortAndSlice = sortAndSlice;
                    break;
                }
                case 74: {
                    if (expression.hasCondition() || this.rangeVariables.length != 1 || this.queryCondition != null) break;
                    if (expression2.getType() == 11) {
                        this.isSimpleCount = true;
                        break;
                    }
                    if (expression2.getNullability() != 0) break;
                    if (expression.isDistinctAggregate) {
                        Table table;
                        if (expression2.opType != 2 || (table = expression2.getRangeVariable().getTable()).getPrimaryKey().length != 1 || table.getColumn(table.getPrimaryKey()[0]) != expression2.getColumn()) break;
                        this.isSimpleCount = true;
                        break;
                    }
                    this.isSimpleCount = true;
                    break;
                }
            }
        }
    }

    private void setGroupedAggregateConditions(Session session) {
    }

    void checkLobUsage() {
    }

    private void resolveGroups() {
        int n2;
        Expression expression;
        int n3;
        int n4;
        OrderedHashSet orderedHashSet = null;
        this.tempSet.clear();
        if (this.isGrouped) {
            for (n4 = this.indexLimitVisible; n4 < this.indexLimitVisible + this.groupByColumnCount; ++n4) {
                this.exprColumns[n4].collectAllExpressions(this.tempSet, OpTypes.aggregateFunctionSet, OpTypes.subqueryExpressionSet);
                if (this.tempSet.isEmpty()) continue;
                throw Error.error(5572, ((Expression)this.tempSet.get(0)).getSQL());
            }
            for (n4 = 0; n4 < this.indexLimitVisible; ++n4) {
                if (this.exprColumns[n4].isComposedOf(this.exprColumns, this.indexLimitVisible, this.indexLimitVisible + this.groupByColumnCount, OpTypes.aggregateFunctionSet)) continue;
                this.tempSet.add(this.exprColumns[n4]);
            }
            if (!this.tempSet.isEmpty()) {
                if (!this.resolveForGroupBy(this.tempSet)) {
                    throw Error.error(5574, ((Expression)this.tempSet.get(0)).getSQL());
                }
                orderedHashSet = new OrderedHashSet();
                orderedHashSet.addAll(this.tempSet);
            }
        } else if (this.isAggregated) {
            for (n4 = 0; n4 < this.indexLimitVisible; ++n4) {
                this.exprColumns[n4].collectAllExpressions(this.tempSet, OpTypes.columnExpressionSet, OpTypes.aggregateFunctionSet);
                for (n3 = 0; n3 < this.tempSet.size(); ++n3) {
                    expression = (Expression)this.tempSet.get(n3);
                    for (int i2 = 0; i2 < this.rangeVariables.length; ++i2) {
                        if (this.rangeVariables[i2] != expression.getRangeVariable()) continue;
                        throw Error.error(5574, expression.getSQL());
                    }
                }
                this.tempSet.clear();
            }
        }
        this.tempSet.clear();
        if (this.havingColumnCount != 0) {
            if (this.unresolvedExpressions != null) {
                this.tempSet.addAll(this.unresolvedExpressions);
            }
            for (n4 = this.indexLimitVisible; n4 < this.indexLimitVisible + this.groupByColumnCount; ++n4) {
                this.tempSet.add(this.exprColumns[n4]);
            }
            if (orderedHashSet != null) {
                this.tempSet.addAll(orderedHashSet);
            }
            if (!this.exprColumns[this.indexStartHaving].isComposedOf(this.tempSet, this.outerRanges, OpTypes.subqueryAggregateExpressionSet)) {
                throw Error.error(5573);
            }
            this.tempSet.clear();
        }
        if (this.isDistinctSelect) {
            n4 = this.sortAndSlice.getOrderLength();
            for (n3 = 0; n3 < n4; ++n3) {
                expression = (Expression)this.sortAndSlice.exprList.get(n3);
                if (expression.resultTableColumnIndex != -1 || expression.isComposedOf(this.exprColumns, 0, this.indexLimitVisible, OpTypes.emptyExpressionSet)) continue;
                throw Error.error(5576);
            }
        }
        if (this.isGrouped) {
            n4 = this.sortAndSlice.getOrderLength();
            for (n3 = 0; n3 < n4; ++n3) {
                expression = (Expression)this.sortAndSlice.exprList.get(n3);
                if (expression.resultTableColumnIndex != -1 || expression.hasAggregate() || expression.isComposedOf(this.exprColumns, 0, this.indexLimitVisible + this.groupByColumnCount, OpTypes.emptyExpressionSet)) continue;
                throw Error.error(5576);
            }
        }
        OrderedHashSet<Expression> orderedHashSet2 = new OrderedHashSet<Expression>();
        n3 = this.indexStartAggregates;
        while (n3 < this.indexLimitExpressions) {
            expression = this.exprColumns[n3];
            expression.resultTableColumnIndex = n3++;
            orderedHashSet2.add(expression);
        }
        for (n3 = 0; n3 < this.indexStartHaving; ++n3) {
            if (this.exprColumns[n3].hasAggregate()) continue;
            expression = this.exprColumns[n3];
            expression.resultTableColumnIndex = n3;
            orderedHashSet2.add(expression);
        }
        if (!this.isAggregated) {
            return;
        }
        n3 = this.sortAndSlice.getOrderLength();
        for (n2 = 0; n2 < n3; ++n2) {
            Expression expression2 = (Expression)this.sortAndSlice.exprList.get(n2);
            if (!expression2.getLeftNode().hasAggregate()) continue;
            expression2.setAggregate();
        }
        for (n2 = this.indexStartOrderBy; n2 < this.indexStartAggregates; ++n2) {
            if (!this.exprColumns[n2].getLeftNode().hasAggregate()) continue;
            this.exprColumns[n2].setAggregate();
        }
        for (n2 = 0; n2 < this.indexStartAggregates; ++n2) {
            Expression expression3 = this.exprColumns[n2];
            if (!expression3.hasAggregate()) continue;
            this.aggregateCheck[n2] = true;
            this.exprColumns[n2] = expression3.replaceExpressions(orderedHashSet2, this.resultRangePosition);
        }
        if (this.resolvedSubqueryExpressions != null) {
            for (n2 = 0; n2 < this.resolvedSubqueryExpressions.size(); ++n2) {
                Expression expression4 = (Expression)this.resolvedSubqueryExpressions.get(n2);
                expression4.replaceExpressions(orderedHashSet2, this.resultRangePosition);
            }
        }
    }

    public void resolveGroupingSets() {
        int n2;
        if (!this.isGrouped) {
            return;
        }
        this.tempSet.clear();
        for (n2 = this.indexLimitVisible; n2 < this.indexStartHaving; ++n2) {
            this.tempSet.add(this.exprColumns[n2]);
        }
        for (n2 = this.indexStartAggregates; n2 < this.indexLimitExpressions; ++n2) {
            this.tempSet.add(this.exprColumns[n2]);
        }
        if (this.isGroupingSets) {
            for (n2 = 0; n2 < this.indexLimitVisible; ++n2) {
                this.exprColumns[n2] = this.exprColumns[n2].replaceExpressions(this.tempSet, this.resultRangePosition);
            }
        }
        for (n2 = this.indexStartHaving; n2 < this.indexStartHaving + this.havingColumnCount; ++n2) {
            this.exprColumns[n2] = this.exprColumns[n2].replaceExpressions(this.tempSet, this.resultRangePosition);
        }
    }

    boolean resolveForGroupBy(List list) {
        Object object;
        Object object2;
        int n2;
        for (n2 = this.indexLimitVisible; n2 < this.indexLimitVisible + this.groupByColumnCount; ++n2) {
            object2 = this.exprColumns[n2];
            if (((Expression)object2).getType() != 2) continue;
            object = ((Expression)object2).getRangeVariable();
            int n3 = ((Expression)object2).getColumnIndex();
            ((RangeVariable)object).columnsInGroupBy[n3] = true;
        }
        for (n2 = 0; n2 < this.rangeVariables.length; ++n2) {
            object2 = this.rangeVariables[n2];
            ((RangeVariable)object2).hasKeyedColumnInGroupBy = ((RangeVariable)object2).rangeTable.getUniqueNotNullColumnGroup(((RangeVariable)object2).columnsInGroupBy) != null;
        }
        OrderedHashSet orderedHashSet = null;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            object = (Expression)list.get(i2);
            orderedHashSet = ((Expression)object).getUnkeyedColumns(orderedHashSet);
        }
        return orderedHashSet == null;
    }

    @Override
    Result getResult(Session session, int n2) {
        RowSetNavigatorData rowSetNavigatorData = new RowSetNavigatorData(session, this);
        int[] nArray = this.sortAndSlice.getLimits(session, this, n2);
        int n3 = 0;
        int n4 = nArray[2];
        if (this.sortAndSlice.skipFullResult) {
            n3 = nArray[0];
            n4 = nArray[1];
        }
        Result result = this.buildResult(session, rowSetNavigatorData, n3, n4);
        rowSetNavigatorData = (RowSetNavigatorData)result.getNavigator();
        if (this.isDistinctSelect) {
            rowSetNavigatorData.removeDuplicates();
        }
        if (this.sortAndSlice.hasOrder() && !this.sortAndSlice.skipSort) {
            rowSetNavigatorData.sortOrder();
        }
        if (nArray != SortAndSlice.defaultLimits && !this.sortAndSlice.skipFullResult) {
            rowSetNavigatorData.trim(nArray[0], nArray[1]);
        }
        result.getNavigator().reset();
        return result;
    }

    private Result buildResult(Session session, RowSetNavigatorData rowSetNavigatorData, int n2, int n3) {
        int n4;
        int n5;
        Result result = Result.newResult(rowSetNavigatorData);
        boolean bl = this.isGrouped && !this.isSimpleDistinct;
        result.metaData = this.resultMetaData;
        if (this.isUpdatable) {
            result.rsProperties = 8;
        }
        if (this.isSimpleCount) {
            this.getSimpleCountResult(session, rowSetNavigatorData);
            return result;
        }
        if (n3 == 0) {
            return result;
        }
        if (this.isGroupingSets) {
            session.sessionContext.setGroup(null);
        }
        int n6 = !this.isAggregated && !this.isSingleMemoryTable && !this.isGroupingSets ? session.resultMaxMemoryRows : 0;
        int n7 = 0;
        RangeIterator[] rangeIteratorArray = new RangeIterator[this.rangeVariables.length];
        for (n5 = 0; n5 < this.rangeVariables.length; ++n5) {
            rangeIteratorArray[n5] = this.rangeVariables[n5].getIterator(session);
        }
        session.sessionContext.rownum = 1;
        n5 = 0;
        while (true) {
            int n8;
            int n9;
            RangeIterator rangeIterator;
            if (n5 < n7) {
                boolean bl2 = true;
                for (n4 = n7 + 1; n4 < this.rangeVariables.length; ++n4) {
                    if (!this.rangeVariables[n4].isRightJoin) continue;
                    n7 = n4;
                    n5 = n4;
                    bl2 = false;
                    ((RangeVariable.RangeIteratorRight)rangeIteratorArray[n4]).setOnOuterRows();
                    break;
                }
                if (bl2) break;
            }
            if ((rangeIterator = rangeIteratorArray[n5]).next()) {
                if (n5 < this.rangeVariables.length - 1) {
                    ++n5;
                    continue;
                }
            } else {
                rangeIterator.reset();
                --n5;
                continue;
            }
            session.sessionData.startRowProcessing();
            Object[] objectArray = new Object[this.indexLimitData];
            int n10 = 0;
            if (this.isGroupingSets) {
                n10 = this.indexLimitVisible;
            }
            for (n9 = n10; n9 < this.indexStartAggregates; ++n9) {
                if (this.isAggregated && this.aggregateCheck[n9] || this.havingColumnCount > 0 && n9 == this.indexStartHaving) continue;
                objectArray[n9] = this.exprColumns[n9].getValue(session);
            }
            for (n9 = this.indexLimitVisible; n9 < this.indexLimitRowId; ++n9) {
                objectArray[n9] = n9 == this.indexLimitVisible ? Long.valueOf(rangeIterator.getRowId()) : rangeIterator.getCurrentRow();
            }
            ++session.sessionContext.rownum;
            if (n2 > 0) {
                --n2;
                continue;
            }
            Object[] objectArray2 = null;
            if ((this.isAggregated || bl) && (objectArray2 = rowSetNavigatorData.getGroupData(objectArray)) != null) {
                objectArray = objectArray2;
            }
            for (n8 = this.indexStartAggregates; n8 < this.indexLimitExpressions; ++n8) {
                objectArray[n8] = this.exprColumns[n8].updateAggregatingValue(session, (SetFunction)objectArray[n8]);
            }
            if (objectArray2 == null) {
                rowSetNavigatorData.add(objectArray);
                if (this.isSimpleDistinct) {
                    for (n8 = 1; n8 < this.rangeVariables.length; ++n8) {
                        rangeIteratorArray[n8].reset();
                    }
                    n5 = 0;
                }
            } else if (this.isAggregated) {
                rowSetNavigatorData.update(objectArray2, objectArray);
            }
            if ((n8 = rowSetNavigatorData.getSize()) == n6) {
                rowSetNavigatorData = new RowSetNavigatorDataTable(session, this, rowSetNavigatorData);
                result.setNavigator(rowSetNavigatorData);
                n6 = 0;
            }
            if ((!this.isAggregated && !bl || this.sortAndSlice.isGenerated) && n8 >= n3) break;
        }
        rowSetNavigatorData.reset();
        for (n5 = 0; n5 < this.rangeVariables.length; ++n5) {
            rangeIteratorArray[n5].reset();
        }
        if (!this.isGroupingSets && !this.isAggregated && this.havingColumnCount == 0) {
            return result;
        }
        session.sessionContext.setRangeIterator(rowSetNavigatorData);
        if (this.isGroupingSets) {
            session.sessionContext.setGroupSet(this.groupSet);
            Iterator iterator = this.groupSet.getIterator();
            Object[][] objectArray = rowSetNavigatorData.getDataTable();
            n4 = rowSetNavigatorData.getSize();
            rowSetNavigatorData.clear();
            if (this.groupSet.nullSets != 0) {
                int n11;
                Object[] objectArray3 = new Object[this.indexLimitData];
                for (n11 = 0; n11 < this.indexStartAggregates; ++n11) {
                    objectArray3[n11] = this.exprColumns[n11].getValue(session);
                }
                rowSetNavigatorData.add(objectArray3);
                rowSetNavigatorData.next();
                if (this.isAggregated) {
                    for (n11 = 0; n11 < n4; ++n11) {
                        Object[] objectArray4 = objectArray[n11];
                        for (int i2 = this.indexStartAggregates; i2 < this.indexLimitExpressions; ++i2) {
                            objectArray3[i2] = this.exprColumns[i2].updateAggregatingValue(session, (SetFunction)objectArray3[i2], (SetFunction)objectArray4[i2]);
                        }
                    }
                    for (n11 = this.indexStartAggregates; n11 < this.indexLimitExpressions; ++n11) {
                        objectArray3[n11] = this.exprColumns[n11].getAggregatedValue(session, (SetFunction)objectArray3[n11]);
                    }
                    for (n11 = 0; n11 < this.indexStartAggregates; ++n11) {
                        if (!this.aggregateCheck[n11]) continue;
                        objectArray3[n11] = this.exprColumns[n11].getValue(session);
                    }
                }
                for (n11 = 1; n11 < this.groupSet.nullSets; ++n11) {
                    rowSetNavigatorData.add(objectArray3);
                    rowSetNavigatorData.next();
                }
            }
            while (iterator.hasNext()) {
                rowSetNavigatorData.resetRowMap();
                List list = (List)iterator.next();
                session.sessionContext.setGroup(list);
                for (int i3 = 0; i3 < n4; ++i3) {
                    int n12;
                    Object[] objectArray5 = objectArray[i3];
                    Object[] objectArray6 = new Object[this.indexLimitData];
                    for (int i4 = this.indexLimitVisible; i4 < this.indexStartHaving; ++i4) {
                        if (!list.contains(i4)) continue;
                        objectArray6[i4] = objectArray5[i4];
                    }
                    Object[] objectArray7 = rowSetNavigatorData.getGroupDataAndPosition(objectArray6);
                    if (objectArray7 == null) {
                        rowSetNavigatorData.add(objectArray6);
                        rowSetNavigatorData.absolute(rowSetNavigatorData.getSize() - 1);
                    } else {
                        objectArray6 = objectArray7;
                    }
                    for (n12 = this.indexStartAggregates; n12 < this.indexLimitExpressions; ++n12) {
                        objectArray6[n12] = this.exprColumns[n12].updateAggregatingValue(session, (SetFunction)objectArray6[n12], (SetFunction)objectArray5[n12]);
                    }
                    for (n12 = 0; n12 < this.indexLimitVisible; ++n12) {
                        objectArray6[n12] = this.exprColumns[n12].getValue(session);
                    }
                    rowSetNavigatorData.update(objectArray7, objectArray6);
                }
            }
        }
        rowSetNavigatorData.reset();
        if (this.isAggregated) {
            if (!bl && rowSetNavigatorData.getSize() == 0) {
                Object[] objectArray = new Object[this.exprColumns.length];
                for (int i5 = 0; i5 < this.indexStartAggregates; ++i5) {
                    if (this.aggregateCheck[i5]) continue;
                    objectArray[i5] = this.exprColumns[i5].getValue(session);
                }
                rowSetNavigatorData.add(objectArray);
            }
            if (this.isGroupingSets) {
                for (int i6 = 0; i6 < this.groupSet.nullSets; ++i6) {
                    rowSetNavigatorData.next();
                }
            }
            while (rowSetNavigatorData.next()) {
                int n13;
                Object[] objectArray = rowSetNavigatorData.getCurrent();
                for (n13 = this.indexStartAggregates; n13 < this.indexLimitExpressions; ++n13) {
                    objectArray[n13] = this.exprColumns[n13].getAggregatedValue(session, (SetFunction)objectArray[n13]);
                }
                for (n13 = 0; n13 < this.indexStartAggregates; ++n13) {
                    if (!this.aggregateCheck[n13]) continue;
                    objectArray[n13] = this.exprColumns[n13].getValue(session);
                }
            }
        }
        rowSetNavigatorData.reset();
        if (this.havingColumnCount != 0) {
            while (rowSetNavigatorData.next()) {
                Object[] objectArray = rowSetNavigatorData.getCurrent();
                boolean bl3 = this.exprColumns[this.indexStartHaving].testCondition(session);
                if (bl3) continue;
                rowSetNavigatorData.removeCurrent();
            }
            rowSetNavigatorData.reset();
        }
        session.sessionContext.unsetRangeIterator(rowSetNavigatorData);
        return result;
    }

    private void getSimpleCountResult(Session session, RowSetNavigatorData rowSetNavigatorData) {
        Object[] objectArray = new Object[this.indexLimitData];
        Table table = this.rangeVariables[0].getTable();
        table.materialise(session);
        PersistentStore persistentStore = table.getRowStore(session);
        long l2 = persistentStore.elementCount(session);
        objectArray[this.indexStartAggregates] = ValuePool.getLong(l2);
        rowSetNavigatorData.add(objectArray);
        rowSetNavigatorData.reset();
        session.sessionContext.setRangeIterator(rowSetNavigatorData);
        if (rowSetNavigatorData.next()) {
            objectArray = rowSetNavigatorData.getCurrent();
            for (int i2 = 0; i2 < this.indexStartAggregates; ++i2) {
                objectArray[i2] = this.exprColumns[i2].getValue(session);
            }
        }
        session.sessionContext.unsetRangeIterator(rowSetNavigatorData);
    }

    void setReferenceableColumns() {
        this.accessibleColumns = new boolean[this.indexLimitVisible];
        IntValueHashMap intValueHashMap = new IntValueHashMap();
        for (int i2 = 0; i2 < this.indexLimitVisible; ++i2) {
            Expression expression = this.exprColumns[i2];
            String string = expression.getAlias();
            if (string.isEmpty()) {
                HsqlNameManager.HsqlName hsqlName = HsqlNameManager.getAutoColumnName(i2);
                expression.setAlias(hsqlName);
                continue;
            }
            int n2 = intValueHashMap.get((Object)string, -1);
            if (n2 == -1) {
                intValueHashMap.put(string, i2);
                this.accessibleColumns[i2] = true;
                continue;
            }
            this.accessibleColumns[n2] = false;
        }
    }

    void setColumnAliases(HsqlNameManager.SimpleName[] simpleNameArray) {
        if (simpleNameArray.length != this.indexLimitVisible) {
            throw Error.error(5593);
        }
        for (int i2 = 0; i2 < this.indexLimitVisible; ++i2) {
            this.exprColumns[i2].setAlias(simpleNameArray[i2]);
        }
    }

    private void createResultMetaData(Session session) {
        this.resultMetaData = ResultMetaData.newResultMetaData(this.resultColumnTypes, this.columnMap, this.indexLimitVisible, this.indexLimitRowId);
        for (int i2 = 0; i2 < this.indexLimitVisible; ++i2) {
            String string;
            Expression expression = this.exprColumns[i2];
            ColumnSchema columnSchema = null;
            columnSchema = expression.getColumn();
            this.resultMetaData.columnTypes[i2] = expression.getDataType();
            ColumnBase columnBase = columnSchema == null ? new ColumnBase() : new ColumnBase(session.database.getCatalogName(), columnSchema, this.lowerCaseResultIdentifier);
            columnBase.setType(expression.getDataType());
            HsqlNameManager.SimpleName simpleName = expression.getSimpleName();
            String string2 = string = simpleName == null ? "" : simpleName.name;
            if (this.lowerCaseResultIdentifier && !simpleName.isNameQuoted) {
                string = string.toLowerCase(Locale.ENGLISH);
            }
            this.resultMetaData.columns[i2] = columnBase;
            this.resultMetaData.columnLabels[i2] = string;
        }
    }

    private void setResultNullability() {
        for (int i2 = 0; i2 < this.indexLimitVisible; ++i2) {
            RangeVariable rangeVariable;
            Expression expression = this.exprColumns[i2];
            byte by = expression.getNullability();
            if (expression.opType == 2 && (rangeVariable = expression.getRangeVariable()) != null && (rangeVariable.rangePositionInJoin < this.startInnerRange || rangeVariable.rangePositionInJoin >= this.endInnerRange)) {
                by = 1;
            }
            this.resultMetaData.columns[i2].setNullability(by);
        }
    }

    @Override
    void createTable(Session session) {
        int[] nArray;
        this.createResultTable(session);
        this.mainIndex = this.resultTable.getPrimaryIndex();
        if (this.sortAndSlice.hasOrder() && !this.sortAndSlice.skipSort) {
            this.orderIndex = this.sortAndSlice.getNewIndex(session, this.resultTable);
        }
        if (this.isDistinctSelect || this.isFullOrder) {
            this.createFullIndex(session);
        }
        if (this.isGrouped) {
            nArray = new int[this.groupByColumnCount];
            for (int i2 = 0; i2 < this.groupByColumnCount; ++i2) {
                nArray[i2] = this.indexLimitRowId + i2;
            }
            this.groupIndex = this.resultTable.createAndAddIndexStructure(session, null, nArray, null, null, false, false, false);
        } else if (this.isAggregated) {
            this.groupIndex = this.mainIndex;
        }
        if (this.isUpdatable && this.view == null) {
            nArray = new int[]{this.indexLimitVisible};
            this.idIndex = this.resultTable.createAndAddIndexStructure(session, null, nArray, null, null, false, false, false);
        }
    }

    private void createFullIndex(Session session) {
        int[] nArray = new int[this.indexLimitVisible];
        ArrayUtil.fillSequence(nArray);
        this.resultTable.fullIndex = this.fullIndex = this.resultTable.createAndAddIndexStructure(session, null, nArray, null, null, false, false, false);
    }

    private void setResultColumnTypes() {
        Expression expression;
        int n2;
        this.resultColumnTypes = new Type[this.indexLimitData];
        for (n2 = 0; n2 < this.indexLimitVisible; ++n2) {
            expression = this.exprColumns[n2];
            this.resultColumnTypes[n2] = expression.getDataType();
        }
        for (n2 = this.indexLimitVisible; n2 < this.indexLimitRowId; ++n2) {
            this.resultColumnTypes[n2] = n2 == this.indexLimitVisible ? Type.SQL_BIGINT : Type.SQL_ALL_TYPES;
        }
        for (n2 = this.indexLimitRowId; n2 < this.indexLimitData; ++n2) {
            expression = this.exprColumns[n2];
            Type type = expression.getDataType();
            if (type.getCollation() != expression.collation && expression.collation != null) {
                type = Type.getType(type, expression.collation);
            }
            this.resultColumnTypes[n2] = type;
        }
    }

    @Override
    void createResultTable(Session session) {
        HsqlNameManager.HsqlName hsqlName = session.database.nameManager.getSubqueryTableName();
        int n2 = this.persistenceScope == 21 ? 2 : 9;
        OrderedHashMap<String, ColumnSchema> orderedHashMap = new OrderedHashMap<String, ColumnSchema>();
        for (int i2 = 0; i2 < this.indexLimitVisible; ++i2) {
            Expression expression = this.exprColumns[i2];
            HsqlNameManager.SimpleName simpleName = expression.getSimpleName();
            String string = simpleName.name;
            HsqlNameManager.HsqlName hsqlName2 = session.database.nameManager.newColumnSchemaHsqlName(hsqlName, simpleName);
            if (!this.accessibleColumns[i2]) {
                string = HsqlNameManager.getAutoNoNameColumnString(i2);
            }
            ColumnSchema columnSchema = new ColumnSchema(hsqlName2, expression.dataType, true, false, null);
            orderedHashMap.add(string, columnSchema);
        }
        this.resultTable = new TableDerived(session.database, hsqlName, n2, this.resultColumnTypes, orderedHashMap, ValuePool.emptyIntArray);
    }

    public String getSQL() {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT").append(' ');
        int n3 = this.indexLimitVisible;
        for (n2 = 0; n2 < n3; ++n2) {
            if (n2 > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.exprColumns[n2].getSQL());
        }
        stringBuilder.append("FROM");
        n3 = this.rangeVariables.length;
        for (n2 = 0; n2 < n3; ++n2) {
            RangeVariable rangeVariable = this.rangeVariables[n2];
            if (n2 > 0) {
                if (rangeVariable.isLeftJoin && rangeVariable.isRightJoin) {
                    stringBuilder.append("FULL").append(' ');
                } else if (rangeVariable.isLeftJoin) {
                    stringBuilder.append("LEFT").append(' ');
                } else if (rangeVariable.isRightJoin) {
                    stringBuilder.append("RIGHT").append(' ');
                }
                stringBuilder.append("JOIN").append(' ');
            }
            stringBuilder.append(rangeVariable.getTable().getName().statementName);
        }
        if (this.isGrouped) {
            stringBuilder.append(' ').append("GROUP").append(' ').append("BY");
            n3 = this.indexLimitVisible + this.groupByColumnCount;
            for (n2 = this.indexLimitVisible; n2 < n3; ++n2) {
                stringBuilder.append(this.exprColumns[n2].getSQL());
                if (n2 >= n3 - 1) continue;
                stringBuilder.append(',');
            }
        }
        if (this.havingColumnCount != 0) {
            stringBuilder.append(' ').append("HAVING").append(' ');
            stringBuilder.append(this.exprColumns[this.indexStartHaving].getSQL());
        }
        if (this.sortAndSlice.hasOrder()) {
            n3 = this.indexStartOrderBy + this.sortAndSlice.getOrderLength();
            stringBuilder.append(' ').append("ORDER").append("BY").append(' ');
            for (n2 = this.indexStartOrderBy; n2 < n3; ++n2) {
                stringBuilder.append(this.exprColumns[n2].getSQL());
                if (n2 >= n3 - 1) continue;
                stringBuilder.append(',');
            }
        }
        if (this.sortAndSlice.hasLimit()) {
            stringBuilder.append(this.sortAndSlice.limitCondition.getLeftNode().getSQL());
        }
        return stringBuilder.toString();
    }

    @Override
    public ResultMetaData getMetaData() {
        return this.resultMetaData;
    }

    @Override
    public String describe(Session session, int n2) {
        String string;
        int n3;
        int n4;
        StringBuilder stringBuilder = new StringBuilder(n2);
        for (n4 = 0; n4 < n2; ++n4) {
            stringBuilder.append(' ');
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append((CharSequence)stringBuilder).append("isDistinctSelect=[").append(this.isDistinctSelect).append("]\n");
        stringBuilder2.append((CharSequence)stringBuilder).append("isGrouped=[").append(this.isGrouped).append("]\n");
        stringBuilder2.append((CharSequence)stringBuilder).append("isAggregated=[").append(this.isAggregated).append("]\n");
        stringBuilder2.append((CharSequence)stringBuilder).append("columns=[");
        for (n4 = 0; n4 < this.indexLimitVisible; ++n4) {
            n3 = n4;
            if (this.exprColumns[n4].getType() == 5) {
                n3 = this.exprColumns[n4].columnIndex;
            }
            stringBuilder2.append((CharSequence)stringBuilder);
            string = this.exprColumns[n3].describe(session, 2);
            stringBuilder2.append(string, 0, string.length() - 1);
            if (this.resultMetaData.columns[n4].getNullability() == 0) {
                stringBuilder2.append(" not nullable\n");
                continue;
            }
            stringBuilder2.append(" nullable\n");
        }
        stringBuilder2.append("\n");
        stringBuilder2.append((CharSequence)stringBuilder).append("]\n");
        for (n4 = 0; n4 < this.rangeVariables.length; ++n4) {
            stringBuilder2.append((CharSequence)stringBuilder).append("[");
            stringBuilder2.append("range variable ").append(n4 + 1).append("\n");
            stringBuilder2.append(this.rangeVariables[n4].describe(session, n2 + 2));
            stringBuilder2.append((CharSequence)stringBuilder).append("]");
        }
        stringBuilder2.append((CharSequence)stringBuilder).append("]\n");
        String string2 = string = this.queryCondition == null ? "null" : this.queryCondition.describe(session, n2);
        if (this.isGrouped) {
            stringBuilder2.append((CharSequence)stringBuilder).append("groupColumns=[");
            for (n4 = this.indexLimitRowId; n4 < this.indexLimitRowId + this.groupByColumnCount; ++n4) {
                n3 = n4;
                if (this.exprColumns[n4].getType() == 5) {
                    n3 = this.exprColumns[n4].columnIndex;
                }
                stringBuilder2.append(this.exprColumns[n3].describe(session, n2));
            }
            stringBuilder2.append((CharSequence)stringBuilder).append("]\n");
        }
        if (this.havingColumnCount != 0) {
            string = this.exprColumns[this.indexStartHaving].describe(session, n2);
            stringBuilder2.append((CharSequence)stringBuilder).append("havingCondition=[").append(string).append("]\n");
        }
        if (this.sortAndSlice.hasOrder()) {
            stringBuilder2.append((CharSequence)stringBuilder).append("order by=[\n");
            for (n4 = 0; n4 < this.sortAndSlice.exprList.size(); ++n4) {
                stringBuilder2.append((CharSequence)stringBuilder).append(((Expression)this.sortAndSlice.exprList.get(n4)).describe(session, n2));
            }
            if (this.sortAndSlice.primaryTableIndex != null) {
                stringBuilder2.append((CharSequence)stringBuilder).append("uses index");
            }
            stringBuilder2.append((CharSequence)stringBuilder).append("]\n");
        }
        if (this.sortAndSlice.hasLimit()) {
            if (this.sortAndSlice.limitCondition.getLeftNode() != null) {
                stringBuilder2.append((CharSequence)stringBuilder).append("offset=[").append(this.sortAndSlice.limitCondition.getLeftNode().describe(session, stringBuilder.length())).append("]\n");
            }
            if (this.sortAndSlice.limitCondition.getRightNode() != null) {
                stringBuilder2.append((CharSequence)stringBuilder).append("limit=[").append(this.sortAndSlice.limitCondition.getRightNode().describe(session, stringBuilder.length())).append("]\n");
            }
        }
        return stringBuilder2.toString();
    }

    void setMergeability() {
        this.isOrderSensitive |= this.sortAndSlice.hasLimit() || this.sortAndSlice.hasOrder();
        if (this.isOrderSensitive) {
            this.isMergeable = false;
        }
        if (this.isAggregated) {
            this.isMergeable = false;
        }
        if (this.isGrouped || this.isDistinctSelect) {
            this.isBaseMergeable = false;
            this.isMergeable = false;
        }
        if (this.rangeVariables.length != 1) {
            this.isBaseMergeable = false;
            this.isMergeable = false;
        }
    }

    void setUpdatability(Session session) {
        String string;
        Object object;
        int n2;
        if (!this.isUpdatable) {
            return;
        }
        this.isUpdatable = false;
        if (this.isGrouped || this.isDistinctSelect || this.isAggregated) {
            return;
        }
        if (!this.isBaseMergeable) {
            return;
        }
        if (!this.isTopLevel) {
            return;
        }
        if ((this.sortAndSlice.hasLimit() || this.sortAndSlice.hasOrder()) && !session.database.sqlSyntaxDb2) {
            return;
        }
        RangeVariable rangeVariable = this.rangeVariables[0];
        Table table = rangeVariable.getTable();
        Table table2 = table.getBaseTable();
        if (table2 == null) {
            return;
        }
        this.isInsertable = table.isInsertable();
        this.isUpdatable = table.isUpdatable();
        if (!this.isInsertable && !this.isUpdatable) {
            return;
        }
        IntValueHashMap intValueHashMap = new IntValueHashMap();
        int[] nArray = table.getBaseTableColumnMap();
        int[] nArray2 = new int[this.indexLimitVisible];
        if (this.queryCondition != null) {
            this.tempSet.clear();
            QuerySpecification.collectSubQueriesAndReferences(this.tempSet, this.queryCondition);
            if (this.tempSet.contains(table.getName()) || this.tempSet.contains(table2.getName())) {
                this.isUpdatable = false;
                this.isInsertable = false;
                return;
            }
        }
        for (n2 = 0; n2 < this.indexLimitVisible; ++n2) {
            object = this.exprColumns[n2];
            if (((Expression)object).getType() == 2) {
                string = ((Expression)object).getColumn().getName().name;
                if (intValueHashMap.containsKey(string)) {
                    intValueHashMap.put(string, 1);
                    continue;
                }
                intValueHashMap.put(string, 0);
                continue;
            }
            this.tempSet.clear();
            QuerySpecification.collectSubQueriesAndReferences(this.tempSet, (Expression)object);
            if (!this.tempSet.contains(table.getName())) continue;
            this.isUpdatable = false;
            this.isInsertable = false;
            return;
        }
        this.isUpdatable = false;
        for (n2 = 0; n2 < this.indexLimitVisible; ++n2) {
            if (this.accessibleColumns[n2] && ((Expression)(object = this.exprColumns[n2])).getType() == 2 && intValueHashMap.get(string = ((Expression)object).getColumn().getName().name) == 0) {
                int n3 = table.findColumn(string);
                nArray2[n2] = nArray[n3];
                if (nArray2[n2] == -1) continue;
                this.isUpdatable = true;
                continue;
            }
            nArray2[n2] = -1;
            this.isInsertable = false;
        }
        if (this.isInsertable) {
            boolean[] blArray = table2.getColumnCheckList(nArray2);
            for (n2 = 0; n2 < blArray.length; ++n2) {
                if (blArray[n2] || ((ColumnBase)(object = table2.getColumn(n2))).isIdentity() || ((ColumnSchema)object).isGenerated() || ((ColumnSchema)object).hasDefault() || ((ColumnSchema)object).isNullable()) continue;
                this.isInsertable = false;
                break;
            }
        }
        if (!this.isUpdatable) {
            this.isInsertable = false;
        }
        if (this.isUpdatable) {
            this.columnMap = nArray2;
            this.baseTable = table2;
            if (this.view != null) {
                return;
            }
            ++this.indexLimitRowId;
            this.hasRowID = true;
            if (!table2.isFileBased()) {
                ++this.indexLimitRowId;
                this.isSingleMemoryTable = true;
            }
            this.indexLimitData = this.indexLimitRowId;
        }
    }

    void mergeQuery(Session session) {
        RangeVariable rangeVariable = this.rangeVariables[0];
        Table table = rangeVariable.getTable();
        Expression expression = this.queryCondition;
        QueryExpression queryExpression = table.getQueryExpression();
        if (this.isBaseMergeable && queryExpression != null && queryExpression.isMergeable) {
            QuerySpecification querySpecification = queryExpression.getMainSelect();
            this.rangeVariables[0] = querySpecification.rangeVariables[0];
            this.rangeVariables[0].resetConditions();
            for (int i2 = 0; i2 < this.indexLimitExpressions; ++i2) {
                Expression expression2 = this.exprColumns[i2];
                this.exprColumns[i2] = expression2.replaceColumnReferences(session, rangeVariable, querySpecification.exprColumns);
            }
            if (expression != null) {
                expression = expression.replaceColumnReferences(session, rangeVariable, querySpecification.exprColumns);
            }
            Expression expression3 = querySpecification.queryCondition;
            this.checkQueryCondition = querySpecification.checkQueryCondition;
            this.queryCondition = ExpressionLogical.andExpressions(expression3, expression);
        }
        if (this.view != null) {
            switch (this.view.getCheckOption()) {
                case 1: {
                    if (!this.isUpdatable) {
                        throw Error.error(5537);
                    }
                    this.checkQueryCondition = expression;
                    break;
                }
                case 2: {
                    if (!this.isUpdatable) {
                        throw Error.error(5537);
                    }
                    this.checkQueryCondition = this.queryCondition;
                }
            }
        }
    }

    static void collectSubQueriesAndReferences(OrderedHashSet orderedHashSet, Expression expression) {
        expression.collectAllExpressions(orderedHashSet, OpTypes.subqueryExpressionSet, OpTypes.emptyExpressionSet);
        int n2 = orderedHashSet.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Expression expression2 = (Expression)orderedHashSet.get(i2);
            expression2.collectObjectNames(orderedHashSet);
        }
    }

    @Override
    public OrderedHashSet getSubqueries() {
        int n2;
        OrderedHashSet orderedHashSet = null;
        for (n2 = 0; n2 < this.indexLimitExpressions; ++n2) {
            orderedHashSet = this.exprColumns[n2].collectAllSubqueries(orderedHashSet);
        }
        if (this.queryCondition != null) {
            orderedHashSet = this.queryCondition.collectAllSubqueries(orderedHashSet);
        }
        for (n2 = 0; n2 < this.rangeVariables.length; ++n2) {
            OrderedHashSet orderedHashSet2 = this.rangeVariables[n2].getSubqueries();
            orderedHashSet = OrderedHashSet.addAll(orderedHashSet, orderedHashSet2);
        }
        return orderedHashSet;
    }

    @Override
    public Table getBaseTable() {
        return this.baseTable;
    }

    public OrderedHashSet collectOuterColumnExpressions(OrderedHashSet orderedHashSet, OrderedHashSet orderedHashSet2) {
        if ((orderedHashSet = this.collectAllExpressions(orderedHashSet, OpTypes.columnExpressionSet, OpTypes.subqueryAggregateExpressionSet)) == null) {
            return null;
        }
        for (int i2 = orderedHashSet.size() - 1; i2 >= 0; --i2) {
            Expression expression = (Expression)orderedHashSet.get(i2);
            if (ArrayUtil.find(this.rangeVariables, expression.getRangeVariable()) >= 0) {
                orderedHashSet.remove(i2);
            }
            if (!orderedHashSet2.contains(expression)) continue;
            orderedHashSet.remove(i2);
        }
        if (orderedHashSet.isEmpty()) {
            orderedHashSet = null;
        }
        return orderedHashSet;
    }

    @Override
    public OrderedHashSet collectAllExpressions(OrderedHashSet orderedHashSet, OrderedIntHashSet orderedIntHashSet, OrderedIntHashSet orderedIntHashSet2) {
        int n2;
        for (n2 = 0; n2 < this.indexStartAggregates; ++n2) {
            orderedHashSet = this.exprColumns[n2].collectAllExpressions(orderedHashSet, orderedIntHashSet, orderedIntHashSet2);
        }
        if (this.queryCondition != null) {
            orderedHashSet = this.queryCondition.collectAllExpressions(orderedHashSet, orderedIntHashSet, orderedIntHashSet2);
        }
        for (n2 = 0; n2 < this.rangeVariables.length; ++n2) {
            this.rangeVariables[n2].collectAllExpressions(orderedHashSet, orderedIntHashSet, orderedIntHashSet2);
        }
        return orderedHashSet;
    }

    @Override
    public void collectObjectNames(Set set) {
        int n2;
        for (n2 = 0; n2 < this.indexStartAggregates; ++n2) {
            this.exprColumns[n2].collectObjectNames(set);
        }
        if (this.queryCondition != null) {
            this.queryCondition.collectObjectNames(set);
        }
        int n3 = this.rangeVariables.length;
        for (n2 = 0; n2 < n3; ++n2) {
            HsqlNameManager.HsqlName hsqlName = this.rangeVariables[n2].getTable().getName();
            set.add(hsqlName);
        }
    }

    @Override
    public void replaceColumnReferences(Session session, RangeVariable rangeVariable, Expression[] expressionArray) {
        int n2;
        for (n2 = 0; n2 < this.indexStartAggregates; ++n2) {
            this.exprColumns[n2] = this.exprColumns[n2].replaceColumnReferences(session, rangeVariable, expressionArray);
        }
        if (this.queryCondition != null) {
            this.queryCondition = this.queryCondition.replaceColumnReferences(session, rangeVariable, expressionArray);
        }
        int n3 = this.rangeVariables.length;
        for (n2 = 0; n2 < n3; ++n2) {
            this.rangeVariables[n2].replaceColumnReferences(session, rangeVariable, expressionArray);
        }
    }

    @Override
    public void replaceRangeVariables(RangeVariable[] rangeVariableArray, RangeVariable[] rangeVariableArray2) {
        int n2;
        for (n2 = 0; n2 < this.indexStartAggregates; ++n2) {
            this.exprColumns[n2].replaceRangeVariables(rangeVariableArray, rangeVariableArray2);
        }
        if (this.queryCondition != null) {
            this.queryCondition.replaceRangeVariables(rangeVariableArray, rangeVariableArray2);
        }
        int n3 = this.rangeVariables.length;
        for (n2 = 0; n2 < n3; ++n2) {
            this.rangeVariables[n2].getSubqueries();
        }
    }

    @Override
    public void replaceExpressions(OrderedHashSet orderedHashSet, int n2) {
        int n3;
        for (n3 = 0; n3 < this.indexStartAggregates; ++n3) {
            this.exprColumns[n3] = this.exprColumns[n3].replaceExpressions(orderedHashSet, n2);
        }
        if (this.queryCondition != null) {
            this.queryCondition = this.queryCondition.replaceExpressions(orderedHashSet, n2);
        }
        int n4 = this.rangeVariables.length;
        for (n3 = 0; n3 < n4; ++n3) {
            this.rangeVariables[n3].replaceExpressions(orderedHashSet, n2);
        }
    }

    @Override
    public void setReturningResult() {
        this.setReturningResultSet();
        this.acceptsSequences = true;
        this.isTopLevel = true;
    }

    @Override
    void setReturningResultSet() {
        this.persistenceScope = 23;
    }

    @Override
    public boolean isSingleColumn() {
        return this.indexLimitVisible == 1;
    }

    @Override
    public String[] getColumnNames() {
        String[] stringArray = new String[this.indexLimitVisible];
        for (int i2 = 0; i2 < this.indexLimitVisible; ++i2) {
            stringArray[i2] = this.exprColumns[i2].getAlias();
        }
        return stringArray;
    }

    @Override
    public Type[] getColumnTypes() {
        if (this.resultColumnTypes.length == this.indexLimitVisible) {
            return this.resultColumnTypes;
        }
        Type[] typeArray = new Type[this.indexLimitVisible];
        ArrayUtil.copyArray(this.resultColumnTypes, typeArray, typeArray.length);
        return typeArray;
    }

    @Override
    public int getColumnCount() {
        return this.indexLimitVisible;
    }

    @Override
    public int[] getBaseTableColumnMap() {
        return this.columnMap;
    }

    @Override
    public Expression getCheckCondition() {
        return this.queryCondition;
    }

    @Override
    void getBaseTableNames(OrderedHashSet orderedHashSet) {
        for (int i2 = 0; i2 < this.rangeVariables.length; ++i2) {
            Table table = this.rangeVariables[i2].rangeTable;
            HsqlNameManager.HsqlName hsqlName = table.getName();
            if (table.isView() || table.isDataReadOnly() || table.isTemp() || hsqlName.schema == SqlInvariants.SYSTEM_SCHEMA_HSQLNAME) continue;
            orderedHashSet.add(hsqlName);
        }
    }

    @Override
    boolean isEquivalent(QueryExpression queryExpression) {
        if (!(queryExpression instanceof QuerySpecification)) {
            return false;
        }
        QuerySpecification querySpecification = (QuerySpecification)queryExpression;
        if (!Expression.equals(this.exprColumns, querySpecification.exprColumns)) {
            return false;
        }
        if (!Expression.equals(this.queryCondition, querySpecification.queryCondition)) {
            return false;
        }
        if (this.rangeVariables.length != querySpecification.rangeVariables.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.rangeVariables.length; ++i2) {
            if (this.rangeVariables[i2].getTable() == querySpecification.rangeVariables[i2].getTable()) continue;
            return false;
        }
        return true;
    }
}

