/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.lang.reflect.Method;
import org.hsqldb.ColumnSchema;
import org.hsqldb.Constraint;
import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.ParserBase;
import org.hsqldb.ParserRoutine;
import org.hsqldb.QueryExpression;
import org.hsqldb.Routine;
import org.hsqldb.RoutineSchema;
import org.hsqldb.Scanner;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Statement;
import org.hsqldb.StatementCommand;
import org.hsqldb.StatementQuery;
import org.hsqldb.StatementSchema;
import org.hsqldb.StatementSchemaDefinition;
import org.hsqldb.StatementSession;
import org.hsqldb.Table;
import org.hsqldb.View;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.List;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.OrderedIntHashSet;
import org.hsqldb.map.ValuePool;
import org.hsqldb.rights.Grantee;
import org.hsqldb.rights.GranteeManager;
import org.hsqldb.rights.Right;
import org.hsqldb.rights.User;
import org.hsqldb.types.Charset;
import org.hsqldb.types.Collation;
import org.hsqldb.types.Type;
import org.hsqldb.types.UserTypeModifier;

public class ParserDDL
extends ParserRoutine {
    static final int[] schemaCommands = new int[]{59, 130};
    static final short[] startStatementTokens = new short[]{59, 130, 4, 93};
    static final short[] startStatementTokensSchema = new short[]{59, 130};

    ParserDDL(Session session, Scanner scanner) {
        super(session, scanner);
    }

    @Override
    void reset(Session session, String string) {
        super.reset(session, string);
    }

    StatementSchema compileCreate() {
        int n2;
        boolean bl = false;
        boolean bl2 = false;
        this.read();
        switch (this.token.tokenType) {
            case 129: {
                this.read();
                this.readThis(566);
                this.readIfThis(659);
                this.readThis(294);
                bl = true;
                n2 = 3;
                break;
            }
            case 688: {
                this.read();
                this.readThis(294);
                bl = true;
                n2 = 3;
                break;
            }
            case 566: {
                this.read();
                this.readThis(294);
                bl = true;
                n2 = 3;
                break;
            }
            case 659: {
                this.read();
                this.readThis(294);
                bl = true;
                n2 = 4;
                break;
            }
            case 613: {
                this.read();
                this.readThis(294);
                bl = true;
                n2 = 5;
                break;
            }
            case 689: {
                this.read();
                this.readThis(294);
                bl = true;
                n2 = 7;
                break;
            }
            case 294: {
                this.read();
                bl = true;
                n2 = this.database.schemaManager.getDefaultTableType();
                break;
            }
            default: {
                n2 = 4;
            }
        }
        if (bl) {
            return this.compileCreateTable(n2);
        }
        if (this.database.sqlSyntaxOra && this.token.tokenType == 207) {
            this.read();
            this.readThis(799);
            switch (this.token.tokenType) {
                case 126: 
                case 229: 
                case 307: 
                case 578: 
                case 589: 
                case 685: {
                    break;
                }
                default: {
                    throw this.unexpectedToken("OR");
                }
            }
            bl2 = true;
        }
        switch (this.token.tokenType) {
            case 601: {
                return this.compileCreateAlias();
            }
            case 548: {
                return this.compileCreateSequence();
            }
            case 540: {
                return this.compileCreateSchema();
            }
            case 307: {
                return this.compileCreateTrigger(bl2);
            }
            case 321: {
                return this.compileCreateUser();
            }
            case 532: {
                return this.compileCreateRole();
            }
            case 589: {
                return this.compileCreateView(false, bl2);
            }
            case 415: {
                return this.compileCreateDomain();
            }
            case 578: {
                return this.compileCreateType(bl2);
            }
            case 38: {
                return this.compileCreateCharacterSet();
            }
            case 380: {
                return this.compileCreateCollation();
            }
            case 315: {
                this.read();
                this.checkIsThis(644);
                return this.compileCreateIndex(true);
            }
            case 644: {
                return this.compileCreateIndex(false);
            }
            case 602: {
                return this.compileCreateProcedureOrFunction(bl2);
            }
            case 126: 
            case 229: {
                return this.compileCreateProcedureOrFunction(bl2);
            }
            case 685: {
                return this.compileCreateSynonym(bl2);
            }
        }
        throw this.unexpectedToken();
    }

    Statement compileAlter() {
        this.read();
        switch (this.token.tokenType) {
            case 644: {
                return this.compileAlterIndex();
            }
            case 540: {
                this.read();
                HsqlNameManager.HsqlName hsqlName = this.readSchemaName();
                this.readThis(677);
                this.readThis(301);
                return this.compileRenameSchema(hsqlName, 2);
            }
            case 370: {
                this.read();
                this.checkIsSimpleName();
                String string = this.token.tokenString;
                this.checkValidCatalogName(string);
                this.read();
                this.readThis(677);
                this.readThis(301);
                return this.compileRenameObject(this.database.getCatalogName(), 1, false);
            }
            case 548: {
                return this.compileAlterSequence();
            }
            case 294: {
                return this.compileAlterTable();
            }
            case 321: {
                return this.compileAlterUser();
            }
            case 415: {
                return this.compileAlterDomain();
            }
            case 589: {
                return this.compileAlterView();
            }
            case 551: {
                return this.compileAlterSession();
            }
            case 273: {
                return this.compileAlterSpecificRoutine();
            }
            case 533: {
                return this.compileAlterRoutine();
            }
            case 51: {
                this.read();
                Constraint constraint = (Constraint)this.readSchemaObjectName(5);
                if (this.readIfThis(644)) {
                    return this.compileAlterFKIndex(constraint);
                }
                this.readThis(677);
                this.readThis(301);
                return this.compileRenameObject(constraint.getName(), 5, false);
            }
        }
        throw this.unexpectedToken();
    }

    Statement compileAlterSpecificRoutine() {
        this.readThis(273);
        this.readThis(533);
        Routine routine = (Routine)this.readSchemaObjectName(24);
        switch (this.token.tokenType) {
            case 677: {
                this.read();
                this.readThis(301);
                return this.compileRenameObject(routine.getSpecificName(), 24, false);
            }
        }
        return this.compileAlterSpecificRoutine(routine);
    }

    Statement compileAlterIndex() {
        this.readThis(644);
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(20, true);
        hsqlName.setSchemaIfNull(this.session.getCurrentSchemaHsqlName());
        if (this.token.tokenType == 677) {
            this.read();
            this.readThis(301);
            return this.compileRenameObject(hsqlName, 20, false);
        }
        this.readThis(11);
        Index index = (Index)this.database.schemaManager.getSchemaObject(hsqlName);
        if (index == null) {
            throw Error.error(5501);
        }
        Table table = (Table)this.database.schemaManager.getSchemaObject(index.getName().parent);
        int[] nArray = this.readColumnList(table, true);
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{table, nArray, index.getName()};
        HsqlNameManager.HsqlName[] hsqlNameArray = new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), table.getName()};
        return new StatementSchema(string, 1121, objectArray, null, hsqlNameArray);
    }

    Statement compileAlterFKIndex(Constraint constraint) {
        if (constraint.getConstraintType() != 0) {
            throw Error.error(1501);
        }
        if (constraint.getName().isReservedName()) {
            throw Error.error(4002);
        }
        this.readThis(356);
        Table table = constraint.getRef();
        int[] nArray = this.readColumnList(table, true);
        int[] nArray2 = constraint.getMainColumns();
        int n2 = ArrayUtil.countCommonElements(nArray2, nArray);
        if (n2 > 0) {
            throw Error.error(1501);
        }
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{table, nArray, constraint.getName()};
        HsqlNameManager.HsqlName[] hsqlNameArray = new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), table.getName()};
        return new StatementSchema(string, 1146, objectArray, null, hsqlNameArray);
    }

    Statement compileAlterRoutine() {
        this.readThis(533);
        RoutineSchema routineSchema = (RoutineSchema)this.readSchemaObjectName(18);
        this.readThis(677);
        this.readThis(301);
        return this.compileRenameObject(routineSchema.getName(), routineSchema.getName().type, false);
    }

    Statement compileDrop() {
        HsqlNameManager.HsqlName[] hsqlNameArray;
        SchemaObject schemaObject;
        int n2;
        int n3;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        this.read();
        int n4 = this.token.tokenType;
        switch (n4) {
            case 644: {
                this.read();
                n3 = 1129;
                n2 = 20;
                bl3 = true;
                break;
            }
            case 361: {
                this.read();
                n3 = 24;
                n2 = 6;
                bl = true;
                break;
            }
            case 273: {
                this.read();
                switch (this.token.tokenType) {
                    case 126: 
                    case 229: 
                    case 533: {
                        this.read();
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                n3 = 30;
                n2 = 24;
                bl = true;
                bl3 = true;
                break;
            }
            case 229: {
                this.read();
                n3 = 30;
                n2 = 17;
                bl = true;
                bl3 = true;
                break;
            }
            case 126: {
                this.read();
                n3 = 30;
                n2 = 16;
                bl = true;
                bl3 = true;
                break;
            }
            case 540: {
                this.read();
                n3 = 31;
                n2 = 2;
                bl = true;
                bl3 = true;
                break;
            }
            case 548: {
                this.read();
                n3 = 32;
                n2 = 7;
                bl = true;
                bl3 = true;
                break;
            }
            case 307: {
                this.read();
                n3 = 36;
                n2 = 8;
                bl = false;
                bl3 = true;
                break;
            }
            case 321: {
                this.read();
                n3 = 1131;
                n2 = 11;
                bl = true;
                break;
            }
            case 532: {
                this.read();
                n3 = 29;
                n2 = 11;
                bl = true;
                break;
            }
            case 415: {
                this.read();
                n3 = 28;
                n2 = 13;
                bl = true;
                bl3 = true;
                break;
            }
            case 578: {
                this.read();
                n3 = 27;
                n2 = 12;
                bl = true;
                bl3 = true;
                break;
            }
            case 38: {
                this.read();
                this.readThis(268);
                n3 = 25;
                n2 = 14;
                bl = false;
                bl3 = true;
                break;
            }
            case 380: {
                this.read();
                n3 = 26;
                n2 = 15;
                bl = false;
                bl3 = true;
                break;
            }
            case 589: {
                this.read();
                n3 = 39;
                n2 = 4;
                bl = true;
                bl3 = true;
                break;
            }
            case 294: {
                this.read();
                n3 = 33;
                n2 = 3;
                bl = true;
                bl3 = true;
                break;
            }
            case 685: {
                this.read();
                n3 = 1148;
                n2 = 29;
                bl = false;
                bl3 = true;
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        if (bl3 && this.token.tokenType == 439) {
            int n5 = this.getPosition();
            this.read();
            if (this.token.tokenType == 109) {
                this.read();
                bl4 = true;
            } else {
                this.rewind(n5);
            }
        }
        this.checkIsIdentifier();
        HsqlNameManager.HsqlName hsqlName = null;
        switch (n4) {
            case 321: {
                this.checkIsSimpleName();
                this.checkDatabaseUpdateAuthorisation();
                schemaObject = this.database.getUserManager().get(this.token.tokenString);
                this.read();
                break;
            }
            case 532: {
                this.checkIsSimpleName();
                this.checkDatabaseUpdateAuthorisation();
                schemaObject = this.database.getGranteeManager().getRole(this.token.tokenString);
                this.read();
                break;
            }
            case 540: {
                hsqlName = this.readNewSchemaName();
                schemaObject = this.database.schemaManager.findSchema(hsqlName.name);
                break;
            }
            case 294: {
                boolean bl5;
                boolean bl6 = bl5 = this.token.namePrePrefix == null && ("SESSION".equals(this.token.namePrefix) || "MODULE".equals(this.token.namePrefix));
                if (bl5) {
                    hsqlName = this.readNewSchemaObjectName(n2, false);
                    if (!bl4 && this.token.tokenType == 439) {
                        this.read();
                        this.readThis(109);
                        bl4 = true;
                    }
                    Object[] objectArray = new Object[]{hsqlName, bl4};
                    return new StatementSession(33, objectArray);
                }
            }
            default: {
                hsqlName = this.readNewSchemaObjectName(n2, false);
                hsqlName.setSchemaIfNull(this.session.getCurrentSchemaHsqlName());
                schemaObject = this.database.schemaManager.findSchemaObject(hsqlName.name, hsqlName.schema.name, hsqlName.type);
            }
        }
        if (!bl4 && bl3 && this.token.tokenType == 439) {
            this.read();
            this.readThis(109);
            bl4 = true;
        }
        if (bl) {
            if (this.token.tokenType == 369) {
                bl2 = true;
                this.read();
                if (this.database.sqlSyntaxOra) {
                    this.readIfThis(396);
                }
            } else if (this.token.tokenType == 526) {
                this.read();
            }
        }
        if (schemaObject == null) {
            hsqlNameArray = null;
        } else {
            if (n2 != 24) {
                hsqlName = schemaObject.getName();
            }
            hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(hsqlName);
        }
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{hsqlName, n2, bl2, bl4};
        StatementSchema statementSchema = new StatementSchema(string, n3, objectArray, null, hsqlNameArray);
        return statementSchema;
    }

    Statement compileAlterTable() {
        Table table;
        boolean bl = false;
        this.readThis(294);
        if (this.token.tokenType == 439) {
            int n2 = this.getPosition();
            this.read();
            if (this.token.tokenType == 109) {
                this.read();
                bl = true;
            } else {
                this.rewind(n2);
            }
        }
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(3, false);
        if (hsqlName.schema == null) {
            hsqlName.schema = this.session.getCurrentSchemaHsqlName();
        }
        if ((table = bl ? this.database.schemaManager.findUserTable(hsqlName.name, hsqlName.schema.name) : this.database.schemaManager.getUserTable(hsqlName)) != null) {
            hsqlName = table.getName();
            this.checkSchemaUpdateAuthorisation(hsqlName.schema);
        }
        if (bl && this.token.tokenType != 677) {
            this.unexpectedToken(439);
        }
        switch (this.token.tokenType) {
            case 677: {
                this.read();
                if (this.database.sqlSyntaxPgs && this.token.tokenType != 301) {
                    if (this.token.tokenType == 46) {
                        this.read();
                    }
                    this.checkIsIdentifier();
                    int n3 = table.getColumnIndex(this.token.tokenString);
                    ColumnSchema columnSchema = table.getColumn(n3);
                    this.read();
                    this.readThis(301);
                    return this.compileAlterColumnRename(table, columnSchema);
                }
                this.readThis(301);
                return this.compileRenameObject(hsqlName, 3, bl);
            }
            case 356: {
                this.read();
                HsqlNameManager.HsqlName hsqlName2 = null;
                Boolean bl2 = Boolean.FALSE;
                if (this.token.tokenType == 51) {
                    this.read();
                    bl2 = this.readIfNotExists();
                    hsqlName2 = this.readNewDependentSchemaObjectName(table.getName(), 5);
                }
                switch (this.token.tokenType) {
                    case 121: {
                        this.read();
                        this.readThis(463);
                        return this.compileAlterTableAddForeignKeyConstraint(table, hsqlName2, bl2);
                    }
                    case 315: {
                        this.read();
                        if (this.database.sqlSyntaxMys && !this.readIfThis(644)) {
                            this.readIfThis(463);
                        }
                        return this.compileAlterTableAddUniqueConstraint(table, hsqlName2, bl2);
                    }
                    case 40: {
                        this.read();
                        return this.compileAlterTableAddCheckConstraint(table, hsqlName2, bl2);
                    }
                    case 228: {
                        this.read();
                        this.readThis(463);
                        return this.compileAlterTableAddPrimaryKey(table, hsqlName2, bl2);
                    }
                    case 220: {
                        if (hsqlName2 != null) {
                            throw this.unexpectedToken();
                        }
                        return this.compileAlterTableAddPeriod(table);
                    }
                    case 291: {
                        if (hsqlName2 != null) {
                            throw this.unexpectedToken();
                        }
                        this.read();
                        this.readThis(331);
                        return this.compileAlterTableAddVersioning(table);
                    }
                    case 46: {
                        if (hsqlName2 != null) {
                            throw this.unexpectedToken();
                        }
                        this.read();
                        this.checkIsSimpleName();
                        return this.compileAlterTableAddColumn(table);
                    }
                }
                if (hsqlName2 != null) {
                    throw this.unexpectedToken();
                }
                this.checkIsSimpleName();
                return this.compileAlterTableAddColumn(table);
            }
            case 93: {
                this.read();
                switch (this.token.tokenType) {
                    case 228: {
                        this.read();
                        this.readThis(463);
                        return this.compileAlterTableDropPrimaryKey(table);
                    }
                    case 51: {
                        this.read();
                        return this.compileAlterTableDropConstraint(table);
                    }
                    case 220: {
                        this.read();
                        this.readThis(120);
                        return this.compileAlterTableDropPeriod(table);
                    }
                    case 291: {
                        this.read();
                        this.readThis(331);
                        return this.compileAlterTableDropVersioning(table);
                    }
                    case 46: {
                        this.read();
                        return this.compileAlterTableDropColumn(table);
                    }
                }
                return this.compileAlterTableDropColumn(table);
            }
            case 4: {
                this.read();
                if (this.token.tokenType == 46) {
                    this.read();
                }
                int n4 = table.getColumnIndex(this.token.tokenString);
                ColumnSchema columnSchema = table.getColumn(n4);
                this.read();
                return this.compileAlterColumn(table, columnSchema, n4);
            }
        }
        throw this.unexpectedToken();
    }

    private Statement compileAlterTableDropConstraint(Table table) {
        boolean bl = false;
        SchemaObject schemaObject = this.readSchemaObjectName(table.getSchemaName(), 5);
        if (this.token.tokenType == 526) {
            this.read();
        } else if (this.token.tokenType == 369) {
            this.read();
            bl = true;
        }
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{schemaObject.getName(), ValuePool.getInt(5), bl, Boolean.FALSE};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        HsqlNameManager.HsqlName hsqlName = ((Constraint)schemaObject).getMainTableName();
        if (hsqlName != null && hsqlName != table.getName()) {
            hsqlNameArray = (HsqlNameManager.HsqlName[])ArrayUtil.toAdjustedArray(hsqlNameArray, hsqlName, hsqlNameArray.length, 1);
        }
        StatementSchema statementSchema = new StatementSchema(string, 1130, objectArray, null, hsqlNameArray);
        return statementSchema;
    }

    private Statement compileAlterTableDropPrimaryKey(Table table) {
        boolean bl = false;
        if (this.token.tokenType == 526) {
            this.read();
        } else if (this.token.tokenType == 369) {
            this.read();
            bl = true;
        }
        if (!table.hasPrimaryKey()) {
            throw Error.error(5501);
        }
        String string = this.getLastPart();
        Constraint constraint = table.getPrimaryConstraint();
        Object[] objectArray = new Object[]{constraint.getName(), ValuePool.getInt(5), bl, Boolean.FALSE};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        StatementSchema statementSchema = new StatementSchema(string, 1130, objectArray, null, hsqlNameArray);
        return statementSchema;
    }

    StatementSession compileDeclareLocalTableOrNull() {
        Object object;
        StatementSchema statementSchema;
        boolean bl;
        int n2 = this.getPosition();
        int n3 = 3;
        try {
            this.readThis(82);
            this.readThis(167);
            this.readThis(566);
            this.readThis(294);
        }
        catch (HsqlException hsqlException) {
            this.lastError = hsqlException;
            this.rewind(n2);
            return null;
        }
        boolean bl2 = bl = this.token.namePrePrefix == null && (this.token.namePrefix == null || "SESSION".equals(this.token.namePrefix) || "MODULE".equals(this.token.namePrefix));
        if (!bl) {
            throw this.unexpectedToken();
        }
        boolean bl3 = this.readIfNotExists();
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(3, false);
        hsqlName.schema = SqlInvariants.SESSION_SCHEMA_HSQLNAME;
        Table table = new Table(this.database, hsqlName, n3);
        if (this.token.tokenType == 11) {
            statementSchema = this.compileCreateTableAsSubqueryDefinition(table, bl3);
        } else {
            statementSchema = this.compileCreateTableBody(table, bl3);
            object = (HsqlArrayList)statementSchema.arguments[1];
            for (int i2 = 0; i2 < ((HsqlArrayList)object).size(); ++i2) {
                Constraint constraint = (Constraint)((HsqlArrayList)object).get(i2);
                if (constraint.getConstraintType() != 0) continue;
                throw this.unexpectedToken("FOREIGN");
            }
        }
        object = new StatementSession(1119, statementSchema.arguments);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StatementSchema compileCreateView(boolean bl, boolean bl2) {
        QueryExpression queryExpression;
        this.read();
        Boolean bl3 = Boolean.FALSE;
        if (!bl) {
            bl3 = this.readIfNotExists();
        }
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(4, true);
        hsqlName.setSchemaIfNull(this.session.getCurrentSchemaHsqlName());
        this.checkSchemaUpdateAuthorisation(hsqlName.schema);
        HsqlNameManager.HsqlName[] hsqlNameArray = null;
        if (this.token.tokenType == 937) {
            hsqlNameArray = this.readColumnNames(hsqlName);
        }
        this.readThis(11);
        ParserBase.Recorder recorder = this.startRecording();
        try {
            this.isViewDefinition = true;
            queryExpression = this.XreadQueryExpression();
        }
        catch (HsqlException hsqlException) {
            queryExpression = this.XreadJoinedTableAsView();
        }
        finally {
            this.isViewDefinition = false;
        }
        int n2 = 0;
        if (this.token.tokenType == 337) {
            this.read();
            n2 = 2;
            if (this.readIfThis(167)) {
                n2 = 1;
            } else {
                this.readIfThis(31);
            }
            this.readThis(40);
            this.readThis(494);
        }
        View view = new View(this.database, hsqlName, hsqlNameArray, n2);
        queryExpression.setView(view);
        queryExpression.resolve(this.session);
        String string = recorder.getSQL();
        view.setStatement(string);
        StatementQuery statementQuery = new StatementQuery(this.session, queryExpression, this.compileContext);
        String string2 = this.getLastPart();
        Object[] objectArray = new Object[]{view, bl3};
        int n3 = bl ? 1122 : 96;
        HsqlNameManager.HsqlName[] hsqlNameArray2 = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(string2, n3, objectArray, statementQuery.readTableNames, hsqlNameArray2);
    }

    StatementSchema compileCreateSequence() {
        this.read();
        Boolean bl = this.readIfNotExists();
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(7, false);
        NumberSequence numberSequence = new NumberSequence(hsqlName, Type.SQL_INTEGER);
        this.readSequenceOptions(numberSequence, true, false, false);
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{numberSequence, bl};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(string, 71, objectArray, null, hsqlNameArray);
    }

    StatementSchema compileCreateDomain() {
        Object[] objectArray;
        int n2;
        UserTypeModifier userTypeModifier = null;
        this.read();
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(13, false);
        this.readIfThis(11);
        Type type = this.readTypeDefinition(true, false).duplicate();
        Expression expression = null;
        if (this.readIfThis(83)) {
            expression = this.readDefaultClause(type);
        }
        userTypeModifier = new UserTypeModifier(hsqlName, 13, type);
        userTypeModifier.setDefaultClause(expression);
        type.userTypeModifier = userTypeModifier;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        this.compileContext.currentDomain = type;
        do {
            n2 = 0;
            switch (this.token.tokenType) {
                case 40: 
                case 51: {
                    this.readConstraint(type, hsqlArrayList);
                    break;
                }
                default: {
                    n2 = 1;
                }
            }
        } while (n2 == 0);
        this.compileContext.currentDomain = null;
        for (n2 = 0; n2 < hsqlArrayList.size(); ++n2) {
            objectArray = (Object[])hsqlArrayList.get(n2);
            objectArray.prepareDomainCheckConstraint(this.session);
            userTypeModifier.addConstraint((Constraint)objectArray);
        }
        String string = this.getLastPart();
        objectArray = new Object[]{type};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(string, 23, objectArray, null, hsqlNameArray);
    }

    StatementSchema compileCreateType(boolean bl) {
        this.read();
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(12, false);
        this.readThis(11);
        Type type = this.readTypeDefinition(true, false).duplicate();
        this.readIfThis(426);
        type.userTypeModifier = new UserTypeModifier(hsqlName, 12, type);
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{type};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(string, 94, objectArray, null, hsqlNameArray);
    }

    StatementSchema compileCreateCharacterSet() {
        this.read();
        this.readThis(268);
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(14, false);
        this.readIfThis(11);
        this.readThis(128);
        String string = this.token.namePrefix;
        Charset charset = (Charset)this.database.schemaManager.getCharacterSet(this.session, this.token.tokenString, string);
        this.read();
        if (this.token.tokenType == 380) {
            this.read();
            this.readThis(124);
            this.readThis(83);
        }
        Charset charset2 = new Charset(hsqlName, charset.getName());
        String string2 = this.getLastPart();
        Object[] objectArray = new Object[]{charset2};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(string2, 11, objectArray, null, hsqlNameArray);
    }

    StatementSchema compileCreateCollation() {
        this.read();
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(15, false);
        hsqlName.setSchemaIfNull(this.session.getCurrentSchemaHsqlName());
        this.readThis(120);
        HsqlNameManager.HsqlName hsqlName2 = this.readNewSchemaObjectName(14, false);
        this.readThis(124);
        HsqlNameManager.HsqlName hsqlName3 = this.readNewSchemaObjectName(15, false);
        Boolean bl = null;
        if (this.readIfThis(190)) {
            this.readThis(503);
            bl = Boolean.FALSE;
        } else if (this.readIfThis(503)) {
            this.readThis(557);
            bl = Boolean.TRUE;
        }
        String string = hsqlName2.schema == null ? null : hsqlName2.schema.name;
        Charset charset = (Charset)this.database.schemaManager.getCharacterSet(this.session, hsqlName2.name, string);
        if (charset == null) {
            throw Error.error(5501, hsqlName2.getSchemaQualifiedStatementName());
        }
        string = hsqlName3.schema == null ? null : hsqlName3.schema.name;
        Collation collation = this.database.schemaManager.getCollation(this.session, hsqlName3.name, string);
        Collation collation2 = new Collation(hsqlName, collation, charset, bl);
        String string2 = this.getLastPart();
        Object[] objectArray = new Object[]{collation2};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(string2, 13, objectArray, null, hsqlNameArray);
    }

    StatementSchema compileCreateAlias() {
        Object[] objectArray;
        Object object;
        String string;
        HsqlNameManager.HsqlName hsqlName = null;
        Routine[] routineArray = null;
        String string2 = null;
        if (!this.session.isProcessingScript()) {
            throw this.unsupportedFeature();
        }
        this.read();
        try {
            string = this.token.tokenString;
            this.read();
            this.readThis(120);
            string2 = this.token.tokenString;
            this.read();
        }
        catch (HsqlException hsqlException) {
            string = null;
        }
        if (string != null) {
            object = this.database.schemaManager.getDefaultSchemaHsqlName();
            hsqlName = this.database.nameManager.newHsqlName((HsqlNameManager.HsqlName)object, string, 16);
            objectArray = Routine.getMethods(string2);
            routineArray = Routine.newRoutines(this.session, (Method[])objectArray);
        }
        object = this.getLastPart();
        objectArray = new Object[]{hsqlName, routineArray};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.catalogNameArray;
        return new StatementSchema((String)object, 1124, objectArray, null, hsqlNameArray);
    }

    StatementSchema compileCreateIndex(boolean bl) {
        this.read();
        Boolean bl2 = this.readIfNotExists();
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(20, true);
        if (this.database.sqlSyntaxMys && this.readIfThis(322) && !this.readIfThis("HASH")) {
            this.readThis("BTREE");
        }
        this.readThis(204);
        Table table = this.readTableName();
        HsqlNameManager.HsqlName hsqlName2 = table.getSchemaName();
        hsqlName.setSchemaIfNull(hsqlName2);
        hsqlName.parent = table.getName();
        if (hsqlName.schema != hsqlName2) {
            throw Error.error(5505);
        }
        hsqlName.schema = table.getSchemaName();
        int[] nArray = this.readColumnList(table, true);
        if (this.database.sqlSyntaxMys) {
            if (this.readIfThis(322) && !this.readIfThis("HASH")) {
                this.readThis("BTREE");
            }
            if (this.readIfThis(619)) {
                hsqlName.comment = this.readQuotedString();
            }
        }
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{table, nArray, hsqlName, bl, null, bl2};
        return new StatementSchema(string, 1125, objectArray, null, new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), table.getName()});
    }

    StatementSchema compileCreateSchema() {
        boolean bl;
        Grantee grantee;
        HsqlNameManager.HsqlName hsqlName = null;
        String string = null;
        HsqlNameManager.HsqlName hsqlName2 = null;
        this.read();
        Boolean bl2 = this.readIfNotExists();
        if (this.token.tokenType != 16) {
            hsqlName = this.readNewSchemaName();
        }
        if (this.token.tokenType == 16) {
            this.read();
            this.checkIsSimpleName();
            string = this.token.tokenString;
            this.read();
            if (hsqlName == null) {
                grantee = this.database.getGranteeManager().get(string);
                if (grantee == null) {
                    throw Error.error(4001, string);
                }
                hsqlName = this.database.nameManager.newHsqlName(grantee.getName().name, this.isDelimitedIdentifier(), 2);
                SqlInvariants.checkSchemaNameNotSystem(this.token.tokenString);
            }
        }
        if ("PUBLIC".equals(string)) {
            throw Error.error(4002, string);
        }
        Grantee grantee2 = grantee = string == null ? this.session.getGrantee() : this.database.getGranteeManager().get(string);
        if (grantee == null) {
            throw Error.error(4001, string);
        }
        if (!this.session.getGrantee().isSchemaCreator()) {
            throw Error.error(2051, this.session.getGrantee().getName().getNameString());
        }
        if (grantee instanceof User && ((User)grantee).isExternalOnly) {
            throw Error.error(2000, this.session.getGrantee().getName().getNameString());
        }
        if (!(!this.database.schemaManager.schemaExists(hsqlName.name) || this.session.isProcessingScript() && "PUBLIC".equals(hsqlName.name) || bl2.booleanValue())) {
            throw Error.error(5504, hsqlName.name);
        }
        if (hsqlName.name.equals("SYSTEM_LOBS")) {
            hsqlName = SqlInvariants.LOBS_SCHEMA_HSQLNAME;
            grantee = hsqlName.owner;
        }
        if (this.readIfThis(83)) {
            this.readThis(38);
            this.readThis(268);
            hsqlName2 = this.readNewSchemaObjectName(14, false);
        }
        String string2 = this.getLastPart();
        Object[] objectArray = new Object[]{hsqlName, grantee, bl2};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.catalogNameArray;
        StatementSchema statementSchema = new StatementSchema(string2, 68, objectArray, null, hsqlNameArray);
        statementSchema.setSchemaHsqlName(hsqlName);
        HsqlArrayList<StatementSchema> hsqlArrayList = new HsqlArrayList<StatementSchema>(128);
        hsqlArrayList.add(statementSchema);
        this.getCompiledStatementBody(hsqlArrayList);
        StatementSchema[] statementSchemaArray = new StatementSchema[hsqlArrayList.size()];
        hsqlArrayList.toArray(statementSchemaArray);
        do {
            bl = false;
            for (int i2 = 0; i2 < statementSchemaArray.length - 1; ++i2) {
                if (statementSchemaArray[i2].order <= statementSchemaArray[i2 + 1].order) continue;
                StatementSchema statementSchema2 = statementSchemaArray[i2 + 1];
                statementSchemaArray[i2 + 1] = statementSchemaArray[i2];
                statementSchemaArray[i2] = statementSchema2;
                bl = true;
            }
        } while (bl);
        return new StatementSchemaDefinition(statementSchemaArray);
    }

    void getCompiledStatementBody(List list) {
        boolean bl = false;
        while (!bl) {
            StatementSchema statementSchema = null;
            int n2 = this.getPosition();
            block0 : switch (this.token.tokenType) {
                case 59: {
                    this.read();
                    switch (this.token.tokenType) {
                        case 315: 
                        case 321: 
                        case 540: {
                            throw this.unexpectedToken();
                        }
                        case 644: {
                            int n3 = 1125;
                            String string = this.getStatement(n2, startStatementTokensSchema);
                            statementSchema = new StatementSchema(string, n3);
                            break block0;
                        }
                        case 548: {
                            statementSchema = this.compileCreateSequence();
                            statementSchema.sql = this.getLastPart(n2);
                            break block0;
                        }
                        case 532: {
                            statementSchema = this.compileCreateRole();
                            statementSchema.sql = this.getLastPart(n2);
                            break block0;
                        }
                        case 415: {
                            int n3 = 23;
                            String string = this.getStatement(n2, startStatementTokensSchema);
                            statementSchema = new StatementSchema(string, n3);
                            break block0;
                        }
                        case 578: {
                            statementSchema = this.compileCreateType(false);
                            statementSchema.sql = this.getLastPart(n2);
                            break block0;
                        }
                        case 38: {
                            statementSchema = this.compileCreateCharacterSet();
                            statementSchema.sql = this.getLastPart(n2);
                            break block0;
                        }
                        case 361: {
                            throw this.unexpectedToken();
                        }
                        case 129: 
                        case 294: 
                        case 566: 
                        case 613: 
                        case 659: 
                        case 688: 
                        case 689: {
                            int n3 = 87;
                            String string = this.getStatement(n2, startStatementTokensSchema);
                            statementSchema = new StatementSchema(string, n3);
                            break block0;
                        }
                        case 307: {
                            int n3 = 90;
                            String string = this.getStatement(n2, startStatementTokensSchema);
                            statementSchema = new StatementSchema(string, n3);
                            break block0;
                        }
                        case 589: {
                            int n3 = 96;
                            String string = this.getStatement(n2, startStatementTokensSchema);
                            statementSchema = new StatementSchema(string, n3);
                            break block0;
                        }
                        case 126: {
                            int n3 = 69;
                            String string = this.getStatementForRoutine(n2, startStatementTokensSchema);
                            statementSchema = new StatementSchema(string, n3);
                            break block0;
                        }
                        case 229: {
                            int n3 = 69;
                            String string = this.getStatementForRoutine(n2, startStatementTokensSchema);
                            statementSchema = new StatementSchema(string, n3);
                            break block0;
                        }
                    }
                    throw this.unexpectedToken();
                }
                case 130: {
                    statementSchema = this.compileGrantOrRevoke();
                    statementSchema.sql = this.getLastPart(n2);
                    break;
                }
                case 943: {
                    this.read();
                    bl = true;
                    break;
                }
                case 1014: {
                    bl = true;
                    break;
                }
                default: {
                    throw this.unexpectedToken();
                }
            }
            if (statementSchema == null) continue;
            statementSchema.isSchemaDefinition = true;
            list.add(statementSchema);
        }
    }

    StatementSchema compileCreateRole() {
        this.read();
        HsqlNameManager.HsqlName hsqlName = this.readNewUserIdentifier();
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{hsqlName};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(string, 65, objectArray, null, hsqlNameArray);
    }

    StatementSchema compileCreateUser() {
        Boolean bl = Boolean.FALSE;
        Boolean bl2 = Boolean.FALSE;
        Grantee grantee = this.session.getGrantee();
        this.read();
        HsqlNameManager.HsqlName hsqlName = this.readNewUserIdentifier();
        this.readThis(668);
        if (this.readIfThis(629)) {
            bl2 = Boolean.TRUE;
        }
        String string = this.readPassword();
        if (this.token.tokenType == 357) {
            this.read();
            bl = Boolean.TRUE;
        }
        this.checkDatabaseUpdateAuthorisation();
        String string2 = this.getLastPart();
        Object[] objectArray = new Object[]{hsqlName, string, grantee, bl, bl2};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.catalogNameArray;
        return new StatementSchema(string2, 1126, objectArray, null, hsqlNameArray);
    }

    HsqlNameManager.HsqlName readNewUserIdentifier() {
        this.checkIsSimpleName();
        String string = this.token.tokenString;
        boolean bl = this.isDelimitedIdentifier();
        if (string.equalsIgnoreCase("SA")) {
            string = "SA";
            bl = false;
        }
        HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newHsqlName(string, bl, 11);
        this.read();
        return hsqlName;
    }

    String readPassword() {
        String string = this.token.tokenString;
        if (this.isUndelimitedSimpleName() || this.isDelimitedSimpleName()) {
            this.read();
        } else {
            this.readQuotedString();
        }
        return string;
    }

    StatementSchema compileCreateSynonym(boolean bl) {
        this.read();
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(29, true);
        this.readThis(120);
        HsqlNameManager.HsqlName hsqlName2 = this.readNewSchemaObjectName(29, true);
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{hsqlName, hsqlName2};
        return new StatementSchema(string, 1147, objectArray, null, new HsqlNameManager.HsqlName[]{this.database.getCatalogName()});
    }

    Statement compileRenameObject(HsqlNameManager.HsqlName hsqlName, int n2, boolean bl) {
        HsqlNameManager.HsqlName hsqlName2 = this.readNewSchemaObjectName(n2, true);
        String string = this.getLastPart();
        switch (n2) {
            case 1: {
                break;
            }
            case 2: {
                this.checkSchemaUpdateAuthorisation(this.session, hsqlName);
                break;
            }
            default: {
                hsqlName.setSchemaIfNull(this.session.getCurrentSchemaHsqlName());
                this.checkSchemaUpdateAuthorisation(this.session, hsqlName.schema);
            }
        }
        Object[] objectArray = new Object[]{hsqlName, hsqlName2, bl};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogNameArray();
        return new StatementSchema(string, 1152, objectArray, null, hsqlNameArray);
    }

    Statement compileAlterTableAddUniqueConstraint(Table table, HsqlNameManager.HsqlName hsqlName, Boolean bl) {
        if (hsqlName == null) {
            hsqlName = this.database.nameManager.newAutoName("CT", table.getSchemaName(), table.getName(), 5);
        }
        int[] nArray = this.readColumnList(table, false);
        HsqlNameManager.HsqlName hsqlName2 = this.session.database.nameManager.newConstraintIndexName(table.getName(), hsqlName, this.session.database.sqlSysIndexNames);
        Index index = table.createIndexStructure(hsqlName2, nArray, null, null, false, true, true, false);
        Constraint constraint = new Constraint(hsqlName, table, index, 2);
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{1134, table, constraint, bl};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(string, 7, objectArray, null, hsqlNameArray);
    }

    Statement compileAlterTableAddForeignKeyConstraint(Table table, HsqlNameManager.HsqlName hsqlName, Boolean bl) {
        if (hsqlName == null) {
            hsqlName = this.database.nameManager.newAutoName("FK", table.getSchemaName(), table.getName(), 5);
        }
        OrderedHashSet orderedHashSet = this.readColumnNames(false);
        Constraint constraint = this.readFKReferences(table, hsqlName, orderedHashSet);
        HsqlNameManager.HsqlName hsqlName2 = constraint.getMainTableName();
        constraint.core.mainTable = this.database.schemaManager.getUserTable(hsqlName2);
        constraint.setColumnsIndexes(table);
        if (constraint.core.mainCols.length != constraint.core.refCols.length) {
            throw Error.error(5593);
        }
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{1134, table, constraint, bl};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        if (hsqlName2 != table.getName()) {
            hsqlNameArray = (HsqlNameManager.HsqlName[])ArrayUtil.toAdjustedArray(hsqlNameArray, hsqlName2, hsqlNameArray.length, 1);
        }
        return new StatementSchema(string, 7, objectArray, null, hsqlNameArray);
    }

    Statement compileAlterTableAddCheckConstraint(Table table, HsqlNameManager.HsqlName hsqlName, Boolean bl) {
        if (hsqlName == null) {
            hsqlName = this.database.nameManager.newAutoName("CT", table.getSchemaName(), table.getName(), 5);
        }
        Constraint constraint = new Constraint(hsqlName, null, 3);
        this.readCheckConstraintCondition(constraint);
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{1134, table, constraint, bl};
        HsqlNameManager.HsqlName[] hsqlNameArray = new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), table.getName()};
        return new StatementSchema(string, 7, objectArray, null, hsqlNameArray);
    }

    Statement compileAlterTableAddColumn(Table table) {
        int n2 = table.getColumnCount();
        HsqlArrayList<Constraint> hsqlArrayList = new HsqlArrayList<Constraint>();
        Constraint constraint = new Constraint(null, null, 5);
        Boolean bl = this.readIfNotExists();
        hsqlArrayList.add(constraint);
        this.checkIsSimpleName();
        this.checkIsSchemaObjectName();
        HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newColumnHsqlName(table.getName(), this.token.tokenString, this.isDelimitedIdentifier());
        this.read();
        ColumnSchema columnSchema = this.readColumnDefinitionOrNull(table, hsqlName, hsqlArrayList);
        if (columnSchema == null) {
            throw Error.error(5000);
        }
        if (this.token.tokenType == 365) {
            this.read();
            n2 = table.getColumnIndex(this.token.tokenString);
            this.read();
        }
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{1133, table, columnSchema, n2, hsqlArrayList, bl};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(string, 7, objectArray, null, hsqlNameArray);
    }

    Statement compileAlterTableAddPrimaryKey(Table table, HsqlNameManager.HsqlName hsqlName, Boolean bl) {
        if (hsqlName == null) {
            hsqlName = this.session.database.nameManager.newAutoName("PK", table.getSchemaName(), table.getName(), 5);
        }
        OrderedHashSet orderedHashSet = this.readColumnNames(false);
        Constraint constraint = new Constraint(hsqlName, orderedHashSet, 4);
        constraint.setColumnsIndexes(table);
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{1134, table, constraint, bl};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(string, 7, objectArray, null, hsqlNameArray);
    }

    Statement compileAlterTableDropColumn(Table table) {
        boolean bl = false;
        this.checkIsSimpleName();
        String string = this.token.tokenString;
        this.read();
        if (this.token.tokenType == 526) {
            this.read();
        } else if (this.token.tokenType == 369) {
            this.read();
            bl = true;
        }
        int n2 = table.getColumnIndex(string);
        if (table.getColumnCount() == 1) {
            throw Error.error(5591);
        }
        String string2 = this.getLastPart();
        Object[] objectArray = new Object[]{table.getColumn(n2).getName(), ValuePool.getInt(9), bl, Boolean.FALSE};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(string2, 1128, objectArray, null, hsqlNameArray);
    }

    Statement compileAlterColumn(Table table, ColumnSchema columnSchema, int n2) {
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        int n3 = this.getPosition();
        switch (this.token.tokenType) {
            case 677: {
                this.read();
                this.readThis(301);
                return this.compileAlterColumnRename(table, columnSchema);
            }
            case 93: {
                this.read();
                if (this.token.tokenType == 83) {
                    this.read();
                    String string = this.getLastPart();
                    Object[] objectArray = new Object[]{1141, table, columnSchema, n2};
                    return new StatementSchema(string, 7, objectArray, null, hsqlNameArray);
                }
                if (this.token.tokenType == 425) {
                    this.read();
                    String string = this.getLastPart();
                    Object[] objectArray = new Object[]{1142, table, columnSchema, n2};
                    return new StatementSchema(string, 7, objectArray, null, hsqlNameArray);
                }
                if (this.token.tokenType == 434 || this.token.tokenType == 138) {
                    this.read();
                    String string = this.getLastPart();
                    Object[] objectArray = new Object[]{1143, table, columnSchema, n2};
                    return new StatementSchema(string, 7, objectArray, null, hsqlNameArray);
                }
                if (this.token.tokenType == 193) {
                    this.read();
                    this.readThis(196);
                    String string = this.getLastPart();
                    Object[] objectArray = new Object[]{1139, table, columnSchema, Boolean.TRUE};
                    return new StatementSchema(string, 7, objectArray, null, hsqlNameArray);
                }
                throw this.unexpectedToken();
            }
            case 268: {
                this.read();
                switch (this.token.tokenType) {
                    case 400: {
                        this.read();
                        this.readThis(578);
                        return this.compileAlterColumnDataType(table, columnSchema);
                    }
                    case 83: {
                        this.read();
                        return this.compileAlterColumnDefault(table, columnSchema, n2);
                    }
                    case 193: {
                        this.read();
                        this.readThis(196);
                        return this.compileAlterColumnSetNullability(table, columnSchema, false);
                    }
                    case 196: {
                        this.read();
                        return this.compileAlterColumnSetNullability(table, columnSchema, true);
                    }
                    case 434: {
                        return this.compileAlterColumnAddSequence(table, columnSchema, n2);
                    }
                }
                this.rewind(n3);
                this.read();
                break;
            }
            case 578: {
                if (!this.database.sqlSyntaxPgs) break;
                this.read();
                return this.compileAlterColumnDataType(table, columnSchema);
            }
            case 434: {
                return this.compileAlterColumnAddSequence(table, columnSchema, n2);
            }
        }
        if (this.token.tokenType == 268 || this.token.tokenType == 525) {
            if (!columnSchema.isIdentity()) {
                throw Error.error(5535);
            }
            return this.compileAlterColumnSequenceOptions(table, columnSchema, n2);
        }
        return this.compileAlterColumnDataTypeIdentity(table, columnSchema);
    }

    private Statement compileAlterColumnDataTypeIdentity(Table table, ColumnSchema columnSchema) {
        if (columnSchema.isGenerated()) {
            throw Error.error(5561);
        }
        NumberSequence numberSequence = columnSchema.getIdentitySequence();
        Type type = columnSchema.getDataType();
        if (this.token.tokenType == 138) {
            this.read();
            if (!type.isIntegralType()) {
                throw Error.error(5561);
            }
            if (numberSequence == null) {
                numberSequence = new NumberSequence(null, type);
            }
        } else {
            type = this.readTypeDefinition(true, true);
            switch (this.token.tokenType) {
                case 138: {
                    if (!type.isIntegralType()) {
                        throw Error.error(5561);
                    }
                    this.read();
                    if (numberSequence != null) break;
                    numberSequence = new NumberSequence(null, type);
                    break;
                }
                case 434: {
                    numberSequence = this.readSequence(table, columnSchema, true);
                    break;
                }
                default: {
                    numberSequence = null;
                }
            }
        }
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{1144, table, columnSchema, type, numberSequence};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(string, 7, objectArray, null, hsqlNameArray);
    }

    private Statement compileAlterColumnDataType(Table table, ColumnSchema columnSchema) {
        if (columnSchema.isGenerated()) {
            throw Error.error(5561);
        }
        Type type = this.readTypeDefinition(true, true);
        if (columnSchema.isIdentity() && !type.isIntegralType()) {
            throw Error.error(5561);
        }
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{1136, table, columnSchema, type};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(string, 7, objectArray, null, hsqlNameArray);
    }

    private Statement compileAlterColumnSetNullability(Table table, ColumnSchema columnSchema, boolean bl) {
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{1139, table, columnSchema, bl};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(string, 7, objectArray, null, hsqlNameArray);
    }

    private Statement compileAlterColumnDefault(Table table, ColumnSchema columnSchema, int n2) {
        Type type = columnSchema.getDataType();
        Expression expression = this.readDefaultClause(type);
        String string = this.getLastPart();
        int n3 = 1140;
        Object object = expression;
        if (expression.opType == 12) {
            n3 = 1137;
            object = ((ExpressionColumn)expression).sequence;
        }
        Object[] objectArray = new Object[]{n3, table, columnSchema, n2, object};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(string, 7, objectArray, null, hsqlNameArray);
    }

    Statement compileAlterSequence() {
        this.read();
        HsqlNameManager.HsqlName hsqlName = this.session.getSchemaHsqlName(this.token.namePrefix);
        NumberSequence numberSequence = this.database.schemaManager.getSequence(this.token.tokenString, hsqlName.name, true);
        this.read();
        if (this.token.tokenType == 677) {
            this.read();
            this.readThis(301);
            return this.compileRenameObject(numberSequence.getName(), 7, false);
        }
        this.checkSchemaUpdateAuthorisation(this.session, numberSequence.getName().schema);
        NumberSequence numberSequence2 = numberSequence.duplicate();
        this.readSequenceOptions(numberSequence2, false, true, false);
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{numberSequence, numberSequence2};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogNameArray();
        return new StatementSchema(string, 5, objectArray, null, hsqlNameArray);
    }

    StatementSchema compileAlterColumnAddSequence(Table table, ColumnSchema columnSchema, int n2) {
        if (!columnSchema.getDataType().isIntegralType()) {
            throw Error.error(5525);
        }
        if (columnSchema.isIdentity()) {
            throw Error.error(5525);
        }
        NumberSequence numberSequence = this.readSequence(table, columnSchema, false);
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{1137, table, columnSchema, n2, numberSequence};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(table.getName());
        return new StatementSchema(string, 7, objectArray, null, hsqlNameArray);
    }

    NumberSequence readSequence(Table table, ColumnSchema columnSchema, boolean bl) {
        this.readThis(434);
        NumberSequence numberSequence = new NumberSequence(null, columnSchema.getDataType());
        boolean bl2 = false;
        if (this.token.tokenType == 27) {
            this.read();
            this.readThis(83);
        } else {
            this.readThis(359);
            bl2 = true;
        }
        this.readThis(11);
        if (!bl && this.token.tokenType == 548) {
            if (bl2) {
                throw this.unexpectedToken();
            }
            this.read();
            if (this.token.namePrefix != null && !this.token.namePrefix.equals(table.getSchemaName().name)) {
                throw this.unexpectedToken(this.token.namePrefix);
            }
            numberSequence = this.database.schemaManager.getSequence(this.token.tokenString, table.getSchemaName().name, true);
            this.read();
        } else {
            this.readThis(138);
            numberSequence.setAlways(bl2);
            if (this.token.tokenType == 937) {
                this.read();
                this.readSequenceOptions(numberSequence, false, false, false);
                this.readThis(922);
            }
            numberSequence.checkValues();
        }
        return numberSequence;
    }

    StatementSchema compileAlterColumnSequenceOptions(Table table, ColumnSchema columnSchema, int n2) {
        boolean bl;
        OrderedIntHashSet orderedIntHashSet = new OrderedIntHashSet();
        NumberSequence numberSequence = columnSchema.getIdentitySequence().duplicate();
        do {
            bl = false;
            block0 : switch (this.token.tokenType) {
                case 525: {
                    long l2;
                    if (!orderedIntHashSet.add(this.token.tokenType)) {
                        throw this.unexpectedToken();
                    }
                    this.read();
                    if (this.readIfThis(337)) {
                        l2 = this.readBigint();
                        numberSequence.setCurrentValueNoCheck(l2);
                        break;
                    }
                    numberSequence.reset();
                    break;
                }
                case 268: {
                    long l2;
                    this.read();
                    switch (this.token.tokenType) {
                        case 444: {
                            if (!orderedIntHashSet.add(this.token.tokenType)) {
                                throw this.unexpectedToken();
                            }
                            this.read();
                            this.readThis(27);
                            l2 = this.readBigint();
                            numberSequence.setIncrement(l2);
                            break block0;
                        }
                        case 190: {
                            this.read();
                            if (this.token.tokenType == 475) {
                                numberSequence.setDefaultMaxValue();
                            } else if (this.token.tokenType == 479) {
                                numberSequence.setDefaultMinValue();
                            } else if (this.token.tokenType == 76) {
                                numberSequence.setCycle(false);
                            } else {
                                throw this.unexpectedToken();
                            }
                            if (!orderedIntHashSet.add(this.token.tokenType)) {
                                throw this.unexpectedToken();
                            }
                            this.read();
                            break block0;
                        }
                        case 475: {
                            if (!orderedIntHashSet.add(this.token.tokenType)) {
                                throw this.unexpectedToken();
                            }
                            this.read();
                            l2 = this.readBigint();
                            numberSequence.setMaxValueNoCheck(l2);
                            break block0;
                        }
                        case 479: {
                            if (!orderedIntHashSet.add(this.token.tokenType)) {
                                throw this.unexpectedToken();
                            }
                            this.read();
                            l2 = this.readBigint();
                            numberSequence.setMinValueNoCheck(l2);
                            break block0;
                        }
                        case 76: {
                            if (!orderedIntHashSet.add(this.token.tokenType)) {
                                throw this.unexpectedToken();
                            }
                            this.read();
                            numberSequence.setCycle(true);
                            break block0;
                        }
                    }
                    throw this.unexpectedToken();
                }
                default: {
                    bl = true;
                }
            }
        } while (!bl);
        numberSequence.checkValues();
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{1137, table, columnSchema, n2, numberSequence};
        HsqlNameManager.HsqlName[] hsqlNameArray = new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), table.getName()};
        return new StatementSchema(string, 7, objectArray, null, hsqlNameArray);
    }

    private Statement compileAlterColumnRename(Table table, ColumnSchema columnSchema) {
        this.checkIsSimpleName();
        HsqlNameManager.HsqlName hsqlName = this.readNewSchemaObjectName(9, true);
        if (table.findColumn(hsqlName.name) > -1) {
            throw Error.error(5504, hsqlName.name);
        }
        this.database.schemaManager.checkColumnIsReferenced(table.getName(), columnSchema.getName());
        String string = this.getLastPart();
        Object[] objectArray = new Object[]{columnSchema.getName(), hsqlName, Boolean.FALSE};
        HsqlNameManager.HsqlName[] hsqlNameArray = new HsqlNameManager.HsqlName[]{this.database.getCatalogName(), table.getName()};
        return new StatementSchema(string, 1152, objectArray, null, hsqlNameArray);
    }

    Statement compileRenameSchema(HsqlNameManager.HsqlName hsqlName, int n2) {
        HsqlNameManager.HsqlName hsqlName2 = this.readNewSchemaObjectName(n2, true);
        String string = this.getLastPart();
        this.checkSchemaUpdateAuthorisation(this.session, hsqlName);
        Object[] objectArray = new Object[]{hsqlName, hsqlName2, Boolean.FALSE};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogNameArray();
        return new StatementSchema(string, 1153, objectArray, null, hsqlNameArray);
    }

    Statement compileAlterUser() {
        this.read();
        HsqlNameManager.HsqlName hsqlName = this.readNewUserIdentifier();
        User user = this.database.getUserManager().get(hsqlName.name);
        if (hsqlName.name.equals("PUBLIC")) {
            throw Error.error(5503);
        }
        if (hsqlName.name.equals("_SYSTEM")) {
            throw Error.error(5503);
        }
        this.readThis(268);
        switch (this.token.tokenType) {
            case 167: {
                this.read();
                Boolean bl = this.processTrueOrFalseObject();
                Object[] objectArray = new Object[]{user, bl};
                return new StatementCommand(1091, objectArray);
            }
            case 668: {
                this.read();
                boolean bl = false;
                if (this.readIfThis(629)) {
                    bl = Boolean.TRUE;
                }
                String string = this.readPassword();
                Object[] objectArray = new Object[]{user, string, bl};
                StatementCommand statementCommand = new StatementCommand(1093, objectArray);
                String string2 = user.getSetUserPasswordDigestSQL(string, bl);
                statementCommand.setSQL(string2);
                return statementCommand;
            }
            case 647: {
                this.read();
                this.readThis(540);
                HsqlNameManager.HsqlName hsqlName2 = this.token.tokenType == 83 ? null : this.database.schemaManager.getSchemaHsqlName(this.token.tokenString);
                this.read();
                Object[] objectArray = new Object[]{user, hsqlName2};
                return new StatementCommand(1092, objectArray);
            }
        }
        throw this.unexpectedToken();
    }

    Statement compileAlterDomain() {
        this.read();
        HsqlNameManager.HsqlName hsqlName = this.session.getSchemaHsqlName(this.token.namePrefix);
        this.checkSchemaUpdateAuthorisation(hsqlName);
        Type type = this.database.schemaManager.getDomain(this.token.tokenString, hsqlName.name, true);
        this.read();
        switch (this.token.tokenType) {
            case 677: {
                this.read();
                this.readThis(301);
                return this.compileRenameObject(type.getName(), 13, false);
            }
            case 93: {
                this.read();
                if (this.token.tokenType == 83) {
                    this.read();
                    String string = this.getLastPart();
                    Object[] objectArray = new Object[]{1132, type};
                    HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(type.getName());
                    return new StatementSchema(string, 3, objectArray, null, hsqlNameArray);
                }
                if (this.token.tokenType == 51) {
                    this.read();
                    this.checkIsSchemaObjectName();
                    HsqlNameManager.HsqlName hsqlName2 = this.database.schemaManager.getSchemaObjectName(type.getSchemaName(), this.token.tokenString, 5, true);
                    this.read();
                    String string = this.getLastPart();
                    Object[] objectArray = new Object[]{1130, type, hsqlName2};
                    HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(type.getName());
                    return new StatementSchema(string, 3, objectArray, null, hsqlNameArray);
                }
                throw this.unexpectedToken();
            }
            case 268: {
                this.read();
                this.readThis(83);
                Expression expression = this.readDefaultClause(type);
                String string = this.getLastPart();
                Object[] objectArray = new Object[]{1135, type, expression};
                HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(type.getName());
                return new StatementSchema(string, 3, objectArray, null, hsqlNameArray);
            }
            case 356: {
                this.read();
                if (this.token.tokenType != 51 && this.token.tokenType != 40) break;
                HsqlArrayList hsqlArrayList = new HsqlArrayList();
                this.compileContext.currentDomain = type;
                this.readConstraint(type, hsqlArrayList);
                this.compileContext.currentDomain = null;
                Constraint constraint = (Constraint)hsqlArrayList.get(0);
                constraint.prepareDomainCheckConstraint(this.session);
                String string = this.getLastPart();
                Object[] objectArray = new Object[]{1134, type, constraint};
                HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogAndBaseTableNames(type.getName());
                return new StatementSchema(string, 3, objectArray, null, hsqlNameArray);
            }
        }
        throw this.unexpectedToken();
    }

    private Statement compileAlterView() {
        int n2 = this.getPosition();
        this.read();
        String string = this.token.tokenString;
        HsqlNameManager.HsqlName hsqlName = this.session.getSchemaHsqlName(this.token.namePrefix);
        this.checkSchemaUpdateAuthorisation(hsqlName);
        Table table = this.database.schemaManager.getUserTable(string, hsqlName.name);
        this.read();
        switch (this.token.tokenType) {
            case 677: {
                this.read();
                this.readThis(301);
                return this.compileRenameObject(table.getName(), 4, false);
            }
            case 11: {
                this.rewind(n2);
                return this.compileCreateView(true, false);
            }
        }
        throw this.unexpectedToken();
    }

    private boolean isGrantToken() {
        switch (this.token.tokenType) {
            case 2: 
            case 84: 
            case 108: 
            case 145: 
            case 236: 
            case 265: 
            case 319: 
            case 584: {
                return true;
            }
        }
        return false;
    }

    StatementSchema compileGrantOrRevoke() {
        boolean bl = this.token.tokenType == 130;
        this.read();
        if (this.isGrantToken() || !bl && (this.token.tokenType == 130 || this.token.tokenType == 438)) {
            return this.compileRightGrantOrRevoke(bl);
        }
        return this.compileRoleGrantOrRevoke(bl);
    }

    private StatementSchema compileRightGrantOrRevoke(boolean bl) {
        Object object;
        HsqlNameManager.HsqlName[] hsqlNameArray;
        Object[] objectArray;
        int n2;
        int n3;
        OrderedHashSet<String> orderedHashSet = new OrderedHashSet<String>();
        Grantee grantee = null;
        Right right = null;
        HsqlNameManager.HsqlName hsqlName = null;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        if (!bl) {
            if (this.token.tokenType == 130) {
                this.read();
                this.readThis(494);
                this.readThis(120);
                bl6 = true;
            } else if (this.token.tokenType == 438) {
                throw this.unsupportedFeature();
            }
        }
        if (this.token.tokenType == 2) {
            this.read();
            if (this.token.tokenType == 519) {
                this.read();
            }
            right = Right.fullRights;
            bl5 = true;
        } else {
            right = new Right();
            n3 = 1;
            block22: while (n3 != 0) {
                this.checkIsUndelimitedIdentifier();
                int n4 = GranteeManager.getCheckSingleRight(this.token.tokenString);
                n2 = this.token.tokenType;
                objectArray = null;
                this.read();
                switch (n2) {
                    case 145: 
                    case 236: 
                    case 265: 
                    case 319: {
                        if (this.token.tokenType == 937) {
                            objectArray = this.readColumnNames(false);
                        }
                    }
                    case 84: {
                        right.set(n4, (OrderedHashSet)objectArray);
                        bl2 = true;
                        if (!bl || n2 == 236) break;
                        hsqlNameArray = this.startRecording();
                        object = this.XreadFilterExpressionOrNull();
                        if (object == null) break;
                        String string = hsqlNameArray.getSQL();
                        right.setFilterExpression(n4, (Expression)object, string);
                        bl7 = true;
                        break;
                    }
                    case 307: {
                        right.set(n4, null);
                        bl2 = true;
                        break;
                    }
                    case 584: {
                        if (bl2) {
                            throw this.unexpectedToken();
                        }
                        right = Right.fullRights;
                        bl3 = true;
                        n3 = 0;
                        continue block22;
                    }
                    case 108: {
                        if (bl2) {
                            throw this.unexpectedToken();
                        }
                        right = Right.fullRights;
                        bl4 = true;
                        n3 = 0;
                        continue block22;
                    }
                }
                if (this.token.tokenType != 924) break;
                this.read();
            }
        }
        this.readThis(204);
        n3 = 0;
        switch (this.token.tokenType) {
            case 617: {
                if (!bl4 && !bl5) {
                    throw this.unexpectedToken();
                }
                this.read();
                if (!this.isSimpleName() || !this.isDelimitedIdentifier()) {
                    throw Error.error(5569);
                }
                n3 = 16;
                break;
            }
            case 273: {
                if (!bl4 && !bl5) {
                    throw this.unexpectedToken();
                }
                this.read();
                switch (this.token.tokenType) {
                    case 126: 
                    case 229: 
                    case 533: {
                        this.read();
                        break;
                    }
                    default: {
                        throw this.unexpectedToken();
                    }
                }
                n3 = 24;
                break;
            }
            case 126: {
                if (!bl4 && !bl5) {
                    throw this.unexpectedToken();
                }
                this.read();
                n3 = 16;
                break;
            }
            case 229: {
                if (!bl4 && !bl5) {
                    throw this.unexpectedToken();
                }
                this.read();
                n3 = 17;
                break;
            }
            case 533: {
                if (!bl4 && !bl5) {
                    throw this.unexpectedToken();
                }
                this.read();
                n3 = 18;
                break;
            }
            case 578: {
                if (!bl3 && !bl5) {
                    throw this.unexpectedToken();
                }
                this.read();
                n3 = 12;
                break;
            }
            case 415: {
                if (!bl3 && !bl5) {
                    throw this.unexpectedToken();
                }
                this.read();
                n3 = 13;
                break;
            }
            case 548: {
                if (!bl3 && !bl5) {
                    throw this.unexpectedToken();
                }
                this.read();
                n3 = 7;
                break;
            }
            case 38: {
                if (!bl3 && !bl5) {
                    throw this.unexpectedToken();
                }
                this.read();
                this.readThis(268);
                n3 = 14;
                break;
            }
            case 2: {
                this.read();
                if (this.readIfThis("SEQUENCES")) {
                    if (!bl3 && !bl5) {
                        throw this.unexpectedToken("SEQUENCES");
                    }
                    right = new Right();
                    right.set(16, null);
                } else if (this.readIfThis("ROUTINES")) {
                    if (!bl4 && !bl5) {
                        throw this.unexpectedToken("ROUTINES");
                    }
                    right = new Right();
                    right.set(32, null);
                } else {
                    if (!bl2 && !bl5) {
                        throw this.unexpectedToken();
                    }
                    this.readThis("TABLES");
                }
                this.readThis(140);
                this.readThis(540);
                n3 = 2;
                break;
            }
            default: {
                if (!bl2 && !bl5) {
                    throw this.unexpectedToken();
                }
                this.readIfThis(294);
                n3 = 3;
            }
        }
        hsqlName = this.readNewSchemaObjectName(n3, false);
        if (bl) {
            if (n3 == 3 && !bl7) {
                ParserBase.Recorder recorder = this.startRecording();
                Expression expression = this.XreadFilterExpressionOrNull();
                if (expression != null) {
                    objectArray = recorder.getSQL();
                    right.setFilterExpression(expression, (String)objectArray);
                }
            }
            this.readThis(301);
        } else {
            this.readThis(124);
        }
        while (true) {
            this.checkIsSimpleName();
            orderedHashSet.add(this.token.tokenString);
            this.read();
            if (this.token.tokenType != 924) break;
            this.read();
        }
        if (bl) {
            if (this.token.tokenType == 337) {
                this.read();
                this.readThis(130);
                this.readThis(494);
                bl6 = true;
            }
            if (this.token.tokenType == 437) {
                this.read();
                this.readThis(27);
                if (this.token.tokenType == 74) {
                    this.read();
                } else {
                    this.readThis(68);
                    if (this.session.getRole() == null) {
                        throw Error.error(2200);
                    }
                    grantee = this.session.getRole();
                }
            }
        } else if (this.token.tokenType == 369) {
            bl8 = true;
            this.read();
        } else {
            this.readThis(526);
        }
        String string = this.getLastPart();
        n2 = bl ? 53 : 63;
        objectArray = new Object[]{orderedHashSet, hsqlName, right, grantee, bl8, bl6};
        hsqlNameArray = this.database.schemaManager.getCatalogNameArray();
        object = new StatementSchema(string, n2, objectArray, null, hsqlNameArray);
        return object;
    }

    private StatementSchema compileRoleGrantOrRevoke(boolean bl) {
        Grantee grantee = this.session.getGrantee();
        OrderedHashSet<String> orderedHashSet = new OrderedHashSet<String>();
        OrderedHashSet<String> orderedHashSet2 = new OrderedHashSet<String>();
        boolean bl2 = false;
        if (!bl && this.token.tokenType == 357) {
            throw this.unsupportedFeature();
        }
        while (true) {
            this.checkIsSimpleName();
            orderedHashSet.add(this.token.tokenString);
            this.read();
            if (this.token.tokenType != 924) break;
            this.read();
        }
        if (bl) {
            this.readThis(301);
        } else {
            this.readThis(124);
        }
        while (true) {
            this.checkIsSimpleName();
            orderedHashSet2.add(this.token.tokenString);
            this.read();
            if (this.token.tokenType != 924) break;
            this.read();
        }
        if (bl && this.token.tokenType == 337) {
            throw this.unsupportedFeature();
        }
        if (this.token.tokenType == 437) {
            this.read();
            this.readThis(27);
            if (this.token.tokenType == 74) {
                this.read();
            } else {
                this.readThis(68);
                if (this.session.getRole() == null) {
                    throw Error.error(2200);
                }
                grantee = this.session.getRole();
            }
        }
        if (!bl) {
            if (this.token.tokenType == 369) {
                bl2 = true;
                this.read();
            } else {
                this.readThis(526);
            }
        }
        String string = this.getLastPart();
        int n2 = bl ? 54 : 64;
        Object[] objectArray = new Object[]{orderedHashSet2, orderedHashSet, grantee, bl2};
        HsqlNameManager.HsqlName[] hsqlNameArray = this.database.schemaManager.getCatalogNameArray();
        StatementSchema statementSchema = new StatementSchema(string, n2, objectArray, null, hsqlNameArray);
        return statementSchema;
    }

    void checkDatabaseUpdateAuthorisation() {
        this.session.checkAdmin();
        this.session.checkDDLWrite();
    }

    void checkSchemaUpdateAuthorisation(Session session, HsqlNameManager.HsqlName hsqlName) {
        if (session.isProcessingLog()) {
            return;
        }
        if (SqlInvariants.isSystemSchemaName(hsqlName.name)) {
            throw Error.error(5503);
        }
        if (session.parser.isSchemaDefinition) {
            if (hsqlName == session.getCurrentSchemaHsqlName()) {
                return;
            }
            throw Error.error(5505, hsqlName.name);
        }
        session.getGrantee().checkSchemaUpdateOrGrantRights(hsqlName);
        session.checkDDLWrite();
    }

    StatementSchema compileComment() {
        int n2;
        this.readThis(619);
        this.readThis(204);
        switch (this.token.tokenType) {
            case 548: {
                n2 = 7;
                break;
            }
            case 307: {
                n2 = 8;
                break;
            }
            case 533: {
                n2 = 18;
                break;
            }
            case 294: {
                n2 = 3;
                break;
            }
            case 46: {
                n2 = 9;
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        this.read();
        this.checkIsSchemaObjectName();
        HsqlNameManager.HsqlName hsqlName = this.database.nameManager.newHsqlName(this.token.tokenString, this.token.isDelimitedIdentifier, n2);
        if (n2 == 9) {
            if (this.token.namePrefix == null) {
                throw Error.error(5501);
            }
            hsqlName.parent = this.database.nameManager.newHsqlName(this.token.namePrefix, this.token.isDelimitedPrefix, 3);
            hsqlName.parent.schema = this.token.namePrePrefix == null ? this.session.getCurrentSchemaHsqlName() : this.database.nameManager.newHsqlName(this.token.namePrePrefix, this.token.isDelimitedPrePrefix, 2);
        } else {
            hsqlName.schema = this.token.namePrefix == null ? this.session.getCurrentSchemaHsqlName() : this.database.nameManager.newHsqlName(this.token.namePrefix, this.token.isDelimitedPrefix, 2);
        }
        this.read();
        this.readThis(152);
        String string = this.readQuotedString();
        Object[] objectArray = new Object[]{hsqlName, string};
        return new StatementSchema(null, 1123, objectArray, null, null);
    }

    Statement compileAlterSession() {
        this.read();
        this.session.checkAdmin();
        if (this.token.tokenType == 678) {
            this.read();
            int n2 = this.token.tokenType;
            switch (this.token.tokenType) {
                case 2: {
                    this.read();
                    break;
                }
                case 250: {
                    this.read();
                    this.readThis(553);
                    break;
                }
                case 294: {
                    this.read();
                    this.readThis(400);
                    break;
                }
                default: {
                    throw this.unexpectedTokenRequire("ALL,RESULT,TABLE");
                }
            }
            Object[] objectArray = new Object[]{this.session.getId(), n2};
            return new StatementCommand(1120, objectArray);
        }
        long l2 = this.readBigint();
        Session session = this.database.sessionManager.getSession(l2);
        if (session == null) {
            throw Error.error(4500);
        }
        int n3 = this.token.tokenType;
        switch (this.token.tokenType) {
            case 42: {
                this.read();
                break;
            }
            case 247: {
                this.read();
                break;
            }
            case 99: {
                this.read();
                this.readThis(560);
                break;
            }
            default: {
                throw this.unexpectedToken();
            }
        }
        Object[] objectArray = new Object[]{l2, n3};
        return new StatementCommand(1120, objectArray);
    }

    boolean processTrueOrFalse() {
        if (this.token.namePrefix != null) {
            throw this.unexpectedToken();
        }
        if (this.token.tokenType == 310) {
            this.read();
            return true;
        }
        if (this.token.tokenType == 114) {
            this.read();
            return false;
        }
        throw this.unexpectedToken();
    }

    Boolean processTrueOrFalseObject() {
        return this.processTrueOrFalse();
    }
}

