/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.math.BigDecimal;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.map.ValuePool;
import org.hsqldb.rights.Grantee;
import org.hsqldb.types.Type;

public final class NumberSequence
implements SchemaObject {
    public static final NumberSequence[] emptyArray = new NumberSequence[0];
    private HsqlNameManager.HsqlName name;
    private long currValue;
    private long lastValue;
    private boolean limitReached;
    private long startValue;
    private long minValue;
    private long maxValue;
    private long increment;
    private Type dataType;
    private boolean isCycle;
    private boolean isAlways;
    private boolean restartValueDefault;

    public NumberSequence(HsqlNameManager.HsqlName hsqlName, Type type) {
        this.setDefaults(hsqlName, type);
    }

    public void setDefaults(HsqlNameManager.HsqlName hsqlName, Type type) {
        long l2;
        long l3;
        this.name = hsqlName;
        this.dataType = type;
        switch (this.dataType.typeCode) {
            case -6: {
                l3 = 127L;
                l2 = -128L;
                break;
            }
            case 5: {
                l3 = 32767L;
                l2 = -32768L;
                break;
            }
            case 4: {
                l3 = Integer.MAX_VALUE;
                l2 = Integer.MIN_VALUE;
                break;
            }
            case 25: {
                l3 = Long.MAX_VALUE;
                l2 = Long.MIN_VALUE;
                break;
            }
            case 2: 
            case 3: {
                if (type.scale == 0) {
                    l3 = Long.MAX_VALUE;
                    l2 = Long.MIN_VALUE;
                    break;
                }
                throw Error.error(5563);
            }
            default: {
                throw Error.error(5563);
            }
        }
        this.minValue = l2;
        this.maxValue = l3;
        this.increment = 1L;
    }

    public NumberSequence(HsqlNameManager.HsqlName hsqlName, long l2, long l3, Type type) {
        this(hsqlName, type);
        this.setStartValue(l2);
        this.setIncrement(l3);
    }

    @Override
    public int getType() {
        return 7;
    }

    @Override
    public HsqlNameManager.HsqlName getName() {
        return this.name;
    }

    @Override
    public HsqlNameManager.HsqlName getSchemaName() {
        return this.name.schema;
    }

    @Override
    public HsqlNameManager.HsqlName getCatalogName() {
        return this.name.schema.schema;
    }

    @Override
    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        return new OrderedHashSet();
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject schemaObject) {
    }

    @Override
    public String getSQL() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("CREATE").append(' ');
        stringBuilder.append("SEQUENCE").append(' ');
        stringBuilder.append(this.getName().getSchemaQualifiedStatementName()).append(' ');
        stringBuilder.append("AS").append(' ');
        stringBuilder.append(this.getDataType().getNameString()).append(' ');
        stringBuilder.append("START").append(' ');
        stringBuilder.append("WITH").append(' ');
        stringBuilder.append(this.startValue);
        if (this.getIncrement() != 1L) {
            stringBuilder.append(' ').append("INCREMENT").append(' ');
            stringBuilder.append("BY").append(' ');
            stringBuilder.append(this.getIncrement());
        }
        if (!this.hasDefaultMinMax()) {
            stringBuilder.append(' ').append("MINVALUE").append(' ');
            stringBuilder.append(this.getMinValue());
            stringBuilder.append(' ').append("MAXVALUE").append(' ');
            stringBuilder.append(this.getMaxValue());
        }
        if (this.isCycle()) {
            stringBuilder.append(' ').append("CYCLE");
        }
        if (this.name == null) {
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    public String getSQLColumnDefinition() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("GENERATED").append(' ');
        if (this.name == null) {
            if (this.isAlways()) {
                stringBuilder.append("ALWAYS");
            } else {
                stringBuilder.append("BY").append(' ').append("DEFAULT");
            }
            stringBuilder.append(' ').append("AS").append(' ').append("IDENTITY").append("(");
            stringBuilder.append("START").append(' ');
            stringBuilder.append("WITH").append(' ');
            stringBuilder.append(this.startValue);
            if (this.getIncrement() != 1L) {
                stringBuilder.append(' ').append("INCREMENT").append(' ');
                stringBuilder.append("BY").append(' ');
                stringBuilder.append(this.getIncrement());
            }
            if (!this.hasDefaultMinMax()) {
                stringBuilder.append(' ').append("MINVALUE").append(' ');
                stringBuilder.append(this.getMinValue());
                stringBuilder.append(' ').append("MAXVALUE").append(' ');
                stringBuilder.append(this.getMaxValue());
            }
            if (this.isCycle()) {
                stringBuilder.append(' ').append("CYCLE");
            }
            if (this.name == null) {
                stringBuilder.append(")");
            }
        } else {
            stringBuilder.append("BY").append(' ').append("DEFAULT");
            stringBuilder.append(' ').append("AS").append(' ');
            stringBuilder.append("SEQUENCE").append(' ');
            stringBuilder.append(this.getName().getSchemaQualifiedStatementName());
        }
        return stringBuilder.toString();
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    public String getRestartSQL() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("ALTER").append(' ');
        stringBuilder.append("SEQUENCE");
        stringBuilder.append(' ').append(this.name.getSchemaQualifiedStatementName());
        stringBuilder.append(' ').append("RESTART");
        stringBuilder.append(' ').append("WITH").append(' ').append(this.peek());
        return stringBuilder.toString();
    }

    public static String getRestartSQL(Table table) {
        String string = table.getColumn((int)table.identityColumn).getName().statementName;
        NumberSequence numberSequence = table.identitySequence;
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("ALTER").append(' ').append("TABLE");
        stringBuilder.append(' ').append(table.getName().getSchemaQualifiedStatementName());
        stringBuilder.append(' ').append("ALTER").append(' ');
        stringBuilder.append("COLUMN");
        stringBuilder.append(' ').append(string);
        stringBuilder.append(' ').append("RESTART");
        stringBuilder.append(' ').append("WITH").append(' ').append(numberSequence.peek());
        return stringBuilder.toString();
    }

    public Type getDataType() {
        return this.dataType;
    }

    public long getIncrement() {
        return this.increment;
    }

    public synchronized long getStartValue() {
        return this.startValue;
    }

    public synchronized long getMinValue() {
        return this.minValue;
    }

    public synchronized long getMaxValue() {
        return this.maxValue;
    }

    public synchronized boolean isCycle() {
        return this.isCycle;
    }

    public synchronized boolean isAlways() {
        return this.isAlways;
    }

    public synchronized boolean hasDefaultMinMax() {
        long l2;
        long l3;
        switch (this.dataType.typeCode) {
            case -6: {
                l3 = 127L;
                l2 = -128L;
                break;
            }
            case 5: {
                l3 = 32767L;
                l2 = -32768L;
                break;
            }
            case 4: {
                l3 = Integer.MAX_VALUE;
                l2 = Integer.MIN_VALUE;
                break;
            }
            case 25: {
                l3 = Long.MAX_VALUE;
                l2 = Long.MIN_VALUE;
                break;
            }
            case 2: 
            case 3: {
                l3 = Long.MAX_VALUE;
                l2 = Long.MIN_VALUE;
                break;
            }
            default: {
                throw Error.runtimeError(201, "NumberSequence");
            }
        }
        return this.minValue == l2 && this.maxValue == l3;
    }

    synchronized void setStartValue(long l2) {
        if (l2 < this.minValue || l2 > this.maxValue) {
            throw Error.error(5597);
        }
        this.currValue = this.lastValue = (this.startValue = l2);
    }

    synchronized void setMinValue(long l2) {
        this.checkInTypeRange(l2);
        if (l2 >= this.maxValue || this.currValue < l2) {
            throw Error.error(5597);
        }
        this.minValue = l2;
    }

    synchronized void setDefaultMinValue() {
        this.minValue = this.getDefaultMinOrMax(false);
    }

    synchronized void setMaxValue(long l2) {
        this.checkInTypeRange(l2);
        if (l2 <= this.minValue || this.currValue > l2) {
            throw Error.error(5597);
        }
        this.maxValue = l2;
    }

    synchronized void setDefaultMaxValue() {
        this.maxValue = this.getDefaultMinOrMax(true);
    }

    synchronized void setIncrement(long l2) {
        if (l2 < -16384L || l2 > 16383L) {
            throw Error.error(5597);
        }
        this.increment = l2;
    }

    synchronized void setCurrentValueNoCheck(long l2) {
        this.checkInTypeRange(l2);
        this.currValue = this.lastValue = l2;
    }

    synchronized void setStartValueNoCheck(long l2) {
        this.checkInTypeRange(l2);
        this.currValue = this.lastValue = (this.startValue = l2);
    }

    synchronized void setStartValueDefault() {
        this.restartValueDefault = true;
    }

    synchronized void setMinValueNoCheck(long l2) {
        this.checkInTypeRange(l2);
        this.minValue = l2;
    }

    synchronized void setMaxValueNoCheck(long l2) {
        this.checkInTypeRange(l2);
        this.maxValue = l2;
    }

    synchronized void setCycle(boolean bl) {
        this.isCycle = bl;
    }

    synchronized void setAlways(boolean bl) {
        this.isAlways = bl;
    }

    private long getDefaultMinOrMax(boolean bl) {
        long l2;
        long l3;
        switch (this.dataType.typeCode) {
            case -6: {
                l3 = 127L;
                l2 = -128L;
                break;
            }
            case 5: {
                l3 = 32767L;
                l2 = -32768L;
                break;
            }
            case 4: {
                l3 = Integer.MAX_VALUE;
                l2 = Integer.MIN_VALUE;
                break;
            }
            case 25: {
                l3 = Long.MAX_VALUE;
                l2 = Long.MIN_VALUE;
                break;
            }
            case 2: 
            case 3: {
                l3 = Long.MAX_VALUE;
                l2 = Long.MIN_VALUE;
                break;
            }
            default: {
                throw Error.runtimeError(201, "NumberSequence");
            }
        }
        return bl ? l3 : l2;
    }

    private void checkInTypeRange(long l2) {
        long l3;
        long l4;
        switch (this.dataType.typeCode) {
            case -6: {
                l4 = 127L;
                l3 = -128L;
                break;
            }
            case 5: {
                l4 = 32767L;
                l3 = -32768L;
                break;
            }
            case 4: {
                l4 = Integer.MAX_VALUE;
                l3 = Integer.MIN_VALUE;
                break;
            }
            case 25: {
                l4 = Long.MAX_VALUE;
                l3 = Long.MIN_VALUE;
                break;
            }
            case 2: 
            case 3: {
                l4 = Long.MAX_VALUE;
                l3 = Long.MIN_VALUE;
                break;
            }
            default: {
                throw Error.runtimeError(201, "NumberSequence");
            }
        }
        if (l2 < l3 || l2 > l4) {
            throw Error.error(5597);
        }
    }

    synchronized void checkValues() {
        if (this.restartValueDefault) {
            this.currValue = this.lastValue = this.startValue;
            this.restartValueDefault = false;
        }
        if (this.minValue >= this.maxValue || this.startValue < this.minValue || this.startValue > this.maxValue || this.currValue < this.minValue || this.currValue > this.maxValue) {
            throw Error.error(5597);
        }
    }

    synchronized NumberSequence duplicate() {
        NumberSequence numberSequence = new NumberSequence(this.name, this.dataType);
        numberSequence.startValue = this.startValue;
        numberSequence.currValue = this.currValue;
        numberSequence.lastValue = this.lastValue;
        numberSequence.increment = this.increment;
        numberSequence.minValue = this.minValue;
        numberSequence.maxValue = this.maxValue;
        numberSequence.isCycle = this.isCycle;
        numberSequence.isAlways = this.isAlways;
        return numberSequence;
    }

    synchronized void reset(NumberSequence numberSequence) {
        this.name = numberSequence.name;
        this.startValue = numberSequence.startValue;
        this.currValue = numberSequence.currValue;
        this.lastValue = numberSequence.lastValue;
        this.increment = numberSequence.increment;
        this.dataType = numberSequence.dataType;
        this.minValue = numberSequence.minValue;
        this.maxValue = numberSequence.maxValue;
        this.isCycle = numberSequence.isCycle;
        this.isAlways = numberSequence.isAlways;
    }

    synchronized long userUpdate(long l2) {
        if (l2 == this.currValue) {
            this.currValue += this.increment;
            return l2;
        }
        if (this.increment > 0L) {
            if (l2 > this.currValue) {
                this.currValue += (l2 - this.currValue + this.increment) / this.increment * this.increment;
            }
        } else if (l2 < this.currValue) {
            this.currValue += (l2 - this.currValue + this.increment) / this.increment * this.increment;
        }
        return l2;
    }

    synchronized long systemUpdate(long l2) {
        if (l2 == this.currValue) {
            this.currValue += this.increment;
            return l2;
        }
        if (this.increment > 0L) {
            if (l2 > this.currValue) {
                this.currValue = l2 + this.increment;
            }
        } else if (l2 < this.currValue) {
            this.currValue = l2 + this.increment;
        }
        return l2;
    }

    synchronized Object getValueObject() {
        Number number;
        long l2 = this.getValue();
        switch (this.dataType.typeCode) {
            default: {
                number = ValuePool.getInt((int)l2);
                break;
            }
            case 25: {
                number = ValuePool.getLong(l2);
                break;
            }
            case 2: 
            case 3: {
                number = ValuePool.getBigDecimal(new BigDecimal(l2));
            }
        }
        return number;
    }

    public synchronized long getValue() {
        long l2;
        if (this.limitReached) {
            throw Error.error(3416);
        }
        if (this.increment > 0L) {
            if (this.currValue > this.maxValue - this.increment) {
                if (this.isCycle) {
                    l2 = this.minValue;
                } else {
                    this.limitReached = true;
                    l2 = this.minValue;
                }
            } else {
                l2 = this.currValue + this.increment;
            }
        } else if (this.currValue < this.minValue - this.increment) {
            if (this.isCycle) {
                l2 = this.maxValue;
            } else {
                this.limitReached = true;
                l2 = this.minValue;
            }
        } else {
            l2 = this.currValue + this.increment;
        }
        long l3 = this.currValue;
        this.currValue = l2;
        return l3;
    }

    synchronized void reset() {
        this.lastValue = this.currValue = this.startValue;
    }

    public synchronized long peek() {
        return this.currValue;
    }

    synchronized boolean resetWasUsed() {
        boolean bl = this.lastValue != this.currValue;
        this.lastValue = this.currValue;
        return bl;
    }

    public synchronized void reset(long l2) {
        if (l2 < this.minValue || l2 > this.maxValue) {
            throw Error.error(5597);
        }
        this.currValue = this.lastValue = l2;
        this.startValue = this.lastValue;
    }
}

